package badges

import (
	"context"
	"net/http"
	"testing"

	"code.justin.tv/samus/nitro/_tools/src/github.com/pkg/errors"
	"code.justin.tv/samus/nitro/metrics"
	mocks "code.justin.tv/samus/nitro/mocks/TwitchClient"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestBadgesClient(t *testing.T) {
	Convey("Testing Badges client APIs", t, func() {
		mockTwitchClient := new(mocks.Client)
		mockMetricLogger := new(metrics.MockIMetricLogger)

		mockTwitchClient.
			On("NewRequest", mock.Anything, mock.Anything, mock.Anything).
			Return(http.NewRequest("", "mocked/path", nil))

		badgesClient := BadgesClient{mockTwitchClient, mockMetricLogger}

		userID := "fake-user-id"

		Convey("Testing GrantPrimeBadge client API", func() {

			Convey("with success", func() {
				mockResp := new(http.Response)
				mockResp.StatusCode = http.StatusOK

				mockTwitchClient.On("Do", context.TODO(), mock.Anything, mock.Anything).Return(mockResp, nil)
				mockMetricLogger.On("AddHttpDependencyCallMetrics", mock.Anything, mock.Anything, mock.Anything).Return()

				err := badgesClient.GrantPrimeBadge(context.TODO(), userID)
				So(err, ShouldBeNil)
			})
			Convey("with failure", func() {
				mockTwitchClient.On("Do", context.TODO(), mock.Anything, mock.Anything).Return(nil, errors.New("Oops, something's not right..."))
				mockMetricLogger.On("AddHttpDependencyCallMetrics", mock.Anything, mock.Anything, mock.Anything).Return()

				err := badgesClient.GrantPrimeBadge(context.TODO(), "fake-user-id")
				So(err, ShouldNotBeNil)
			})
		})

		Convey("Testing RemovePrimeBadge client API", func() {
			Convey("with success", func() {
				mockResp := new(http.Response)
				mockResp.StatusCode = http.StatusOK

				mockTwitchClient.On("Do", context.TODO(), mock.Anything, mock.Anything).Return(mockResp, nil)
				mockMetricLogger.On("AddHttpDependencyCallMetrics", mock.Anything, mock.Anything, mock.Anything).Return()

				err := badgesClient.RemovePrimeBadge(context.TODO(), userID)
				So(err, ShouldBeNil)
			})
			Convey("with failure", func() {
				mockTwitchClient.On("Do", context.TODO(), mock.Anything, mock.Anything).Return(nil, errors.New("Oops, something's not right..."))
				mockMetricLogger.On("AddHttpDependencyCallMetrics", mock.Anything, mock.Anything, mock.Anything).Return()

				err := badgesClient.RemovePrimeBadge(context.TODO(), userID)
				So(err, ShouldNotBeNil)
			})
		})
	})
}
