package dynamo

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

type AdditionalPremiumStatusDynamoTable struct {
}

type AdditionalPremiumStatusDynamo struct {
	TwitchUserID string
	PrestoEnable string
}

type AdditionalPremiumStatusDynamoDao struct {
	BaseDao
}

type IAdditionalPremiumStatusDynamoDao interface {
	Put(TwitchUserID string) error
	Get(TwitchUserID string) (*AdditionalPremiumStatusDynamo, error)
	Delete(TwitchUserID string) error
}

func NewAdditionalPremiumStatusDynamoDao(client *DynamoClient) IAdditionalPremiumStatusDynamoDao {
	dao := &AdditionalPremiumStatusDynamoDao{}
	dao.client = client
	dao.table = &AdditionalPremiumStatusDynamoTable{}
	return dao
}

func (u *AdditionalPremiumStatusDynamoTable) ConvertAttributeMapToRecord(attributeMap map[string]*dynamodb.AttributeValue) (DynamoTableRecord, error) {
	return &AdditionalPremiumStatusDynamo{
		TwitchUserID: StringFromAttributes(attributeMap, "TwitchUserID"),
		PrestoEnable: StringFromAttributes(attributeMap, "PrestoEnable"),
	}, nil
}

func (u *AdditionalPremiumStatusDynamo) NewItemKey() map[string]*dynamodb.AttributeValue {
	keyMap := make(map[string]*dynamodb.AttributeValue)
	keyMap["TwitchUserID"] = &dynamodb.AttributeValue{S: aws.String(string(u.TwitchUserID))}
	return keyMap
}

func (u *AdditionalPremiumStatusDynamo) NewAttributeMap() map[string]*dynamodb.AttributeValue {
	itemMap := make(map[string]*dynamodb.AttributeValue)
	PopulateAttributesString(itemMap, "TwitchUserID", u.TwitchUserID)
	PopulateAttributesString(itemMap, "PrestoEnable", u.PrestoEnable)
	return itemMap
}

func (dao *AdditionalPremiumStatusDynamoDao) Get(twitchUserID string) (*AdditionalPremiumStatusDynamo, error) {
	var AdditionalPremiumStatusDynamoResult *AdditionalPremiumStatusDynamo

	AdditionalPremiumStatusDynamoQuery := &AdditionalPremiumStatusDynamo{
		TwitchUserID: twitchUserID,
	}

	result, err := dao.client.GetItem(AdditionalPremiumStatusDynamoQuery)
	if err != nil {
		return AdditionalPremiumStatusDynamoResult, err
	}

	if result == nil {
		return nil, nil
	}

	AdditionalPremiumStatusDynamoResult, isAdditionalPremiumStatusDynamo := result.(*AdditionalPremiumStatusDynamo)
	if !isAdditionalPremiumStatusDynamo {
		msg := "Encountered an unexpected type while converting dynamo result to AdditionalPremiumStatusDynamo"
		log.Error(msg)
		return AdditionalPremiumStatusDynamoResult, errors.New(msg)
	}

	return AdditionalPremiumStatusDynamoResult, nil
}

func (dao *AdditionalPremiumStatusDynamoDao) Put(twitchUserID string) error {

	additionalPremiumStatusDynamoNew := &AdditionalPremiumStatusDynamo{
		TwitchUserID: twitchUserID,
		PrestoEnable: "true",
	}
	return dao.client.PutItem(additionalPremiumStatusDynamoNew)
}

func (dao *AdditionalPremiumStatusDynamoDao) Delete(twitchUserID string) error {

	AdditionalPremiumStatusDynamoQuery := &AdditionalPremiumStatusDynamo{
		TwitchUserID: twitchUserID,
	}
	err := dao.client.DeleteItem(AdditionalPremiumStatusDynamoQuery)
	if err != nil {
		return err
	}
	return nil
}

func (te *AdditionalPremiumStatusDynamo) GetTable() DynamoTable {
	return &AdditionalPremiumStatusDynamoTable{}
}
