package dynamo

import (
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

type DynamoTable interface {
	ConvertAttributeMapToRecord(attributeMap map[string]*dynamodb.AttributeValue) (DynamoTableRecord, error)
}

type DynamoTableRecord interface {
	GetTable() DynamoTable
	NewItemKey() map[string]*dynamodb.AttributeValue
	NewAttributeMap() map[string]*dynamodb.AttributeValue
}
