package dynamo

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

func NewGetItemInput(tableName string, record DynamoTableRecord) *dynamodb.GetItemInput {
	return &dynamodb.GetItemInput{
		TableName: aws.String(tableName),
		Key:       record.NewItemKey(),
	}
}

func StringFromAttributes(attributeMap map[string]*dynamodb.AttributeValue, attributeName string) string {
	var result string
	attribute, exists := attributeMap[attributeName]
	if exists {
		result = *attribute.S
	}
	return result
}

func NewPutItemInput(tableName string, record DynamoTableRecord) *dynamodb.PutItemInput {
	record.GetTable()
	itemMap := record.NewAttributeMap()
	return &dynamodb.PutItemInput{
		TableName: aws.String(tableName),
		Item:      itemMap,
	}
}

func PopulateAttributesString(attributeMap map[string]*dynamodb.AttributeValue, attributeName string, attributeValue string) {
	if attributeValue != "" {
		attributeMap[attributeName] = &dynamodb.AttributeValue{S: aws.String(attributeValue)}
	}
}

func NewDeleteItemInput(tableName string, record DynamoTableRecord) *dynamodb.DeleteItemInput {
	return &dynamodb.DeleteItemInput{
		TableName: aws.String(tableName),
		Key:       record.NewItemKey(),
	}
}
