package mako

import (
	"context"
	"testing"

	"code.justin.tv/commerce/mako-client"
	"code.justin.tv/samus/nitro/metrics"
	mocks "code.justin.tv/samus/nitro/mocks/MakoClient"
	"github.com/pkg/errors"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestMakoClient(t *testing.T) {
	Convey("Testing Mako client APIs", t, func() {
		mockMakoClient := new(mocks.Mako)
		mockMetricLogger := new(metrics.MockIMetricLogger)
		makoClient := MakoClient{mockMakoClient, mockMetricLogger}

		userID := "fake-user-id"

		Convey("Testing ResetSmiliesForUser client API", func() {
			smiliesRequest := mako_client.SetSmiliesRequest{UserId: userID, SmiliesSetId: mako_client.SmiliesSetId_ROBOTS}
			smiliesResponse := mako_client.SetSmiliesResponse{SmiliesSetId: mako_client.SmiliesSetId_ROBOTS}

			Convey("with success", func() {
				mockMakoClient.On("SetSmilies", context.TODO(), &smiliesRequest).Return(&smiliesResponse, nil)
				mockMetricLogger.On("AddTwirpDependencyCallMetrics", mock.Anything, mock.Anything, mock.Anything).Return()

				resp, err := makoClient.ResetSmiliesSetForUser(context.TODO(), userID)
				So(err, ShouldBeNil)
				So(resp, ShouldNotBeNil)
			})
			Convey("with failure", func() {
				mockMakoClient.On("SetSmilies", context.TODO(), mock.Anything).Return(nil, errors.New("Oops, something's not right..."))
				mockMetricLogger.On("AddTwirpDependencyCallMetrics", mock.Anything, mock.Anything, mock.Anything).Return()

				resp, err := makoClient.ResetSmiliesSetForUser(context.TODO(), userID)
				So(err, ShouldNotBeNil)
				So(resp, ShouldBeNil)
			})
		})
	})
}
