package subs

import (
	"testing"

	voyagertwirp "code.justin.tv/amzn/TwitchVoyagerTwirp"
	"code.justin.tv/samus/nitro/_tools/src/github.com/pkg/errors"
	"code.justin.tv/samus/nitro/metrics"
	submocks "code.justin.tv/samus/nitro/mocks/SubscriptionsClient"
	voyagermocks "code.justin.tv/samus/nitro/mocks/VoyagerClient"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestSubsServiceClient(t *testing.T) {
	Convey("TestSubsServiceClient", t, func() {
		mockSubscriptionsClient := new(submocks.Subscriptions)
		mockVoyagerClient := new(voyagermocks.TwitchVoyager)
		mockMetricLogger := new(metrics.MockIMetricLogger)

		premiumStatuses := SubsServiceImpl{
			SubsClient:    mockSubscriptionsClient,
			VoyagerClient: mockVoyagerClient,
			metricLogger:  mockMetricLogger,
		}

		Convey("Test GetUserProductSubscriptions", func() {
			Convey("returns a response if subs service is available", func() {
				mockVoyagerClient.On("GetUserProductSubscriptions", mock.Anything, mock.Anything).Return(&voyagertwirp.GetUserProductSubscriptionsResponse{}, nil)
				mockMetricLogger.On("AddTwirpDependencyCallMetrics", mock.Anything, mock.Anything, mock.Anything).Return()

				result, err := premiumStatuses.GetUserProductSubscriptions("id", []string{})
				So(err, ShouldBeNil)
				So(result, ShouldNotBeNil)
			})

			Convey("returns error when subs service has an error", func() {
				mockVoyagerClient.On("GetUserProductSubscriptions", mock.Anything, mock.Anything).Return(nil, errors.New("Error calling subs service"))
				mockMetricLogger.On("AddTwirpDependencyCallMetrics", mock.Anything, mock.Anything, mock.Anything).Return()

				_, err := premiumStatuses.GetUserProductSubscriptions("id", []string{})
				So(err, ShouldNotBeNil)
			})
		})
	})
}
