package wrapper

import (
	"context"
	"fmt"

	log "github.com/sirupsen/logrus"

	"code.justin.tv/foundation/twitchclient"
)

const (
	metricPattern         = "service.%s.%s"
	defaultStatSampleRate = 1.0
	defaultServiceName    = "unknownservice"
	defaultAPIName        = "unknownapi"
)

func GenerateRequestContext(serviceName string, apiName string) context.Context {
	if serviceName == "" {
		log.Error("Service name must not be empty when generating client request context")
		serviceName = defaultServiceName
	}

	if apiName == "" {
		log.Error("API name must not be empty when generating client request context")
		apiName = defaultAPIName
	}

	reqOpts := twitchclient.ReqOpts{}
	reqOpts.StatName = fmt.Sprintf(metricPattern, serviceName, apiName)
	reqOpts.StatSampleRate = defaultStatSampleRate
	ctx := twitchclient.WithReqOpts(context.Background(), reqOpts)
	return ctx
}
