#!/bin/bash

set -e

ACCOUNT=$1

case "$ACCOUNT" in
        nitro)
            ENVIRONMENTS=(prod staging)
            ;;
        *)
            echo "Unknown account \"$ACCOUNT\", exiting"
            exit 1
esac

cd ./terraform/${ACCOUNT}

for ENVIRONMENT in "${ENVIRONMENTS[@]}"
do
    ROLE=`terraform output ${ENVIRONMENT}-iam_role_arn`

    tcs sandstorm role-flags \
        --owner team-samus \
        --name samus-${ENVIRONMENT}-nitro \
        --secret_key "samus/nitro/${ENVIRONMENT}/*" \
        --allowed_arn "${ROLE}" \
        --output ./sandstorm.d/${ACCOUNT}_${ENVIRONMENT}.json

done
