// Code generated by protoc-gen-twirp v3.0.1
// source: mako-service.proto
// DO NOT EDIT!

/*
Package mako_client is a generated twirp stub package.
This code was generated with code.justin.tv/common/twirp/protoc-gen-twirp v3.0.1.

It is generated from these files:
	mako-service.proto
*/
package mako_client

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import bytes "bytes"
import strconv "strconv"
import context "golang.org/x/net/context"
import chitin "code.justin.tv/common/chitin"
import ctxhttp "golang.org/x/net/context/ctxhttp"
import http "net/http"
import ioutil "io/ioutil"
import jsonpb "github.com/golang/protobuf/jsonpb"
import log "log"
import proto1 "github.com/golang/protobuf/proto"
import twirp "code.justin.tv/common/twirp"

// Imports only used by utility functions:
import io "io"
import strings "strings"
import json "encoding/json"
import url "net/url"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// ==============
// Mako Interface
// ==============

type Mako interface {
	// Get Entitlements for a user. Results can be filtered with an EntitlementScopedKey
	GetEntitlements(context.Context, *GetEntitlementsRequest) (*GetEntitlementsResponse, error)

	// Set Entitlement for a user.
	SetEntitlement(context.Context, *SetEntitlementRequest) (*SetEntitlementResponse, error)

	// Get Triggers for an event. Results can be filtered with an EntitlementScopedKey.
	GetTriggers(context.Context, *GetTriggersRequest) (*GetTriggersResponse, error)

	// Set Trigger for an event.
	SetTrigger(context.Context, *SetTriggerRequest) (*SetTriggerResponse, error)

	// Get the emote set details for a given user.
	GetEmoteSetDetails(context.Context, *GetEmoteSetDetailsRequest) (*GetEmoteSetDetailsResponse, error)

	// Get the emoticon group details for the given emoticon groups
	GetEmoticonsByGroups(context.Context, *GetEmoticonsByGroupsRequest) (*GetEmoticonsByGroupsResponse, error)

	// Get the emoticon details for the given emoticon ids
	GetEmoticonsByEmoticonIds(context.Context, *GetEmoticonsByEmoticonIdsRequest) (*GetEmoticonsByEmoticonIdsResponse, error)

	// Get all emotes.
	GetAllEmotes(context.Context, *GetAllEmotesRequest) (*GetAllEmotesResponse, error)

	// Get active emote codes for a given user.
	GetActiveEmoteCodes(context.Context, *GetActiveEmoteCodesRequest) (*GetActiveEmoteCodesResponse, error)

	// Get emoticon image/upload id and url.
	GetEmoticonUploadConfiguration(context.Context, *GetEmoticonUploadConfigurationRequest) (*GetEmoticonUploadConfigurationResponse, error)

	// Create emoticon given 3 upload URLs and emoticon info.
	CreateEmoticon(context.Context, *CreateEmoticonRequest) (*CreateEmoticonReponse, error)

	// Deactivate emoticon given id
	DeactivateEmoticon(context.Context, *DeactivateEmoticonRequest) (*DeactivateEmoticonResponse, error)

	// Update an emoticon's code given new code, code suffix, and emoticon id.
	UpdateEmoticonCode(context.Context, *UpdateEmoticonCodeRequest) (*UpdateEmoticonCodeResponse, error)

	// Get the selected smilies set and emoticon info.
	GetSelectedSmilies(context.Context, *GetSelectedSmiliesRequest) (*GetSelectedSmiliesResponse, error)

	// Get all of the smilies sets and emoticon info.
	GetAllSmilies(context.Context, *GetAllSmiliesRequest) (*GetAllSmiliesResponse, error)

	// Set the selected smilies set and emoticon info.
	SetSmilies(context.Context, *SetSmiliesRequest) (*SetSmiliesResponse, error)

	// Returns S3 URLs to the emoticon all payloads for the legacy kraken endpoints.
	GetLegacyEmoticonAllURLs(context.Context, *GetLegacyEmoticonAllURLsRequest) (*GetLegacyEmoticonAllURLsResponse, error)

	// Represents the kraken/chat/:channel_name/emoticons API which return channel and global emoticons
	// based upon channel_name.
	GetLegacyChannelEmoticons(context.Context, *GetLegacyChannelEmoticonsRequest) (*GetLegacyChannelEmoticonsResponse, error)
}

// ============
// Mako Clients
// ============

type makoProtobufClient struct {
	urlBase string
	client  *http.Client
}

// NewMakoProtobufClient creates a Protobuf client that implements the Mako interface.
// It communicates using protobuf messages and can be configured with a custom http.Client.
func NewMakoProtobufClient(addr string, client *http.Client) Mako {
	return &makoProtobufClient{
		urlBase: urlBase(addr),
		client:  client,
	}
}

func (c *makoProtobufClient) GetEntitlements(ctx context.Context, in *GetEntitlementsRequest) (*GetEntitlementsResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetEntitlements"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetEntitlementsResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) SetEntitlement(ctx context.Context, in *SetEntitlementRequest) (*SetEntitlementResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "SetEntitlement"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(SetEntitlementResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetTriggers(ctx context.Context, in *GetTriggersRequest) (*GetTriggersResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetTriggers"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetTriggersResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) SetTrigger(ctx context.Context, in *SetTriggerRequest) (*SetTriggerResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "SetTrigger"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(SetTriggerResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetEmoteSetDetails(ctx context.Context, in *GetEmoteSetDetailsRequest) (*GetEmoteSetDetailsResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetEmoteSetDetails"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetEmoteSetDetailsResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetEmoticonsByGroups(ctx context.Context, in *GetEmoticonsByGroupsRequest) (*GetEmoticonsByGroupsResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetEmoticonsByGroups"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetEmoticonsByGroupsResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetEmoticonsByEmoticonIds(ctx context.Context, in *GetEmoticonsByEmoticonIdsRequest) (*GetEmoticonsByEmoticonIdsResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetEmoticonsByEmoticonIds"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetEmoticonsByEmoticonIdsResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetAllEmotes(ctx context.Context, in *GetAllEmotesRequest) (*GetAllEmotesResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetAllEmotes"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetAllEmotesResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetActiveEmoteCodes(ctx context.Context, in *GetActiveEmoteCodesRequest) (*GetActiveEmoteCodesResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetActiveEmoteCodes"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetActiveEmoteCodesResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetEmoticonUploadConfiguration(ctx context.Context, in *GetEmoticonUploadConfigurationRequest) (*GetEmoticonUploadConfigurationResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetEmoticonUploadConfiguration"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetEmoticonUploadConfigurationResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "CreateEmoticon"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(CreateEmoticonReponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) DeactivateEmoticon(ctx context.Context, in *DeactivateEmoticonRequest) (*DeactivateEmoticonResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "DeactivateEmoticon"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(DeactivateEmoticonResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) UpdateEmoticonCode(ctx context.Context, in *UpdateEmoticonCodeRequest) (*UpdateEmoticonCodeResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "UpdateEmoticonCode"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(UpdateEmoticonCodeResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetSelectedSmilies(ctx context.Context, in *GetSelectedSmiliesRequest) (*GetSelectedSmiliesResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetSelectedSmilies"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetSelectedSmiliesResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetAllSmilies(ctx context.Context, in *GetAllSmiliesRequest) (*GetAllSmiliesResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetAllSmilies"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetAllSmiliesResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) SetSmilies(ctx context.Context, in *SetSmiliesRequest) (*SetSmiliesResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "SetSmilies"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(SetSmiliesResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetLegacyEmoticonAllURLs(ctx context.Context, in *GetLegacyEmoticonAllURLsRequest) (*GetLegacyEmoticonAllURLsResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetLegacyEmoticonAllURLs"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetLegacyEmoticonAllURLsResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

func (c *makoProtobufClient) GetLegacyChannelEmoticons(ctx context.Context, in *GetLegacyChannelEmoticonsRequest) (*GetLegacyChannelEmoticonsResponse, error) {
	var err error
	bodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return nil, clientError("failed to marshal proto request", err)
	}
	body := bytes.NewBuffer(bodyBytes)
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetLegacyChannelEmoticons"
	req, err := newRequest(ctx, url, body, "application/protobuf")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, clientError("failed to read response body", err)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("failed to read response because context was done", err)
	}

	respContent := new(GetLegacyChannelEmoticonsResponse)
	if err = proto1.Unmarshal(respBody, respContent); err != nil {
		return nil, clientError("failed to unmarshal proto response", err)
	}

	return respContent, nil
}

// NewMakoClient creates a Protobuf client that implements the Mako interface.
// It is the same as NewMakoProtobufClient but pre-configured with a Chitin RoundTripper.
func NewMakoClient(addr string) Mako {
	chitinRT, err := chitin.RoundTripper(context.Background(), http.DefaultTransport)
	if err != nil {
		panic("You are using a very old version of chitin, please upgrade!")
	}
	chitinClient := http.Client{Transport: chitinRT}
	return NewMakoProtobufClient(addr, &chitinClient)
}

type makoJSONClient struct {
	urlBase string
	client  *http.Client
}

// NewMakoJSONClient creates a JSON client that implements the Mako interface.
// It communicates using JSON requests and responses instead of protobuf messages.
func NewMakoJSONClient(addr string, client *http.Client) Mako {
	return &makoJSONClient{
		urlBase: urlBase(addr),
		client:  client,
	}
}

func (c *makoJSONClient) GetEntitlements(ctx context.Context, in *GetEntitlementsRequest) (*GetEntitlementsResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetEntitlements"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetEntitlementsResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) SetEntitlement(ctx context.Context, in *SetEntitlementRequest) (*SetEntitlementResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "SetEntitlement"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(SetEntitlementResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetTriggers(ctx context.Context, in *GetTriggersRequest) (*GetTriggersResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetTriggers"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetTriggersResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) SetTrigger(ctx context.Context, in *SetTriggerRequest) (*SetTriggerResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "SetTrigger"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(SetTriggerResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetEmoteSetDetails(ctx context.Context, in *GetEmoteSetDetailsRequest) (*GetEmoteSetDetailsResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetEmoteSetDetails"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetEmoteSetDetailsResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetEmoticonsByGroups(ctx context.Context, in *GetEmoticonsByGroupsRequest) (*GetEmoticonsByGroupsResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetEmoticonsByGroups"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetEmoticonsByGroupsResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetEmoticonsByEmoticonIds(ctx context.Context, in *GetEmoticonsByEmoticonIdsRequest) (*GetEmoticonsByEmoticonIdsResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetEmoticonsByEmoticonIds"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetEmoticonsByEmoticonIdsResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetAllEmotes(ctx context.Context, in *GetAllEmotesRequest) (*GetAllEmotesResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetAllEmotes"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetAllEmotesResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetActiveEmoteCodes(ctx context.Context, in *GetActiveEmoteCodesRequest) (*GetActiveEmoteCodesResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetActiveEmoteCodes"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetActiveEmoteCodesResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetEmoticonUploadConfiguration(ctx context.Context, in *GetEmoticonUploadConfigurationRequest) (*GetEmoticonUploadConfigurationResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetEmoticonUploadConfiguration"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetEmoticonUploadConfigurationResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "CreateEmoticon"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(CreateEmoticonReponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) DeactivateEmoticon(ctx context.Context, in *DeactivateEmoticonRequest) (*DeactivateEmoticonResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "DeactivateEmoticon"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(DeactivateEmoticonResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) UpdateEmoticonCode(ctx context.Context, in *UpdateEmoticonCodeRequest) (*UpdateEmoticonCodeResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "UpdateEmoticonCode"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(UpdateEmoticonCodeResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetSelectedSmilies(ctx context.Context, in *GetSelectedSmiliesRequest) (*GetSelectedSmiliesResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetSelectedSmilies"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetSelectedSmiliesResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetAllSmilies(ctx context.Context, in *GetAllSmiliesRequest) (*GetAllSmiliesResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetAllSmilies"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetAllSmiliesResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) SetSmilies(ctx context.Context, in *SetSmiliesRequest) (*SetSmiliesResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "SetSmilies"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(SetSmiliesResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetLegacyEmoticonAllURLs(ctx context.Context, in *GetLegacyEmoticonAllURLsRequest) (*GetLegacyEmoticonAllURLsResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetLegacyEmoticonAllURLs"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetLegacyEmoticonAllURLsResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

func (c *makoJSONClient) GetLegacyChannelEmoticons(ctx context.Context, in *GetLegacyChannelEmoticonsRequest) (*GetLegacyChannelEmoticonsResponse, error) {
	var err error
	body := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(body, in); err != nil {
		return nil, clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	url := c.urlBase + MakoPathPrefix + "GetLegacyChannelEmoticons"
	req, err := newRequest(ctx, url, body, "application/json")
	if err != nil {
		return nil, clientError("could not build request", err)
	}

	resp, err := ctxhttp.Do(ctx, c.client, req)
	if err != nil {
		return nil, clientError("failed to do request", err)
	}
	defer closebody(resp.Body)

	if resp.StatusCode != 200 {
		return nil, unmarshalErrorFromJSONResponse(resp.Body)
	}

	if err = done(ctx); err != nil {
		return nil, clientError("aborted because context was done", err)
	}

	respContent := new(GetLegacyChannelEmoticonsResponse)
	if err = jsonpb.Unmarshal(resp.Body, respContent); err != nil {
		return nil, clientError("failed to unmarshal json response", err)
	}

	return respContent, nil
}

// ===================
// Mako Server Handler
// ===================

type makoServer struct {
	Mako
	hooks     *twirp.ServerHooks
	ctxSource ContextSource
}

func NewMakoServer(svc Mako, hooks *twirp.ServerHooks, ctxSrc ContextSource) http.Handler {
	if hooks == nil {
		hooks = twirp.NewServerHooks()
	}
	if ctxSrc == nil {
		ctxSrc = BackgroundContextSource
	}
	return &makoServer{svc, hooks, ctxSrc}
}

// MakoPathPrefix is used for all URL paths on a twirp Mako server.
// Requests are always: POST MakoPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const MakoPathPrefix = "/twirp/code.justin.tv.commerce.mako.Mako/"

// MakoPathPrefixOld is used to handle requests from v2 Clients.
// If you are using an HTTP mux, please handle this routes as well to upgrade from v2 to v3.
const MakoPathPrefixOld = "/v2/code.justin.tv.commerce.mako.Mako/"

func (s *makoServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := s.ctxSource(resp, req)
	ctx = setServerName(ctx, "Mako")
	ctx = setVersionFromPath(ctx, req.URL.Path)
	ctx = context.WithValue(ctx, "__tw_response_writer", resp) // for SetHTTPResponseHeader
	ctx = s.hooks.RequestReceived(ctx)

	if req.Method != "POST" {
		twerr := twirp.NotFoundError(fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
		return
	}

	switch req.URL.Path {
	case MakoPathPrefix + "GetEntitlements", MakoPathPrefixOld + "GetEntitlements", "/v1/Mako/GetEntitlements":
		s.serveGetEntitlements(ctx, resp, req)
		return
	case MakoPathPrefix + "SetEntitlement", MakoPathPrefixOld + "SetEntitlement", "/v1/Mako/SetEntitlement":
		s.serveSetEntitlement(ctx, resp, req)
		return
	case MakoPathPrefix + "GetTriggers", MakoPathPrefixOld + "GetTriggers", "/v1/Mako/GetTriggers":
		s.serveGetTriggers(ctx, resp, req)
		return
	case MakoPathPrefix + "SetTrigger", MakoPathPrefixOld + "SetTrigger", "/v1/Mako/SetTrigger":
		s.serveSetTrigger(ctx, resp, req)
		return
	case MakoPathPrefix + "GetEmoteSetDetails", MakoPathPrefixOld + "GetEmoteSetDetails", "/v1/Mako/GetEmoteSetDetails":
		s.serveGetEmoteSetDetails(ctx, resp, req)
		return
	case MakoPathPrefix + "GetEmoticonsByGroups", MakoPathPrefixOld + "GetEmoticonsByGroups", "/v1/Mako/GetEmoticonsByGroups":
		s.serveGetEmoticonsByGroups(ctx, resp, req)
		return
	case MakoPathPrefix + "GetEmoticonsByEmoticonIds", MakoPathPrefixOld + "GetEmoticonsByEmoticonIds", "/v1/Mako/GetEmoticonsByEmoticonIds":
		s.serveGetEmoticonsByEmoticonIds(ctx, resp, req)
		return
	case MakoPathPrefix + "GetAllEmotes", MakoPathPrefixOld + "GetAllEmotes", "/v1/Mako/GetAllEmotes":
		s.serveGetAllEmotes(ctx, resp, req)
		return
	case MakoPathPrefix + "GetActiveEmoteCodes", MakoPathPrefixOld + "GetActiveEmoteCodes", "/v1/Mako/GetActiveEmoteCodes":
		s.serveGetActiveEmoteCodes(ctx, resp, req)
		return
	case MakoPathPrefix + "GetEmoticonUploadConfiguration", MakoPathPrefixOld + "GetEmoticonUploadConfiguration", "/v1/Mako/GetEmoticonUploadConfiguration":
		s.serveGetEmoticonUploadConfiguration(ctx, resp, req)
		return
	case MakoPathPrefix + "CreateEmoticon", MakoPathPrefixOld + "CreateEmoticon", "/v1/Mako/CreateEmoticon":
		s.serveCreateEmoticon(ctx, resp, req)
		return
	case MakoPathPrefix + "DeactivateEmoticon", MakoPathPrefixOld + "DeactivateEmoticon", "/v1/Mako/DeactivateEmoticon":
		s.serveDeactivateEmoticon(ctx, resp, req)
		return
	case MakoPathPrefix + "UpdateEmoticonCode", MakoPathPrefixOld + "UpdateEmoticonCode", "/v1/Mako/UpdateEmoticonCode":
		s.serveUpdateEmoticonCode(ctx, resp, req)
		return
	case MakoPathPrefix + "GetSelectedSmilies", MakoPathPrefixOld + "GetSelectedSmilies", "/v1/Mako/GetSelectedSmilies":
		s.serveGetSelectedSmilies(ctx, resp, req)
		return
	case MakoPathPrefix + "GetAllSmilies", MakoPathPrefixOld + "GetAllSmilies", "/v1/Mako/GetAllSmilies":
		s.serveGetAllSmilies(ctx, resp, req)
		return
	case MakoPathPrefix + "SetSmilies", MakoPathPrefixOld + "SetSmilies", "/v1/Mako/SetSmilies":
		s.serveSetSmilies(ctx, resp, req)
		return
	case MakoPathPrefix + "GetLegacyEmoticonAllURLs", MakoPathPrefixOld + "GetLegacyEmoticonAllURLs", "/v1/Mako/GetLegacyEmoticonAllURLs":
		s.serveGetLegacyEmoticonAllURLs(ctx, resp, req)
		return
	case MakoPathPrefix + "GetLegacyChannelEmoticons", MakoPathPrefixOld + "GetLegacyChannelEmoticons", "/v1/Mako/GetLegacyChannelEmoticons":
		s.serveGetLegacyChannelEmoticons(ctx, resp, req)
		return
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("no handler for path %q", req.URL.Path))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
		return
	}
}

// Make HTTP response from an error.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *makoServer) serveError(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// When handling v2 client requests, serve backwards-compatible error responses
	if version := getVersion(ctx); version == "v1" || version == "v2" {
		s.serveErrorV1V2(ctx, resp, req, err)
	} else {
		s.serveErrorV3Plus(ctx, resp, req, err)
	}
}

// v3+ error responses.
func (s *makoServer) serveErrorV3Plus(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = setStatusCode(ctx, statusCode)
	ctx = s.hooks.Error(ctx, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, err2 := resp.Write(respBody)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

// v1/v2 backwards-compatible error responses.
// To make it easy to upgrade to v3, a v3 server keeps serving v2-style errors to v2 clients.
func (s *makoServer) serveErrorV1V2(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// Non-twirp errors are wrapped as Unknown 500 (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.NewError(twirp.Unknown, err.Error())
	}

	resp.Header().Set("Content-Type", "text/plain")

	// v2err.Retryable <= v3err.Meta("retryable")
	if twerr.Meta("retryable") != "" {
		resp.Header().Set("Twirp-Error-Retryable", "true")
	}

	// v2err.ErrorID <= v3err.Meta("v2_error_id") if present, otherwise v3err.Code()
	// or "unroutable" if generated from twirp router (NotFound with Meta("twirp_invalid_route"))
	var v2ErrorID string
	if twerr.Code() == twirp.NotFound && twerr.Meta("twirp_invalid_route") != "" {
		v2ErrorID = "unroutable" // as was generated by previous router
	} else if twerr.Meta("v2_error_id") != "" {
		v2ErrorID = twerr.Meta("v2_error_id")
	} else {
		v2ErrorID = string(twerr.Code()) // the string-format of v3 codes match v2 error ids for the most part: i.e. "not_found", "internal", "unknown", "canceled", etc.
	}
	resp.Header().Set("Twirp-ErrorID", v2ErrorID)

	// v2err.StatusCode <= v3err.Meta("v2_status_code") if present, otherwise same as in v3
	statusCode, err := strconv.Atoi(twerr.Meta("v2_status_code"))
	if err != nil {
		statusCode = twirp.ServerHTTPStatusFromErrorCode(twerr.Code()) // v3 it's the same as v2 for the most part: i.e. "not_found" is 404
	}
	ctx = setStatusCode(ctx, statusCode)
	ctx = s.hooks.Error(ctx, twerr)
	resp.WriteHeader(statusCode)

	msg := []byte(twerr.Msg())
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}
	_, err2 := resp.Write(msg)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetEntitlements(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEntitlementsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEntitlementsProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetEntitlementsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEntitlements")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEntitlementsRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetEntitlementsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetEntitlementsResponse and nil error while calling GetEntitlements. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetEntitlementsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEntitlements")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetEntitlementsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetEntitlementsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetEntitlementsResponse and nil error while calling GetEntitlements. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveSetEntitlement(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetEntitlementJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetEntitlementProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveSetEntitlementJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetEntitlement")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetEntitlementRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *SetEntitlementResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetEntitlement(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *SetEntitlementResponse and nil error while calling SetEntitlement. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveSetEntitlementProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetEntitlement")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(SetEntitlementRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *SetEntitlementResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetEntitlement(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *SetEntitlementResponse and nil error while calling SetEntitlement. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetTriggers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetTriggersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTriggersProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetTriggersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetTriggers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetTriggersRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetTriggersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTriggers(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetTriggersResponse and nil error while calling GetTriggers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetTriggersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetTriggers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetTriggersRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetTriggersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTriggers(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetTriggersResponse and nil error while calling GetTriggers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveSetTrigger(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetTriggerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetTriggerProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveSetTriggerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetTrigger")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetTriggerRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *SetTriggerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetTrigger(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *SetTriggerResponse and nil error while calling SetTrigger. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveSetTriggerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetTrigger")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(SetTriggerRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *SetTriggerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetTrigger(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *SetTriggerResponse and nil error while calling SetTrigger. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetEmoteSetDetails(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmoteSetDetailsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoteSetDetailsProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetEmoteSetDetailsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoteSetDetails")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmoteSetDetailsRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetEmoteSetDetailsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoteSetDetails(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetEmoteSetDetailsResponse and nil error while calling GetEmoteSetDetails. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetEmoteSetDetailsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoteSetDetails")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetEmoteSetDetailsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetEmoteSetDetailsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoteSetDetails(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetEmoteSetDetailsResponse and nil error while calling GetEmoteSetDetails. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetEmoticonsByGroups(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmoticonsByGroupsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoticonsByGroupsProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetEmoticonsByGroupsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonsByGroups")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmoticonsByGroupsRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetEmoticonsByGroupsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonsByGroups(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetEmoticonsByGroupsResponse and nil error while calling GetEmoticonsByGroups. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetEmoticonsByGroupsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonsByGroups")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetEmoticonsByGroupsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetEmoticonsByGroupsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonsByGroups(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetEmoticonsByGroupsResponse and nil error while calling GetEmoticonsByGroups. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetEmoticonsByEmoticonIds(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmoticonsByEmoticonIdsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoticonsByEmoticonIdsProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetEmoticonsByEmoticonIdsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonsByEmoticonIds")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmoticonsByEmoticonIdsRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetEmoticonsByEmoticonIdsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonsByEmoticonIds(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetEmoticonsByEmoticonIdsResponse and nil error while calling GetEmoticonsByEmoticonIds. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetEmoticonsByEmoticonIdsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonsByEmoticonIds")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetEmoticonsByEmoticonIdsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetEmoticonsByEmoticonIdsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonsByEmoticonIds(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetEmoticonsByEmoticonIdsResponse and nil error while calling GetEmoticonsByEmoticonIds. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetAllEmotes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetAllEmotesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllEmotesProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetAllEmotesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllEmotes")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetAllEmotesRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetAllEmotesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetAllEmotesResponse and nil error while calling GetAllEmotes. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetAllEmotesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllEmotes")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetAllEmotesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetAllEmotesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetAllEmotesResponse and nil error while calling GetAllEmotes. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetActiveEmoteCodes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetActiveEmoteCodesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetActiveEmoteCodesProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetActiveEmoteCodesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetActiveEmoteCodes")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetActiveEmoteCodesRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetActiveEmoteCodesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetActiveEmoteCodes(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetActiveEmoteCodesResponse and nil error while calling GetActiveEmoteCodes. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetActiveEmoteCodesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetActiveEmoteCodes")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetActiveEmoteCodesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetActiveEmoteCodesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetActiveEmoteCodes(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetActiveEmoteCodesResponse and nil error while calling GetActiveEmoteCodes. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetEmoticonUploadConfiguration(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmoticonUploadConfigurationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoticonUploadConfigurationProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetEmoticonUploadConfigurationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonUploadConfiguration")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmoticonUploadConfigurationRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetEmoticonUploadConfigurationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonUploadConfiguration(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetEmoticonUploadConfigurationResponse and nil error while calling GetEmoticonUploadConfiguration. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetEmoticonUploadConfigurationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonUploadConfiguration")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetEmoticonUploadConfigurationRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetEmoticonUploadConfigurationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonUploadConfiguration(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetEmoticonUploadConfigurationResponse and nil error while calling GetEmoticonUploadConfiguration. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveCreateEmoticon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateEmoticonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateEmoticonProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveCreateEmoticonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateEmoticonRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveCreateEmoticonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(CreateEmoticonRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveDeactivateEmoticon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveDeactivateEmoticonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeactivateEmoticonProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveDeactivateEmoticonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "DeactivateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(DeactivateEmoticonRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *DeactivateEmoticonResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeactivateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *DeactivateEmoticonResponse and nil error while calling DeactivateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveDeactivateEmoticonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "DeactivateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(DeactivateEmoticonRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *DeactivateEmoticonResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeactivateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *DeactivateEmoticonResponse and nil error while calling DeactivateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveUpdateEmoticonCode(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateEmoticonCodeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateEmoticonCodeProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveUpdateEmoticonCodeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateEmoticonCode")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateEmoticonCodeRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *UpdateEmoticonCodeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateEmoticonCode(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *UpdateEmoticonCodeResponse and nil error while calling UpdateEmoticonCode. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveUpdateEmoticonCodeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateEmoticonCode")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(UpdateEmoticonCodeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *UpdateEmoticonCodeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateEmoticonCode(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *UpdateEmoticonCodeResponse and nil error while calling UpdateEmoticonCode. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetSelectedSmilies(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetSelectedSmiliesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSelectedSmiliesProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetSelectedSmiliesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetSelectedSmilies")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetSelectedSmiliesRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetSelectedSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSelectedSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetSelectedSmiliesResponse and nil error while calling GetSelectedSmilies. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetSelectedSmiliesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetSelectedSmilies")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetSelectedSmiliesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetSelectedSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSelectedSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetSelectedSmiliesResponse and nil error while calling GetSelectedSmilies. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetAllSmilies(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetAllSmiliesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllSmiliesProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetAllSmiliesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllSmilies")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetAllSmiliesRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetAllSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetAllSmiliesResponse and nil error while calling GetAllSmilies. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetAllSmiliesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllSmilies")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetAllSmiliesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetAllSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetAllSmiliesResponse and nil error while calling GetAllSmilies. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveSetSmilies(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetSmiliesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetSmiliesProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveSetSmiliesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetSmilies")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetSmiliesRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *SetSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *SetSmiliesResponse and nil error while calling SetSmilies. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveSetSmiliesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetSmilies")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(SetSmiliesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *SetSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *SetSmiliesResponse and nil error while calling SetSmilies. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetLegacyEmoticonAllURLs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetLegacyEmoticonAllURLsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyEmoticonAllURLsProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetLegacyEmoticonAllURLsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetLegacyEmoticonAllURLs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetLegacyEmoticonAllURLsRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetLegacyEmoticonAllURLsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyEmoticonAllURLs(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetLegacyEmoticonAllURLsResponse and nil error while calling GetLegacyEmoticonAllURLs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetLegacyEmoticonAllURLsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetLegacyEmoticonAllURLs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetLegacyEmoticonAllURLsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetLegacyEmoticonAllURLsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyEmoticonAllURLs(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetLegacyEmoticonAllURLsResponse and nil error while calling GetLegacyEmoticonAllURLs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetLegacyChannelEmoticons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetLegacyChannelEmoticonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyChannelEmoticonsProtobuf(ctx, resp, req)
	default:
		twerr := twirp.NotFoundError(fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type")))
		twerr = twerr.WithMeta("twirp_invalid_route", req.Method+" "+req.URL.Path+" - Content-Type:"+req.Header.Get("Content-Type"))
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *makoServer) serveGetLegacyChannelEmoticonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetLegacyChannelEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetLegacyChannelEmoticonsRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		msg := "failed to parse request json: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetLegacyChannelEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyChannelEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetLegacyChannelEmoticonsResponse and nil error while calling GetLegacyChannelEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal json response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

func (s *makoServer) serveGetLegacyChannelEmoticonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetLegacyChannelEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		msg := "unable to read request body: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}
	reqContent := new(GetLegacyChannelEmoticonsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		msg := "failed to parse request proto: " + err.Error()
		s.serveError(ctx, resp, req, twirp.InternalError(msg))
		return
	}

	// Call service method
	var respContent *GetLegacyChannelEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyChannelEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetLegacyChannelEmoticonsResponse and nil error while calling GetLegacyChannelEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		s.serveError(ctx, resp, req, twirp.InternalError("failed to marshal proto response"))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	ctx = s.hooks.ResponseSent(ctx)
}

// =====
// Utils
// =====

// A ContextSource establishes the base context for a Server.
type ContextSource func(http.ResponseWriter, *http.Request) context.Context

var BackgroundContextSource ContextSource = func(http.ResponseWriter, *http.Request) context.Context {
	return context.Background()
}

// done returns ctx.Err() if ctx.Done() indicates that the context done
func done(ctx context.Context) error {
	select {
	case <-ctx.Done():
		return ctx.Err()
	default:
		return nil
	}
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// setMethodName, setServerName, and setStatusCode are functions to
// expose internal state through contexts. The context keys hardcoded
// in here are not to be used on their own. Twirp provides accessor
// functions which will retrieve these values out and give them the
// correct type for you.
func setMethodName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_method_name", name)
}
func setServerName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_service_name", name)
}
func setStatusCode(ctx context.Context, code int) context.Context {
	return context.WithValue(ctx, "__tw_status_code", strconv.Itoa(code))
}

type privateContextKey int

var versionKey = new(privateContextKey)

// setVersionFromPath adds "v1", "v2" or "v3" to the context depending on the path.
func setVersionFromPath(ctx context.Context, path string) context.Context {
	var version string
	if strings.HasPrefix(path, "/v1/") {
		version = "v1"
	} else if strings.HasPrefix(path, "/v2/") {
		version = "v2"
	} else {
		version = "v3"
	}
	return context.WithValue(ctx, versionKey, version)
}

// getVersion returns the version number ("v1", "v2", "v3") or empty string if unset.
func getVersion(ctx context.Context) string {
	v, _ := ctx.Value(versionKey).(string)
	return v
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := ctx.Value("__tw_request_header").(http.Header)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// closebody closes a response or request body and just logs
// any error encountered while closing, since errors are
// considered very unusual.
func closebody(body io.Closer) {
	if err := body.Close(); err != nil {
		log.Printf("error closing body: %q", err)
	}
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v3.0.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// unmarshalErrorFromJSONResponse returns a twirp.Error from JSON data.
// If de-serialization fails, it returns a descriptive Internal error instead
func unmarshalErrorFromJSONResponse(body io.Reader) twirp.Error {
	data, err := ioutil.ReadAll(body)
	if err != nil {
		msg := "failed to read server error response body: " + err.Error()
		return twirp.InternalError(msg)
	}
	var tj twerrJSON
	err = json.Unmarshal(data, &tj)
	if err != nil {
		msg := "failed to unmarshal server error response: " + err.Error()
		return twirp.InternalError(msg)
	}
	code := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(code) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(code, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	msg := desc + ": " + err.Error()
	return twirp.InternalError(msg)
}
