// Code generated by protoc-gen-go. DO NOT EDIT.
// source: twirp/subscriptions.proto

/*
Package substwirp is a generated protocol buffer package.

It is generated from these files:
	twirp/subscriptions.proto

It has these top-level messages:
	EmailPendingPrefixApprovalRequest
	EmailPendingPrefixApprovalResponse
	EmailGlobalEmoteRequest
	EmailGlobalEmoteResponse
	EmailSubscribersRequest
	EmailSubscribersResponse
	EmoticonLevel
	SetScoreRequest
	SetScoreResponse
	SubscriptionCount
	CalculateSubscriberCountRequest
	CalculateSubscriberCountResponse
	GetUserSettingsRequest
	GetUserSettingsResponse
	SetUserSettingsRequest
	SetUserSettingsResponse
	OptionalBool
	Subscription
	FormerSubscriber
	FulfillSubscriptionRequest
	FulfillSubscriptionResponse
	CreateSubscriptionRequest
	CreateSubscriptionResponse
	CancelSubscriptionRequest
	CancelSubscriptionResponse
	UpdateSubscriptionRequest
	UpdateSubscriptionResponse
	CanSubscribeRequest
	CanSubscribeResponse
	ListUserSubscriptionsRequest
	GetUserChannelSubscriptionWithPaymentsDataRequest
	GetUserChannelSubscriptionRequest
	UserSubscription
	UserSubscriptionResult
	ListUserSubscriptionsResponse
	GetUserChannelSubscriptionWithPaymentsDataResponse
	GetUserChannelSubscriptionResponse
	GetUserProductSubscriptionsRequest
	GetUserProductSubscriptionsResponse
	GetUserSubscriptionsRequest
	GetUserSubscriptionsResponse
	GetChannelSubscriptionsRequest
	GetChannelSubscriptionsResponse
	GetFormerSubscribersRequest
	GetFormerSubscribersResponse
	TakedownBadgesRequest
	TakedownBadgesResponse
	TakedownAllBadgesRequest
	TakedownAllBadgesResponse
	GetExternalProductTemplateSKURequest
	GetExternalProductTemplateSKUResponse
	GetExternalProductPurchasableSKURequest
	GetExternalProductPurchasableSKUResponse
	SubKey
	PaidUpgrade
	GetPaidUpgradesRequest
	GetPaidUpgradesResponse
	CreatePaidUpgradeRequest
	CreatePaidUpgradeResponse
	CancelPaidUpgradeRequest
	CancelPaidUpgradeResponse
	CreateChatNotificationTokenRequest
	CreateChatNotificationTokenResponse
	NewTicketInterval
	UseChatNotificationTokenRequest
	UseChatNotificationTokenResponse
	CancelChatNotificationTokenRequest
	CancelChatNotificationTokenResponse
	GetUserChannelChatNotificationTokenRequest
	GetUserChannelChatNotificationTokenResponse
	ChatNotificationToken
	Gift
	GiftKey
	CreateGiftRequest
	CreateGiftResponse
	InsertGiftRequest
	InsertGiftResponse
	CancelGiftRequest
	CancelGiftResponse
	GetGiftsRequest
	GetGiftsResponse
	CanGiftRequest
	CanGiftResponse
	CanSenderGiftRequest
	CanSenderGiftResponse
	CanGiftRecipientRequest
	CanGiftRecipientResponse
	GiftPromotion
	GetGiftPromotionRequest
	GetGiftPromotionResponse
	FulfillGiftsRequest
	FulfillGiftsResponse
	SendMMGChatNotificationRequest
	SendMMGChatNotificationResponse
	SendMMGStartChatNotificationRequest
	SendMMGStartChatNotificationResponse
	GetEmotePrefixRequest
	GetEmotePrefixResponse
	GetEmoticonPrefixRequest
	GetEmoticonPrefixResponse
	CreateEmoticonRequest
	CreateEmoticonReponse
	GetAllEmoticonsByProductIDsRequest
	GetAllEmoticonsByProductIDsResponse
	EmoticonGroup
	Emoticon
	GetPartnerStandingRequest
	GetPartnerStandingResponse
	SubmitEmoticonPrefixRequest
	SubmitEmoticonPrefixResponse
	GetPendingEmoticonsByIDsRequest
	GetPendingEmoticonsByIDsResponse
	GetPendingEmoticonsRequest
	GetPendingEmoticonsResponse
	ReviewPendingEmoticonsRequest
	ReviewPendingEmoticonRequest
	ReviewPendingEmoticonsResponse
	ReviewPendingEmoticonResponse
	EmoticonBucket
	PendingEmoticon
	Product
	ProductInterval
	GetProductsByIDsRequest
	GetProductsByIDsResponse
	GetChannelProductsRequest
	GetChannelProductsResponse
	UpdateProductRequest
	UpdateProductResponse
	UpdateChannelProductsRequest
	UpdateChannelProductsResponse
*/
package substwirp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Subscriptions
// =============
type Platform int32

const (
	Platform_PLATFORM_NONE    Platform = 0
	Platform_PLATFORM_WEB     Platform = 1
	Platform_PLATFORM_IOS     Platform = 2
	Platform_PLATFORM_ANDROID Platform = 3
	Platform_PLATFORM_AMAZON  Platform = 4
)

var Platform_name = map[int32]string{
	0: "PLATFORM_NONE",
	1: "PLATFORM_WEB",
	2: "PLATFORM_IOS",
	3: "PLATFORM_ANDROID",
	4: "PLATFORM_AMAZON",
}
var Platform_value = map[string]int32{
	"PLATFORM_NONE":    0,
	"PLATFORM_WEB":     1,
	"PLATFORM_IOS":     2,
	"PLATFORM_ANDROID": 3,
	"PLATFORM_AMAZON":  4,
}

func (x Platform) String() string {
	return proto.EnumName(Platform_name, int32(x))
}
func (Platform) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type SubscriptionType int32

const (
	// Subscription paid by the user.
	SubscriptionType_SUBSCRIPTION_PAID SubscriptionType = 0
	// Subscription created by spending a prime token.
	SubscriptionType_SUBSCRIPTION_PRIME SubscriptionType = 1
	// Free subscription created by admin tools.
	SubscriptionType_SUBSCRIPTION_ADMIN SubscriptionType = 2
	// When upgrading a non-recurring gift subscription to a recurring paid subscription.
	SubscriptionType_SUBSCRIPTION_GIFT_PAID_UPGRADE SubscriptionType = 3
	// When upgrading a non-recurring prime subscription to a recurring paid subscription.
	SubscriptionType_SUBSCRIPTION_PRIME_PAID_UPGRADE SubscriptionType = 4
	// Subscription for gift recipient.
	SubscriptionType_SUBSCRIPTION_GIFT SubscriptionType = 5
)

var SubscriptionType_name = map[int32]string{
	0: "SUBSCRIPTION_PAID",
	1: "SUBSCRIPTION_PRIME",
	2: "SUBSCRIPTION_ADMIN",
	3: "SUBSCRIPTION_GIFT_PAID_UPGRADE",
	4: "SUBSCRIPTION_PRIME_PAID_UPGRADE",
	5: "SUBSCRIPTION_GIFT",
}
var SubscriptionType_value = map[string]int32{
	"SUBSCRIPTION_PAID":               0,
	"SUBSCRIPTION_PRIME":              1,
	"SUBSCRIPTION_ADMIN":              2,
	"SUBSCRIPTION_GIFT_PAID_UPGRADE":  3,
	"SUBSCRIPTION_PRIME_PAID_UPGRADE": 4,
	"SUBSCRIPTION_GIFT":               5,
}

func (x SubscriptionType) String() string {
	return proto.EnumName(SubscriptionType_name, int32(x))
}
func (SubscriptionType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type GiftState int32

const (
	GiftState_GIFT_NONE     GiftState = 0
	GiftState_GIFT_ACCEPTED GiftState = 1
	GiftState_GIFT_CANCELED GiftState = 2
)

var GiftState_name = map[int32]string{
	0: "GIFT_NONE",
	1: "GIFT_ACCEPTED",
	2: "GIFT_CANCELED",
}
var GiftState_value = map[string]int32{
	"GIFT_NONE":     0,
	"GIFT_ACCEPTED": 1,
	"GIFT_CANCELED": 2,
}

func (x GiftState) String() string {
	return proto.EnumName(GiftState_name, int32(x))
}
func (GiftState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// DiscountType is the type of the discount.
type DiscountType int32

const (
	DiscountType_DISCOUNT_NONE          DiscountType = 0
	DiscountType_DISCOUNT_PERCENTOFF    DiscountType = 1
	DiscountType_DISCOUNT_FIXEDVALUEOFF DiscountType = 2
)

var DiscountType_name = map[int32]string{
	0: "DISCOUNT_NONE",
	1: "DISCOUNT_PERCENTOFF",
	2: "DISCOUNT_FIXEDVALUEOFF",
}
var DiscountType_value = map[string]int32{
	"DISCOUNT_NONE":          0,
	"DISCOUNT_PERCENTOFF":    1,
	"DISCOUNT_FIXEDVALUEOFF": 2,
}

func (x DiscountType) String() string {
	return proto.EnumName(DiscountType_name, int32(x))
}
func (DiscountType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type GiftType int32

const (
	GiftType_GIFT_TYPE_NONE     GiftType = 0
	GiftType_GIFT_TYPE_MYSTERY  GiftType = 1
	GiftType_GIFT_TYPE_STANDARD GiftType = 2
)

var GiftType_name = map[int32]string{
	0: "GIFT_TYPE_NONE",
	1: "GIFT_TYPE_MYSTERY",
	2: "GIFT_TYPE_STANDARD",
}
var GiftType_value = map[string]int32{
	"GIFT_TYPE_NONE":     0,
	"GIFT_TYPE_MYSTERY":  1,
	"GIFT_TYPE_STANDARD": 2,
}

func (x GiftType) String() string {
	return proto.EnumName(GiftType_name, int32(x))
}
func (GiftType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// State of the emote.
type EmoticonState int32

const (
	EmoticonState_EmoticonState_NONE     EmoticonState = 0
	EmoticonState_EmoticonState_ACTIVE   EmoticonState = 1
	EmoticonState_EmoticonState_PENDING  EmoticonState = 2
	EmoticonState_EmoticonState_INACTIVE EmoticonState = 3
)

var EmoticonState_name = map[int32]string{
	0: "EmoticonState_NONE",
	1: "EmoticonState_ACTIVE",
	2: "EmoticonState_PENDING",
	3: "EmoticonState_INACTIVE",
}
var EmoticonState_value = map[string]int32{
	"EmoticonState_NONE":     0,
	"EmoticonState_ACTIVE":   1,
	"EmoticonState_PENDING":  2,
	"EmoticonState_INACTIVE": 3,
}

func (x EmoticonState) String() string {
	return proto.EnumName(EmoticonState_name, int32(x))
}
func (EmoticonState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// State of the emote prefix.
type EmoticonPrefixState int32

const (
	EmoticonPrefixState_PREFIX_UNKNOWN  EmoticonPrefixState = 0
	EmoticonPrefixState_PREFIX_UNSET    EmoticonPrefixState = 1
	EmoticonPrefixState_PREFIX_ACTIVE   EmoticonPrefixState = 2
	EmoticonPrefixState_PREFIX_REJECTED EmoticonPrefixState = 3
	EmoticonPrefixState_PREFIX_PENDING  EmoticonPrefixState = 4
)

var EmoticonPrefixState_name = map[int32]string{
	0: "PREFIX_UNKNOWN",
	1: "PREFIX_UNSET",
	2: "PREFIX_ACTIVE",
	3: "PREFIX_REJECTED",
	4: "PREFIX_PENDING",
}
var EmoticonPrefixState_value = map[string]int32{
	"PREFIX_UNKNOWN":  0,
	"PREFIX_UNSET":    1,
	"PREFIX_ACTIVE":   2,
	"PREFIX_REJECTED": 3,
	"PREFIX_PENDING":  4,
}

func (x EmoticonPrefixState) String() string {
	return proto.EnumName(EmoticonPrefixState_name, int32(x))
}
func (EmoticonPrefixState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type EmoticonFilter int32

const (
	EmoticonFilter_EmoticonFilter_All       EmoticonFilter = 0
	EmoticonFilter_EmoticonFilter_Partner   EmoticonFilter = 1
	EmoticonFilter_EmoticonFilter_Affiliate EmoticonFilter = 2
)

var EmoticonFilter_name = map[int32]string{
	0: "EmoticonFilter_All",
	1: "EmoticonFilter_Partner",
	2: "EmoticonFilter_Affiliate",
}
var EmoticonFilter_value = map[string]int32{
	"EmoticonFilter_All":       0,
	"EmoticonFilter_Partner":   1,
	"EmoticonFilter_Affiliate": 2,
}

func (x EmoticonFilter) String() string {
	return proto.EnumName(EmoticonFilter_name, int32(x))
}
func (EmoticonFilter) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type ProductIntervalUnit int32

const (
	ProductIntervalUnit_ProductIntervalUnit_NONE    ProductIntervalUnit = 0
	ProductIntervalUnit_ProductIntervalUnit_WEEK    ProductIntervalUnit = 1
	ProductIntervalUnit_ProductIntervalUnit_MONTH   ProductIntervalUnit = 2
	ProductIntervalUnit_ProductIntervalUnit_YEAR    ProductIntervalUnit = 3
	ProductIntervalUnit_ProductIntervalUnit_ONETIME ProductIntervalUnit = 4
)

var ProductIntervalUnit_name = map[int32]string{
	0: "ProductIntervalUnit_NONE",
	1: "ProductIntervalUnit_WEEK",
	2: "ProductIntervalUnit_MONTH",
	3: "ProductIntervalUnit_YEAR",
	4: "ProductIntervalUnit_ONETIME",
}
var ProductIntervalUnit_value = map[string]int32{
	"ProductIntervalUnit_NONE":    0,
	"ProductIntervalUnit_WEEK":    1,
	"ProductIntervalUnit_MONTH":   2,
	"ProductIntervalUnit_YEAR":    3,
	"ProductIntervalUnit_ONETIME": 4,
}

func (x ProductIntervalUnit) String() string {
	return proto.EnumName(ProductIntervalUnit_name, int32(x))
}
func (ProductIntervalUnit) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type ListUserSubscriptionsRequest_Filter int32

const (
	ListUserSubscriptionsRequest_ALL      ListUserSubscriptionsRequest_Filter = 0
	ListUserSubscriptionsRequest_PLATFORM ListUserSubscriptionsRequest_Filter = 1
	ListUserSubscriptionsRequest_GIFT     ListUserSubscriptionsRequest_Filter = 2
)

var ListUserSubscriptionsRequest_Filter_name = map[int32]string{
	0: "ALL",
	1: "PLATFORM",
	2: "GIFT",
}
var ListUserSubscriptionsRequest_Filter_value = map[string]int32{
	"ALL":      0,
	"PLATFORM": 1,
	"GIFT":     2,
}

func (x ListUserSubscriptionsRequest_Filter) String() string {
	return proto.EnumName(ListUserSubscriptionsRequest_Filter_name, int32(x))
}
func (ListUserSubscriptionsRequest_Filter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{29, 0}
}

type EmailPendingPrefixApprovalRequest struct {
	UserId        string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	Prefix        string `protobuf:"bytes,2,opt,name=prefix" json:"prefix,omitempty"`
	State         string `protobuf:"bytes,3,opt,name=state" json:"state,omitempty"`
	EmoticonSetId string `protobuf:"bytes,4,opt,name=emoticon_set_id,json=emoticonSetId" json:"emoticon_set_id,omitempty"`
}

func (m *EmailPendingPrefixApprovalRequest) Reset()         { *m = EmailPendingPrefixApprovalRequest{} }
func (m *EmailPendingPrefixApprovalRequest) String() string { return proto.CompactTextString(m) }
func (*EmailPendingPrefixApprovalRequest) ProtoMessage()    {}
func (*EmailPendingPrefixApprovalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{0}
}

func (m *EmailPendingPrefixApprovalRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *EmailPendingPrefixApprovalRequest) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *EmailPendingPrefixApprovalRequest) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *EmailPendingPrefixApprovalRequest) GetEmoticonSetId() string {
	if m != nil {
		return m.EmoticonSetId
	}
	return ""
}

type EmailPendingPrefixApprovalResponse struct {
}

func (m *EmailPendingPrefixApprovalResponse) Reset()         { *m = EmailPendingPrefixApprovalResponse{} }
func (m *EmailPendingPrefixApprovalResponse) String() string { return proto.CompactTextString(m) }
func (*EmailPendingPrefixApprovalResponse) ProtoMessage()    {}
func (*EmailPendingPrefixApprovalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{1}
}

type EmailGlobalEmoteRequest struct {
	UserId  string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	EmoteId string `protobuf:"bytes,2,opt,name=emote_id,json=emoteId" json:"emote_id,omitempty"`
}

func (m *EmailGlobalEmoteRequest) Reset()                    { *m = EmailGlobalEmoteRequest{} }
func (m *EmailGlobalEmoteRequest) String() string            { return proto.CompactTextString(m) }
func (*EmailGlobalEmoteRequest) ProtoMessage()               {}
func (*EmailGlobalEmoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *EmailGlobalEmoteRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *EmailGlobalEmoteRequest) GetEmoteId() string {
	if m != nil {
		return m.EmoteId
	}
	return ""
}

type EmailGlobalEmoteResponse struct {
}

func (m *EmailGlobalEmoteResponse) Reset()                    { *m = EmailGlobalEmoteResponse{} }
func (m *EmailGlobalEmoteResponse) String() string            { return proto.CompactTextString(m) }
func (*EmailGlobalEmoteResponse) ProtoMessage()               {}
func (*EmailGlobalEmoteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type EmailSubscribersRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Title     string `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	Text      string `protobuf:"bytes,3,opt,name=text" json:"text,omitempty"`
}

func (m *EmailSubscribersRequest) Reset()                    { *m = EmailSubscribersRequest{} }
func (m *EmailSubscribersRequest) String() string            { return proto.CompactTextString(m) }
func (*EmailSubscribersRequest) ProtoMessage()               {}
func (*EmailSubscribersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *EmailSubscribersRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *EmailSubscribersRequest) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *EmailSubscribersRequest) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

type EmailSubscribersResponse struct {
}

func (m *EmailSubscribersResponse) Reset()                    { *m = EmailSubscribersResponse{} }
func (m *EmailSubscribersResponse) String() string            { return proto.CompactTextString(m) }
func (*EmailSubscribersResponse) ProtoMessage()               {}
func (*EmailSubscribersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Score
// =====
type EmoticonLevel struct {
	MinimumScore  int64 `protobuf:"varint,1,opt,name=minimum_score,json=minimumScore" json:"minimum_score,omitempty"`
	EmoticonLimit int64 `protobuf:"varint,2,opt,name=emoticon_limit,json=emoticonLimit" json:"emoticon_limit,omitempty"`
}

func (m *EmoticonLevel) Reset()                    { *m = EmoticonLevel{} }
func (m *EmoticonLevel) String() string            { return proto.CompactTextString(m) }
func (*EmoticonLevel) ProtoMessage()               {}
func (*EmoticonLevel) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *EmoticonLevel) GetMinimumScore() int64 {
	if m != nil {
		return m.MinimumScore
	}
	return 0
}

func (m *EmoticonLevel) GetEmoticonLimit() int64 {
	if m != nil {
		return m.EmoticonLimit
	}
	return 0
}

type SetScoreRequest struct {
	ChannelId       string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	SubscriberScore int64  `protobuf:"varint,2,opt,name=subscriber_score,json=subscriberScore" json:"subscriber_score,omitempty"`
}

func (m *SetScoreRequest) Reset()                    { *m = SetScoreRequest{} }
func (m *SetScoreRequest) String() string            { return proto.CompactTextString(m) }
func (*SetScoreRequest) ProtoMessage()               {}
func (*SetScoreRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *SetScoreRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *SetScoreRequest) GetSubscriberScore() int64 {
	if m != nil {
		return m.SubscriberScore
	}
	return 0
}

type SetScoreResponse struct {
	SubscriberScore int64          `protobuf:"varint,1,opt,name=subscriber_score,json=subscriberScore" json:"subscriber_score,omitempty"`
	EmoticonLimit   int64          `protobuf:"varint,2,opt,name=emoticon_limit,json=emoticonLimit" json:"emoticon_limit,omitempty"`
	NextLevel       *EmoticonLevel `protobuf:"bytes,3,opt,name=next_level,json=nextLevel" json:"next_level,omitempty"`
}

func (m *SetScoreResponse) Reset()                    { *m = SetScoreResponse{} }
func (m *SetScoreResponse) String() string            { return proto.CompactTextString(m) }
func (*SetScoreResponse) ProtoMessage()               {}
func (*SetScoreResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *SetScoreResponse) GetSubscriberScore() int64 {
	if m != nil {
		return m.SubscriberScore
	}
	return 0
}

func (m *SetScoreResponse) GetEmoticonLimit() int64 {
	if m != nil {
		return m.EmoticonLimit
	}
	return 0
}

func (m *SetScoreResponse) GetNextLevel() *EmoticonLevel {
	if m != nil {
		return m.NextLevel
	}
	return nil
}

type SubscriptionCount struct {
	Score          int64            `protobuf:"varint,1,opt,name=score" json:"score,omitempty"`
	NextLevel      *EmoticonLevel   `protobuf:"bytes,2,opt,name=next_level,json=nextLevel" json:"next_level,omitempty"`
	CountBreakdown map[string]int64 `protobuf:"bytes,3,rep,name=count_breakdown,json=countBreakdown" json:"count_breakdown,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	ScoreBreakdown map[string]int64 `protobuf:"bytes,4,rep,name=score_breakdown,json=scoreBreakdown" json:"score_breakdown,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	TicketCount    int64            `protobuf:"varint,5,opt,name=ticket_count,json=ticketCount" json:"ticket_count,omitempty"`
	EmoticonLimit  int64            `protobuf:"varint,6,opt,name=emoticon_limit,json=emoticonLimit" json:"emoticon_limit,omitempty"`
}

func (m *SubscriptionCount) Reset()                    { *m = SubscriptionCount{} }
func (m *SubscriptionCount) String() string            { return proto.CompactTextString(m) }
func (*SubscriptionCount) ProtoMessage()               {}
func (*SubscriptionCount) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *SubscriptionCount) GetScore() int64 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *SubscriptionCount) GetNextLevel() *EmoticonLevel {
	if m != nil {
		return m.NextLevel
	}
	return nil
}

func (m *SubscriptionCount) GetCountBreakdown() map[string]int64 {
	if m != nil {
		return m.CountBreakdown
	}
	return nil
}

func (m *SubscriptionCount) GetScoreBreakdown() map[string]int64 {
	if m != nil {
		return m.ScoreBreakdown
	}
	return nil
}

func (m *SubscriptionCount) GetTicketCount() int64 {
	if m != nil {
		return m.TicketCount
	}
	return 0
}

func (m *SubscriptionCount) GetEmoticonLimit() int64 {
	if m != nil {
		return m.EmoticonLimit
	}
	return 0
}

type CalculateSubscriberCountRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *CalculateSubscriberCountRequest) Reset()         { *m = CalculateSubscriberCountRequest{} }
func (m *CalculateSubscriberCountRequest) String() string { return proto.CompactTextString(m) }
func (*CalculateSubscriberCountRequest) ProtoMessage()    {}
func (*CalculateSubscriberCountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{10}
}

func (m *CalculateSubscriberCountRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type CalculateSubscriberCountResponse struct {
	SubsCount *SubscriptionCount `protobuf:"bytes,1,opt,name=subs_count,json=subsCount" json:"subs_count,omitempty"`
}

func (m *CalculateSubscriberCountResponse) Reset()         { *m = CalculateSubscriberCountResponse{} }
func (m *CalculateSubscriberCountResponse) String() string { return proto.CompactTextString(m) }
func (*CalculateSubscriberCountResponse) ProtoMessage()    {}
func (*CalculateSubscriberCountResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{11}
}

func (m *CalculateSubscriberCountResponse) GetSubsCount() *SubscriptionCount {
	if m != nil {
		return m.SubsCount
	}
	return nil
}

// UserSettings
// ============
type GetUserSettingsRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *GetUserSettingsRequest) Reset()                    { *m = GetUserSettingsRequest{} }
func (m *GetUserSettingsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetUserSettingsRequest) ProtoMessage()               {}
func (*GetUserSettingsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GetUserSettingsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type GetUserSettingsResponse struct {
	GiftsInFollowedChannelsOnly bool `protobuf:"varint,1,opt,name=gifts_in_followed_channels_only,json=giftsInFollowedChannelsOnly" json:"gifts_in_followed_channels_only,omitempty"`
	HideGiftCount               bool `protobuf:"varint,2,opt,name=hide_gift_count,json=hideGiftCount" json:"hide_gift_count,omitempty"`
}

func (m *GetUserSettingsResponse) Reset()                    { *m = GetUserSettingsResponse{} }
func (m *GetUserSettingsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetUserSettingsResponse) ProtoMessage()               {}
func (*GetUserSettingsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetUserSettingsResponse) GetGiftsInFollowedChannelsOnly() bool {
	if m != nil {
		return m.GiftsInFollowedChannelsOnly
	}
	return false
}

func (m *GetUserSettingsResponse) GetHideGiftCount() bool {
	if m != nil {
		return m.HideGiftCount
	}
	return false
}

type SetUserSettingsRequest struct {
	UserId                             string        `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	GiftsInFollowedChannelsOnly        bool          `protobuf:"varint,2,opt,name=gifts_in_followed_channels_only,json=giftsInFollowedChannelsOnly" json:"gifts_in_followed_channels_only,omitempty"`
	ReceiveGiftsInFollowedChannelsOnly *OptionalBool `protobuf:"bytes,3,opt,name=receive_gifts_in_followed_channels_only,json=receiveGiftsInFollowedChannelsOnly" json:"receive_gifts_in_followed_channels_only,omitempty"`
	HideGiftCount                      *OptionalBool `protobuf:"bytes,4,opt,name=hide_gift_count,json=hideGiftCount" json:"hide_gift_count,omitempty"`
}

func (m *SetUserSettingsRequest) Reset()                    { *m = SetUserSettingsRequest{} }
func (m *SetUserSettingsRequest) String() string            { return proto.CompactTextString(m) }
func (*SetUserSettingsRequest) ProtoMessage()               {}
func (*SetUserSettingsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *SetUserSettingsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *SetUserSettingsRequest) GetGiftsInFollowedChannelsOnly() bool {
	if m != nil {
		return m.GiftsInFollowedChannelsOnly
	}
	return false
}

func (m *SetUserSettingsRequest) GetReceiveGiftsInFollowedChannelsOnly() *OptionalBool {
	if m != nil {
		return m.ReceiveGiftsInFollowedChannelsOnly
	}
	return nil
}

func (m *SetUserSettingsRequest) GetHideGiftCount() *OptionalBool {
	if m != nil {
		return m.HideGiftCount
	}
	return nil
}

type SetUserSettingsResponse struct {
	GiftsInFollowedChannelsOnly bool `protobuf:"varint,1,opt,name=gifts_in_followed_channels_only,json=giftsInFollowedChannelsOnly" json:"gifts_in_followed_channels_only,omitempty"`
	HideGiftCount               bool `protobuf:"varint,2,opt,name=hide_gift_count,json=hideGiftCount" json:"hide_gift_count,omitempty"`
}

func (m *SetUserSettingsResponse) Reset()                    { *m = SetUserSettingsResponse{} }
func (m *SetUserSettingsResponse) String() string            { return proto.CompactTextString(m) }
func (*SetUserSettingsResponse) ProtoMessage()               {}
func (*SetUserSettingsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *SetUserSettingsResponse) GetGiftsInFollowedChannelsOnly() bool {
	if m != nil {
		return m.GiftsInFollowedChannelsOnly
	}
	return false
}

func (m *SetUserSettingsResponse) GetHideGiftCount() bool {
	if m != nil {
		return m.HideGiftCount
	}
	return false
}

type OptionalBool struct {
	Value bool `protobuf:"varint,1,opt,name=value" json:"value,omitempty"`
}

func (m *OptionalBool) Reset()                    { *m = OptionalBool{} }
func (m *OptionalBool) String() string            { return proto.CompactTextString(m) }
func (*OptionalBool) ProtoMessage()               {}
func (*OptionalBool) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *OptionalBool) GetValue() bool {
	if m != nil {
		return m.Value
	}
	return false
}

// Subscription defines a user's entitlement to product for a time period.
type Subscription struct {
	Id           string                     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	ChannelId    string                     `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	OwnerId      string                     `protobuf:"bytes,3,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId    string                     `protobuf:"bytes,4,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId     string                     `protobuf:"bytes,5,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd   *google_protobuf.Timestamp `protobuf:"bytes,7,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	AccessGuid   string                     `protobuf:"bytes,8,opt,name=access_guid,json=accessGuid" json:"access_guid,omitempty"`
}

func (m *Subscription) Reset()                    { *m = Subscription{} }
func (m *Subscription) String() string            { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()               {}
func (*Subscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *Subscription) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Subscription) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *Subscription) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Subscription) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *Subscription) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *Subscription) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *Subscription) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *Subscription) GetAccessGuid() string {
	if m != nil {
		return m.AccessGuid
	}
	return ""
}

type FormerSubscriber struct {
	Id        string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *FormerSubscriber) Reset()                    { *m = FormerSubscriber{} }
func (m *FormerSubscriber) String() string            { return proto.CompactTextString(m) }
func (*FormerSubscriber) ProtoMessage()               {}
func (*FormerSubscriber) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *FormerSubscriber) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *FormerSubscriber) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type FulfillSubscriptionRequest struct {
	OwnerId      string                     `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId    string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId     string                     `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd   *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	Platform     Platform                   `protobuf:"varint,6,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
}

func (m *FulfillSubscriptionRequest) Reset()                    { *m = FulfillSubscriptionRequest{} }
func (m *FulfillSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*FulfillSubscriptionRequest) ProtoMessage()               {}
func (*FulfillSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *FulfillSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *FulfillSubscriptionRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *FulfillSubscriptionRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *FulfillSubscriptionRequest) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *FulfillSubscriptionRequest) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *FulfillSubscriptionRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

type FulfillSubscriptionResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *FulfillSubscriptionResponse) Reset()                    { *m = FulfillSubscriptionResponse{} }
func (m *FulfillSubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*FulfillSubscriptionResponse) ProtoMessage()               {}
func (*FulfillSubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *FulfillSubscriptionResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

// CreateSubscription
// ===================
type CreateSubscriptionRequest struct {
	OwnerId          string                     `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId        string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId         string                     `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart     *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd       *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	SubscriptionType SubscriptionType           `protobuf:"varint,6,opt,name=subscription_type,json=subscriptionType,enum=code.justin.tv.revenue.subscriptions.SubscriptionType" json:"subscription_type,omitempty"`
}

func (m *CreateSubscriptionRequest) Reset()                    { *m = CreateSubscriptionRequest{} }
func (m *CreateSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateSubscriptionRequest) ProtoMessage()               {}
func (*CreateSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *CreateSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CreateSubscriptionRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateSubscriptionRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *CreateSubscriptionRequest) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *CreateSubscriptionRequest) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *CreateSubscriptionRequest) GetSubscriptionType() SubscriptionType {
	if m != nil {
		return m.SubscriptionType
	}
	return SubscriptionType_SUBSCRIPTION_PAID
}

type CreateSubscriptionResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *CreateSubscriptionResponse) Reset()                    { *m = CreateSubscriptionResponse{} }
func (m *CreateSubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateSubscriptionResponse) ProtoMessage()               {}
func (*CreateSubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *CreateSubscriptionResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

// CancelSubscription
// ==================
type CancelSubscriptionRequest struct {
	OwnerId   string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId string `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId  string `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
}

func (m *CancelSubscriptionRequest) Reset()                    { *m = CancelSubscriptionRequest{} }
func (m *CancelSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelSubscriptionRequest) ProtoMessage()               {}
func (*CancelSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *CancelSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CancelSubscriptionRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CancelSubscriptionRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

type CancelSubscriptionResponse struct {
}

func (m *CancelSubscriptionResponse) Reset()                    { *m = CancelSubscriptionResponse{} }
func (m *CancelSubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelSubscriptionResponse) ProtoMessage()               {}
func (*CancelSubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

// UpdateSubscription
// ==================
type UpdateSubscriptionRequest struct {
	// Types that are valid to be assigned to Subscription:
	//	*UpdateSubscriptionRequest_Id
	//	*UpdateSubscriptionRequest_Key
	Subscription isUpdateSubscriptionRequest_Subscription `protobuf_oneof:"subscription"`
	BenefitEnd   *google_protobuf.Timestamp               `protobuf:"bytes,3,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
}

func (m *UpdateSubscriptionRequest) Reset()                    { *m = UpdateSubscriptionRequest{} }
func (m *UpdateSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateSubscriptionRequest) ProtoMessage()               {}
func (*UpdateSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

type isUpdateSubscriptionRequest_Subscription interface{ isUpdateSubscriptionRequest_Subscription() }

type UpdateSubscriptionRequest_Id struct {
	Id string `protobuf:"bytes,1,opt,name=id,oneof"`
}
type UpdateSubscriptionRequest_Key struct {
	Key *SubKey `protobuf:"bytes,2,opt,name=key,oneof"`
}

func (*UpdateSubscriptionRequest_Id) isUpdateSubscriptionRequest_Subscription()  {}
func (*UpdateSubscriptionRequest_Key) isUpdateSubscriptionRequest_Subscription() {}

func (m *UpdateSubscriptionRequest) GetSubscription() isUpdateSubscriptionRequest_Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *UpdateSubscriptionRequest) GetId() string {
	if x, ok := m.GetSubscription().(*UpdateSubscriptionRequest_Id); ok {
		return x.Id
	}
	return ""
}

func (m *UpdateSubscriptionRequest) GetKey() *SubKey {
	if x, ok := m.GetSubscription().(*UpdateSubscriptionRequest_Key); ok {
		return x.Key
	}
	return nil
}

func (m *UpdateSubscriptionRequest) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UpdateSubscriptionRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UpdateSubscriptionRequest_OneofMarshaler, _UpdateSubscriptionRequest_OneofUnmarshaler, _UpdateSubscriptionRequest_OneofSizer, []interface{}{
		(*UpdateSubscriptionRequest_Id)(nil),
		(*UpdateSubscriptionRequest_Key)(nil),
	}
}

func _UpdateSubscriptionRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UpdateSubscriptionRequest)
	// subscription
	switch x := m.Subscription.(type) {
	case *UpdateSubscriptionRequest_Id:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Id)
	case *UpdateSubscriptionRequest_Key:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Key); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UpdateSubscriptionRequest.Subscription has unexpected type %T", x)
	}
	return nil
}

func _UpdateSubscriptionRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UpdateSubscriptionRequest)
	switch tag {
	case 1: // subscription.id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Subscription = &UpdateSubscriptionRequest_Id{x}
		return true, err
	case 2: // subscription.key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubKey)
		err := b.DecodeMessage(msg)
		m.Subscription = &UpdateSubscriptionRequest_Key{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UpdateSubscriptionRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UpdateSubscriptionRequest)
	// subscription
	switch x := m.Subscription.(type) {
	case *UpdateSubscriptionRequest_Id:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Id)))
		n += len(x.Id)
	case *UpdateSubscriptionRequest_Key:
		s := proto.Size(x.Key)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type UpdateSubscriptionResponse struct {
}

func (m *UpdateSubscriptionResponse) Reset()                    { *m = UpdateSubscriptionResponse{} }
func (m *UpdateSubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateSubscriptionResponse) ProtoMessage()               {}
func (*UpdateSubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

type CanSubscribeRequest struct {
	OwnerId          string           `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId        string           `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Platform         Platform         `protobuf:"varint,3,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	SubscriptionType SubscriptionType `protobuf:"varint,4,opt,name=subscription_type,json=subscriptionType,enum=code.justin.tv.revenue.subscriptions.SubscriptionType" json:"subscription_type,omitempty"`
}

func (m *CanSubscribeRequest) Reset()                    { *m = CanSubscribeRequest{} }
func (m *CanSubscribeRequest) String() string            { return proto.CompactTextString(m) }
func (*CanSubscribeRequest) ProtoMessage()               {}
func (*CanSubscribeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *CanSubscribeRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CanSubscribeRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CanSubscribeRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *CanSubscribeRequest) GetSubscriptionType() SubscriptionType {
	if m != nil {
		return m.SubscriptionType
	}
	return SubscriptionType_SUBSCRIPTION_PAID
}

type CanSubscribeResponse struct {
	CanSubscribe bool `protobuf:"varint,1,opt,name=can_subscribe,json=canSubscribe" json:"can_subscribe,omitempty"`
}

func (m *CanSubscribeResponse) Reset()                    { *m = CanSubscribeResponse{} }
func (m *CanSubscribeResponse) String() string            { return proto.CompactTextString(m) }
func (*CanSubscribeResponse) ProtoMessage()               {}
func (*CanSubscribeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *CanSubscribeResponse) GetCanSubscribe() bool {
	if m != nil {
		return m.CanSubscribe
	}
	return false
}

// ListUserSubscriptionsRequest is the body of ListUserSubscriptions request.
type ListUserSubscriptionsRequest struct {
	OwnerId  string                              `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Limit    int64                               `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	Cursor   string                              `protobuf:"bytes,3,opt,name=cursor" json:"cursor,omitempty"`
	Platform Platform                            `protobuf:"varint,4,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	Filter   ListUserSubscriptionsRequest_Filter `protobuf:"varint,5,opt,name=filter,enum=code.justin.tv.revenue.subscriptions.ListUserSubscriptionsRequest_Filter" json:"filter,omitempty"`
}

func (m *ListUserSubscriptionsRequest) Reset()                    { *m = ListUserSubscriptionsRequest{} }
func (m *ListUserSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListUserSubscriptionsRequest) ProtoMessage()               {}
func (*ListUserSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *ListUserSubscriptionsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *ListUserSubscriptionsRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListUserSubscriptionsRequest) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

func (m *ListUserSubscriptionsRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *ListUserSubscriptionsRequest) GetFilter() ListUserSubscriptionsRequest_Filter {
	if m != nil {
		return m.Filter
	}
	return ListUserSubscriptionsRequest_ALL
}

type GetUserChannelSubscriptionWithPaymentsDataRequest struct {
	OwnerId   string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) Reset() {
	*m = GetUserChannelSubscriptionWithPaymentsDataRequest{}
}
func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelSubscriptionWithPaymentsDataRequest) ProtoMessage() {}
func (*GetUserChannelSubscriptionWithPaymentsDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{30}
}

func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetUserChannelSubscriptionRequest struct {
	OwnerId   string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetUserChannelSubscriptionRequest) Reset()         { *m = GetUserChannelSubscriptionRequest{} }
func (m *GetUserChannelSubscriptionRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserChannelSubscriptionRequest) ProtoMessage()    {}
func (*GetUserChannelSubscriptionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{31}
}

func (m *GetUserChannelSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetUserChannelSubscriptionRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

// UserSubscription defines active subscription for a twitch user.
type UserSubscription struct {
	SubscriptionId string                     `protobuf:"bytes,1,opt,name=subscription_id,json=subscriptionId" json:"subscription_id,omitempty"`
	OwnerId        string                     `protobuf:"bytes,2,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId      string                     `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId       string                     `protobuf:"bytes,4,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart   *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd     *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	Platform       Platform                   `protobuf:"varint,7,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	RenewsAt       *google_protobuf.Timestamp `protobuf:"bytes,8,opt,name=renews_at,json=renewsAt" json:"renews_at,omitempty"`
	ExtPurchaseSku string                     `protobuf:"bytes,9,opt,name=ext_purchase_sku,json=extPurchaseSku" json:"ext_purchase_sku,omitempty"`
	IsPrime        bool                       `protobuf:"varint,10,opt,name=is_prime,json=isPrime" json:"is_prime,omitempty"`
	IsGift         bool                       `protobuf:"varint,11,opt,name=is_gift,json=isGift" json:"is_gift,omitempty"`
	IsRefundable   bool                       `protobuf:"varint,12,opt,name=is_refundable,json=isRefundable" json:"is_refundable,omitempty"`
}

func (m *UserSubscription) Reset()                    { *m = UserSubscription{} }
func (m *UserSubscription) String() string            { return proto.CompactTextString(m) }
func (*UserSubscription) ProtoMessage()               {}
func (*UserSubscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *UserSubscription) GetSubscriptionId() string {
	if m != nil {
		return m.SubscriptionId
	}
	return ""
}

func (m *UserSubscription) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *UserSubscription) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *UserSubscription) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *UserSubscription) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *UserSubscription) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *UserSubscription) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *UserSubscription) GetRenewsAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.RenewsAt
	}
	return nil
}

func (m *UserSubscription) GetExtPurchaseSku() string {
	if m != nil {
		return m.ExtPurchaseSku
	}
	return ""
}

func (m *UserSubscription) GetIsPrime() bool {
	if m != nil {
		return m.IsPrime
	}
	return false
}

func (m *UserSubscription) GetIsGift() bool {
	if m != nil {
		return m.IsGift
	}
	return false
}

func (m *UserSubscription) GetIsRefundable() bool {
	if m != nil {
		return m.IsRefundable
	}
	return false
}

// Element of a list of UserSubscriptions
type UserSubscriptionResult struct {
	Subscription *UserSubscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	Cursor       string            `protobuf:"bytes,2,opt,name=cursor" json:"cursor,omitempty"`
}

func (m *UserSubscriptionResult) Reset()                    { *m = UserSubscriptionResult{} }
func (m *UserSubscriptionResult) String() string            { return proto.CompactTextString(m) }
func (*UserSubscriptionResult) ProtoMessage()               {}
func (*UserSubscriptionResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *UserSubscriptionResult) GetSubscription() *UserSubscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *UserSubscriptionResult) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

// ListUserSubscriptionsResponse is the response to a ListUserSubscriptions request.
type ListUserSubscriptionsResponse struct {
	Results         []*UserSubscriptionResult `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
	HasPreviousPage bool                      `protobuf:"varint,2,opt,name=has_previous_page,json=hasPreviousPage" json:"has_previous_page,omitempty"`
	HasNextPage     bool                      `protobuf:"varint,3,opt,name=has_next_page,json=hasNextPage" json:"has_next_page,omitempty"`
}

func (m *ListUserSubscriptionsResponse) Reset()                    { *m = ListUserSubscriptionsResponse{} }
func (m *ListUserSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListUserSubscriptionsResponse) ProtoMessage()               {}
func (*ListUserSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *ListUserSubscriptionsResponse) GetResults() []*UserSubscriptionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ListUserSubscriptionsResponse) GetHasPreviousPage() bool {
	if m != nil {
		return m.HasPreviousPage
	}
	return false
}

func (m *ListUserSubscriptionsResponse) GetHasNextPage() bool {
	if m != nil {
		return m.HasNextPage
	}
	return false
}

type GetUserChannelSubscriptionWithPaymentsDataResponse struct {
	Subscription *UserSubscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetUserChannelSubscriptionWithPaymentsDataResponse) Reset() {
	*m = GetUserChannelSubscriptionWithPaymentsDataResponse{}
}
func (m *GetUserChannelSubscriptionWithPaymentsDataResponse) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelSubscriptionWithPaymentsDataResponse) ProtoMessage() {}
func (*GetUserChannelSubscriptionWithPaymentsDataResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{35}
}

func (m *GetUserChannelSubscriptionWithPaymentsDataResponse) GetSubscription() *UserSubscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type GetUserChannelSubscriptionResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetUserChannelSubscriptionResponse) Reset()         { *m = GetUserChannelSubscriptionResponse{} }
func (m *GetUserChannelSubscriptionResponse) String() string { return proto.CompactTextString(m) }
func (*GetUserChannelSubscriptionResponse) ProtoMessage()    {}
func (*GetUserChannelSubscriptionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{36}
}

func (m *GetUserChannelSubscriptionResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type GetUserProductSubscriptionsRequest struct {
	OwnerId    string   `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductIds []string `protobuf:"bytes,2,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetUserProductSubscriptionsRequest) Reset()         { *m = GetUserProductSubscriptionsRequest{} }
func (m *GetUserProductSubscriptionsRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserProductSubscriptionsRequest) ProtoMessage()    {}
func (*GetUserProductSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{37}
}

func (m *GetUserProductSubscriptionsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetUserProductSubscriptionsRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

type GetUserProductSubscriptionsResponse struct {
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetUserProductSubscriptionsResponse) Reset()         { *m = GetUserProductSubscriptionsResponse{} }
func (m *GetUserProductSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*GetUserProductSubscriptionsResponse) ProtoMessage()    {}
func (*GetUserProductSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{38}
}

func (m *GetUserProductSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

type GetUserSubscriptionsRequest struct {
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
}

func (m *GetUserSubscriptionsRequest) Reset()                    { *m = GetUserSubscriptionsRequest{} }
func (m *GetUserSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetUserSubscriptionsRequest) ProtoMessage()               {}
func (*GetUserSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *GetUserSubscriptionsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

type GetUserSubscriptionsResponse struct {
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetUserSubscriptionsResponse) Reset()                    { *m = GetUserSubscriptionsResponse{} }
func (m *GetUserSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetUserSubscriptionsResponse) ProtoMessage()               {}
func (*GetUserSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *GetUserSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

// GetChannelSubscriptions
type GetChannelSubscriptionsRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Limit     int32  `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	Offset    int32  `protobuf:"varint,3,opt,name=offset" json:"offset,omitempty"`
}

func (m *GetChannelSubscriptionsRequest) Reset()                    { *m = GetChannelSubscriptionsRequest{} }
func (m *GetChannelSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChannelSubscriptionsRequest) ProtoMessage()               {}
func (*GetChannelSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *GetChannelSubscriptionsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetChannelSubscriptionsRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *GetChannelSubscriptionsRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type GetChannelSubscriptionsResponse struct {
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetChannelSubscriptionsResponse) Reset()         { *m = GetChannelSubscriptionsResponse{} }
func (m *GetChannelSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*GetChannelSubscriptionsResponse) ProtoMessage()    {}
func (*GetChannelSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{42}
}

func (m *GetChannelSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

// GetFormerSubscribers
type GetFormerSubscribersRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Limit     int32  `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	Offset    int32  `protobuf:"varint,3,opt,name=offset" json:"offset,omitempty"`
}

func (m *GetFormerSubscribersRequest) Reset()                    { *m = GetFormerSubscribersRequest{} }
func (m *GetFormerSubscribersRequest) String() string            { return proto.CompactTextString(m) }
func (*GetFormerSubscribersRequest) ProtoMessage()               {}
func (*GetFormerSubscribersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

func (m *GetFormerSubscribersRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetFormerSubscribersRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *GetFormerSubscribersRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type GetFormerSubscribersResponse struct {
	TotalCount      int32               `protobuf:"varint,1,opt,name=total_count,json=totalCount" json:"total_count,omitempty"`
	Subscribers     []*FormerSubscriber `protobuf:"bytes,2,rep,name=subscribers" json:"subscribers,omitempty"`
	HasPreviousPage bool                `protobuf:"varint,3,opt,name=has_previous_page,json=hasPreviousPage" json:"has_previous_page,omitempty"`
	HasNextPage     bool                `protobuf:"varint,4,opt,name=has_next_page,json=hasNextPage" json:"has_next_page,omitempty"`
}

func (m *GetFormerSubscribersResponse) Reset()                    { *m = GetFormerSubscribersResponse{} }
func (m *GetFormerSubscribersResponse) String() string            { return proto.CompactTextString(m) }
func (*GetFormerSubscribersResponse) ProtoMessage()               {}
func (*GetFormerSubscribersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

func (m *GetFormerSubscribersResponse) GetTotalCount() int32 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *GetFormerSubscribersResponse) GetSubscribers() []*FormerSubscriber {
	if m != nil {
		return m.Subscribers
	}
	return nil
}

func (m *GetFormerSubscribersResponse) GetHasPreviousPage() bool {
	if m != nil {
		return m.HasPreviousPage
	}
	return false
}

func (m *GetFormerSubscribersResponse) GetHasNextPage() bool {
	if m != nil {
		return m.HasNextPage
	}
	return false
}

// Subscriber Badges
// ================
type TakedownBadgesRequest struct {
	ChannelId string   `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	BadgeIds  []string `protobuf:"bytes,2,rep,name=badge_ids,json=badgeIds" json:"badge_ids,omitempty"`
	Reason    string   `protobuf:"bytes,3,opt,name=reason" json:"reason,omitempty"`
}

func (m *TakedownBadgesRequest) Reset()                    { *m = TakedownBadgesRequest{} }
func (m *TakedownBadgesRequest) String() string            { return proto.CompactTextString(m) }
func (*TakedownBadgesRequest) ProtoMessage()               {}
func (*TakedownBadgesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

func (m *TakedownBadgesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *TakedownBadgesRequest) GetBadgeIds() []string {
	if m != nil {
		return m.BadgeIds
	}
	return nil
}

func (m *TakedownBadgesRequest) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type TakedownBadgesResponse struct {
	BadgesRemoved []string `protobuf:"bytes,1,rep,name=badges_removed,json=badgesRemoved" json:"badges_removed,omitempty"`
}

func (m *TakedownBadgesResponse) Reset()                    { *m = TakedownBadgesResponse{} }
func (m *TakedownBadgesResponse) String() string            { return proto.CompactTextString(m) }
func (*TakedownBadgesResponse) ProtoMessage()               {}
func (*TakedownBadgesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

func (m *TakedownBadgesResponse) GetBadgesRemoved() []string {
	if m != nil {
		return m.BadgesRemoved
	}
	return nil
}

type TakedownAllBadgesRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Reason    string `protobuf:"bytes,2,opt,name=reason" json:"reason,omitempty"`
}

func (m *TakedownAllBadgesRequest) Reset()                    { *m = TakedownAllBadgesRequest{} }
func (m *TakedownAllBadgesRequest) String() string            { return proto.CompactTextString(m) }
func (*TakedownAllBadgesRequest) ProtoMessage()               {}
func (*TakedownAllBadgesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *TakedownAllBadgesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *TakedownAllBadgesRequest) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type TakedownAllBadgesResponse struct {
	BadgesRemoved []string `protobuf:"bytes,1,rep,name=badges_removed,json=badgesRemoved" json:"badges_removed,omitempty"`
}

func (m *TakedownAllBadgesResponse) Reset()                    { *m = TakedownAllBadgesResponse{} }
func (m *TakedownAllBadgesResponse) String() string            { return proto.CompactTextString(m) }
func (*TakedownAllBadgesResponse) ProtoMessage()               {}
func (*TakedownAllBadgesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *TakedownAllBadgesResponse) GetBadgesRemoved() []string {
	if m != nil {
		return m.BadgesRemoved
	}
	return nil
}

// External Product
// ================
type GetExternalProductTemplateSKURequest struct {
	ProductId   string   `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Platform    Platform `protobuf:"varint,2,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	CountryCode string   `protobuf:"bytes,3,opt,name=country_code,json=countryCode" json:"country_code,omitempty"`
}

func (m *GetExternalProductTemplateSKURequest) Reset()         { *m = GetExternalProductTemplateSKURequest{} }
func (m *GetExternalProductTemplateSKURequest) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductTemplateSKURequest) ProtoMessage()    {}
func (*GetExternalProductTemplateSKURequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{49}
}

func (m *GetExternalProductTemplateSKURequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *GetExternalProductTemplateSKURequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *GetExternalProductTemplateSKURequest) GetCountryCode() string {
	if m != nil {
		return m.CountryCode
	}
	return ""
}

type GetExternalProductTemplateSKUResponse struct {
	SkuId string `protobuf:"bytes,1,opt,name=sku_id,json=skuId" json:"sku_id,omitempty"`
}

func (m *GetExternalProductTemplateSKUResponse) Reset()         { *m = GetExternalProductTemplateSKUResponse{} }
func (m *GetExternalProductTemplateSKUResponse) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductTemplateSKUResponse) ProtoMessage()    {}
func (*GetExternalProductTemplateSKUResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{50}
}

func (m *GetExternalProductTemplateSKUResponse) GetSkuId() string {
	if m != nil {
		return m.SkuId
	}
	return ""
}

type GetExternalProductPurchasableSKURequest struct {
	OwnerId     string   `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId   string   `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Platform    Platform `protobuf:"varint,3,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	CountryCode string   `protobuf:"bytes,4,opt,name=country_code,json=countryCode" json:"country_code,omitempty"`
}

func (m *GetExternalProductPurchasableSKURequest) Reset() {
	*m = GetExternalProductPurchasableSKURequest{}
}
func (m *GetExternalProductPurchasableSKURequest) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductPurchasableSKURequest) ProtoMessage()    {}
func (*GetExternalProductPurchasableSKURequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{51}
}

func (m *GetExternalProductPurchasableSKURequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetExternalProductPurchasableSKURequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *GetExternalProductPurchasableSKURequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *GetExternalProductPurchasableSKURequest) GetCountryCode() string {
	if m != nil {
		return m.CountryCode
	}
	return ""
}

type GetExternalProductPurchasableSKUResponse struct {
	SkuId string `protobuf:"bytes,1,opt,name=sku_id,json=skuId" json:"sku_id,omitempty"`
}

func (m *GetExternalProductPurchasableSKUResponse) Reset() {
	*m = GetExternalProductPurchasableSKUResponse{}
}
func (m *GetExternalProductPurchasableSKUResponse) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductPurchasableSKUResponse) ProtoMessage()    {}
func (*GetExternalProductPurchasableSKUResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{52}
}

func (m *GetExternalProductPurchasableSKUResponse) GetSkuId() string {
	if m != nil {
		return m.SkuId
	}
	return ""
}

// Paid Upgrades
// =============
// SubKey is used to identify unique subscriptions based on
// product owner and origin.
type SubKey struct {
	Product string `protobuf:"bytes,1,opt,name=product" json:"product,omitempty"`
	Owner   string `protobuf:"bytes,2,opt,name=owner" json:"owner,omitempty"`
	Origin  string `protobuf:"bytes,3,opt,name=origin" json:"origin,omitempty"`
}

func (m *SubKey) Reset()                    { *m = SubKey{} }
func (m *SubKey) String() string            { return proto.CompactTextString(m) }
func (*SubKey) ProtoMessage()               {}
func (*SubKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

func (m *SubKey) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *SubKey) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *SubKey) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

type PaidUpgrade struct {
	BaseKey       *SubKey                    `protobuf:"bytes,1,opt,name=base_key,json=baseKey" json:"base_key,omitempty"`
	UpgradeKey    *SubKey                    `protobuf:"bytes,2,opt,name=upgrade_key,json=upgradeKey" json:"upgrade_key,omitempty"`
	EntitlementId string                     `protobuf:"bytes,3,opt,name=entitlement_id,json=entitlementId" json:"entitlement_id,omitempty"`
	StartDate     *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=start_date,json=startDate" json:"start_date,omitempty"`
	Tier          string                     `protobuf:"bytes,5,opt,name=tier" json:"tier,omitempty"`
	Price         int32                      `protobuf:"varint,6,opt,name=price" json:"price,omitempty"`
	PriceId       string                     `protobuf:"bytes,7,opt,name=price_id,json=priceId" json:"price_id,omitempty"`
}

func (m *PaidUpgrade) Reset()                    { *m = PaidUpgrade{} }
func (m *PaidUpgrade) String() string            { return proto.CompactTextString(m) }
func (*PaidUpgrade) ProtoMessage()               {}
func (*PaidUpgrade) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54} }

func (m *PaidUpgrade) GetBaseKey() *SubKey {
	if m != nil {
		return m.BaseKey
	}
	return nil
}

func (m *PaidUpgrade) GetUpgradeKey() *SubKey {
	if m != nil {
		return m.UpgradeKey
	}
	return nil
}

func (m *PaidUpgrade) GetEntitlementId() string {
	if m != nil {
		return m.EntitlementId
	}
	return ""
}

func (m *PaidUpgrade) GetStartDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *PaidUpgrade) GetTier() string {
	if m != nil {
		return m.Tier
	}
	return ""
}

func (m *PaidUpgrade) GetPrice() int32 {
	if m != nil {
		return m.Price
	}
	return 0
}

func (m *PaidUpgrade) GetPriceId() string {
	if m != nil {
		return m.PriceId
	}
	return ""
}

type GetPaidUpgradesRequest struct {
	Keys []*SubKey `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *GetPaidUpgradesRequest) Reset()                    { *m = GetPaidUpgradesRequest{} }
func (m *GetPaidUpgradesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPaidUpgradesRequest) ProtoMessage()               {}
func (*GetPaidUpgradesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

func (m *GetPaidUpgradesRequest) GetKeys() []*SubKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

type GetPaidUpgradesResponse struct {
	PaidUpgrades []*PaidUpgrade `protobuf:"bytes,1,rep,name=paid_upgrades,json=paidUpgrades" json:"paid_upgrades,omitempty"`
}

func (m *GetPaidUpgradesResponse) Reset()                    { *m = GetPaidUpgradesResponse{} }
func (m *GetPaidUpgradesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPaidUpgradesResponse) ProtoMessage()               {}
func (*GetPaidUpgradesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{56} }

func (m *GetPaidUpgradesResponse) GetPaidUpgrades() []*PaidUpgrade {
	if m != nil {
		return m.PaidUpgrades
	}
	return nil
}

type CreatePaidUpgradeRequest struct {
	BaseKey    *SubKey `protobuf:"bytes,1,opt,name=base_key,json=baseKey" json:"base_key,omitempty"`
	UpgradeKey *SubKey `protobuf:"bytes,2,opt,name=upgrade_key,json=upgradeKey" json:"upgrade_key,omitempty"`
}

func (m *CreatePaidUpgradeRequest) Reset()                    { *m = CreatePaidUpgradeRequest{} }
func (m *CreatePaidUpgradeRequest) String() string            { return proto.CompactTextString(m) }
func (*CreatePaidUpgradeRequest) ProtoMessage()               {}
func (*CreatePaidUpgradeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{57} }

func (m *CreatePaidUpgradeRequest) GetBaseKey() *SubKey {
	if m != nil {
		return m.BaseKey
	}
	return nil
}

func (m *CreatePaidUpgradeRequest) GetUpgradeKey() *SubKey {
	if m != nil {
		return m.UpgradeKey
	}
	return nil
}

type CreatePaidUpgradeResponse struct {
	PaidUpgrade *PaidUpgrade `protobuf:"bytes,1,opt,name=paid_upgrade,json=paidUpgrade" json:"paid_upgrade,omitempty"`
}

func (m *CreatePaidUpgradeResponse) Reset()                    { *m = CreatePaidUpgradeResponse{} }
func (m *CreatePaidUpgradeResponse) String() string            { return proto.CompactTextString(m) }
func (*CreatePaidUpgradeResponse) ProtoMessage()               {}
func (*CreatePaidUpgradeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{58} }

func (m *CreatePaidUpgradeResponse) GetPaidUpgrade() *PaidUpgrade {
	if m != nil {
		return m.PaidUpgrade
	}
	return nil
}

type CancelPaidUpgradeRequest struct {
	BaseKey    *SubKey `protobuf:"bytes,1,opt,name=base_key,json=baseKey" json:"base_key,omitempty"`
	UpgradeKey *SubKey `protobuf:"bytes,2,opt,name=upgrade_key,json=upgradeKey" json:"upgrade_key,omitempty"`
}

func (m *CancelPaidUpgradeRequest) Reset()                    { *m = CancelPaidUpgradeRequest{} }
func (m *CancelPaidUpgradeRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelPaidUpgradeRequest) ProtoMessage()               {}
func (*CancelPaidUpgradeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{59} }

func (m *CancelPaidUpgradeRequest) GetBaseKey() *SubKey {
	if m != nil {
		return m.BaseKey
	}
	return nil
}

func (m *CancelPaidUpgradeRequest) GetUpgradeKey() *SubKey {
	if m != nil {
		return m.UpgradeKey
	}
	return nil
}

type CancelPaidUpgradeResponse struct {
}

func (m *CancelPaidUpgradeResponse) Reset()                    { *m = CancelPaidUpgradeResponse{} }
func (m *CancelPaidUpgradeResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelPaidUpgradeResponse) ProtoMessage()               {}
func (*CancelPaidUpgradeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{60} }

// Chat Notifications
// ======
// Example Body for CreateChatNotificationTokenRequest:
// {
// 	    "owner_id": "29386024", Who does the token belong to?
//      "product_id": "834",    Which ticket product?
//      "available_at": "2018-01-02T15:04:05Z",    When is the token granted?
//      "is_prime" : {"value": true}, specifies whether or not the token is coming from a prime sub. Defaults to paid/not-prime if unspecified.
// 		"new_ticket_interval" : {"access_start" : "2018-06-18T15:04:05Z",   used for multi-month subscriptions since the ticket does not
// 							    "access_end" : "2018-07-18T15:04:05Z"}      persist before chat notification call is made from payments service
// }
type CreateChatNotificationTokenRequest struct {
	OwnerId           string                     `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId         string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	AvailableAt       *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=available_at,json=availableAt" json:"available_at,omitempty"`
	IsPrime           *OptionalBool              `protobuf:"bytes,4,opt,name=is_prime,json=isPrime" json:"is_prime,omitempty"`
	NewTicketInterval *NewTicketInterval         `protobuf:"bytes,5,opt,name=new_ticket_interval,json=newTicketInterval" json:"new_ticket_interval,omitempty"`
}

func (m *CreateChatNotificationTokenRequest) Reset()         { *m = CreateChatNotificationTokenRequest{} }
func (m *CreateChatNotificationTokenRequest) String() string { return proto.CompactTextString(m) }
func (*CreateChatNotificationTokenRequest) ProtoMessage()    {}
func (*CreateChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{61}
}

func (m *CreateChatNotificationTokenRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CreateChatNotificationTokenRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateChatNotificationTokenRequest) GetAvailableAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.AvailableAt
	}
	return nil
}

func (m *CreateChatNotificationTokenRequest) GetIsPrime() *OptionalBool {
	if m != nil {
		return m.IsPrime
	}
	return nil
}

func (m *CreateChatNotificationTokenRequest) GetNewTicketInterval() *NewTicketInterval {
	if m != nil {
		return m.NewTicketInterval
	}
	return nil
}

type CreateChatNotificationTokenResponse struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *CreateChatNotificationTokenResponse) Reset()         { *m = CreateChatNotificationTokenResponse{} }
func (m *CreateChatNotificationTokenResponse) String() string { return proto.CompactTextString(m) }
func (*CreateChatNotificationTokenResponse) ProtoMessage()    {}
func (*CreateChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{62}
}

func (m *CreateChatNotificationTokenResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type NewTicketInterval struct {
	AccessStart *google_protobuf.Timestamp `protobuf:"bytes,1,opt,name=access_start,json=accessStart" json:"access_start,omitempty"`
	AccessEnd   *google_protobuf.Timestamp `protobuf:"bytes,2,opt,name=access_end,json=accessEnd" json:"access_end,omitempty"`
}

func (m *NewTicketInterval) Reset()                    { *m = NewTicketInterval{} }
func (m *NewTicketInterval) String() string            { return proto.CompactTextString(m) }
func (*NewTicketInterval) ProtoMessage()               {}
func (*NewTicketInterval) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{63} }

func (m *NewTicketInterval) GetAccessStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.AccessStart
	}
	return nil
}

func (m *NewTicketInterval) GetAccessEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.AccessEnd
	}
	return nil
}

// Example Body for UseChatNotificationTokenRequest:
// {
// 	    "token_id": "29386024", which token do we want to use?
//      "authed_user_id": "834",   the id of the authed user calling this endpoint
//      "custom_message": "im a custom message", do we want to post a custom message?
// }
type UseChatNotificationTokenRequest struct {
	TokenId       string `protobuf:"bytes,1,opt,name=token_id,json=tokenId" json:"token_id,omitempty"`
	AuthedUserId  string `protobuf:"bytes,2,opt,name=authed_user_id,json=authedUserId" json:"authed_user_id,omitempty"`
	CustomMessage string `protobuf:"bytes,3,opt,name=custom_message,json=customMessage" json:"custom_message,omitempty"`
}

func (m *UseChatNotificationTokenRequest) Reset()         { *m = UseChatNotificationTokenRequest{} }
func (m *UseChatNotificationTokenRequest) String() string { return proto.CompactTextString(m) }
func (*UseChatNotificationTokenRequest) ProtoMessage()    {}
func (*UseChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{64}
}

func (m *UseChatNotificationTokenRequest) GetTokenId() string {
	if m != nil {
		return m.TokenId
	}
	return ""
}

func (m *UseChatNotificationTokenRequest) GetAuthedUserId() string {
	if m != nil {
		return m.AuthedUserId
	}
	return ""
}

func (m *UseChatNotificationTokenRequest) GetCustomMessage() string {
	if m != nil {
		return m.CustomMessage
	}
	return ""
}

type UseChatNotificationTokenResponse struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *UseChatNotificationTokenResponse) Reset()         { *m = UseChatNotificationTokenResponse{} }
func (m *UseChatNotificationTokenResponse) String() string { return proto.CompactTextString(m) }
func (*UseChatNotificationTokenResponse) ProtoMessage()    {}
func (*UseChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{65}
}

func (m *UseChatNotificationTokenResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type CancelChatNotificationTokenRequest struct {
	SubscriptionId string `protobuf:"bytes,1,opt,name=subscription_id,json=subscriptionId" json:"subscription_id,omitempty"`
}

func (m *CancelChatNotificationTokenRequest) Reset()         { *m = CancelChatNotificationTokenRequest{} }
func (m *CancelChatNotificationTokenRequest) String() string { return proto.CompactTextString(m) }
func (*CancelChatNotificationTokenRequest) ProtoMessage()    {}
func (*CancelChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{66}
}

func (m *CancelChatNotificationTokenRequest) GetSubscriptionId() string {
	if m != nil {
		return m.SubscriptionId
	}
	return ""
}

type CancelChatNotificationTokenResponse struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *CancelChatNotificationTokenResponse) Reset()         { *m = CancelChatNotificationTokenResponse{} }
func (m *CancelChatNotificationTokenResponse) String() string { return proto.CompactTextString(m) }
func (*CancelChatNotificationTokenResponse) ProtoMessage()    {}
func (*CancelChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{67}
}

func (m *CancelChatNotificationTokenResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type GetUserChannelChatNotificationTokenRequest struct {
	UserId    string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetUserChannelChatNotificationTokenRequest) Reset() {
	*m = GetUserChannelChatNotificationTokenRequest{}
}
func (m *GetUserChannelChatNotificationTokenRequest) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelChatNotificationTokenRequest) ProtoMessage() {}
func (*GetUserChannelChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{68}
}

func (m *GetUserChannelChatNotificationTokenRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetUserChannelChatNotificationTokenRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetUserChannelChatNotificationTokenResponse struct {
	ChatNotificationToken *ChatNotificationToken `protobuf:"bytes,1,opt,name=chat_notification_token,json=chatNotificationToken" json:"chat_notification_token,omitempty"`
}

func (m *GetUserChannelChatNotificationTokenResponse) Reset() {
	*m = GetUserChannelChatNotificationTokenResponse{}
}
func (m *GetUserChannelChatNotificationTokenResponse) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelChatNotificationTokenResponse) ProtoMessage() {}
func (*GetUserChannelChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{69}
}

func (m *GetUserChannelChatNotificationTokenResponse) GetChatNotificationToken() *ChatNotificationToken {
	if m != nil {
		return m.ChatNotificationToken
	}
	return nil
}

type ChatNotificationToken struct {
	Id      string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Message string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	Month   string `protobuf:"bytes,3,opt,name=month" json:"month,omitempty"`
	Kind    string `protobuf:"bytes,4,opt,name=kind" json:"kind,omitempty"`
}

func (m *ChatNotificationToken) Reset()                    { *m = ChatNotificationToken{} }
func (m *ChatNotificationToken) String() string            { return proto.CompactTextString(m) }
func (*ChatNotificationToken) ProtoMessage()               {}
func (*ChatNotificationToken) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{70} }

func (m *ChatNotificationToken) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ChatNotificationToken) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ChatNotificationToken) GetMonth() string {
	if m != nil {
		return m.Month
	}
	return ""
}

func (m *ChatNotificationToken) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

// Gifts
// ======
type Gift struct {
	Sender    string                     `protobuf:"bytes,1,opt,name=sender" json:"sender,omitempty"`
	Recipient string                     `protobuf:"bytes,2,opt,name=recipient" json:"recipient,omitempty"`
	Product   string                     `protobuf:"bytes,3,opt,name=product" json:"product,omitempty"`
	Origin    string                     `protobuf:"bytes,4,opt,name=origin" json:"origin,omitempty"`
	State     GiftState                  `protobuf:"varint,5,opt,name=state,enum=code.justin.tv.revenue.subscriptions.GiftState" json:"state,omitempty"`
	GiftDate  *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=gift_date,json=giftDate" json:"gift_date,omitempty"`
	GiftType  GiftType                   `protobuf:"varint,7,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
}

func (m *Gift) Reset()                    { *m = Gift{} }
func (m *Gift) String() string            { return proto.CompactTextString(m) }
func (*Gift) ProtoMessage()               {}
func (*Gift) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{71} }

func (m *Gift) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

func (m *Gift) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

func (m *Gift) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *Gift) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *Gift) GetState() GiftState {
	if m != nil {
		return m.State
	}
	return GiftState_GIFT_NONE
}

func (m *Gift) GetGiftDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.GiftDate
	}
	return nil
}

func (m *Gift) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

// GiftKey is used to identify gifts using product, origin, owner (receiver), domain.
// This is convention from HATS so that consumers don't need to store extra information.
// Product, owner, origin, domain (POOD) is used as a hash key in the gifts dynamo table
// for blazing fast lookups.
type GiftKey struct {
	Product   string `protobuf:"bytes,1,opt,name=product" json:"product,omitempty"`
	Origin    string `protobuf:"bytes,2,opt,name=origin" json:"origin,omitempty"`
	Recipient string `protobuf:"bytes,3,opt,name=recipient" json:"recipient,omitempty"`
}

func (m *GiftKey) Reset()                    { *m = GiftKey{} }
func (m *GiftKey) String() string            { return proto.CompactTextString(m) }
func (*GiftKey) ProtoMessage()               {}
func (*GiftKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{72} }

func (m *GiftKey) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *GiftKey) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *GiftKey) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

// CreateGiftRequest is the body of a CreateGift rpc request.
type CreateGiftRequest struct {
	Sender    string   `protobuf:"bytes,1,opt,name=sender" json:"sender,omitempty"`
	Recipient string   `protobuf:"bytes,2,opt,name=recipient" json:"recipient,omitempty"`
	Product   string   `protobuf:"bytes,3,opt,name=product" json:"product,omitempty"`
	Origin    string   `protobuf:"bytes,4,opt,name=origin" json:"origin,omitempty"`
	GiftType  GiftType `protobuf:"varint,5,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
}

func (m *CreateGiftRequest) Reset()                    { *m = CreateGiftRequest{} }
func (m *CreateGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateGiftRequest) ProtoMessage()               {}
func (*CreateGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{73} }

func (m *CreateGiftRequest) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

func (m *CreateGiftRequest) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

func (m *CreateGiftRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *CreateGiftRequest) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *CreateGiftRequest) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

// CreateGiftResponse is the response to a CreateGift rpc request.
type CreateGiftResponse struct {
	Gift *Gift `protobuf:"bytes,1,opt,name=gift" json:"gift,omitempty"`
}

func (m *CreateGiftResponse) Reset()                    { *m = CreateGiftResponse{} }
func (m *CreateGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateGiftResponse) ProtoMessage()               {}
func (*CreateGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{74} }

func (m *CreateGiftResponse) GetGift() *Gift {
	if m != nil {
		return m.Gift
	}
	return nil
}

// InsertGiftRequest is the body of a InsertGift rpc request.
type InsertGiftRequest struct {
	Sender    string   `protobuf:"bytes,1,opt,name=sender" json:"sender,omitempty"`
	Recipient string   `protobuf:"bytes,2,opt,name=recipient" json:"recipient,omitempty"`
	Product   string   `protobuf:"bytes,3,opt,name=product" json:"product,omitempty"`
	Origin    string   `protobuf:"bytes,4,opt,name=origin" json:"origin,omitempty"`
	GiftType  GiftType `protobuf:"varint,5,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
}

func (m *InsertGiftRequest) Reset()                    { *m = InsertGiftRequest{} }
func (m *InsertGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*InsertGiftRequest) ProtoMessage()               {}
func (*InsertGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{75} }

func (m *InsertGiftRequest) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

func (m *InsertGiftRequest) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

func (m *InsertGiftRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *InsertGiftRequest) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *InsertGiftRequest) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

// CreateGiftResponse is the response to a CreateGift rpc request.
type InsertGiftResponse struct {
	Gift *Gift `protobuf:"bytes,1,opt,name=gift" json:"gift,omitempty"`
}

func (m *InsertGiftResponse) Reset()                    { *m = InsertGiftResponse{} }
func (m *InsertGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*InsertGiftResponse) ProtoMessage()               {}
func (*InsertGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{76} }

func (m *InsertGiftResponse) GetGift() *Gift {
	if m != nil {
		return m.Gift
	}
	return nil
}

// CancelGiftRequest is the body of a CancelGift rpc request.
type CancelGiftRequest struct {
	Product   string `protobuf:"bytes,1,opt,name=product" json:"product,omitempty"`
	Origin    string `protobuf:"bytes,2,opt,name=origin" json:"origin,omitempty"`
	Recipient string `protobuf:"bytes,3,opt,name=recipient" json:"recipient,omitempty"`
}

func (m *CancelGiftRequest) Reset()                    { *m = CancelGiftRequest{} }
func (m *CancelGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelGiftRequest) ProtoMessage()               {}
func (*CancelGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{77} }

func (m *CancelGiftRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *CancelGiftRequest) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *CancelGiftRequest) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

// CancelGiftResponse is the response of a CancelGift rpc request.
type CancelGiftResponse struct {
	CanceledGift *Gift `protobuf:"bytes,1,opt,name=canceled_gift,json=canceledGift" json:"canceled_gift,omitempty"`
}

func (m *CancelGiftResponse) Reset()                    { *m = CancelGiftResponse{} }
func (m *CancelGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelGiftResponse) ProtoMessage()               {}
func (*CancelGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{78} }

func (m *CancelGiftResponse) GetCanceledGift() *Gift {
	if m != nil {
		return m.CanceledGift
	}
	return nil
}

// GetGifts
type GetGiftsRequest struct {
	Keys []*GiftKey `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *GetGiftsRequest) Reset()                    { *m = GetGiftsRequest{} }
func (m *GetGiftsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGiftsRequest) ProtoMessage()               {}
func (*GetGiftsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{79} }

func (m *GetGiftsRequest) GetKeys() []*GiftKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

type GetGiftsResponse struct {
	Gifts []*Gift `protobuf:"bytes,1,rep,name=gifts" json:"gifts,omitempty"`
}

func (m *GetGiftsResponse) Reset()                    { *m = GetGiftsResponse{} }
func (m *GetGiftsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetGiftsResponse) ProtoMessage()               {}
func (*GetGiftsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{80} }

func (m *GetGiftsResponse) GetGifts() []*Gift {
	if m != nil {
		return m.Gifts
	}
	return nil
}

// CanGift
type CanGiftRequest struct {
	Sender    string `protobuf:"bytes,1,opt,name=sender" json:"sender,omitempty"`
	Recipient string `protobuf:"bytes,2,opt,name=recipient" json:"recipient,omitempty"`
	Product   string `protobuf:"bytes,3,opt,name=product" json:"product,omitempty"`
}

func (m *CanGiftRequest) Reset()                    { *m = CanGiftRequest{} }
func (m *CanGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*CanGiftRequest) ProtoMessage()               {}
func (*CanGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{81} }

func (m *CanGiftRequest) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

func (m *CanGiftRequest) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

func (m *CanGiftRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

type CanGiftResponse struct {
	CanGift bool `protobuf:"varint,1,opt,name=can_gift,json=canGift" json:"can_gift,omitempty"`
}

func (m *CanGiftResponse) Reset()                    { *m = CanGiftResponse{} }
func (m *CanGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*CanGiftResponse) ProtoMessage()               {}
func (*CanGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{82} }

func (m *CanGiftResponse) GetCanGift() bool {
	if m != nil {
		return m.CanGift
	}
	return false
}

// CanSenderGift
type CanSenderGiftRequest struct {
	SenderId  string `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	ProductId string `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
}

func (m *CanSenderGiftRequest) Reset()                    { *m = CanSenderGiftRequest{} }
func (m *CanSenderGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*CanSenderGiftRequest) ProtoMessage()               {}
func (*CanSenderGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{83} }

func (m *CanSenderGiftRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *CanSenderGiftRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

type CanSenderGiftResponse struct {
	CanGift bool `protobuf:"varint,1,opt,name=can_gift,json=canGift" json:"can_gift,omitempty"`
}

func (m *CanSenderGiftResponse) Reset()                    { *m = CanSenderGiftResponse{} }
func (m *CanSenderGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*CanSenderGiftResponse) ProtoMessage()               {}
func (*CanSenderGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{84} }

func (m *CanSenderGiftResponse) GetCanGift() bool {
	if m != nil {
		return m.CanGift
	}
	return false
}

// CanGiftRecipient
type CanGiftRecipientRequest struct {
	SenderId    string   `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	ProductId   string   `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	RecipientId string   `protobuf:"bytes,3,opt,name=recipient_id,json=recipientId" json:"recipient_id,omitempty"`
	GiftType    GiftType `protobuf:"varint,4,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
}

func (m *CanGiftRecipientRequest) Reset()                    { *m = CanGiftRecipientRequest{} }
func (m *CanGiftRecipientRequest) String() string            { return proto.CompactTextString(m) }
func (*CanGiftRecipientRequest) ProtoMessage()               {}
func (*CanGiftRecipientRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{85} }

func (m *CanGiftRecipientRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *CanGiftRecipientRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CanGiftRecipientRequest) GetRecipientId() string {
	if m != nil {
		return m.RecipientId
	}
	return ""
}

func (m *CanGiftRecipientRequest) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

type CanGiftRecipientResponse struct {
	CanGift bool `protobuf:"varint,1,opt,name=can_gift,json=canGift" json:"can_gift,omitempty"`
}

func (m *CanGiftRecipientResponse) Reset()                    { *m = CanGiftRecipientResponse{} }
func (m *CanGiftRecipientResponse) String() string            { return proto.CompactTextString(m) }
func (*CanGiftRecipientResponse) ProtoMessage()               {}
func (*CanGiftRecipientResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{86} }

func (m *CanGiftRecipientResponse) GetCanGift() bool {
	if m != nil {
		return m.CanGift
	}
	return false
}

// GiftPromotion describes the promotion on a subscription product.
type GiftPromotion struct {
	ProductId     string       `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	NewPrice      int64        `protobuf:"varint,2,opt,name=new_price,json=newPrice" json:"new_price,omitempty"`
	OldPrice      int64        `protobuf:"varint,3,opt,name=old_price,json=oldPrice" json:"old_price,omitempty"`
	DiscountType  DiscountType `protobuf:"varint,4,opt,name=discount_type,json=discountType,enum=code.justin.tv.revenue.subscriptions.DiscountType" json:"discount_type,omitempty"`
	DiscountValue int64        `protobuf:"varint,5,opt,name=discount_value,json=discountValue" json:"discount_value,omitempty"`
	Error         string       `protobuf:"bytes,6,opt,name=error" json:"error,omitempty"`
}

func (m *GiftPromotion) Reset()                    { *m = GiftPromotion{} }
func (m *GiftPromotion) String() string            { return proto.CompactTextString(m) }
func (*GiftPromotion) ProtoMessage()               {}
func (*GiftPromotion) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{87} }

func (m *GiftPromotion) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *GiftPromotion) GetNewPrice() int64 {
	if m != nil {
		return m.NewPrice
	}
	return 0
}

func (m *GiftPromotion) GetOldPrice() int64 {
	if m != nil {
		return m.OldPrice
	}
	return 0
}

func (m *GiftPromotion) GetDiscountType() DiscountType {
	if m != nil {
		return m.DiscountType
	}
	return DiscountType_DISCOUNT_NONE
}

func (m *GiftPromotion) GetDiscountValue() int64 {
	if m != nil {
		return m.DiscountValue
	}
	return 0
}

func (m *GiftPromotion) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// GetGiftPromotionRequest describes the request of GetGiftPromotion.
type GetGiftPromotionRequest struct {
	ProductIds []string `protobuf:"bytes,1,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetGiftPromotionRequest) Reset()                    { *m = GetGiftPromotionRequest{} }
func (m *GetGiftPromotionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGiftPromotionRequest) ProtoMessage()               {}
func (*GetGiftPromotionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{88} }

func (m *GetGiftPromotionRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

// GetGiftPromotionResponse describes the response of GetGiftPromotion.
type GetGiftPromotionResponse struct {
	IsPromotionActive bool             `protobuf:"varint,1,opt,name=is_promotion_active,json=isPromotionActive" json:"is_promotion_active,omitempty"`
	GiftPromotions    []*GiftPromotion `protobuf:"bytes,2,rep,name=gift_promotions,json=giftPromotions" json:"gift_promotions,omitempty"`
}

func (m *GetGiftPromotionResponse) Reset()                    { *m = GetGiftPromotionResponse{} }
func (m *GetGiftPromotionResponse) String() string            { return proto.CompactTextString(m) }
func (*GetGiftPromotionResponse) ProtoMessage()               {}
func (*GetGiftPromotionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{89} }

func (m *GetGiftPromotionResponse) GetIsPromotionActive() bool {
	if m != nil {
		return m.IsPromotionActive
	}
	return false
}

func (m *GetGiftPromotionResponse) GetGiftPromotions() []*GiftPromotion {
	if m != nil {
		return m.GiftPromotions
	}
	return nil
}

// FulfillGiftsRequest is the body of FulfillGifts rpc request.
type FulfillGiftsRequest struct {
	SenderId     string                     `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	ProductId    string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId     string                     `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	GiftType     GiftType                   `protobuf:"varint,4,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
	GiftQuantity int32                      `protobuf:"varint,5,opt,name=gift_quantity,json=giftQuantity" json:"gift_quantity,omitempty"`
	BenefitStart *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd   *google_protobuf.Timestamp `protobuf:"bytes,7,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
}

func (m *FulfillGiftsRequest) Reset()                    { *m = FulfillGiftsRequest{} }
func (m *FulfillGiftsRequest) String() string            { return proto.CompactTextString(m) }
func (*FulfillGiftsRequest) ProtoMessage()               {}
func (*FulfillGiftsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{90} }

func (m *FulfillGiftsRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *FulfillGiftsRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *FulfillGiftsRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *FulfillGiftsRequest) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

func (m *FulfillGiftsRequest) GetGiftQuantity() int32 {
	if m != nil {
		return m.GiftQuantity
	}
	return 0
}

func (m *FulfillGiftsRequest) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *FulfillGiftsRequest) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

// FulFillGiftsResponse is an empty response. If subscriptions service can not fulfill this error, it will return appropriate error.
// Error codes:
// 1. InvalidArgumentError : If request is invalid
// 2. FailedPrecondition: If one of the eligibility pre-condition is not true.
// 3. InternalError: If there was an internal server error fulfilling the gift request.
type FulfillGiftsResponse struct {
}

func (m *FulfillGiftsResponse) Reset()                    { *m = FulfillGiftsResponse{} }
func (m *FulfillGiftsResponse) String() string            { return proto.CompactTextString(m) }
func (*FulfillGiftsResponse) ProtoMessage()               {}
func (*FulfillGiftsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{91} }

// SendMMGChatNotificationRequest is the body of the SendMMGChatNotification rpc request.
type SendMMGChatNotificationRequest struct {
	SenderId    string `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	RecipientId string `protobuf:"bytes,2,opt,name=recipient_id,json=recipientId" json:"recipient_id,omitempty"`
	ProductId   string `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	ChannelId   string `protobuf:"bytes,4,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *SendMMGChatNotificationRequest) Reset()                    { *m = SendMMGChatNotificationRequest{} }
func (m *SendMMGChatNotificationRequest) String() string            { return proto.CompactTextString(m) }
func (*SendMMGChatNotificationRequest) ProtoMessage()               {}
func (*SendMMGChatNotificationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{92} }

func (m *SendMMGChatNotificationRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *SendMMGChatNotificationRequest) GetRecipientId() string {
	if m != nil {
		return m.RecipientId
	}
	return ""
}

func (m *SendMMGChatNotificationRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *SendMMGChatNotificationRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

// SendMMGChatNotificationResponse is an empty response
type SendMMGChatNotificationResponse struct {
}

func (m *SendMMGChatNotificationResponse) Reset()         { *m = SendMMGChatNotificationResponse{} }
func (m *SendMMGChatNotificationResponse) String() string { return proto.CompactTextString(m) }
func (*SendMMGChatNotificationResponse) ProtoMessage()    {}
func (*SendMMGChatNotificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{93}
}

// SendMMGStartChatNotificationRequest is the body of the SendMMGStartChatNotification rpc request.
type SendMMGStartChatNotificationRequest struct {
	SenderId     string `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	ProductId    string `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	ChannelId    string `protobuf:"bytes,3,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	GiftQuantity int32  `protobuf:"varint,4,opt,name=gift_quantity,json=giftQuantity" json:"gift_quantity,omitempty"`
}

func (m *SendMMGStartChatNotificationRequest) Reset()         { *m = SendMMGStartChatNotificationRequest{} }
func (m *SendMMGStartChatNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*SendMMGStartChatNotificationRequest) ProtoMessage()    {}
func (*SendMMGStartChatNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{94}
}

func (m *SendMMGStartChatNotificationRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *SendMMGStartChatNotificationRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *SendMMGStartChatNotificationRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *SendMMGStartChatNotificationRequest) GetGiftQuantity() int32 {
	if m != nil {
		return m.GiftQuantity
	}
	return 0
}

// SendMMGStartChatNotificationRequest is an empty response
type SendMMGStartChatNotificationResponse struct {
}

func (m *SendMMGStartChatNotificationResponse) Reset()         { *m = SendMMGStartChatNotificationResponse{} }
func (m *SendMMGStartChatNotificationResponse) String() string { return proto.CompactTextString(m) }
func (*SendMMGStartChatNotificationResponse) ProtoMessage()    {}
func (*SendMMGStartChatNotificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{95}
}

// Emoticons
// ======
type GetEmotePrefixRequest struct {
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
}

func (m *GetEmotePrefixRequest) Reset()                    { *m = GetEmotePrefixRequest{} }
func (m *GetEmotePrefixRequest) String() string            { return proto.CompactTextString(m) }
func (*GetEmotePrefixRequest) ProtoMessage()               {}
func (*GetEmotePrefixRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{96} }

func (m *GetEmotePrefixRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

type GetEmotePrefixResponse struct {
	Prefixes []string `protobuf:"bytes,1,rep,name=prefixes" json:"prefixes,omitempty"`
}

func (m *GetEmotePrefixResponse) Reset()                    { *m = GetEmotePrefixResponse{} }
func (m *GetEmotePrefixResponse) String() string            { return proto.CompactTextString(m) }
func (*GetEmotePrefixResponse) ProtoMessage()               {}
func (*GetEmotePrefixResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{97} }

func (m *GetEmotePrefixResponse) GetPrefixes() []string {
	if m != nil {
		return m.Prefixes
	}
	return nil
}

type GetEmoticonPrefixRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetEmoticonPrefixRequest) Reset()                    { *m = GetEmoticonPrefixRequest{} }
func (m *GetEmoticonPrefixRequest) String() string            { return proto.CompactTextString(m) }
func (*GetEmoticonPrefixRequest) ProtoMessage()               {}
func (*GetEmoticonPrefixRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{98} }

func (m *GetEmoticonPrefixRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetEmoticonPrefixResponse struct {
	Prefix string              `protobuf:"bytes,1,opt,name=prefix" json:"prefix,omitempty"`
	State  EmoticonPrefixState `protobuf:"varint,2,opt,name=state,enum=code.justin.tv.revenue.subscriptions.EmoticonPrefixState" json:"state,omitempty"`
}

func (m *GetEmoticonPrefixResponse) Reset()                    { *m = GetEmoticonPrefixResponse{} }
func (m *GetEmoticonPrefixResponse) String() string            { return proto.CompactTextString(m) }
func (*GetEmoticonPrefixResponse) ProtoMessage()               {}
func (*GetEmoticonPrefixResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{99} }

func (m *GetEmoticonPrefixResponse) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *GetEmoticonPrefixResponse) GetState() EmoticonPrefixState {
	if m != nil {
		return m.State
	}
	return EmoticonPrefixState_PREFIX_UNKNOWN
}

type CreateEmoticonRequest struct {
	UserId     string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	CodeSuffix string `protobuf:"bytes,2,opt,name=code_suffix,json=codeSuffix" json:"code_suffix,omitempty"`
	ProductId  string `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Image28Id  string `protobuf:"bytes,4,opt,name=image28_id,json=image28Id" json:"image28_id,omitempty"`
	Image56Id  string `protobuf:"bytes,5,opt,name=image56_id,json=image56Id" json:"image56_id,omitempty"`
	Image112Id string `protobuf:"bytes,6,opt,name=image112_id,json=image112Id" json:"image112_id,omitempty"`
}

func (m *CreateEmoticonRequest) Reset()                    { *m = CreateEmoticonRequest{} }
func (m *CreateEmoticonRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateEmoticonRequest) ProtoMessage()               {}
func (*CreateEmoticonRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{100} }

func (m *CreateEmoticonRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *CreateEmoticonRequest) GetCodeSuffix() string {
	if m != nil {
		return m.CodeSuffix
	}
	return ""
}

func (m *CreateEmoticonRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateEmoticonRequest) GetImage28Id() string {
	if m != nil {
		return m.Image28Id
	}
	return ""
}

func (m *CreateEmoticonRequest) GetImage56Id() string {
	if m != nil {
		return m.Image56Id
	}
	return ""
}

func (m *CreateEmoticonRequest) GetImage112Id() string {
	if m != nil {
		return m.Image112Id
	}
	return ""
}

type CreateEmoticonReponse struct {
	Id        string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Code      string `protobuf:"bytes,2,opt,name=code" json:"code,omitempty"`
	ProductId string `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	GroupId   string `protobuf:"bytes,4,opt,name=group_id,json=groupId" json:"group_id,omitempty"`
	State     string `protobuf:"bytes,5,opt,name=state" json:"state,omitempty"`
}

func (m *CreateEmoticonReponse) Reset()                    { *m = CreateEmoticonReponse{} }
func (m *CreateEmoticonReponse) String() string            { return proto.CompactTextString(m) }
func (*CreateEmoticonReponse) ProtoMessage()               {}
func (*CreateEmoticonReponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{101} }

func (m *CreateEmoticonReponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CreateEmoticonReponse) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *CreateEmoticonReponse) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateEmoticonReponse) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *CreateEmoticonReponse) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

type GetAllEmoticonsByProductIDsRequest struct {
	ProductIds []string `protobuf:"bytes,1,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetAllEmoticonsByProductIDsRequest) Reset()         { *m = GetAllEmoticonsByProductIDsRequest{} }
func (m *GetAllEmoticonsByProductIDsRequest) String() string { return proto.CompactTextString(m) }
func (*GetAllEmoticonsByProductIDsRequest) ProtoMessage()    {}
func (*GetAllEmoticonsByProductIDsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{102}
}

func (m *GetAllEmoticonsByProductIDsRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

type GetAllEmoticonsByProductIDsResponse struct {
	EmoticonGroups []*EmoticonGroup `protobuf:"bytes,1,rep,name=emoticon_groups,json=emoticonGroups" json:"emoticon_groups,omitempty"`
}

func (m *GetAllEmoticonsByProductIDsResponse) Reset()         { *m = GetAllEmoticonsByProductIDsResponse{} }
func (m *GetAllEmoticonsByProductIDsResponse) String() string { return proto.CompactTextString(m) }
func (*GetAllEmoticonsByProductIDsResponse) ProtoMessage()    {}
func (*GetAllEmoticonsByProductIDsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{103}
}

func (m *GetAllEmoticonsByProductIDsResponse) GetEmoticonGroups() []*EmoticonGroup {
	if m != nil {
		return m.EmoticonGroups
	}
	return nil
}

type EmoticonGroup struct {
	ProductId string      `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Emoticons []*Emoticon `protobuf:"bytes,2,rep,name=emoticons" json:"emoticons,omitempty"`
}

func (m *EmoticonGroup) Reset()                    { *m = EmoticonGroup{} }
func (m *EmoticonGroup) String() string            { return proto.CompactTextString(m) }
func (*EmoticonGroup) ProtoMessage()               {}
func (*EmoticonGroup) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{104} }

func (m *EmoticonGroup) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *EmoticonGroup) GetEmoticons() []*Emoticon {
	if m != nil {
		return m.Emoticons
	}
	return nil
}

type Emoticon struct {
	Id      string        `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Code    string        `protobuf:"bytes,2,opt,name=code" json:"code,omitempty"`
	GroupId string        `protobuf:"bytes,3,opt,name=group_id,json=groupId" json:"group_id,omitempty"`
	State   EmoticonState `protobuf:"varint,4,opt,name=state,enum=code.justin.tv.revenue.subscriptions.EmoticonState" json:"state,omitempty"`
}

func (m *Emoticon) Reset()                    { *m = Emoticon{} }
func (m *Emoticon) String() string            { return proto.CompactTextString(m) }
func (*Emoticon) ProtoMessage()               {}
func (*Emoticon) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{105} }

func (m *Emoticon) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Emoticon) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *Emoticon) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *Emoticon) GetState() EmoticonState {
	if m != nil {
		return m.State
	}
	return EmoticonState_EmoticonState_NONE
}

// GetPartnerStandingRequest takes a user_id to find the partner standing status for.
type GetPartnerStandingRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *GetPartnerStandingRequest) Reset()                    { *m = GetPartnerStandingRequest{} }
func (m *GetPartnerStandingRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPartnerStandingRequest) ProtoMessage()               {}
func (*GetPartnerStandingRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{106} }

func (m *GetPartnerStandingRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

// GetPartnerStandingStatusResponse returns the partner standing status for a given user.
// Partners are considered to be in “good standing” if they have not had a conduct infraction within the last 90 days.
type GetPartnerStandingResponse struct {
	IsInGoodStanding bool `protobuf:"varint,1,opt,name=is_in_good_standing,json=isInGoodStanding" json:"is_in_good_standing,omitempty"`
}

func (m *GetPartnerStandingResponse) Reset()                    { *m = GetPartnerStandingResponse{} }
func (m *GetPartnerStandingResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPartnerStandingResponse) ProtoMessage()               {}
func (*GetPartnerStandingResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{107} }

func (m *GetPartnerStandingResponse) GetIsInGoodStanding() bool {
	if m != nil {
		return m.IsInGoodStanding
	}
	return false
}

// SubmitEmoticonPrefixRequest takes a prefix and a user id.
// Prefix must be between 3 and 10 characters inclusive.
type SubmitEmoticonPrefixRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Prefix    string `protobuf:"bytes,2,opt,name=prefix" json:"prefix,omitempty"`
}

func (m *SubmitEmoticonPrefixRequest) Reset()                    { *m = SubmitEmoticonPrefixRequest{} }
func (m *SubmitEmoticonPrefixRequest) String() string            { return proto.CompactTextString(m) }
func (*SubmitEmoticonPrefixRequest) ProtoMessage()               {}
func (*SubmitEmoticonPrefixRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{108} }

func (m *SubmitEmoticonPrefixRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *SubmitEmoticonPrefixRequest) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

// SubmitEmoticonPrefixResponse will be empty. Check the status code to determine whether the
// request was succesful.
type SubmitEmoticonPrefixResponse struct {
}

func (m *SubmitEmoticonPrefixResponse) Reset()                    { *m = SubmitEmoticonPrefixResponse{} }
func (m *SubmitEmoticonPrefixResponse) String() string            { return proto.CompactTextString(m) }
func (*SubmitEmoticonPrefixResponse) ProtoMessage()               {}
func (*SubmitEmoticonPrefixResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{109} }

// Pending Emoticons
// =========
type GetPendingEmoticonsByIDsRequest struct {
	EmoticonIds []string `protobuf:"bytes,1,rep,name=emoticon_ids,json=emoticonIds" json:"emoticon_ids,omitempty"`
}

func (m *GetPendingEmoticonsByIDsRequest) Reset()         { *m = GetPendingEmoticonsByIDsRequest{} }
func (m *GetPendingEmoticonsByIDsRequest) String() string { return proto.CompactTextString(m) }
func (*GetPendingEmoticonsByIDsRequest) ProtoMessage()    {}
func (*GetPendingEmoticonsByIDsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{110}
}

func (m *GetPendingEmoticonsByIDsRequest) GetEmoticonIds() []string {
	if m != nil {
		return m.EmoticonIds
	}
	return nil
}

type GetPendingEmoticonsByIDsResponse struct {
	Emoticons []*PendingEmoticon `protobuf:"bytes,1,rep,name=emoticons" json:"emoticons,omitempty"`
}

func (m *GetPendingEmoticonsByIDsResponse) Reset()         { *m = GetPendingEmoticonsByIDsResponse{} }
func (m *GetPendingEmoticonsByIDsResponse) String() string { return proto.CompactTextString(m) }
func (*GetPendingEmoticonsByIDsResponse) ProtoMessage()    {}
func (*GetPendingEmoticonsByIDsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{111}
}

func (m *GetPendingEmoticonsByIDsResponse) GetEmoticons() []*PendingEmoticon {
	if m != nil {
		return m.Emoticons
	}
	return nil
}

// GetPendingEmoticonsRequest
type GetPendingEmoticonsRequest struct {
	Filter         EmoticonFilter             `protobuf:"varint,1,opt,name=filter,enum=code.justin.tv.revenue.subscriptions.EmoticonFilter" json:"filter,omitempty"`
	Count          int32                      `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
	Bucket         *EmoticonBucket            `protobuf:"bytes,3,opt,name=bucket" json:"bucket,omitempty"`
	AfterTimestamp *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=after_timestamp,json=afterTimestamp" json:"after_timestamp,omitempty"`
}

func (m *GetPendingEmoticonsRequest) Reset()                    { *m = GetPendingEmoticonsRequest{} }
func (m *GetPendingEmoticonsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPendingEmoticonsRequest) ProtoMessage()               {}
func (*GetPendingEmoticonsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{112} }

func (m *GetPendingEmoticonsRequest) GetFilter() EmoticonFilter {
	if m != nil {
		return m.Filter
	}
	return EmoticonFilter_EmoticonFilter_All
}

func (m *GetPendingEmoticonsRequest) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *GetPendingEmoticonsRequest) GetBucket() *EmoticonBucket {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *GetPendingEmoticonsRequest) GetAfterTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.AfterTimestamp
	}
	return nil
}

// GetPendingEmoticonsResponse
type GetPendingEmoticonsResponse struct {
	Emoticons  []*PendingEmoticon `protobuf:"bytes,1,rep,name=emoticons" json:"emoticons,omitempty"`
	TotalCount int32              `protobuf:"varint,2,opt,name=total_count,json=totalCount" json:"total_count,omitempty"`
}

func (m *GetPendingEmoticonsResponse) Reset()                    { *m = GetPendingEmoticonsResponse{} }
func (m *GetPendingEmoticonsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPendingEmoticonsResponse) ProtoMessage()               {}
func (*GetPendingEmoticonsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{113} }

func (m *GetPendingEmoticonsResponse) GetEmoticons() []*PendingEmoticon {
	if m != nil {
		return m.Emoticons
	}
	return nil
}

func (m *GetPendingEmoticonsResponse) GetTotalCount() int32 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

type ReviewPendingEmoticonsRequest struct {
	Reviews []*ReviewPendingEmoticonRequest `protobuf:"bytes,1,rep,name=reviews" json:"reviews,omitempty"`
	AdminId string                          `protobuf:"bytes,2,opt,name=admin_id,json=adminId" json:"admin_id,omitempty"`
}

func (m *ReviewPendingEmoticonsRequest) Reset()                    { *m = ReviewPendingEmoticonsRequest{} }
func (m *ReviewPendingEmoticonsRequest) String() string            { return proto.CompactTextString(m) }
func (*ReviewPendingEmoticonsRequest) ProtoMessage()               {}
func (*ReviewPendingEmoticonsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{114} }

func (m *ReviewPendingEmoticonsRequest) GetReviews() []*ReviewPendingEmoticonRequest {
	if m != nil {
		return m.Reviews
	}
	return nil
}

func (m *ReviewPendingEmoticonsRequest) GetAdminId() string {
	if m != nil {
		return m.AdminId
	}
	return ""
}

type ReviewPendingEmoticonRequest struct {
	Id                 string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Approve            bool   `protobuf:"varint,2,opt,name=approve" json:"approve,omitempty"`
	DeclineReason      string `protobuf:"bytes,3,opt,name=decline_reason,json=declineReason" json:"decline_reason,omitempty"`
	DeclineExplanation string `protobuf:"bytes,4,opt,name=decline_explanation,json=declineExplanation" json:"decline_explanation,omitempty"`
}

func (m *ReviewPendingEmoticonRequest) Reset()                    { *m = ReviewPendingEmoticonRequest{} }
func (m *ReviewPendingEmoticonRequest) String() string            { return proto.CompactTextString(m) }
func (*ReviewPendingEmoticonRequest) ProtoMessage()               {}
func (*ReviewPendingEmoticonRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{115} }

func (m *ReviewPendingEmoticonRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ReviewPendingEmoticonRequest) GetApprove() bool {
	if m != nil {
		return m.Approve
	}
	return false
}

func (m *ReviewPendingEmoticonRequest) GetDeclineReason() string {
	if m != nil {
		return m.DeclineReason
	}
	return ""
}

func (m *ReviewPendingEmoticonRequest) GetDeclineExplanation() string {
	if m != nil {
		return m.DeclineExplanation
	}
	return ""
}

type ReviewPendingEmoticonsResponse struct {
	Results []*ReviewPendingEmoticonResponse `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
}

func (m *ReviewPendingEmoticonsResponse) Reset()         { *m = ReviewPendingEmoticonsResponse{} }
func (m *ReviewPendingEmoticonsResponse) String() string { return proto.CompactTextString(m) }
func (*ReviewPendingEmoticonsResponse) ProtoMessage()    {}
func (*ReviewPendingEmoticonsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{116}
}

func (m *ReviewPendingEmoticonsResponse) GetResults() []*ReviewPendingEmoticonResponse {
	if m != nil {
		return m.Results
	}
	return nil
}

type ReviewPendingEmoticonResponse struct {
	Id        string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Succeeded bool   `protobuf:"varint,2,opt,name=succeeded" json:"succeeded,omitempty"`
	NewStatus string `protobuf:"bytes,3,opt,name=new_status,json=newStatus" json:"new_status,omitempty"`
}

func (m *ReviewPendingEmoticonResponse) Reset()                    { *m = ReviewPendingEmoticonResponse{} }
func (m *ReviewPendingEmoticonResponse) String() string            { return proto.CompactTextString(m) }
func (*ReviewPendingEmoticonResponse) ProtoMessage()               {}
func (*ReviewPendingEmoticonResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{117} }

func (m *ReviewPendingEmoticonResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ReviewPendingEmoticonResponse) GetSucceeded() bool {
	if m != nil {
		return m.Succeeded
	}
	return false
}

func (m *ReviewPendingEmoticonResponse) GetNewStatus() string {
	if m != nil {
		return m.NewStatus
	}
	return ""
}

type EmoticonBucket struct {
	Requested   int32 `protobuf:"varint,1,opt,name=requested" json:"requested,omitempty"`
	BucketCount int32 `protobuf:"varint,2,opt,name=bucket_count,json=bucketCount" json:"bucket_count,omitempty"`
}

func (m *EmoticonBucket) Reset()                    { *m = EmoticonBucket{} }
func (m *EmoticonBucket) String() string            { return proto.CompactTextString(m) }
func (*EmoticonBucket) ProtoMessage()               {}
func (*EmoticonBucket) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{118} }

func (m *EmoticonBucket) GetRequested() int32 {
	if m != nil {
		return m.Requested
	}
	return 0
}

func (m *EmoticonBucket) GetBucketCount() int32 {
	if m != nil {
		return m.BucketCount
	}
	return 0
}

// PendingEmoticon contains all the data necessary for Moderation to view and judge an emoticon
type PendingEmoticon struct {
	Id         string                     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Prefix     string                     `protobuf:"bytes,2,opt,name=prefix" json:"prefix,omitempty"`
	Code       string                     `protobuf:"bytes,3,opt,name=code" json:"code,omitempty"`
	OwnerId    string                     `protobuf:"bytes,4,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	UploadTime *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=upload_time,json=uploadTime" json:"upload_time,omitempty"`
}

func (m *PendingEmoticon) Reset()                    { *m = PendingEmoticon{} }
func (m *PendingEmoticon) String() string            { return proto.CompactTextString(m) }
func (*PendingEmoticon) ProtoMessage()               {}
func (*PendingEmoticon) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{119} }

func (m *PendingEmoticon) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PendingEmoticon) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *PendingEmoticon) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *PendingEmoticon) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *PendingEmoticon) GetUploadTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.UploadTime
	}
	return nil
}

// Products
// =========
type Product struct {
	Id              string           `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	ShortName       string           `protobuf:"bytes,2,opt,name=short_name,json=shortName" json:"short_name,omitempty"`
	DisplayName     string           `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	EmoticonSetIds  []string         `protobuf:"bytes,4,rep,name=emoticon_set_ids,json=emoticonSetIds" json:"emoticon_set_ids,omitempty"`
	Price           int32            `protobuf:"varint,5,opt,name=price" json:"price,omitempty"`
	HideAds         bool             `protobuf:"varint,6,opt,name=hide_ads,json=hideAds" json:"hide_ads,omitempty"`
	Type            string           `protobuf:"bytes,7,opt,name=type" json:"type,omitempty"`
	OwnerId         string           `protobuf:"bytes,8,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Tier            string           `protobuf:"bytes,9,opt,name=tier" json:"tier,omitempty"`
	Interval        *ProductInterval `protobuf:"bytes,10,opt,name=interval" json:"interval,omitempty"`
	BitrateAccess   []string         `protobuf:"bytes,11,rep,name=bitrate_access,json=bitrateAccess" json:"bitrate_access,omitempty"`
	SubonlyArchives bool             `protobuf:"varint,12,opt,name=subonly_archives,json=subonlyArchives" json:"subonly_archives,omitempty"`
	EmoticonSetId   string           `protobuf:"bytes,13,opt,name=emoticon_set_id,json=emoticonSetId" json:"emoticon_set_id,omitempty"`
	PriceId         string           `protobuf:"bytes,14,opt,name=price_id,json=priceId" json:"price_id,omitempty"`
}

func (m *Product) Reset()                    { *m = Product{} }
func (m *Product) String() string            { return proto.CompactTextString(m) }
func (*Product) ProtoMessage()               {}
func (*Product) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{120} }

func (m *Product) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Product) GetShortName() string {
	if m != nil {
		return m.ShortName
	}
	return ""
}

func (m *Product) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Product) GetEmoticonSetIds() []string {
	if m != nil {
		return m.EmoticonSetIds
	}
	return nil
}

func (m *Product) GetPrice() int32 {
	if m != nil {
		return m.Price
	}
	return 0
}

func (m *Product) GetHideAds() bool {
	if m != nil {
		return m.HideAds
	}
	return false
}

func (m *Product) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Product) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Product) GetTier() string {
	if m != nil {
		return m.Tier
	}
	return ""
}

func (m *Product) GetInterval() *ProductInterval {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *Product) GetBitrateAccess() []string {
	if m != nil {
		return m.BitrateAccess
	}
	return nil
}

func (m *Product) GetSubonlyArchives() bool {
	if m != nil {
		return m.SubonlyArchives
	}
	return false
}

func (m *Product) GetEmoticonSetId() string {
	if m != nil {
		return m.EmoticonSetId
	}
	return ""
}

func (m *Product) GetPriceId() string {
	if m != nil {
		return m.PriceId
	}
	return ""
}

type ProductInterval struct {
	Duration int32               `protobuf:"varint,1,opt,name=duration" json:"duration,omitempty"`
	Unit     ProductIntervalUnit `protobuf:"varint,2,opt,name=unit,enum=code.justin.tv.revenue.subscriptions.ProductIntervalUnit" json:"unit,omitempty"`
}

func (m *ProductInterval) Reset()                    { *m = ProductInterval{} }
func (m *ProductInterval) String() string            { return proto.CompactTextString(m) }
func (*ProductInterval) ProtoMessage()               {}
func (*ProductInterval) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{121} }

func (m *ProductInterval) GetDuration() int32 {
	if m != nil {
		return m.Duration
	}
	return 0
}

func (m *ProductInterval) GetUnit() ProductIntervalUnit {
	if m != nil {
		return m.Unit
	}
	return ProductIntervalUnit_ProductIntervalUnit_NONE
}

// Takes in a list of product_ids. Max 100.
type GetProductsByIDsRequest struct {
	ProductIds []string `protobuf:"bytes,1,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetProductsByIDsRequest) Reset()                    { *m = GetProductsByIDsRequest{} }
func (m *GetProductsByIDsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetProductsByIDsRequest) ProtoMessage()               {}
func (*GetProductsByIDsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{122} }

func (m *GetProductsByIDsRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

// Returns a list of products.
type GetProductsByIDsResponse struct {
	Products []*Product `protobuf:"bytes,1,rep,name=products" json:"products,omitempty"`
}

func (m *GetProductsByIDsResponse) Reset()                    { *m = GetProductsByIDsResponse{} }
func (m *GetProductsByIDsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetProductsByIDsResponse) ProtoMessage()               {}
func (*GetProductsByIDsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{123} }

func (m *GetProductsByIDsResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

// Accepts a single channel ID.
type GetChannelProductsRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	ClientId  string `protobuf:"bytes,2,opt,name=client_id,json=clientId" json:"client_id,omitempty"`
}

func (m *GetChannelProductsRequest) Reset()                    { *m = GetChannelProductsRequest{} }
func (m *GetChannelProductsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChannelProductsRequest) ProtoMessage()               {}
func (*GetChannelProductsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{124} }

func (m *GetChannelProductsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetChannelProductsRequest) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

// Returns a list of products.
type GetChannelProductsResponse struct {
	Products []*Product `protobuf:"bytes,1,rep,name=products" json:"products,omitempty"`
}

func (m *GetChannelProductsResponse) Reset()                    { *m = GetChannelProductsResponse{} }
func (m *GetChannelProductsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetChannelProductsResponse) ProtoMessage()               {}
func (*GetChannelProductsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{125} }

func (m *GetChannelProductsResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

// UpdateProductRequest is the request for UpdateProduct rpc method.
type UpdateProductRequest struct {
	ProductId   string `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
}

func (m *UpdateProductRequest) Reset()                    { *m = UpdateProductRequest{} }
func (m *UpdateProductRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateProductRequest) ProtoMessage()               {}
func (*UpdateProductRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{126} }

func (m *UpdateProductRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *UpdateProductRequest) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// empty response for UpdateProduct rpc request.
type UpdateProductResponse struct {
}

func (m *UpdateProductResponse) Reset()                    { *m = UpdateProductResponse{} }
func (m *UpdateProductResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateProductResponse) ProtoMessage()               {}
func (*UpdateProductResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{127} }

// UpdateChannelProductsRequest is the body of UpdateChannelProducts rpc method.
type UpdateChannelProductsRequest struct {
	ChannelId       string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	HideAds         bool   `protobuf:"varint,2,opt,name=hide_ads,json=hideAds" json:"hide_ads,omitempty"`
	SubonlyArchives bool   `protobuf:"varint,3,opt,name=subonly_archives,json=subonlyArchives" json:"subonly_archives,omitempty"`
}

func (m *UpdateChannelProductsRequest) Reset()                    { *m = UpdateChannelProductsRequest{} }
func (m *UpdateChannelProductsRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateChannelProductsRequest) ProtoMessage()               {}
func (*UpdateChannelProductsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{128} }

func (m *UpdateChannelProductsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *UpdateChannelProductsRequest) GetHideAds() bool {
	if m != nil {
		return m.HideAds
	}
	return false
}

func (m *UpdateChannelProductsRequest) GetSubonlyArchives() bool {
	if m != nil {
		return m.SubonlyArchives
	}
	return false
}

// empty response for UpdateChannelProduct rpc request.
type UpdateChannelProductsResponse struct {
}

func (m *UpdateChannelProductsResponse) Reset()                    { *m = UpdateChannelProductsResponse{} }
func (m *UpdateChannelProductsResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateChannelProductsResponse) ProtoMessage()               {}
func (*UpdateChannelProductsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{129} }

func init() {
	proto.RegisterType((*EmailPendingPrefixApprovalRequest)(nil), "code.justin.tv.revenue.subscriptions.EmailPendingPrefixApprovalRequest")
	proto.RegisterType((*EmailPendingPrefixApprovalResponse)(nil), "code.justin.tv.revenue.subscriptions.EmailPendingPrefixApprovalResponse")
	proto.RegisterType((*EmailGlobalEmoteRequest)(nil), "code.justin.tv.revenue.subscriptions.EmailGlobalEmoteRequest")
	proto.RegisterType((*EmailGlobalEmoteResponse)(nil), "code.justin.tv.revenue.subscriptions.EmailGlobalEmoteResponse")
	proto.RegisterType((*EmailSubscribersRequest)(nil), "code.justin.tv.revenue.subscriptions.EmailSubscribersRequest")
	proto.RegisterType((*EmailSubscribersResponse)(nil), "code.justin.tv.revenue.subscriptions.EmailSubscribersResponse")
	proto.RegisterType((*EmoticonLevel)(nil), "code.justin.tv.revenue.subscriptions.EmoticonLevel")
	proto.RegisterType((*SetScoreRequest)(nil), "code.justin.tv.revenue.subscriptions.SetScoreRequest")
	proto.RegisterType((*SetScoreResponse)(nil), "code.justin.tv.revenue.subscriptions.SetScoreResponse")
	proto.RegisterType((*SubscriptionCount)(nil), "code.justin.tv.revenue.subscriptions.SubscriptionCount")
	proto.RegisterType((*CalculateSubscriberCountRequest)(nil), "code.justin.tv.revenue.subscriptions.CalculateSubscriberCountRequest")
	proto.RegisterType((*CalculateSubscriberCountResponse)(nil), "code.justin.tv.revenue.subscriptions.CalculateSubscriberCountResponse")
	proto.RegisterType((*GetUserSettingsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserSettingsRequest")
	proto.RegisterType((*GetUserSettingsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserSettingsResponse")
	proto.RegisterType((*SetUserSettingsRequest)(nil), "code.justin.tv.revenue.subscriptions.SetUserSettingsRequest")
	proto.RegisterType((*SetUserSettingsResponse)(nil), "code.justin.tv.revenue.subscriptions.SetUserSettingsResponse")
	proto.RegisterType((*OptionalBool)(nil), "code.justin.tv.revenue.subscriptions.OptionalBool")
	proto.RegisterType((*Subscription)(nil), "code.justin.tv.revenue.subscriptions.Subscription")
	proto.RegisterType((*FormerSubscriber)(nil), "code.justin.tv.revenue.subscriptions.FormerSubscriber")
	proto.RegisterType((*FulfillSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.FulfillSubscriptionRequest")
	proto.RegisterType((*FulfillSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.FulfillSubscriptionResponse")
	proto.RegisterType((*CreateSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateSubscriptionRequest")
	proto.RegisterType((*CreateSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.CreateSubscriptionResponse")
	proto.RegisterType((*CancelSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelSubscriptionRequest")
	proto.RegisterType((*CancelSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelSubscriptionResponse")
	proto.RegisterType((*UpdateSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.UpdateSubscriptionRequest")
	proto.RegisterType((*UpdateSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.UpdateSubscriptionResponse")
	proto.RegisterType((*CanSubscribeRequest)(nil), "code.justin.tv.revenue.subscriptions.CanSubscribeRequest")
	proto.RegisterType((*CanSubscribeResponse)(nil), "code.justin.tv.revenue.subscriptions.CanSubscribeResponse")
	proto.RegisterType((*ListUserSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.ListUserSubscriptionsRequest")
	proto.RegisterType((*GetUserChannelSubscriptionWithPaymentsDataRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionWithPaymentsDataRequest")
	proto.RegisterType((*GetUserChannelSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionRequest")
	proto.RegisterType((*UserSubscription)(nil), "code.justin.tv.revenue.subscriptions.UserSubscription")
	proto.RegisterType((*UserSubscriptionResult)(nil), "code.justin.tv.revenue.subscriptions.UserSubscriptionResult")
	proto.RegisterType((*ListUserSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.ListUserSubscriptionsResponse")
	proto.RegisterType((*GetUserChannelSubscriptionWithPaymentsDataResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionWithPaymentsDataResponse")
	proto.RegisterType((*GetUserChannelSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionResponse")
	proto.RegisterType((*GetUserProductSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserProductSubscriptionsRequest")
	proto.RegisterType((*GetUserProductSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserProductSubscriptionsResponse")
	proto.RegisterType((*GetUserSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserSubscriptionsRequest")
	proto.RegisterType((*GetUserSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserSubscriptionsResponse")
	proto.RegisterType((*GetChannelSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetChannelSubscriptionsRequest")
	proto.RegisterType((*GetChannelSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetChannelSubscriptionsResponse")
	proto.RegisterType((*GetFormerSubscribersRequest)(nil), "code.justin.tv.revenue.subscriptions.GetFormerSubscribersRequest")
	proto.RegisterType((*GetFormerSubscribersResponse)(nil), "code.justin.tv.revenue.subscriptions.GetFormerSubscribersResponse")
	proto.RegisterType((*TakedownBadgesRequest)(nil), "code.justin.tv.revenue.subscriptions.TakedownBadgesRequest")
	proto.RegisterType((*TakedownBadgesResponse)(nil), "code.justin.tv.revenue.subscriptions.TakedownBadgesResponse")
	proto.RegisterType((*TakedownAllBadgesRequest)(nil), "code.justin.tv.revenue.subscriptions.TakedownAllBadgesRequest")
	proto.RegisterType((*TakedownAllBadgesResponse)(nil), "code.justin.tv.revenue.subscriptions.TakedownAllBadgesResponse")
	proto.RegisterType((*GetExternalProductTemplateSKURequest)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductTemplateSKURequest")
	proto.RegisterType((*GetExternalProductTemplateSKUResponse)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductTemplateSKUResponse")
	proto.RegisterType((*GetExternalProductPurchasableSKURequest)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductPurchasableSKURequest")
	proto.RegisterType((*GetExternalProductPurchasableSKUResponse)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductPurchasableSKUResponse")
	proto.RegisterType((*SubKey)(nil), "code.justin.tv.revenue.subscriptions.SubKey")
	proto.RegisterType((*PaidUpgrade)(nil), "code.justin.tv.revenue.subscriptions.PaidUpgrade")
	proto.RegisterType((*GetPaidUpgradesRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPaidUpgradesRequest")
	proto.RegisterType((*GetPaidUpgradesResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPaidUpgradesResponse")
	proto.RegisterType((*CreatePaidUpgradeRequest)(nil), "code.justin.tv.revenue.subscriptions.CreatePaidUpgradeRequest")
	proto.RegisterType((*CreatePaidUpgradeResponse)(nil), "code.justin.tv.revenue.subscriptions.CreatePaidUpgradeResponse")
	proto.RegisterType((*CancelPaidUpgradeRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelPaidUpgradeRequest")
	proto.RegisterType((*CancelPaidUpgradeResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelPaidUpgradeResponse")
	proto.RegisterType((*CreateChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateChatNotificationTokenRequest")
	proto.RegisterType((*CreateChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.CreateChatNotificationTokenResponse")
	proto.RegisterType((*NewTicketInterval)(nil), "code.justin.tv.revenue.subscriptions.NewTicketInterval")
	proto.RegisterType((*UseChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.UseChatNotificationTokenRequest")
	proto.RegisterType((*UseChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.UseChatNotificationTokenResponse")
	proto.RegisterType((*CancelChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelChatNotificationTokenRequest")
	proto.RegisterType((*CancelChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelChatNotificationTokenResponse")
	proto.RegisterType((*GetUserChannelChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelChatNotificationTokenRequest")
	proto.RegisterType((*GetUserChannelChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelChatNotificationTokenResponse")
	proto.RegisterType((*ChatNotificationToken)(nil), "code.justin.tv.revenue.subscriptions.ChatNotificationToken")
	proto.RegisterType((*Gift)(nil), "code.justin.tv.revenue.subscriptions.Gift")
	proto.RegisterType((*GiftKey)(nil), "code.justin.tv.revenue.subscriptions.GiftKey")
	proto.RegisterType((*CreateGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateGiftRequest")
	proto.RegisterType((*CreateGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.CreateGiftResponse")
	proto.RegisterType((*InsertGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.InsertGiftRequest")
	proto.RegisterType((*InsertGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.InsertGiftResponse")
	proto.RegisterType((*CancelGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelGiftRequest")
	proto.RegisterType((*CancelGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelGiftResponse")
	proto.RegisterType((*GetGiftsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetGiftsRequest")
	proto.RegisterType((*GetGiftsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetGiftsResponse")
	proto.RegisterType((*CanGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.CanGiftRequest")
	proto.RegisterType((*CanGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.CanGiftResponse")
	proto.RegisterType((*CanSenderGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.CanSenderGiftRequest")
	proto.RegisterType((*CanSenderGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.CanSenderGiftResponse")
	proto.RegisterType((*CanGiftRecipientRequest)(nil), "code.justin.tv.revenue.subscriptions.CanGiftRecipientRequest")
	proto.RegisterType((*CanGiftRecipientResponse)(nil), "code.justin.tv.revenue.subscriptions.CanGiftRecipientResponse")
	proto.RegisterType((*GiftPromotion)(nil), "code.justin.tv.revenue.subscriptions.GiftPromotion")
	proto.RegisterType((*GetGiftPromotionRequest)(nil), "code.justin.tv.revenue.subscriptions.GetGiftPromotionRequest")
	proto.RegisterType((*GetGiftPromotionResponse)(nil), "code.justin.tv.revenue.subscriptions.GetGiftPromotionResponse")
	proto.RegisterType((*FulfillGiftsRequest)(nil), "code.justin.tv.revenue.subscriptions.FulfillGiftsRequest")
	proto.RegisterType((*FulfillGiftsResponse)(nil), "code.justin.tv.revenue.subscriptions.FulfillGiftsResponse")
	proto.RegisterType((*SendMMGChatNotificationRequest)(nil), "code.justin.tv.revenue.subscriptions.SendMMGChatNotificationRequest")
	proto.RegisterType((*SendMMGChatNotificationResponse)(nil), "code.justin.tv.revenue.subscriptions.SendMMGChatNotificationResponse")
	proto.RegisterType((*SendMMGStartChatNotificationRequest)(nil), "code.justin.tv.revenue.subscriptions.SendMMGStartChatNotificationRequest")
	proto.RegisterType((*SendMMGStartChatNotificationResponse)(nil), "code.justin.tv.revenue.subscriptions.SendMMGStartChatNotificationResponse")
	proto.RegisterType((*GetEmotePrefixRequest)(nil), "code.justin.tv.revenue.subscriptions.GetEmotePrefixRequest")
	proto.RegisterType((*GetEmotePrefixResponse)(nil), "code.justin.tv.revenue.subscriptions.GetEmotePrefixResponse")
	proto.RegisterType((*GetEmoticonPrefixRequest)(nil), "code.justin.tv.revenue.subscriptions.GetEmoticonPrefixRequest")
	proto.RegisterType((*GetEmoticonPrefixResponse)(nil), "code.justin.tv.revenue.subscriptions.GetEmoticonPrefixResponse")
	proto.RegisterType((*CreateEmoticonRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateEmoticonRequest")
	proto.RegisterType((*CreateEmoticonReponse)(nil), "code.justin.tv.revenue.subscriptions.CreateEmoticonReponse")
	proto.RegisterType((*GetAllEmoticonsByProductIDsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetAllEmoticonsByProductIDsRequest")
	proto.RegisterType((*GetAllEmoticonsByProductIDsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetAllEmoticonsByProductIDsResponse")
	proto.RegisterType((*EmoticonGroup)(nil), "code.justin.tv.revenue.subscriptions.EmoticonGroup")
	proto.RegisterType((*Emoticon)(nil), "code.justin.tv.revenue.subscriptions.Emoticon")
	proto.RegisterType((*GetPartnerStandingRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPartnerStandingRequest")
	proto.RegisterType((*GetPartnerStandingResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPartnerStandingResponse")
	proto.RegisterType((*SubmitEmoticonPrefixRequest)(nil), "code.justin.tv.revenue.subscriptions.SubmitEmoticonPrefixRequest")
	proto.RegisterType((*SubmitEmoticonPrefixResponse)(nil), "code.justin.tv.revenue.subscriptions.SubmitEmoticonPrefixResponse")
	proto.RegisterType((*GetPendingEmoticonsByIDsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPendingEmoticonsByIDsRequest")
	proto.RegisterType((*GetPendingEmoticonsByIDsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPendingEmoticonsByIDsResponse")
	proto.RegisterType((*GetPendingEmoticonsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPendingEmoticonsRequest")
	proto.RegisterType((*GetPendingEmoticonsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPendingEmoticonsResponse")
	proto.RegisterType((*ReviewPendingEmoticonsRequest)(nil), "code.justin.tv.revenue.subscriptions.ReviewPendingEmoticonsRequest")
	proto.RegisterType((*ReviewPendingEmoticonRequest)(nil), "code.justin.tv.revenue.subscriptions.ReviewPendingEmoticonRequest")
	proto.RegisterType((*ReviewPendingEmoticonsResponse)(nil), "code.justin.tv.revenue.subscriptions.ReviewPendingEmoticonsResponse")
	proto.RegisterType((*ReviewPendingEmoticonResponse)(nil), "code.justin.tv.revenue.subscriptions.ReviewPendingEmoticonResponse")
	proto.RegisterType((*EmoticonBucket)(nil), "code.justin.tv.revenue.subscriptions.EmoticonBucket")
	proto.RegisterType((*PendingEmoticon)(nil), "code.justin.tv.revenue.subscriptions.PendingEmoticon")
	proto.RegisterType((*Product)(nil), "code.justin.tv.revenue.subscriptions.Product")
	proto.RegisterType((*ProductInterval)(nil), "code.justin.tv.revenue.subscriptions.ProductInterval")
	proto.RegisterType((*GetProductsByIDsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetProductsByIDsRequest")
	proto.RegisterType((*GetProductsByIDsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetProductsByIDsResponse")
	proto.RegisterType((*GetChannelProductsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetChannelProductsRequest")
	proto.RegisterType((*GetChannelProductsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetChannelProductsResponse")
	proto.RegisterType((*UpdateProductRequest)(nil), "code.justin.tv.revenue.subscriptions.UpdateProductRequest")
	proto.RegisterType((*UpdateProductResponse)(nil), "code.justin.tv.revenue.subscriptions.UpdateProductResponse")
	proto.RegisterType((*UpdateChannelProductsRequest)(nil), "code.justin.tv.revenue.subscriptions.UpdateChannelProductsRequest")
	proto.RegisterType((*UpdateChannelProductsResponse)(nil), "code.justin.tv.revenue.subscriptions.UpdateChannelProductsResponse")
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.Platform", Platform_name, Platform_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.SubscriptionType", SubscriptionType_name, SubscriptionType_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.GiftState", GiftState_name, GiftState_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.DiscountType", DiscountType_name, DiscountType_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.GiftType", GiftType_name, GiftType_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.EmoticonState", EmoticonState_name, EmoticonState_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.EmoticonPrefixState", EmoticonPrefixState_name, EmoticonPrefixState_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.EmoticonFilter", EmoticonFilter_name, EmoticonFilter_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.ProductIntervalUnit", ProductIntervalUnit_name, ProductIntervalUnit_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.ListUserSubscriptionsRequest_Filter", ListUserSubscriptionsRequest_Filter_name, ListUserSubscriptionsRequest_Filter_value)
}

func init() { proto.RegisterFile("twirp/subscriptions.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 5575 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x7d, 0xeb, 0x6f, 0x23, 0xc9,
	0x71, 0xf8, 0x0e, 0x49, 0x49, 0x64, 0x51, 0x0f, 0x6a, 0x76, 0x57, 0x4b, 0x71, 0x77, 0x4f, 0xbb,
	0xb3, 0x7b, 0xf6, 0x79, 0x7f, 0xb6, 0x0e, 0xa7, 0x7b, 0xbf, 0x76, 0x97, 0x92, 0x28, 0x1d, 0x6f,
	0x57, 0x14, 0x6f, 0x48, 0xdd, 0xee, 0x9d, 0xcf, 0xa0, 0x47, 0x9c, 0x96, 0x34, 0xd6, 0x70, 0x86,
	0x37, 0x33, 0x94, 0x56, 0xbf, 0x1c, 0x70, 0x01, 0x9c, 0xc0, 0x49, 0x9c, 0x04, 0x49, 0x7c, 0x80,
	0x0d, 0x03, 0x09, 0x8c, 0x04, 0x0e, 0x92, 0x4f, 0x06, 0x9c, 0x04, 0xb0, 0x91, 0x07, 0xe0, 0x0f,
	0x41, 0x82, 0x20, 0x40, 0x80, 0x00, 0xfe, 0x98, 0x04, 0xf9, 0x98, 0x7f, 0x22, 0x08, 0xfa, 0x31,
	0x4f, 0x0e, 0xc9, 0x1e, 0x52, 0xeb, 0x5c, 0xfc, 0x45, 0x62, 0x57, 0x77, 0x57, 0x57, 0x57, 0x57,
	0x57, 0x57, 0x57, 0x57, 0x91, 0xb0, 0xec, 0x9c, 0x6a, 0x56, 0xf7, 0x79, 0xbb, 0xb7, 0x6f, 0xb7,
	0x2d, 0xad, 0xeb, 0x68, 0xa6, 0x61, 0xaf, 0x76, 0x2d, 0xd3, 0x31, 0xc5, 0xdb, 0x6d, 0x53, 0x45,
	0xab, 0xdf, 0xe8, 0xd9, 0x8e, 0x66, 0xac, 0x3a, 0x27, 0xab, 0x16, 0x3a, 0x41, 0x46, 0x0f, 0xad,
	0x86, 0xda, 0x96, 0x56, 0x0e, 0x4d, 0xf3, 0x50, 0x47, 0xcf, 0x93, 0x3e, 0xfb, 0xbd, 0x83, 0xe7,
	0x1d, 0xad, 0x83, 0x6c, 0x47, 0xe9, 0x74, 0x29, 0x1a, 0xe9, 0x0f, 0x04, 0xb8, 0x59, 0xe9, 0x28,
	0x9a, 0x5e, 0x47, 0x86, 0xaa, 0x19, 0x87, 0x75, 0x0b, 0x1d, 0x68, 0x4f, 0xca, 0xdd, 0xae, 0x65,
	0x9e, 0x28, 0xba, 0x8c, 0x3e, 0xee, 0x21, 0xdb, 0x11, 0xaf, 0xc0, 0x4c, 0xcf, 0x46, 0x56, 0x4b,
	0x53, 0x8b, 0xc2, 0x0d, 0xe1, 0xb9, 0x9c, 0x3c, 0x8d, 0x8b, 0x55, 0x55, 0x5c, 0x82, 0xe9, 0x2e,
	0xe9, 0x51, 0x4c, 0x51, 0x38, 0x2d, 0x89, 0x97, 0x60, 0xca, 0x76, 0x14, 0x07, 0x15, 0xd3, 0x04,
	0x4c, 0x0b, 0xe2, 0x17, 0x60, 0x01, 0x75, 0x4c, 0x47, 0x6b, 0x9b, 0x46, 0xcb, 0x46, 0x0e, 0x46,
	0x97, 0x21, 0xf5, 0x73, 0x2e, 0xb8, 0x81, 0x9c, 0xaa, 0x2a, 0xdd, 0x06, 0x69, 0x18, 0x4d, 0x76,
	0xd7, 0x34, 0x6c, 0x24, 0xed, 0xc0, 0x15, 0xd2, 0x6a, 0x5b, 0x37, 0xf7, 0x15, 0xbd, 0xd2, 0x31,
	0x1d, 0x34, 0x92, 0xde, 0x65, 0xc8, 0xe2, 0xa1, 0x10, 0xae, 0xa1, 0x14, 0xcf, 0x90, 0x72, 0x55,
	0x95, 0x4a, 0x50, 0xec, 0x47, 0xc7, 0x86, 0xda, 0x67, 0x43, 0x35, 0x28, 0x73, 0xf7, 0x91, 0x65,
	0xbb, 0x43, 0x5d, 0x07, 0x68, 0x1f, 0x29, 0x86, 0x81, 0x74, 0x7f, 0xb4, 0x1c, 0x83, 0x54, 0x55,
	0xcc, 0x08, 0x47, 0x73, 0x74, 0xc4, 0x46, 0xa3, 0x05, 0x51, 0x84, 0x8c, 0x83, 0x9e, 0x38, 0x8c,
	0x3b, 0xe4, 0xb3, 0x37, 0x7e, 0x68, 0x0c, 0x36, 0xfe, 0x57, 0x61, 0xae, 0xc2, 0x38, 0xf4, 0x10,
	0x9d, 0x20, 0x5d, 0xbc, 0x05, 0x73, 0x1d, 0xcd, 0xd0, 0x3a, 0xbd, 0x4e, 0xcb, 0x6e, 0x9b, 0x16,
	0x22, 0x03, 0xa7, 0xe5, 0x59, 0x06, 0x6c, 0x60, 0x98, 0xf8, 0x2c, 0xcc, 0x7b, 0xec, 0xd6, 0xb5,
	0x8e, 0xe6, 0x10, 0x22, 0xd2, 0x3e, 0xb7, 0x1f, 0x62, 0xa0, 0xf4, 0x55, 0x58, 0x68, 0x20, 0x87,
	0x74, 0xe1, 0x9c, 0xd4, 0x97, 0xa0, 0x60, 0x7b, 0x54, 0x32, 0x02, 0x28, 0xea, 0x05, 0x1f, 0x4e,
	0x10, 0x4a, 0x3f, 0x11, 0xa0, 0xe0, 0x63, 0xa7, 0xd3, 0x89, 0xed, 0x2f, 0xc4, 0xf6, 0xe7, 0x9c,
	0x83, 0x28, 0x03, 0x18, 0xe8, 0x89, 0xd3, 0xd2, 0x31, 0x77, 0x08, 0x5b, 0xf3, 0x6b, 0x2f, 0xae,
	0xf2, 0x6c, 0x91, 0xd5, 0x10, 0x63, 0xe5, 0x1c, 0x46, 0x43, 0x3e, 0x4a, 0x3f, 0xcd, 0xc0, 0x62,
	0x23, 0xd0, 0x74, 0xc3, 0xec, 0x19, 0x0e, 0x91, 0xec, 0x00, 0xc1, 0xb4, 0x10, 0x19, 0x3f, 0x75,
	0x1e, 0xe3, 0x8b, 0x0e, 0x2c, 0xb4, 0xf1, 0x90, 0xad, 0x7d, 0x0b, 0x29, 0xc7, 0xaa, 0x79, 0x6a,
	0x14, 0xd3, 0x37, 0xd2, 0xcf, 0xe5, 0xd7, 0x1e, 0xf0, 0x21, 0xee, 0xa3, 0x7d, 0x95, 0xfc, 0x5d,
	0x77, 0xb1, 0x55, 0x0c, 0xc7, 0x3a, 0x93, 0xe7, 0xdb, 0x21, 0x20, 0x1e, 0x95, 0x4c, 0x29, 0x30,
	0x6a, 0x66, 0xb2, 0x51, 0xc9, 0x42, 0x46, 0x47, 0xb5, 0x43, 0x40, 0xf1, 0x26, 0xcc, 0x3a, 0x5a,
	0xfb, 0x18, 0x39, 0x2d, 0x42, 0x4e, 0x71, 0x8a, 0x30, 0x37, 0x4f, 0x61, 0x94, 0xf1, 0xfd, 0x92,
	0x30, 0x1d, 0x23, 0x09, 0xa5, 0x32, 0x5c, 0x8c, 0x99, 0xa6, 0x58, 0x80, 0xf4, 0x31, 0x3a, 0x63,
	0xa2, 0x8c, 0x3f, 0xe2, 0x85, 0x3c, 0x51, 0xf4, 0x9e, 0x2b, 0xb9, 0xb4, 0xf0, 0x46, 0xea, 0x35,
	0x01, 0xa3, 0x88, 0xa1, 0x39, 0x09, 0x0a, 0xe9, 0x3e, 0xac, 0x6c, 0x28, 0x7a, 0xbb, 0xa7, 0x2b,
	0x0e, 0xf2, 0x37, 0x34, 0x21, 0x8c, 0x6f, 0x8f, 0x49, 0xff, 0x1f, 0x6e, 0x0c, 0xc6, 0xc0, 0xf6,
	0xd1, 0xfb, 0x00, 0x98, 0xf9, 0x8c, 0x67, 0x02, 0x91, 0xba, 0x57, 0xc7, 0x5c, 0x26, 0x39, 0x87,
	0x1b, 0x90, 0x8f, 0xd2, 0x0b, 0xb0, 0xb4, 0x8d, 0x9c, 0x3d, 0x1b, 0x59, 0x0d, 0xe4, 0x38, 0x9a,
	0x71, 0x68, 0x8f, 0x52, 0xac, 0xd2, 0xb7, 0x04, 0xb8, 0xd2, 0xd7, 0x87, 0x91, 0xb9, 0x09, 0x2b,
	0x87, 0xda, 0x81, 0x63, 0xb7, 0x34, 0xa3, 0x75, 0x60, 0xea, 0xba, 0x79, 0x8a, 0xd4, 0x16, 0x9b,
	0xa9, 0xdd, 0x32, 0x0d, 0x9d, 0x32, 0x35, 0x2b, 0x5f, 0x25, 0xcd, 0xaa, 0xc6, 0x16, 0x6b, 0xb4,
	0xc1, 0xda, 0xec, 0x1a, 0xfa, 0x19, 0x3e, 0x3c, 0x8e, 0x34, 0x15, 0xb5, 0x70, 0x1b, 0x36, 0xe3,
	0x14, 0xe9, 0x35, 0x87, 0xc1, 0xdb, 0xda, 0x01, 0x95, 0x13, 0xe9, 0xdf, 0x52, 0xb0, 0xd4, 0x48,
	0x46, 0x3d, 0x0f, 0x85, 0xa9, 0xd1, 0x14, 0x7e, 0x4b, 0x80, 0x2f, 0x5a, 0xa8, 0x8d, 0xb4, 0x13,
	0x4a, 0xe5, 0x30, 0x74, 0x54, 0x45, 0xad, 0xf1, 0x2d, 0xd6, 0x2e, 0xf9, 0xaf, 0xe8, 0xeb, 0xa6,
	0xa9, 0xcb, 0x12, 0x1b, 0x62, 0x7b, 0x08, 0x25, 0x1f, 0xf6, 0xf3, 0x2a, 0x33, 0xf6, 0x80, 0x11,
	0xfe, 0xe2, 0x95, 0x6e, 0x7c, 0x2e, 0x56, 0xfa, 0x36, 0xcc, 0x06, 0x09, 0xf5, 0xb7, 0x23, 0x1d,
	0x83, 0x16, 0xa4, 0xbf, 0x48, 0xc1, 0x6c, 0x50, 0xda, 0xc5, 0x79, 0x48, 0x79, 0x02, 0x90, 0xd2,
	0xd4, 0xc8, 0x46, 0x4c, 0x45, 0x0f, 0xbb, 0x65, 0xc8, 0x9a, 0xa7, 0x06, 0x95, 0x1a, 0x7a, 0x5e,
	0xcf, 0x90, 0x72, 0x95, 0xf4, 0xec, 0x5a, 0xa6, 0xda, 0x6b, 0x07, 0x4c, 0x99, 0x1c, 0x83, 0x54,
	0x55, 0xf1, 0x2a, 0xe4, 0x4c, 0x4b, 0x3b, 0xd4, 0x0c, 0x5c, 0x3b, 0x45, 0x6a, 0xb3, 0x14, 0x50,
	0x55, 0xc5, 0x7b, 0x30, 0xb7, 0x8f, 0x0c, 0x74, 0xa0, 0x39, 0x2d, 0xdb, 0x51, 0x2c, 0xaa, 0xcd,
	0xf2, 0x6b, 0xa5, 0x55, 0x6a, 0xb1, 0xad, 0xba, 0x16, 0xdb, 0x6a, 0xd3, 0xb5, 0xd8, 0xe4, 0x59,
	0xd6, 0xa1, 0x81, 0xdb, 0x8b, 0x6f, 0x42, 0xde, 0x45, 0x80, 0x0c, 0xb5, 0x38, 0x33, 0xb2, 0x3b,
	0xb0, 0xe6, 0x15, 0x43, 0x15, 0x57, 0x20, 0xaf, 0xb4, 0xdb, 0xc8, 0xb6, 0x5b, 0x87, 0x3d, 0x4d,
	0x2d, 0x66, 0x09, 0x71, 0x40, 0x41, 0xdb, 0x3d, 0x4d, 0x95, 0xca, 0x50, 0xd8, 0x32, 0xad, 0x0e,
	0xb2, 0x7c, 0xdd, 0x93, 0x90, 0x71, 0xd2, 0xdf, 0xa6, 0xa0, 0xb4, 0xd5, 0xd3, 0x0f, 0x34, 0x5d,
	0x0f, 0xf2, 0xdf, 0xdd, 0x8c, 0x41, 0xbe, 0x0a, 0xc3, 0xf8, 0x9a, 0x1a, 0xca, 0xd7, 0xf4, 0x28,
	0xbe, 0x66, 0x26, 0xe3, 0xeb, 0x54, 0x22, 0xbe, 0xbe, 0x0b, 0xd9, 0xae, 0xae, 0x38, 0x07, 0xa6,
	0xd5, 0x21, 0x0b, 0x3a, 0xbf, 0xb6, 0xca, 0xb7, 0xe3, 0xea, 0xac, 0x97, 0xec, 0xf5, 0x97, 0x7a,
	0x70, 0x35, 0x96, 0x7d, 0x9e, 0xf2, 0x9f, 0x0d, 0xa2, 0x60, 0xea, 0x7f, 0x2d, 0xb9, 0xfa, 0x97,
	0x43, 0x78, 0xa4, 0x9f, 0xa7, 0x60, 0x79, 0xc3, 0x42, 0xfe, 0xb1, 0xf3, 0xcb, 0xbf, 0x6a, 0x6d,
	0x58, 0x0c, 0xb2, 0xa0, 0xe5, 0x9c, 0x75, 0x11, 0x5b, 0xbe, 0x57, 0x92, 0xf3, 0xb3, 0x79, 0xd6,
	0x45, 0x72, 0xc1, 0x8e, 0x40, 0x24, 0x07, 0x4a, 0x71, 0x6c, 0x7d, 0xca, 0xab, 0x69, 0xc1, 0xf2,
	0x86, 0x62, 0xb4, 0xd1, 0x2f, 0x70, 0x0b, 0x4a, 0xd7, 0xa0, 0x14, 0x37, 0x26, 0xbb, 0xcb, 0xfc,
	0x8d, 0x00, 0xcb, 0x7b, 0x5d, 0x75, 0x80, 0x7c, 0x15, 0x7c, 0x1d, 0xf3, 0xce, 0x05, 0xa2, 0x65,
	0xee, 0x53, 0xb3, 0x8b, 0xda, 0xd4, 0x5f, 0xe6, 0x66, 0xc8, 0x03, 0x74, 0xf6, 0xce, 0x05, 0x6a,
	0xa6, 0x45, 0x64, 0x23, 0x9d, 0x44, 0x36, 0xd6, 0xe7, 0xc3, 0x0b, 0x83, 0x27, 0x17, 0x47, 0x3d,
	0x9b, 0xdc, 0xaf, 0xa6, 0xe0, 0xe2, 0x86, 0x62, 0x78, 0x4a, 0x73, 0x72, 0x4e, 0x07, 0x35, 0x4a,
	0x7a, 0x32, 0x8d, 0x12, 0x2f, 0xe7, 0x99, 0x73, 0x96, 0xf3, 0x37, 0xe1, 0x52, 0x98, 0x03, 0x4c,
	0xc2, 0x6f, 0xc1, 0x5c, 0x5b, 0x31, 0x5a, 0xde, 0x05, 0x8f, 0x9d, 0xd2, 0xb3, 0xed, 0x40, 0x63,
	0xe9, 0x67, 0x29, 0xb8, 0xf6, 0x50, 0xb3, 0xa9, 0x75, 0x11, 0x1c, 0x99, 0x83, 0x91, 0x97, 0x60,
	0x2a, 0x78, 0x43, 0xa4, 0x05, 0x71, 0x09, 0xa6, 0xdb, 0x3d, 0xcb, 0x36, 0x2d, 0x26, 0xa6, 0xac,
	0x14, 0xe2, 0x6b, 0x66, 0x42, 0xbe, 0x2a, 0x30, 0x7d, 0xa0, 0xe9, 0x0e, 0xb2, 0x88, 0xde, 0x99,
	0x5f, 0xab, 0xf2, 0x61, 0x1a, 0x36, 0xd1, 0xd5, 0x2d, 0x82, 0x50, 0x66, 0x88, 0xa5, 0x2f, 0xc1,
	0x34, 0x85, 0x88, 0x33, 0x90, 0x2e, 0x3f, 0x7c, 0x58, 0xb8, 0x20, 0xce, 0x42, 0xb6, 0xfe, 0xb0,
	0xdc, 0xdc, 0xda, 0x95, 0x77, 0x0a, 0x82, 0x98, 0x85, 0xcc, 0x76, 0x75, 0xab, 0x59, 0x48, 0x49,
	0x1d, 0x78, 0x81, 0x59, 0xe2, 0xcc, 0xaa, 0x0a, 0xe2, 0x7f, 0xa4, 0x39, 0x47, 0x75, 0xe5, 0xac,
	0x83, 0x0c, 0xc7, 0xde, 0x54, 0x1c, 0x85, 0x4f, 0x40, 0x87, 0x1d, 0xf3, 0x5f, 0x83, 0x9b, 0x83,
	0x87, 0x9b, 0x1c, 0xfd, 0xf7, 0x32, 0x50, 0x88, 0x32, 0x49, 0xfc, 0x22, 0x2c, 0x84, 0x04, 0xd9,
	0xc3, 0x3a, 0x1f, 0x04, 0x47, 0x8c, 0xb7, 0xd4, 0xb0, 0x7d, 0x97, 0x1e, 0xaa, 0xe1, 0x32, 0xa3,
	0x8e, 0xab, 0xa9, 0xc9, 0x8e, 0xab, 0xe9, 0xb1, 0x8d, 0x8c, 0x99, 0x09, 0x45, 0xf7, 0x55, 0xc8,
	0x59, 0xc8, 0x40, 0xa7, 0x76, 0x4b, 0x71, 0x88, 0x19, 0x38, 0x9c, 0x8c, 0x2c, 0x6d, 0x5c, 0x76,
	0xc4, 0xe7, 0xa0, 0x80, 0x9e, 0x38, 0xad, 0x6e, 0xcf, 0x6a, 0x1f, 0x29, 0x36, 0x6a, 0xd9, 0xc7,
	0xbd, 0x62, 0x8e, 0xae, 0x01, 0x7a, 0xe2, 0xd4, 0x19, 0xb8, 0x71, 0xdc, 0xc3, 0x6b, 0xa0, 0xd9,
	0xad, 0xae, 0xa5, 0x75, 0x50, 0x11, 0xc8, 0x9e, 0x9f, 0xd1, 0xec, 0x3a, 0x2e, 0xe2, 0x0b, 0x99,
	0x66, 0x13, 0x3b, 0xbf, 0x98, 0x27, 0x35, 0xd3, 0x9a, 0x8d, 0xed, 0x7b, 0xac, 0x2c, 0x34, 0xbb,
	0x65, 0xa1, 0x83, 0x9e, 0xa1, 0x2a, 0xfb, 0x3a, 0x2a, 0xce, 0x52, 0x65, 0xa1, 0xd9, 0xb2, 0x07,
	0x93, 0x7e, 0x5b, 0x80, 0xa5, 0xa8, 0x68, 0xc8, 0xc8, 0xee, 0xe9, 0x8e, 0xf8, 0x61, 0xec, 0x71,
	0xca, 0xa9, 0xe4, 0xfa, 0x70, 0x86, 0x70, 0x05, 0x34, 0x4a, 0x2a, 0xa8, 0x51, 0xa4, 0x7f, 0x10,
	0xe0, 0xfa, 0x80, 0x2d, 0xed, 0x1d, 0xf2, 0x33, 0x16, 0xa1, 0xcf, 0x2e, 0x0a, 0xc4, 0xa7, 0xf2,
	0xd6, 0x98, 0x04, 0x11, 0x24, 0xb2, 0x8b, 0x4c, 0xbc, 0x03, 0x8b, 0x47, 0x0a, 0x66, 0x31, 0x3a,
	0xd1, 0xcc, 0x9e, 0xdd, 0xea, 0x2a, 0x87, 0x88, 0x5d, 0x99, 0x16, 0x8e, 0x14, 0xbb, 0xce, 0xe0,
	0x75, 0xe5, 0x10, 0x89, 0x12, 0xcc, 0xe1, 0xb6, 0xc4, 0x5b, 0x45, 0xda, 0xa5, 0x49, 0xbb, 0xfc,
	0x91, 0x62, 0xd7, 0xf0, 0xc2, 0x29, 0x87, 0x48, 0xfa, 0x3d, 0x01, 0xd6, 0x92, 0xa8, 0x10, 0x36,
	0xbd, 0xa7, 0xc8, 0x74, 0xe9, 0x13, 0x90, 0x86, 0x69, 0x99, 0xa7, 0x6c, 0x45, 0x7d, 0xdd, 0x1b,
	0xbd, 0x4e, 0x15, 0x44, 0xd2, 0xb3, 0x69, 0x05, 0xf2, 0xbe, 0xb2, 0xb1, 0x8b, 0xa9, 0x1b, 0x69,
	0x7c, 0xdf, 0xf2, 0xb4, 0x8d, 0x2d, 0x7d, 0x0a, 0xb7, 0x86, 0x8e, 0xc0, 0x26, 0xf8, 0x18, 0xe6,
	0x42, 0x44, 0x33, 0x39, 0x1a, 0x67, 0x86, 0x61, 0x44, 0xd2, 0x6b, 0x70, 0xd5, 0xf5, 0xdf, 0x24,
	0x9b, 0x9b, 0xf4, 0x04, 0xae, 0xc5, 0xf7, 0x7c, 0xea, 0x34, 0x77, 0xe0, 0x99, 0x6d, 0xe4, 0xc4,
	0x08, 0x44, 0x02, 0xef, 0xbc, 0x6f, 0x32, 0x4c, 0x05, 0x4c, 0x06, 0xf3, 0xe0, 0xc0, 0x46, 0xd4,
	0x3f, 0x3f, 0x25, 0xb3, 0x92, 0xf4, 0x2b, 0xb0, 0x32, 0x70, 0xb8, 0xa7, 0x3e, 0xd7, 0x6f, 0x90,
	0xf5, 0x89, 0xde, 0xc9, 0x9f, 0xce, 0x44, 0xff, 0x4b, 0x20, 0x4b, 0x1a, 0x33, 0x18, 0x9b, 0xe6,
	0x0a, 0xe4, 0x1d, 0xd3, 0x51, 0xf4, 0x80, 0xe7, 0x71, 0x4a, 0x06, 0x02, 0xa2, 0xce, 0xda, 0xc7,
	0x90, 0xf7, 0x3d, 0xf9, 0x54, 0xde, 0xb9, 0x35, 0x41, 0x74, 0x58, 0x39, 0x88, 0x2a, 0x5e, 0xd7,
	0xa5, 0x39, 0x75, 0x5d, 0xa6, 0x5f, 0xd7, 0x1d, 0xc3, 0xe5, 0xa6, 0x72, 0x8c, 0x54, 0xf3, 0xd4,
	0x58, 0x57, 0xd4, 0x43, 0xc4, 0xcb, 0xd1, 0xab, 0x90, 0xdb, 0xc7, 0xed, 0x03, 0xfb, 0x39, 0x4b,
	0x00, 0x55, 0xd5, 0xc6, 0x8c, 0xb5, 0x90, 0x62, 0x9b, 0x86, 0x6b, 0x74, 0xd2, 0x92, 0x74, 0x0f,
	0x96, 0xa2, 0x83, 0x31, 0x8e, 0x3e, 0x0b, 0xf3, 0xa4, 0x37, 0x3e, 0xf4, 0x3a, 0xe6, 0x09, 0x52,
	0x89, 0xe4, 0xe4, 0xe4, 0xb9, 0x7d, 0xd6, 0x8e, 0x00, 0xa5, 0xf7, 0xa0, 0xe8, 0x22, 0x28, 0xeb,
	0x7a, 0x22, 0x82, 0x7d, 0x9a, 0x52, 0x21, 0x9a, 0xd6, 0x61, 0x39, 0x06, 0x65, 0x32, 0xb2, 0xfe,
	0x52, 0x80, 0xdb, 0xdb, 0xc8, 0xa9, 0x3c, 0x71, 0x90, 0x65, 0x28, 0x3a, 0x53, 0x61, 0x4d, 0xd4,
	0xe9, 0x12, 0xf7, 0xf5, 0x83, 0xbd, 0x00, 0x8d, 0x01, 0xa3, 0x4b, 0x18, 0x76, 0xd9, 0x49, 0x4d,
	0x68, 0xd9, 0xdc, 0x84, 0x59, 0x22, 0x9d, 0xd6, 0x59, 0x0b, 0xa3, 0x60, 0x2b, 0x91, 0x67, 0xb0,
	0x0d, 0x53, 0x45, 0xd2, 0x5d, 0x78, 0x76, 0x04, 0xd5, 0x8c, 0x0d, 0x97, 0x61, 0xda, 0x3e, 0xee,
	0xf9, 0x24, 0x4f, 0xd9, 0xc7, 0xbd, 0xaa, 0x2a, 0xfd, 0xab, 0x00, 0x5f, 0xec, 0x47, 0xc0, 0x6c,
	0x1f, 0x6c, 0xa2, 0x04, 0x66, 0xfe, 0xf9, 0xb8, 0x01, 0x46, 0x99, 0x92, 0xe9, 0x67, 0x4a, 0x19,
	0x9e, 0x1b, 0x3d, 0xa7, 0xe1, 0x7c, 0xa9, 0xc3, 0x34, 0xbd, 0x81, 0x8b, 0x45, 0x98, 0x61, 0x13,
	0x71, 0x27, 0xcd, 0x8a, 0x58, 0x23, 0x91, 0xf9, 0xbb, 0x0f, 0xa3, 0xa4, 0x40, 0x34, 0x12, 0x31,
	0xb2, 0xdd, 0x8d, 0x43, 0x4b, 0xd2, 0x3f, 0xa7, 0x20, 0x5f, 0x57, 0x34, 0x75, 0xaf, 0x7b, 0x68,
	0x29, 0x2a, 0x12, 0xb7, 0x21, 0xbb, 0x8f, 0xad, 0x4e, 0xf7, 0x41, 0x26, 0xa1, 0x67, 0x40, 0x9e,
	0xc1, 0xbd, 0x31, 0x81, 0x3b, 0x90, 0xef, 0x51, 0x9c, 0xad, 0x31, 0xbd, 0x0c, 0x32, 0x30, 0x04,
	0x18, 0xdd, 0xb3, 0x30, 0x8f, 0x0c, 0xf2, 0xc6, 0x8b, 0xcd, 0x23, 0xff, 0x62, 0x31, 0x17, 0x80,
	0x56, 0x55, 0xf1, 0x75, 0x00, 0x72, 0x6f, 0x68, 0xa9, 0x8a, 0x83, 0x38, 0x7c, 0x5d, 0x39, 0xd2,
	0x7a, 0x53, 0x71, 0xe8, 0xd3, 0xb1, 0xc6, 0x6e, 0x9a, 0x39, 0x99, 0x7c, 0xc6, 0xbc, 0xec, 0x5a,
	0x5a, 0x9b, 0xfa, 0xac, 0xa6, 0x64, 0x5a, 0xc0, 0x12, 0x47, 0x3e, 0x60, 0x2a, 0x66, 0x5c, 0xe6,
	0x6b, 0x6d, 0x54, 0x55, 0xa5, 0x0f, 0xc9, 0x03, 0x4f, 0x80, 0xa1, 0x9e, 0x12, 0xb9, 0x0f, 0x99,
	0x63, 0x74, 0xe6, 0x9e, 0x5b, 0xc9, 0x18, 0x41, 0x7a, 0x4a, 0x1f, 0x93, 0x87, 0xa0, 0x30, 0x6e,
	0xcf, 0x3c, 0x9b, 0xeb, 0x2a, 0x9a, 0xda, 0x62, 0x0c, 0x73, 0x47, 0x79, 0x81, 0x53, 0x9c, 0x7d,
	0x94, 0xf2, 0x6c, 0x37, 0x80, 0x5f, 0xfa, 0xb1, 0x00, 0x45, 0xea, 0x5b, 0x0b, 0xb6, 0x61, 0x33,
	0xfa, 0x9c, 0x8a, 0x8a, 0xf4, 0xb1, 0xeb, 0x66, 0x0d, 0xd1, 0xcc, 0x38, 0xd5, 0x84, 0xd9, 0x20,
	0xa7, 0x18, 0xe1, 0x63, 0x30, 0x2a, 0x1f, 0x60, 0x14, 0xe5, 0x13, 0xf1, 0xcc, 0xfd, 0x1f, 0xe2,
	0xd3, 0x55, 0xd7, 0x83, 0x19, 0xc3, 0x27, 0xe9, 0xe7, 0x29, 0x90, 0x28, 0x17, 0x37, 0x8e, 0x14,
	0xa7, 0x66, 0x3a, 0xda, 0x81, 0xd6, 0x56, 0x88, 0x2f, 0xca, 0x3c, 0x46, 0xe7, 0xe0, 0xe8, 0x7c,
	0x1b, 0x66, 0x95, 0x13, 0x45, 0xd3, 0xb1, 0xe6, 0xc3, 0x57, 0xe4, 0xd1, 0xce, 0xc3, 0xbc, 0xd7,
	0xbe, 0xec, 0x88, 0x3b, 0x81, 0xbb, 0xef, 0xf8, 0x2f, 0x70, 0xde, 0x7d, 0xf9, 0x10, 0x2e, 0x1a,
	0xe8, 0xb4, 0xc5, 0x9e, 0xca, 0x35, 0xc3, 0x41, 0xd6, 0x89, 0xa2, 0x33, 0xef, 0x03, 0xe7, 0xcb,
	0x6f, 0x0d, 0x9d, 0x36, 0x49, 0xff, 0x2a, 0xeb, 0x2e, 0x2f, 0x1a, 0x51, 0x90, 0x74, 0x0f, 0x6e,
	0x0d, 0x65, 0x2b, 0x13, 0xd3, 0x22, 0xcc, 0x74, 0x90, 0x6d, 0x63, 0xd3, 0x8a, 0xb1, 0x95, 0x15,
	0xa5, 0xdf, 0x11, 0x60, 0xb1, 0x6f, 0x24, 0xc2, 0x4d, 0xfa, 0xec, 0x44, 0xdd, 0x26, 0x02, 0x07,
	0x37, 0x49, 0x7b, 0xea, 0x35, 0x79, 0x1d, 0xd8, 0x13, 0x15, 0x71, 0x9a, 0xa4, 0x46, 0xab, 0x4d,
	0xda, 0xba, 0x62, 0xa8, 0xd2, 0x6f, 0x0a, 0xb0, 0xb2, 0x67, 0x8f, 0x94, 0x12, 0x07, 0x97, 0x03,
	0x52, 0x42, 0xca, 0x55, 0x55, 0xbc, 0x0d, 0xf3, 0x4a, 0xcf, 0x39, 0x42, 0x6a, 0xcb, 0x7d, 0x40,
	0xa6, 0x92, 0x32, 0x4b, 0xa1, 0x7b, 0xf4, 0x19, 0xf9, 0x59, 0x98, 0x6f, 0xf7, 0x6c, 0xc7, 0xec,
	0xb4, 0x5c, 0xae, 0x30, 0xed, 0x4f, 0xa1, 0x3b, 0x8c, 0x37, 0x6f, 0xc1, 0x8d, 0xc1, 0xa4, 0x8c,
	0xe4, 0xec, 0x0e, 0x48, 0x74, 0x3f, 0x0c, 0x9d, 0x0b, 0xaf, 0x87, 0x8c, 0xac, 0xf4, 0x30, 0x74,
	0x23, 0xe9, 0x51, 0xe1, 0x4e, 0xf8, 0x66, 0x3e, 0x94, 0xae, 0x81, 0x4f, 0xf0, 0x23, 0xdc, 0x80,
	0x7f, 0x2c, 0xc0, 0xff, 0xe3, 0x1a, 0x86, 0xd1, 0x6b, 0xc3, 0x95, 0xf6, 0x91, 0xe2, 0xb4, 0x8c,
	0x40, 0x8b, 0x16, 0x59, 0x4d, 0x26, 0x74, 0x6f, 0xf2, 0xed, 0x96, 0xf8, 0x51, 0x2e, 0xb7, 0xe3,
	0xc0, 0xf8, 0x2e, 0x11, 0xdb, 0xbe, 0xef, 0xe5, 0x34, 0xc0, 0xcd, 0x54, 0x88, 0x9b, 0xf8, 0x28,
	0xef, 0x98, 0x86, 0x73, 0xe4, 0x06, 0xce, 0x91, 0x02, 0x3e, 0xf4, 0x8f, 0x35, 0xc3, 0xf5, 0x43,
	0x92, 0xcf, 0xd2, 0x5f, 0xa7, 0x20, 0x43, 0x7c, 0x65, 0x4b, 0x30, 0x6d, 0x23, 0x43, 0x45, 0x96,
	0xcb, 0x51, 0x5a, 0x12, 0xaf, 0x41, 0xce, 0x42, 0x6d, 0xad, 0xab, 0x21, 0xf6, 0x80, 0x9e, 0x93,
	0x7d, 0x40, 0xd0, 0x32, 0x4b, 0x87, 0x2d, 0x33, 0xdf, 0x06, 0xcb, 0x04, 0x6d, 0x30, 0xb1, 0xe2,
	0xc6, 0xf4, 0x51, 0x27, 0xf7, 0xf3, 0x7c, 0x0c, 0xc4, 0x24, 0x36, 0x70, 0x37, 0x37, 0x08, 0xf0,
	0x55, 0xc8, 0x91, 0x87, 0x7d, 0x62, 0xfa, 0x8c, 0x76, 0x7c, 0x66, 0x71, 0x63, 0x62, 0xf9, 0x3c,
	0x60, 0x1d, 0xc9, 0xab, 0x45, 0x22, 0xbf, 0x27, 0xa6, 0x81, 0xbc, 0x56, 0x10, 0x64, 0xe4, 0x95,
	0xe2, 0x03, 0x98, 0xc1, 0xd0, 0xe1, 0x36, 0xaa, 0xcf, 0x89, 0x54, 0x88, 0x13, 0x21, 0xce, 0xa6,
	0x23, 0x9c, 0x95, 0xfe, 0x51, 0x80, 0x45, 0xaa, 0x3c, 0xf1, 0x08, 0xae, 0xe0, 0xff, 0xa2, 0x56,
	0x29, 0xc4, 0xa5, 0xa9, 0x09, 0xb9, 0xd4, 0x04, 0x31, 0x38, 0x13, 0xb6, 0xb7, 0xee, 0x42, 0x86,
	0xb8, 0x6c, 0xe9, 0x46, 0xba, 0xc3, 0x8f, 0x5d, 0x26, 0xfd, 0x08, 0x83, 0xaa, 0x86, 0x8d, 0x2c,
	0xe7, 0x97, 0x81, 0x41, 0xc1, 0x99, 0x9c, 0x13, 0x83, 0xda, 0xb0, 0x48, 0x75, 0x72, 0x90, 0x3f,
	0xe7, 0x2d, 0xa6, 0x08, 0xc4, 0xe0, 0x20, 0x8c, 0xf4, 0x5d, 0xf2, 0x4a, 0xd7, 0x46, 0x3a, 0x52,
	0x5b, 0x63, 0xce, 0x61, 0xd6, 0x45, 0x80, 0x4b, 0x52, 0x13, 0x16, 0xb6, 0x11, 0x61, 0x8f, 0x77,
	0xc7, 0x28, 0x87, 0xee, 0x18, 0x5f, 0xe1, 0x47, 0xed, 0x5f, 0x32, 0x9a, 0x50, 0xf0, 0xb1, 0x32,
	0xd2, 0xef, 0xc3, 0x14, 0x89, 0x2a, 0x62, 0x78, 0x93, 0x90, 0x4c, 0x3b, 0x4a, 0x5f, 0x87, 0xf9,
	0x0d, 0xc5, 0x78, 0x8a, 0x42, 0x29, 0x7d, 0x19, 0x16, 0xbc, 0x11, 0x18, 0xd9, 0xcb, 0x90, 0x6d,
	0x2b, 0x86, 0xcf, 0xec, 0xac, 0x3c, 0xd3, 0xa6, 0x4d, 0x24, 0x99, 0x3e, 0xa5, 0x92, 0x21, 0x83,
	0x54, 0x5d, 0x85, 0x1c, 0xa5, 0xc3, 0x3f, 0x46, 0xb3, 0x14, 0x30, 0xd2, 0xa0, 0x95, 0xd6, 0xe0,
	0x72, 0x04, 0xe7, 0x68, 0x3a, 0xfe, 0x5e, 0x80, 0x2b, 0x1e, 0xd9, 0x6c, 0x92, 0xe7, 0x40, 0x8b,
	0x78, 0x13, 0x66, 0x3d, 0xa6, 0xf9, 0x77, 0xe5, 0xbc, 0x07, 0xab, 0xaa, 0xe1, 0xdd, 0x9a, 0x99,
	0x70, 0xb7, 0xbe, 0x4c, 0xae, 0x3f, 0x91, 0x69, 0x8c, 0x9e, 0xfe, 0x7f, 0x0b, 0x30, 0x87, 0x3f,
	0xd4, 0x2d, 0xb3, 0x63, 0x92, 0x27, 0xa0, 0x11, 0x6e, 0xac, 0xab, 0x90, 0xc3, 0x66, 0x3a, 0xbd,
	0x93, 0xd3, 0xd7, 0xe8, 0xac, 0x81, 0x4e, 0xeb, 0xe4, 0x5a, 0x7e, 0x15, 0x72, 0xa6, 0xae, 0xb2,
	0xca, 0x34, 0xad, 0x34, 0x75, 0x95, 0x56, 0x3e, 0x82, 0x39, 0x55, 0xb3, 0x69, 0xd8, 0x6f, 0x60,
	0xca, 0x9c, 0x97, 0x86, 0x4d, 0xd6, 0x95, 0x4c, 0x7b, 0x56, 0x0d, 0x94, 0xb0, 0x69, 0xea, 0x21,
	0xa6, 0x41, 0x72, 0x34, 0xc4, 0xd6, 0x1b, 0xee, 0x7d, 0x0c, 0xc4, 0xe6, 0x07, 0xb2, 0x2c, 0xd3,
	0x22, 0x07, 0x73, 0x4e, 0xa6, 0x05, 0xe9, 0x0d, 0x72, 0xa5, 0x0f, 0xb1, 0xc0, 0x5d, 0xfe, 0xc8,
	0xc3, 0x86, 0xd0, 0xf7, 0xb0, 0xf1, 0x67, 0x02, 0x14, 0xfb, 0x3b, 0x33, 0xa6, 0xaf, 0xc2, 0x45,
	0x72, 0x3d, 0x62, 0xf0, 0x96, 0xd2, 0x76, 0xb4, 0x13, 0x37, 0x32, 0x60, 0x11, 0xdf, 0x7a, 0x58,
	0x4d, 0x99, 0x54, 0x88, 0x1f, 0xc1, 0x02, 0x91, 0x06, 0xaf, 0x87, 0xeb, 0x5a, 0x7e, 0x91, 0x5f,
	0x26, 0x7c, 0x2a, 0xe6, 0x0f, 0x83, 0x45, 0x5b, 0xfa, 0xf7, 0x14, 0x5c, 0x64, 0x11, 0x57, 0x21,
	0x7d, 0x35, 0x89, 0x88, 0x0f, 0x8d, 0x7a, 0x3a, 0x4f, 0xe1, 0x16, 0x6f, 0xc1, 0x1c, 0x41, 0xf6,
	0x71, 0x4f, 0x31, 0x1c, 0xcd, 0x39, 0x23, 0x0b, 0x3c, 0x25, 0xcf, 0x62, 0xe0, 0x7b, 0x0c, 0xf6,
	0xbf, 0x1b, 0x75, 0x28, 0x2d, 0xc1, 0xa5, 0x30, 0x7f, 0xd9, 0x2d, 0xfe, 0x8f, 0x04, 0x78, 0x06,
	0x6b, 0xa4, 0x9d, 0x9d, 0xed, 0xa8, 0xfd, 0xcc, 0xb5, 0x06, 0x51, 0x3d, 0x92, 0xea, 0xd7, 0x23,
	0x23, 0x5e, 0xfb, 0xc3, 0xb7, 0x8f, 0x4c, 0xf4, 0xf6, 0x71, 0x13, 0x56, 0x06, 0xd2, 0xc7, 0xe6,
	0xf0, 0x43, 0x01, 0x6e, 0xb1, 0x36, 0x84, 0x53, 0x63, 0x4d, 0x64, 0x84, 0x30, 0x85, 0xa9, 0x4c,
	0x47, 0x3d, 0xfc, 0x7d, 0x12, 0x90, 0xe9, 0x97, 0x00, 0xe9, 0x0b, 0x70, 0x7b, 0x38, 0x99, 0x6c,
	0x3e, 0x6b, 0x70, 0x79, 0x1b, 0x39, 0x24, 0x0d, 0x86, 0xe6, 0xdf, 0x70, 0xbc, 0x04, 0xbe, 0x44,
	0xdc, 0x8a, 0xa1, 0x3e, 0x6c, 0xa3, 0x97, 0x20, 0x4b, 0x33, 0x83, 0x90, 0xab, 0x23, 0xbc, 0xb2,
	0xf4, 0x3a, 0x51, 0x10, 0x6e, 0x1a, 0x44, 0x78, 0xb0, 0x11, 0x41, 0xf2, 0xbf, 0x26, 0xc0, 0x72,
	0x4c, 0x5f, 0x36, 0xa8, 0x9f, 0x9c, 0x24, 0x84, 0x92, 0x93, 0x76, 0xdd, 0x8b, 0x0c, 0x7d, 0x62,
	0x78, 0x3d, 0x59, 0x9e, 0x06, 0x1d, 0x24, 0x78, 0xa5, 0x91, 0xfe, 0x45, 0x80, 0xcb, 0xd4, 0x4e,
	0x76, 0x1b, 0x8d, 0xbc, 0xee, 0xae, 0x40, 0x1e, 0x8f, 0xda, 0xb2, 0x7b, 0x07, 0x7e, 0xf6, 0x14,
	0x60, 0x50, 0x83, 0x40, 0x38, 0x04, 0x56, 0xeb, 0x28, 0x87, 0x68, 0xed, 0xb5, 0x80, 0xc0, 0x32,
	0x48, 0xa0, 0xfa, 0xe5, 0x57, 0xfc, 0xd8, 0xe3, 0x1c, 0x83, 0xd0, 0xd1, 0x49, 0xe1, 0x85, 0x17,
	0xd6, 0x70, 0x3d, 0x55, 0xf6, 0xe0, 0x82, 0xaa, 0xaa, 0xf4, 0xed, 0x98, 0x19, 0x51, 0xa6, 0x46,
	0xaf, 0xb2, 0x22, 0x64, 0xc8, 0x4b, 0x02, 0x9d, 0x01, 0xf9, 0x3c, 0x8a, 0xf6, 0x65, 0xc8, 0x1e,
	0x5a, 0x66, 0xaf, 0xeb, 0x53, 0x3e, 0x43, 0xca, 0xf4, 0x9d, 0xd2, 0xbf, 0x63, 0xba, 0x79, 0x63,
	0x52, 0x85, 0x3c, 0xbf, 0x97, 0x75, 0xdd, 0x25, 0xc6, 0x5e, 0x3f, 0x63, 0x0f, 0x13, 0xd5, 0x4d,
	0x9b, 0xfb, 0x28, 0xfa, 0xa6, 0x40, 0x1e, 0xd9, 0x07, 0xe3, 0x61, 0x72, 0xf3, 0x51, 0x20, 0x4d,
	0x8d, 0x10, 0xe6, 0x9a, 0x94, 0x09, 0x33, 0x7a, 0xb6, 0x71, 0x5f, 0xd9, 0xcb, 0x5a, 0x21, 0x45,
	0x5b, 0xfa, 0xc4, 0xcf, 0xe5, 0x22, 0x90, 0x51, 0xc6, 0xc4, 0x43, 0xc8, 0xb9, 0x18, 0xdc, 0xd3,
	0x6e, 0x35, 0x19, 0x1d, 0xb2, 0x8f, 0x40, 0xfa, 0x4c, 0x80, 0xac, 0x0b, 0xe7, 0x5a, 0xcb, 0xe0,
	0x62, 0xa5, 0xc3, 0x8b, 0x55, 0x75, 0x17, 0x8b, 0x1e, 0x5d, 0x09, 0xb9, 0x13, 0xda, 0x41, 0x2f,
	0x91, 0x7d, 0x5c, 0x57, 0x2c, 0xc7, 0x40, 0x56, 0xc3, 0x51, 0x48, 0xde, 0xdf, 0xc8, 0xa4, 0x93,
	0x07, 0x50, 0x8a, 0xeb, 0xc5, 0x96, 0xf1, 0x2b, 0xc4, 0xb8, 0xd0, 0x8c, 0xd6, 0xa1, 0x69, 0xaa,
	0xf8, 0xb8, 0x23, 0xd5, 0xcc, 0xb8, 0x28, 0x68, 0x76, 0xd5, 0xd8, 0x36, 0x4d, 0xd5, 0xed, 0x26,
	0x35, 0xe1, 0x6a, 0xa3, 0xb7, 0xdf, 0xd1, 0xc6, 0xd2, 0x44, 0x83, 0x12, 0x21, 0xa5, 0x67, 0xe0,
	0x5a, 0x3c, 0x56, 0xa6, 0x66, 0x37, 0x49, 0x4c, 0x01, 0x4b, 0x74, 0x0c, 0x88, 0x65, 0x40, 0xae,
	0x6f, 0xc2, 0xac, 0x27, 0x8e, 0xbe, 0x60, 0xe7, 0x5d, 0x18, 0x96, 0xec, 0x53, 0xb8, 0x31, 0x18,
	0x0b, 0x63, 0x47, 0x23, 0x28, 0x47, 0x54, 0x9e, 0x5f, 0xe6, 0x7c, 0x4f, 0x08, 0xe3, 0x0d, 0x8a,
	0xd3, 0x77, 0x52, 0x74, 0x09, 0x22, 0x23, 0xbb, 0xa4, 0x3f, 0xf4, 0x02, 0x23, 0x05, 0x22, 0x22,
	0x2f, 0x25, 0x13, 0x91, 0x70, 0x0c, 0x24, 0x56, 0x0e, 0x7e, 0x36, 0xc8, 0x94, 0x4c, 0x0b, 0x78,
	0x8c, 0xfd, 0x5e, 0xfb, 0x18, 0xb9, 0xbe, 0xf9, 0x84, 0x63, 0xac, 0x93, 0xbe, 0x32, 0xc3, 0x21,
	0x6e, 0xc0, 0x82, 0x72, 0xe0, 0x20, 0xab, 0xe5, 0x25, 0xca, 0x72, 0x3c, 0xcf, 0xcd, 0x93, 0x2e,
	0x5e, 0x59, 0xfa, 0x8e, 0x40, 0x82, 0x35, 0xfa, 0xb9, 0xf2, 0x14, 0x97, 0x22, 0x1a, 0x93, 0x91,
	0x8a, 0xc6, 0x64, 0x48, 0xdf, 0x13, 0xe0, 0xba, 0x8c, 0x4e, 0x34, 0x74, 0x3a, 0x68, 0xb9, 0x3e,
	0x82, 0x19, 0x8b, 0x34, 0x70, 0xa9, 0x5a, 0xe7, 0xa3, 0x2a, 0x16, 0x2b, 0x43, 0x2a, 0xbb, 0x28,
	0xb1, 0x26, 0x51, 0xd4, 0x0e, 0xb5, 0x84, 0x99, 0xd7, 0x93, 0x94, 0xab, 0xaa, 0xf4, 0x03, 0x01,
	0xae, 0x0d, 0x43, 0x12, 0xe7, 0x40, 0x55, 0x48, 0x3e, 0xb0, 0x1b, 0xe7, 0xe6, 0x16, 0xc9, 0x45,
	0x07, 0xb5, 0x75, 0xcd, 0x40, 0xad, 0x50, 0x08, 0xc6, 0x1c, 0x83, 0xca, 0x04, 0x28, 0x3e, 0x0f,
	0x17, 0xdd, 0x66, 0xe8, 0x49, 0x57, 0x57, 0x0c, 0x62, 0xfd, 0xb0, 0xe3, 0x48, 0x64, 0x55, 0x15,
	0xbf, 0x46, 0xfa, 0x14, 0x9e, 0x19, 0xc4, 0x3c, 0xb6, 0xaa, 0x5f, 0x8b, 0x46, 0xf7, 0x6d, 0x4c,
	0xc4, 0x3d, 0x8a, 0xd5, 0x0b, 0xf2, 0x93, 0xf4, 0x01, 0xab, 0xe7, 0x8d, 0x1f, 0xe5, 0xd1, 0x35,
	0xc8, 0xd9, 0xbd, 0x76, 0x1b, 0x21, 0x15, 0xa9, 0x8c, 0x4b, 0x3e, 0x00, 0xeb, 0x33, 0x7c, 0x47,
	0xc5, 0xea, 0xb7, 0x67, 0xbb, 0x67, 0xb4, 0x81, 0x4e, 0x1b, 0x04, 0x20, 0xbd, 0x07, 0xf3, 0xe1,
	0x1d, 0x42, 0x5d, 0x1e, 0x64, 0x35, 0x90, 0xca, 0x22, 0x7e, 0x7c, 0x00, 0x56, 0x52, 0x74, 0x07,
	0x85, 0xc4, 0x2f, 0x4f, 0x61, 0x54, 0xfe, 0x7e, 0x28, 0xc0, 0x42, 0x84, 0xf6, 0x3e, 0x9a, 0x07,
	0xe5, 0x93, 0xbb, 0x27, 0x53, 0x3a, 0x7c, 0x32, 0x79, 0x86, 0x68, 0x26, 0xfc, 0xa8, 0xf7, 0x26,
	0xe4, 0x7b, 0x5d, 0xdd, 0x54, 0x54, 0xb2, 0x8d, 0x79, 0xb2, 0x41, 0x68, 0x73, 0x0c, 0x90, 0xfe,
	0x33, 0x0d, 0x33, 0xcc, 0x2a, 0x88, 0x4b, 0x79, 0xb2, 0x8f, 0x4c, 0xcb, 0x69, 0x19, 0x4a, 0xc7,
	0x3d, 0x27, 0x73, 0x04, 0x52, 0x53, 0x3a, 0x08, 0x73, 0x41, 0xd5, 0xec, 0xae, 0xae, 0x9c, 0xd1,
	0x06, 0xcc, 0xa1, 0xc1, 0x60, 0xa4, 0xc9, 0x73, 0x50, 0x88, 0xe4, 0xc0, 0xdb, 0x24, 0xc1, 0x36,
	0xe7, 0x1b, 0x0a, 0x24, 0x09, 0xde, 0xf6, 0x5f, 0xf5, 0xa7, 0x22, 0xaf, 0xfa, 0x24, 0x39, 0x4e,
	0x51, 0x6d, 0x62, 0xb7, 0x65, 0xe5, 0x19, 0x5c, 0x2e, 0xab, 0x36, 0x09, 0x0d, 0x70, 0x7d, 0xe3,
	0x39, 0x99, 0x7c, 0x0e, 0x31, 0x29, 0x1b, 0x66, 0x92, 0x1b, 0x49, 0x90, 0x0b, 0x44, 0x12, 0xbc,
	0x07, 0x59, 0xef, 0x55, 0x11, 0x08, 0xd7, 0x78, 0x15, 0x13, 0xb3, 0x57, 0xdc, 0x37, 0x45, 0x0f,
	0x0d, 0x09, 0x21, 0xd2, 0x1c, 0x4b, 0x71, 0x50, 0x8b, 0x3e, 0xc7, 0x15, 0xf3, 0x2c, 0x84, 0x88,
	0x42, 0xcb, 0x04, 0xc8, 0x72, 0xc2, 0x4d, 0x43, 0x3f, 0x6b, 0x29, 0x56, 0xfb, 0x48, 0x3b, 0x41,
	0x36, 0x0b, 0xfa, 0x5d, 0x60, 0xf0, 0x32, 0x03, 0xc7, 0x7d, 0x8d, 0xc0, 0x5c, 0xcc, 0xd7, 0x08,
	0x84, 0x02, 0x20, 0xe6, 0xc3, 0x01, 0x10, 0x9f, 0xc0, 0x42, 0x84, 0x62, 0x7c, 0x45, 0x51, 0x7b,
	0x96, 0xe2, 0xc5, 0x8d, 0x4e, 0xc9, 0x5e, 0x59, 0xdc, 0x81, 0x4c, 0xcf, 0x60, 0xd1, 0x73, 0xdc,
	0x17, 0x86, 0xc8, 0x00, 0x7b, 0x86, 0xe6, 0xc8, 0x04, 0x0d, 0xf3, 0xa7, 0xb0, 0xfa, 0xf0, 0x61,
	0x3f, 0xd2, 0x88, 0x45, 0xe4, 0xb6, 0x14, 0xe9, 0xcb, 0x34, 0x40, 0x15, 0x4f, 0x98, 0x56, 0x24,
	0x73, 0xae, 0x32, 0x74, 0xb2, 0xd7, 0x5d, 0x7a, 0x44, 0x0c, 0x32, 0xf6, 0xd4, 0xe6, 0x8e, 0xc6,
	0x1f, 0x1a, 0xd7, 0xd6, 0xc3, 0x77, 0xf1, 0x2c, 0x05, 0x54, 0x55, 0xe9, 0x90, 0x18, 0x0c, 0x7d,
	0x88, 0xcf, 0x7f, 0x06, 0x8f, 0xe1, 0x12, 0x4d, 0xd4, 0x71, 0xab, 0xf8, 0x42, 0xd0, 0xa2, 0x5b,
	0x38, 0xd5, 0xb7, 0x85, 0xa5, 0x2b, 0x70, 0x39, 0x82, 0x99, 0x19, 0x73, 0xdf, 0x14, 0xe0, 0x1a,
	0xad, 0x19, 0x8f, 0x71, 0xc1, 0xbd, 0x9d, 0x0a, 0xef, 0xed, 0xb8, 0xed, 0x91, 0x8e, 0xdd, 0x1e,
	0xd2, 0x0a, 0x5c, 0x1f, 0x40, 0x04, 0x25, 0xf3, 0x8e, 0x0e, 0x59, 0x37, 0x34, 0x4c, 0x5c, 0x84,
	0x39, 0x37, 0x89, 0xa4, 0x55, 0xdb, 0xad, 0x55, 0x0a, 0x17, 0xc4, 0x02, 0xcc, 0x7a, 0xa0, 0x47,
	0x95, 0xf5, 0x82, 0x10, 0x82, 0x54, 0x77, 0x1b, 0x85, 0x94, 0x78, 0x09, 0x0a, 0x1e, 0xa4, 0x5c,
	0xdb, 0x94, 0x77, 0xab, 0x9b, 0x85, 0xb4, 0x78, 0x11, 0x16, 0x7c, 0xe8, 0x4e, 0xf9, 0xc3, 0xdd,
	0x5a, 0x21, 0x73, 0xe7, 0xa7, 0x02, 0x14, 0xa2, 0x69, 0x43, 0xe2, 0x65, 0x58, 0x6c, 0xec, 0xad,
	0x37, 0x36, 0xe4, 0x6a, 0xbd, 0x59, 0xdd, 0xad, 0xb5, 0xea, 0xe5, 0xea, 0x66, 0xe1, 0x82, 0xb8,
	0x04, 0x62, 0x18, 0x2c, 0x57, 0x77, 0x2a, 0x05, 0xa1, 0x0f, 0x5e, 0xde, 0xdc, 0xa9, 0xd6, 0x0a,
	0x29, 0x51, 0x82, 0x67, 0x42, 0xf0, 0xed, 0xea, 0x56, 0x93, 0xe0, 0x6a, 0xed, 0xd5, 0xb7, 0xe5,
	0xf2, 0x66, 0xa5, 0x90, 0x16, 0x6f, 0xc1, 0x4a, 0x3f, 0xce, 0x70, 0xa3, 0x4c, 0x1f, 0x3d, 0x24,
	0x95, 0x66, 0xea, 0xce, 0x7d, 0xc8, 0x79, 0xef, 0x97, 0xe2, 0x1c, 0xe4, 0x08, 0x7e, 0xc6, 0xa6,
	0x45, 0x98, 0x23, 0xc5, 0xf2, 0xc6, 0x46, 0xa5, 0xde, 0xac, 0x6c, 0x16, 0x04, 0x0f, 0xb4, 0x51,
	0xae, 0x6d, 0x54, 0x1e, 0x56, 0x36, 0x0b, 0xa9, 0x3b, 0xef, 0xc3, 0x6c, 0xd0, 0x2b, 0x8b, 0x9b,
	0x6c, 0x56, 0x1b, 0x1b, 0xbb, 0x7b, 0x35, 0x0f, 0xd1, 0x15, 0xb8, 0xe8, 0x81, 0xea, 0x15, 0x79,
	0xa3, 0x52, 0x6b, 0xee, 0x6e, 0x6d, 0x15, 0x04, 0xb1, 0x04, 0x4b, 0x5e, 0xc5, 0x56, 0xf5, 0x71,
	0x65, 0xf3, 0xfd, 0xf2, 0xc3, 0xbd, 0x0a, 0xae, 0x4b, 0xdd, 0xd9, 0x81, 0xac, 0xeb, 0x03, 0x14,
	0x45, 0x98, 0x27, 0xc3, 0x36, 0x3f, 0xa8, 0x57, 0x5c, 0xa4, 0x97, 0x61, 0xd1, 0x87, 0xed, 0x7c,
	0xd0, 0x68, 0x56, 0xe4, 0x0f, 0x28, 0x23, 0x7d, 0x70, 0xa3, 0x59, 0xae, 0x6d, 0x96, 0x65, 0x4c,
	0xe6, 0x13, 0xff, 0x52, 0x4a, 0x27, 0xbb, 0x04, 0x62, 0x08, 0xe0, 0xe2, 0x2d, 0xc2, 0xa5, 0x30,
	0xbc, 0xbc, 0xd1, 0xac, 0xbe, 0x8f, 0xd7, 0x68, 0x19, 0x2e, 0x87, 0x6b, 0xea, 0x95, 0xda, 0x66,
	0xb5, 0xb6, 0x5d, 0x48, 0xe1, 0x89, 0x84, 0xab, 0xaa, 0x35, 0xd6, 0x2d, 0x7d, 0xe7, 0x14, 0x2e,
	0xc6, 0x78, 0x56, 0xf0, 0x9c, 0xea, 0x72, 0x65, 0xab, 0xfa, 0xb8, 0xb5, 0x57, 0x7b, 0x50, 0xdb,
	0x7d, 0x54, 0x63, 0x82, 0xe9, 0xc2, 0x1a, 0x95, 0x26, 0x65, 0x38, 0x83, 0x30, 0x7c, 0x29, 0x22,
	0x83, 0x14, 0x24, 0x57, 0xde, 0xad, 0x6c, 0xe0, 0x85, 0x49, 0x07, 0xb0, 0xb9, 0x44, 0x65, 0xee,
	0xec, 0xfb, 0x16, 0x0e, 0xcb, 0xac, 0x0a, 0xcc, 0x99, 0x42, 0x5a, 0x65, 0x5d, 0x2f, 0x5c, 0x08,
	0x92, 0xcf, 0xe0, 0xec, 0xca, 0x59, 0x10, 0xc4, 0x6b, 0x50, 0x8c, 0xf6, 0x39, 0x38, 0xd0, 0x74,
	0x4d, 0x71, 0x50, 0x21, 0x75, 0xe7, 0x47, 0x02, 0x5c, 0x8c, 0x39, 0x06, 0x70, 0xaf, 0x18, 0xb0,
	0xcb, 0xe3, 0x01, 0xb5, 0x8f, 0x2a, 0x95, 0x07, 0x05, 0x41, 0xbc, 0x0e, 0xcb, 0x71, 0xb5, 0x3b,
	0xbb, 0xb5, 0xe6, 0x3b, 0x85, 0xd4, 0xa0, 0xce, 0x1f, 0x54, 0xca, 0x72, 0x21, 0x2d, 0xae, 0xc0,
	0xd5, 0xb8, 0xda, 0xdd, 0x5a, 0xa5, 0x89, 0x77, 0x5a, 0x66, 0xed, 0xef, 0xd6, 0x61, 0x2e, 0x14,
	0xda, 0x2e, 0x7e, 0x5f, 0xf0, 0xbc, 0xe2, 0xa1, 0x1c, 0xac, 0xfb, 0x9c, 0xd1, 0xdc, 0x03, 0x33,
	0xc0, 0x4b, 0xe5, 0x09, 0x30, 0xb0, 0xf3, 0xe2, 0xbb, 0x82, 0xfb, 0x42, 0x1d, 0xa2, 0xed, 0x1e,
	0x67, 0x70, 0xc7, 0xa0, 0x34, 0xe7, 0xd2, 0xfd, 0xf1, 0x11, 0x04, 0x29, 0xeb, 0xcb, 0x82, 0xe5,
	0xa6, 0x6c, 0x50, 0xce, 0x2e, 0x37, 0x65, 0x03, 0x13, 0x70, 0x09, 0x65, 0xfd, 0x29, 0xac, 0xbc,
	0x94, 0x0d, 0x4c, 0xdd, 0xe5, 0xa5, 0x6c, 0x70, 0xf6, 0xac, 0xf8, 0xeb, 0x02, 0xcc, 0x06, 0x73,
	0x47, 0xc5, 0xd7, 0xb9, 0x27, 0x1b, 0xcd, 0xb8, 0x2d, 0xbd, 0x31, 0x4e, 0x57, 0x46, 0xc7, 0x0f,
	0x04, 0xb8, 0x1c, 0x9b, 0xc9, 0x25, 0xae, 0x4f, 0x9e, 0xd9, 0x59, 0xda, 0x98, 0x08, 0x07, 0x23,
	0xf1, 0x3f, 0x84, 0x68, 0xd8, 0xd5, 0xb0, 0x14, 0x2d, 0xf1, 0x11, 0xe7, 0xb3, 0x52, 0xd2, 0xbc,
	0xd1, 0xd2, 0xe3, 0xf3, 0x47, 0xcc, 0x66, 0xf8, 0x87, 0x02, 0x5c, 0x8a, 0xcb, 0x2b, 0x12, 0xcb,
	0x89, 0x86, 0x8c, 0x5d, 0x82, 0xf5, 0x49, 0x50, 0x30, 0xfa, 0x7e, 0x24, 0x10, 0x4b, 0x76, 0xc0,
	0xb4, 0xc4, 0xed, 0x49, 0x19, 0xe3, 0xd2, 0xfa, 0xce, 0xe4, 0x88, 0x18, 0xc5, 0x3f, 0x16, 0xbc,
	0x1c, 0xaf, 0xb8, 0x24, 0x33, 0x31, 0xd9, 0x48, 0x43, 0x32, 0xe1, 0x4a, 0xd5, 0x73, 0xc0, 0xc4,
	0x88, 0xfe, 0x53, 0xfa, 0xc5, 0x42, 0x71, 0x59, 0x57, 0xe2, 0x26, 0xf7, 0x30, 0x43, 0x72, 0xc4,
	0x4a, 0x95, 0x09, 0xb1, 0x84, 0xe5, 0xb5, 0x2f, 0x69, 0x2a, 0x81, 0xbc, 0x0e, 0xca, 0xee, 0x4a,
	0x20, 0xaf, 0x83, 0x73, 0xb6, 0xbe, 0x2d, 0xc0, 0x7c, 0x38, 0xf9, 0x48, 0xe4, 0x8c, 0x81, 0x8c,
	0xcd, 0x8f, 0x2a, 0xbd, 0x35, 0x5e, 0x67, 0x46, 0xcd, 0x67, 0x02, 0x2c, 0xf6, 0xa5, 0x1d, 0x89,
	0x77, 0x93, 0xe1, 0x8c, 0xa6, 0x40, 0x95, 0xee, 0x8d, 0xdd, 0x9f, 0x91, 0x75, 0x06, 0x59, 0xf7,
	0xdb, 0xea, 0x44, 0x4e, 0xcf, 0x47, 0xe4, 0xbb, 0xf3, 0x4a, 0xaf, 0x24, 0xed, 0xc6, 0x86, 0xfe,
	0x73, 0x12, 0x9c, 0x1f, 0xff, 0x8d, 0x5f, 0x62, 0x85, 0xf7, 0x34, 0x1b, 0xfa, 0x9d, 0x63, 0xa5,
	0xad, 0x49, 0xd1, 0x04, 0x34, 0xc9, 0x90, 0xf8, 0x70, 0x5e, 0x4d, 0x32, 0x3a, 0x72, 0x9f, 0x57,
	0x93, 0xf0, 0x04, 0xab, 0x63, 0x06, 0x0f, 0x8a, 0xbb, 0xe6, 0x65, 0xf0, 0x88, 0x10, 0x72, 0x5e,
	0x06, 0x8f, 0x0c, 0xff, 0x26, 0x0c, 0x1e, 0x1c, 0x96, 0xcd, 0xcd, 0xe0, 0x91, 0x81, 0xe2, 0xdc,
	0x0c, 0xe6, 0x88, 0x11, 0xff, 0x27, 0xc1, 0x4b, 0x62, 0x1e, 0x16, 0xa3, 0x2d, 0xd6, 0xc7, 0x39,
	0xd1, 0x86, 0x4e, 0xe2, 0xbd, 0x73, 0xc4, 0xc8, 0x26, 0xf3, 0xbb, 0x02, 0x09, 0x5c, 0x0c, 0x7e,
	0xcd, 0x99, 0xf8, 0x56, 0x32, 0xb3, 0x21, 0xfc, 0xed, 0x73, 0xa5, 0xb7, 0xc7, 0xec, 0x1d, 0x20,
	0xa8, 0x31, 0x1e, 0x41, 0x8d, 0x89, 0x08, 0x1a, 0xf4, 0x65, 0x6f, 0x3f, 0x11, 0xe0, 0xfa, 0xd0,
	0xf4, 0x49, 0xf1, 0x5d, 0xee, 0x19, 0x8f, 0xcc, 0x1c, 0x2d, 0x3d, 0x38, 0x17, 0x5c, 0x8c, 0xf4,
	0x9f, 0x09, 0xe4, 0xc1, 0x74, 0x68, 0x92, 0xa3, 0xb8, 0x33, 0xee, 0x88, 0xb1, 0x09, 0xa0, 0xa5,
	0xda, 0x79, 0xa1, 0x0b, 0x0b, 0x68, 0x30, 0xd1, 0x2e, 0x81, 0x80, 0xc6, 0xe4, 0xfe, 0x25, 0x10,
	0xd0, 0xd8, 0xec, 0xbe, 0xcf, 0xbc, 0xb8, 0xf7, 0x60, 0xa6, 0xe6, 0xdd, 0x24, 0x0a, 0xbc, 0x3f,
	0x2d, 0xad, 0x74, 0x6f, 0xec, 0xfe, 0x41, 0xb2, 0xa2, 0x09, 0x64, 0xdc, 0x64, 0x0d, 0xc8, 0x96,
	0x2b, 0xdd, 0x1b, 0xbb, 0x3f, 0x23, 0xeb, 0x53, 0x00, 0x3f, 0xb4, 0x5e, 0x7c, 0x35, 0xc9, 0x2c,
	0x03, 0xa1, 0xc0, 0xa5, 0xd7, 0x92, 0x77, 0xf4, 0x09, 0xf0, 0x43, 0xd7, 0x79, 0x09, 0xe8, 0x0b,
	0xdb, 0xe7, 0x25, 0x20, 0x26, 0x4a, 0x1e, 0x73, 0xc0, 0x0b, 0x40, 0xe7, 0xe6, 0x40, 0x34, 0x2e,
	0x9e, 0x9b, 0x03, 0xfd, 0xb1, 0xee, 0x67, 0x90, 0x75, 0x83, 0xc8, 0x79, 0x8d, 0xbd, 0x48, 0x28,
	0x3b, 0xaf, 0xb1, 0xd7, 0x17, 0xab, 0x7e, 0x02, 0x33, 0x2c, 0x12, 0x59, 0x7c, 0x89, 0x9b, 0xfe,
	0xe0, 0xac, 0x5f, 0x4e, 0xd8, 0x8b, 0x8d, 0xfb, 0xfb, 0x82, 0x17, 0x38, 0xef, 0x47, 0x33, 0xbf,
	0x9d, 0x68, 0x12, 0xd1, 0x10, 0xe0, 0xd2, 0xdd, 0x71, 0xbb, 0x33, 0x9a, 0x7e, 0x43, 0x80, 0xb9,
	0x50, 0x48, 0xba, 0x98, 0xc0, 0x77, 0x13, 0x8d, 0x8d, 0x2f, 0xbd, 0x39, 0x56, 0xdf, 0x00, 0x7b,
	0xa2, 0x11, 0xe2, 0xbc, 0xec, 0x19, 0x10, 0x20, 0x5f, 0xba, 0x3b, 0x6e, 0xf7, 0x80, 0x53, 0x2c,
	0x18, 0x35, 0xcb, 0xeb, 0x14, 0x8b, 0x89, 0x64, 0xe6, 0x75, 0x8a, 0xc5, 0x05, 0xe9, 0x92, 0x8b,
	0xf8, 0x80, 0x20, 0x58, 0xde, 0x8b, 0xf8, 0xf0, 0x18, 0x5f, 0xde, 0x8b, 0xf8, 0x88, 0x48, 0x5c,
	0xf1, 0xaf, 0x04, 0xb8, 0x36, 0x2c, 0xc4, 0x55, 0xac, 0x26, 0x1a, 0x67, 0x58, 0x34, 0x6f, 0xe9,
	0xdd, 0xf3, 0x40, 0x15, 0xb8, 0xa0, 0x87, 0xc3, 0x67, 0x79, 0x2f, 0xe8, 0xb1, 0x81, 0xba, 0xa5,
	0xb7, 0xc6, 0xeb, 0xcc, 0xa8, 0xf9, 0x2d, 0x01, 0xe6, 0xc3, 0x11, 0xa0, 0xbc, 0xd4, 0xc4, 0x46,
	0xc2, 0x96, 0xc6, 0xec, 0x1c, 0xf2, 0x5c, 0x0d, 0x8a, 0xdc, 0x4c, 0xe0, 0xb9, 0x1a, 0x11, 0x44,
	0x9a, 0xc0, 0x73, 0x35, 0x32, 0x8c, 0xf4, 0xbb, 0x02, 0x88, 0xfd, 0xe1, 0x89, 0xbc, 0x7e, 0xf6,
	0x81, 0xe1, 0x90, 0xbc, 0x7e, 0xf6, 0x21, 0x91, 0x91, 0xd8, 0x24, 0xea, 0x0b, 0x9b, 0x16, 0xef,
	0x26, 0x92, 0x97, 0xbe, 0x08, 0xc9, 0xd2, 0xbd, 0xb1, 0xfb, 0x07, 0x3c, 0x68, 0x71, 0xc1, 0x92,
	0xbc, 0x1e, 0xb4, 0x21, 0xe1, 0x9b, 0xbc, 0x1e, 0xb4, 0x61, 0xb1, 0x9a, 0xc4, 0x81, 0x30, 0x28,
	0xcc, 0x52, 0xe4, 0xf7, 0x22, 0x0e, 0x0b, 0xf6, 0xe4, 0x75, 0x20, 0x8c, 0x8c, 0xf6, 0xfc, 0xbe,
	0x00, 0x17, 0x63, 0x1a, 0x89, 0xf7, 0xc7, 0xc6, 0x9f, 0xf0, 0xd5, 0x6e, 0x58, 0xfc, 0xe3, 0x9f,
	0x08, 0xb0, 0x14, 0x1f, 0x4c, 0x27, 0x4e, 0x12, 0x33, 0xe7, 0x91, 0xb8, 0x39, 0x19, 0x92, 0xb0,
	0xad, 0x14, 0x0a, 0xb5, 0x49, 0x60, 0x2b, 0xc5, 0x85, 0xf7, 0x24, 0xb0, 0x95, 0xe2, 0x23, 0x7c,
	0x98, 0x4e, 0x89, 0x44, 0x76, 0x24, 0xd0, 0x29, 0xf1, 0x81, 0x29, 0x09, 0x74, 0xca, 0xa0, 0xc8,
	0x1d, 0x6c, 0xc5, 0x85, 0xa2, 0x62, 0x78, 0xad, 0xb8, 0xb8, 0x20, 0x1d, 0xde, 0xd3, 0x22, 0x36,
	0x0c, 0x87, 0x3c, 0xdf, 0xc5, 0x46, 0xc0, 0xf0, 0x3e, 0xdf, 0x0d, 0x8b, 0xe1, 0xe1, 0x7d, 0xbe,
	0x1b, 0x1a, 0x82, 0x43, 0x64, 0x2b, 0xfa, 0x6b, 0x2f, 0xbc, 0xb2, 0x35, 0xe0, 0x97, 0x68, 0x78,
	0x65, 0x6b, 0xd0, 0x8f, 0xcc, 0xf8, 0x34, 0x05, 0x7e, 0x01, 0x27, 0x11, 0x4d, 0xfd, 0x3f, 0xc4,
	0x93, 0x88, 0xa6, 0x98, 0x1f, 0xde, 0x21, 0x8f, 0x6c, 0x83, 0x7f, 0x0a, 0x88, 0xf7, 0x91, 0x6d,
	0xe4, 0x0f, 0x1c, 0xf1, 0x3e, 0xb2, 0x8d, 0xfe, 0x55, 0xa2, 0xf5, 0xfc, 0x87, 0xe4, 0x87, 0x34,
	0xc8, 0x0f, 0x37, 0xed, 0x4f, 0x93, 0x50, 0xd3, 0x17, 0xff, 0x27, 0x00, 0x00, 0xff, 0xff, 0x37,
	0x88, 0x99, 0x41, 0xc8, 0x69, 0x00, 0x00,
}
