// Code generated by protoc-gen-twirp v4.7.0, DO NOT EDIT.
// source: twirp/subscriptions.proto

/*
Package substwirp is a generated twirp stub package.
This code was generated with code.justin.tv/common/twirp/protoc-gen-twirp v4.7.0.

It is generated from these files:
	twirp/subscriptions.proto
*/
package substwirp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/timestamp"

import bytes "bytes"
import context "golang.org/x/net/context"
import http "net/http"
import ioutil "io/ioutil"
import jsonpb "github.com/golang/protobuf/jsonpb"
import log "log"
import proto1 "github.com/golang/protobuf/proto"
import twirp "code.justin.tv/common/twirp"
import fmt1 "fmt"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import strings "strings"
import json "encoding/json"
import url "net/url"
import ctxhttp "golang.org/x/net/context/ctxhttp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// =======================
// Subscriptions Interface
// =======================

type Subscriptions interface {
	// Subscriptions
	// =============
	// FulfillSubscription creates/upgrades subscription for user to product.
	FulfillSubscription(context.Context, *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error)

	// CreateSubscription creates a new subscription without the extra steps that FulfillSubscription
	// does, such as creating chat notification tokens. CreateSubscription is called by
	// FulfillSubscription as one of its steps.
	// The following steps will be executed during CreateSubscription:
	//   Lock using redis
	//   CanSubscribe?
	//   Create subscription entitlement
	//   Send entitlementSNS
	//   Unlock
	CreateSubscription(context.Context, *CreateSubscriptionRequest) (*CreateSubscriptionResponse, error)

	// CancelSubscription cancels user's subscription to product.
	CancelSubscription(context.Context, *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error)

	// UpdateSubscription updates user's subscription to product.
	// The following steps will be executed during UpdateSubscription:
	//   Update subscription entitlement
	//   Send entitlementSNS
	UpdateSubscription(context.Context, *UpdateSubscriptionRequest) (*UpdateSubscriptionResponse, error)

	// CanSubscribe returns whether user can subscribe to product for a given platform.
	CanSubscribe(context.Context, *CanSubscribeRequest) (*CanSubscribeResponse, error)

	// ListUserSubscriptions returns a paginated list of user's active subscriptions.
	ListUserSubscriptions(context.Context, *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error)

	// GetUserChannelSubscriptionWithPaymentsData returns the highest max tier active subscription with payments data for an owner channel pair.
	GetUserChannelSubscriptionWithPaymentsData(context.Context, *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error)

	// GetUserSubscriptions returns the list of all a user's active subscriptions without payment data. Will return highest tier sub per channel.
	GetUserSubscriptions(context.Context, *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error)

	// GetUserChannelSubscription returns the highest max tier active subscription without payments data for a user channel pair.
	// This should be used when you need to know if a user channel pair is subscribed.
	GetUserChannelSubscription(context.Context, *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error)

	// GetUserSubscriptions returns the list of a user's active subscriptions without payments data given a list of product_ids.
	GetUserProductSubscriptions(context.Context, *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error)

	// GetChannelSubscriptions returns a paginated list of active subscribers to a channel.
	GetChannelSubscriptions(context.Context, *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error)

	// GetFormerSubscribers returns a paginated list of former subscribers to a channel.
	// This API is not sorted, going through paginated results might result in duplicates/missing entries.
	// Limit is capped at 1000
	GetFormerSubscribers(context.Context, *GetFormerSubscribersRequest) (*GetFormerSubscribersResponse, error)

	// Subscriber Badges
	// =====
	// TakedownBadges takes down one or more custom subscriber badges belonging to a broadcaster
	TakedownBadges(context.Context, *TakedownBadgesRequest) (*TakedownBadgesResponse, error)

	// TakedownAllBadges takes down all badges belonging to a broadcaster
	TakedownAllBadges(context.Context, *TakedownAllBadgesRequest) (*TakedownAllBadgesResponse, error)

	// Score
	// =====
	// SetScore sets the subscription high score given a channel and current score.
	SetScore(context.Context, *SetScoreRequest) (*SetScoreResponse, error)

	// CalculateSubscriberScore returns the subscriber score given their channel id.
	CalculateSubscriberCount(context.Context, *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error)

	// ChatNotification
	// =====
	// CreateChatNotificationToken creates a chat notification token
	CreateChatNotificationToken(context.Context, *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error)

	// UseChatNotificationToken posts a chat notification token, marks it as used given a token_id.
	UseChatNotificationToken(context.Context, *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error)

	// CancelChatNotificationToken invalidates a chat notification token, given a subscription_id.
	CancelChatNotificationToken(context.Context, *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error)

	// GetAvailableTokens gets all the tokens that are available that belong to a user and channel.
	GetUserChannelChatNotificationToken(context.Context, *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error)

	// UserSettings
	// ============
	// GetUserSettings gets the user subscription settings.
	GetUserSettings(context.Context, *GetUserSettingsRequest) (*GetUserSettingsResponse, error)

	// SetUserSettings sets the user subscription settings.
	SetUserSettings(context.Context, *SetUserSettingsRequest) (*SetUserSettingsResponse, error)

	// External Product
	// ================
	// GetExternalProductTemplateSKU returns a template SKU which can be used to fetch external product's attributes
	// from third party subscription providers like Apple, Google.
	GetExternalProductTemplateSKU(context.Context, *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error)

	// GetExternalProductPurchasableSKU does subscription eligibility checks and returns SKU for purchase from
	// external subscriptions providers (e.g, Apple, Google)
	GetExternalProductPurchasableSKU(context.Context, *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error)

	// Paid Upgrades
	// =======
	// GetPaidUpgrades returns a list of paid upgrades from a list of subKeys.
	GetPaidUpgrades(context.Context, *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error)

	// CreatePaidUpgrades creates a paid upgrade from a subKey.
	CreatePaidUpgrade(context.Context, *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error)

	// CancelPaidUpgrade cancels the paid upgrade from a subKey.
	CancelPaidUpgrade(context.Context, *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error)

	// Gifts
	// ======
	// CreateGift creates a new gift record in the gifts table if product is valid and sender/recipient are eligibile. Also sends notifications about the new gift.
	CreateGift(context.Context, *CreateGiftRequest) (*CreateGiftResponse, error)

	// InsertGift creates a new gift record in the gifts table without checking product, eligibilty or sending notifications.
	InsertGift(context.Context, *InsertGiftRequest) (*InsertGiftResponse, error)

	// CancelGift cancels a subscription gift.
	CancelGift(context.Context, *CancelGiftRequest) (*CancelGiftResponse, error)

	// GetGifts determines if there are gifts associated with supplied POODs.
	GetGifts(context.Context, *GetGiftsRequest) (*GetGiftsResponse, error)

	// CanGift determines if a sender can gift a subscription to a recipient.
	CanGift(context.Context, *CanGiftRequest) (*CanGiftResponse, error)

	// GetGiftPromotion returns the active gift promotion for subscription products.
	GetGiftPromotion(context.Context, *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error)

	// CanSenderGift determines if a sender is allowed to gift to recipients
	CanSenderGift(context.Context, *CanSenderGiftRequest) (*CanSenderGiftResponse, error)

	// CanGiftRecipient determines if a recipient is allowed to receive a gift from a particular sender depending on th type of gift.
	CanGiftRecipient(context.Context, *CanGiftRecipientRequest) (*CanGiftRecipientResponse, error)

	// FulfillGifts asynchronously entitles gift subscription for a given request.
	FulfillGifts(context.Context, *FulfillGiftsRequest) (*FulfillGiftsResponse, error)

	// SendMMGChatNotification sends a chat notification indicating the sender has gifted a sub to a recipient.
	SendMMGChatNotification(context.Context, *SendMMGChatNotificationRequest) (*SendMMGChatNotificationResponse, error)

	// SendMMGStartChatNotification sends a chat notification that indicates the start of a mass mystery gift.
	SendMMGStartChatNotification(context.Context, *SendMMGStartChatNotificationRequest) (*SendMMGStartChatNotificationResponse, error)

	// Emoticons
	// ======
	// GetEmotePrefix gets the emote prefix for a given channel ID.
	GetEmotePrefix(context.Context, *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error)

	// CreateEmoticon creates a subscription emoticon.
	CreateEmoticon(context.Context, *CreateEmoticonRequest) (*CreateEmoticonReponse, error)

	GetAllEmoticonsByProductIDs(context.Context, *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error)

	// Get standing status of a user. Can be "in good standing" or "not in good standing".
	// Partners are considered to be in “good standing” if they have not had a conduct infraction within the last 90 days.
	GetPartnerStanding(context.Context, *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error)

	// GetEmoticonPrefix returns the emote prefix and prefix state for a given channel ID.
	GetEmoticonPrefix(context.Context, *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error)

	// SubmitEmoticonPrefix is used when a new partner has a blank emoticon prefix and wants to submit
	// a prefix for approval. Will return precondition failed if the user does not have a blank prefix.
	SubmitEmoticonPrefix(context.Context, *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error)

	// Pending Emoticons
	// ======
	// GetPendingEmoticonByID returns a particular pending emoticon for use in the aegis GQL loader
	GetPendingEmoticonsByIDs(context.Context, *GetPendingEmoticonsByIDsRequest) (*GetPendingEmoticonsByIDsResponse, error)

	// GetPendingEmoticons returns an array of pending emoticons for the moderation team's approval flow.
	GetPendingEmoticons(context.Context, *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error)

	// ReviewPendingEmoticons accepts an array of approve or reject actions and either approves or rejects each emoticon
	ReviewPendingEmoticons(context.Context, *ReviewPendingEmoticonsRequest) (*ReviewPendingEmoticonsResponse, error)

	// Products
	// =========
	// GetProductsByIDs returns a list of products given a list of product ids.
	// Max size of 100 ids.
	GetProductsByIDs(context.Context, *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error)

	// GetChannelProducts accepts a channelID and returns a list of active products owned by the channel.
	// If the channel belongs to a teamsub, it will return the teamsub product.
	GetChannelProducts(context.Context, *GetChannelProductsRequest) (*GetChannelProductsResponse, error)

	// UpdateProduct updates the fields of the given product.
	UpdateProduct(context.Context, *UpdateProductRequest) (*UpdateProductResponse, error)

	// Updates all products for a given channel.
	UpdateChannelProducts(context.Context, *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error)

	// EmailSubscribers publishes to a queue to initiate the email process.
	EmailSubscribers(context.Context, *EmailSubscribersRequest) (*EmailSubscribersResponse, error)

	EmailGlobalEmote(context.Context, *EmailGlobalEmoteRequest) (*EmailGlobalEmoteResponse, error)

	EmailPendingPrefixApproval(context.Context, *EmailPendingPrefixApprovalRequest) (*EmailPendingPrefixApprovalResponse, error)
}

// =============================
// Subscriptions Protobuf Client
// =============================

type subscriptionsProtobufClient struct {
	urlBase string
	client  *http.Client
}

// NewSubscriptionsProtobufClient creates a Protobuf client that implements the Subscriptions interface.
// It communicates using protobuf messages and can be configured with a custom http.Client.
func NewSubscriptionsProtobufClient(addr string, client *http.Client) Subscriptions {
	return &subscriptionsProtobufClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *subscriptionsProtobufClient) FulfillSubscription(ctx context.Context, in *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillSubscription"
	out := new(FulfillSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateSubscription(ctx context.Context, in *CreateSubscriptionRequest) (*CreateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateSubscription"
	out := new(CreateSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelSubscription(ctx context.Context, in *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelSubscription"
	out := new(CancelSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest) (*UpdateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateSubscription"
	out := new(UpdateSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanSubscribe(ctx context.Context, in *CanSubscribeRequest) (*CanSubscribeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSubscribe"
	out := new(CanSubscribeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) ListUserSubscriptions(ctx context.Context, in *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserSubscriptions"
	out := new(ListUserSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData"
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSubscriptions"
	out := new(GetUserSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscription"
	out := new(GetUserChannelSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptions"
	out := new(GetUserProductSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetChannelSubscriptions(ctx context.Context, in *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelSubscriptions"
	out := new(GetChannelSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetFormerSubscribers(ctx context.Context, in *GetFormerSubscribersRequest) (*GetFormerSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetFormerSubscribers"
	out := new(GetFormerSubscribersResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) TakedownBadges(ctx context.Context, in *TakedownBadgesRequest) (*TakedownBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownBadges"
	out := new(TakedownBadgesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) TakedownAllBadges(ctx context.Context, in *TakedownAllBadgesRequest) (*TakedownAllBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownAllBadges"
	out := new(TakedownAllBadgesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SetScore(ctx context.Context, in *SetScoreRequest) (*SetScoreResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetScore"
	out := new(SetScoreResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CalculateSubscriberCount(ctx context.Context, in *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CalculateSubscriberCount"
	out := new(CalculateSubscriberCountResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateChatNotificationToken(ctx context.Context, in *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChatNotificationToken"
	out := new(CreateChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UseChatNotificationToken(ctx context.Context, in *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UseChatNotificationToken"
	out := new(UseChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelChatNotificationToken(ctx context.Context, in *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelChatNotificationToken"
	out := new(CancelChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelChatNotificationToken(ctx context.Context, in *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken"
	out := new(GetUserChannelChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserSettings(ctx context.Context, in *GetUserSettingsRequest) (*GetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSettings"
	out := new(GetUserSettingsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SetUserSettings(ctx context.Context, in *SetUserSettingsRequest) (*SetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetUserSettings"
	out := new(SetUserSettingsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetExternalProductTemplateSKU(ctx context.Context, in *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductTemplateSKU"
	out := new(GetExternalProductTemplateSKUResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetExternalProductPurchasableSKU(ctx context.Context, in *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU"
	out := new(GetExternalProductPurchasableSKUResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPaidUpgrades(ctx context.Context, in *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgrades"
	out := new(GetPaidUpgradesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreatePaidUpgrade(ctx context.Context, in *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreatePaidUpgrade"
	out := new(CreatePaidUpgradeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelPaidUpgrade(ctx context.Context, in *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelPaidUpgrade"
	out := new(CancelPaidUpgradeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateGift(ctx context.Context, in *CreateGiftRequest) (*CreateGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateGift"
	out := new(CreateGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) InsertGift(ctx context.Context, in *InsertGiftRequest) (*InsertGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "InsertGift"
	out := new(InsertGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelGift(ctx context.Context, in *CancelGiftRequest) (*CancelGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelGift"
	out := new(CancelGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetGifts(ctx context.Context, in *GetGiftsRequest) (*GetGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGifts"
	out := new(GetGiftsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanGift(ctx context.Context, in *CanGiftRequest) (*CanGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGift"
	out := new(CanGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetGiftPromotion(ctx context.Context, in *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGiftPromotion"
	out := new(GetGiftPromotionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanSenderGift(ctx context.Context, in *CanSenderGiftRequest) (*CanSenderGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSenderGift"
	out := new(CanSenderGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanGiftRecipient(ctx context.Context, in *CanGiftRecipientRequest) (*CanGiftRecipientResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGiftRecipient"
	out := new(CanGiftRecipientResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) FulfillGifts(ctx context.Context, in *FulfillGiftsRequest) (*FulfillGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillGifts"
	out := new(FulfillGiftsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SendMMGChatNotification(ctx context.Context, in *SendMMGChatNotificationRequest) (*SendMMGChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGChatNotification"
	out := new(SendMMGChatNotificationResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SendMMGStartChatNotification(ctx context.Context, in *SendMMGStartChatNotificationRequest) (*SendMMGStartChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGStartChatNotification"
	out := new(SendMMGStartChatNotificationResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetEmotePrefix(ctx context.Context, in *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmotePrefix"
	out := new(GetEmotePrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateEmoticon"
	out := new(CreateEmoticonReponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetAllEmoticonsByProductIDs(ctx context.Context, in *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs"
	out := new(GetAllEmoticonsByProductIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPartnerStanding(ctx context.Context, in *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPartnerStanding"
	out := new(GetPartnerStandingResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetEmoticonPrefix(ctx context.Context, in *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmoticonPrefix"
	out := new(GetEmoticonPrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SubmitEmoticonPrefix(ctx context.Context, in *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SubmitEmoticonPrefix"
	out := new(SubmitEmoticonPrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPendingEmoticonsByIDs(ctx context.Context, in *GetPendingEmoticonsByIDsRequest) (*GetPendingEmoticonsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticonsByIDs"
	out := new(GetPendingEmoticonsByIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPendingEmoticons(ctx context.Context, in *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticons"
	out := new(GetPendingEmoticonsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) ReviewPendingEmoticons(ctx context.Context, in *ReviewPendingEmoticonsRequest) (*ReviewPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ReviewPendingEmoticons"
	out := new(ReviewPendingEmoticonsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetProductsByIDs(ctx context.Context, in *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByIDs"
	out := new(GetProductsByIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetChannelProducts(ctx context.Context, in *GetChannelProductsRequest) (*GetChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelProducts"
	out := new(GetChannelProductsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest) (*UpdateProductResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateProduct"
	out := new(UpdateProductResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateChannelProducts(ctx context.Context, in *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateChannelProducts"
	out := new(UpdateChannelProductsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) EmailSubscribers(ctx context.Context, in *EmailSubscribersRequest) (*EmailSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailSubscribers"
	out := new(EmailSubscribersResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) EmailGlobalEmote(ctx context.Context, in *EmailGlobalEmoteRequest) (*EmailGlobalEmoteResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailGlobalEmote"
	out := new(EmailGlobalEmoteResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) EmailPendingPrefixApproval(ctx context.Context, in *EmailPendingPrefixApprovalRequest) (*EmailPendingPrefixApprovalResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailPendingPrefixApproval"
	out := new(EmailPendingPrefixApprovalResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

// =========================
// Subscriptions JSON Client
// =========================

type subscriptionsJSONClient struct {
	urlBase string
	client  *http.Client
}

// NewSubscriptionsJSONClient creates a JSON client that implements the Subscriptions interface.
// It communicates using JSON requests and responses instead of protobuf messages.
func NewSubscriptionsJSONClient(addr string, client *http.Client) Subscriptions {
	return &subscriptionsJSONClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *subscriptionsJSONClient) FulfillSubscription(ctx context.Context, in *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillSubscription"
	out := new(FulfillSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateSubscription(ctx context.Context, in *CreateSubscriptionRequest) (*CreateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateSubscription"
	out := new(CreateSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelSubscription(ctx context.Context, in *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelSubscription"
	out := new(CancelSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest) (*UpdateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateSubscription"
	out := new(UpdateSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanSubscribe(ctx context.Context, in *CanSubscribeRequest) (*CanSubscribeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSubscribe"
	out := new(CanSubscribeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) ListUserSubscriptions(ctx context.Context, in *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserSubscriptions"
	out := new(ListUserSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData"
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSubscriptions"
	out := new(GetUserSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscription"
	out := new(GetUserChannelSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptions"
	out := new(GetUserProductSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetChannelSubscriptions(ctx context.Context, in *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelSubscriptions"
	out := new(GetChannelSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetFormerSubscribers(ctx context.Context, in *GetFormerSubscribersRequest) (*GetFormerSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetFormerSubscribers"
	out := new(GetFormerSubscribersResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) TakedownBadges(ctx context.Context, in *TakedownBadgesRequest) (*TakedownBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownBadges"
	out := new(TakedownBadgesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) TakedownAllBadges(ctx context.Context, in *TakedownAllBadgesRequest) (*TakedownAllBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownAllBadges"
	out := new(TakedownAllBadgesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SetScore(ctx context.Context, in *SetScoreRequest) (*SetScoreResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetScore"
	out := new(SetScoreResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CalculateSubscriberCount(ctx context.Context, in *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CalculateSubscriberCount"
	out := new(CalculateSubscriberCountResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateChatNotificationToken(ctx context.Context, in *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChatNotificationToken"
	out := new(CreateChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UseChatNotificationToken(ctx context.Context, in *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UseChatNotificationToken"
	out := new(UseChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelChatNotificationToken(ctx context.Context, in *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelChatNotificationToken"
	out := new(CancelChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelChatNotificationToken(ctx context.Context, in *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken"
	out := new(GetUserChannelChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserSettings(ctx context.Context, in *GetUserSettingsRequest) (*GetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSettings"
	out := new(GetUserSettingsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SetUserSettings(ctx context.Context, in *SetUserSettingsRequest) (*SetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetUserSettings"
	out := new(SetUserSettingsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetExternalProductTemplateSKU(ctx context.Context, in *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductTemplateSKU"
	out := new(GetExternalProductTemplateSKUResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetExternalProductPurchasableSKU(ctx context.Context, in *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU"
	out := new(GetExternalProductPurchasableSKUResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPaidUpgrades(ctx context.Context, in *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgrades"
	out := new(GetPaidUpgradesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreatePaidUpgrade(ctx context.Context, in *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreatePaidUpgrade"
	out := new(CreatePaidUpgradeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelPaidUpgrade(ctx context.Context, in *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelPaidUpgrade"
	out := new(CancelPaidUpgradeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateGift(ctx context.Context, in *CreateGiftRequest) (*CreateGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateGift"
	out := new(CreateGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) InsertGift(ctx context.Context, in *InsertGiftRequest) (*InsertGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "InsertGift"
	out := new(InsertGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelGift(ctx context.Context, in *CancelGiftRequest) (*CancelGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelGift"
	out := new(CancelGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetGifts(ctx context.Context, in *GetGiftsRequest) (*GetGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGifts"
	out := new(GetGiftsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanGift(ctx context.Context, in *CanGiftRequest) (*CanGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGift"
	out := new(CanGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetGiftPromotion(ctx context.Context, in *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGiftPromotion"
	out := new(GetGiftPromotionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanSenderGift(ctx context.Context, in *CanSenderGiftRequest) (*CanSenderGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSenderGift"
	out := new(CanSenderGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanGiftRecipient(ctx context.Context, in *CanGiftRecipientRequest) (*CanGiftRecipientResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGiftRecipient"
	out := new(CanGiftRecipientResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) FulfillGifts(ctx context.Context, in *FulfillGiftsRequest) (*FulfillGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillGifts"
	out := new(FulfillGiftsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SendMMGChatNotification(ctx context.Context, in *SendMMGChatNotificationRequest) (*SendMMGChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGChatNotification"
	out := new(SendMMGChatNotificationResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SendMMGStartChatNotification(ctx context.Context, in *SendMMGStartChatNotificationRequest) (*SendMMGStartChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGStartChatNotification"
	out := new(SendMMGStartChatNotificationResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetEmotePrefix(ctx context.Context, in *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmotePrefix"
	out := new(GetEmotePrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateEmoticon"
	out := new(CreateEmoticonReponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetAllEmoticonsByProductIDs(ctx context.Context, in *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs"
	out := new(GetAllEmoticonsByProductIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPartnerStanding(ctx context.Context, in *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPartnerStanding"
	out := new(GetPartnerStandingResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetEmoticonPrefix(ctx context.Context, in *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmoticonPrefix"
	out := new(GetEmoticonPrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SubmitEmoticonPrefix(ctx context.Context, in *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SubmitEmoticonPrefix"
	out := new(SubmitEmoticonPrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPendingEmoticonsByIDs(ctx context.Context, in *GetPendingEmoticonsByIDsRequest) (*GetPendingEmoticonsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticonsByIDs"
	out := new(GetPendingEmoticonsByIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPendingEmoticons(ctx context.Context, in *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticons"
	out := new(GetPendingEmoticonsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) ReviewPendingEmoticons(ctx context.Context, in *ReviewPendingEmoticonsRequest) (*ReviewPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ReviewPendingEmoticons"
	out := new(ReviewPendingEmoticonsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetProductsByIDs(ctx context.Context, in *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByIDs"
	out := new(GetProductsByIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetChannelProducts(ctx context.Context, in *GetChannelProductsRequest) (*GetChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelProducts"
	out := new(GetChannelProductsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest) (*UpdateProductResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateProduct"
	out := new(UpdateProductResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateChannelProducts(ctx context.Context, in *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateChannelProducts"
	out := new(UpdateChannelProductsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) EmailSubscribers(ctx context.Context, in *EmailSubscribersRequest) (*EmailSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailSubscribers"
	out := new(EmailSubscribersResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) EmailGlobalEmote(ctx context.Context, in *EmailGlobalEmoteRequest) (*EmailGlobalEmoteResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailGlobalEmote"
	out := new(EmailGlobalEmoteResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) EmailPendingPrefixApproval(ctx context.Context, in *EmailPendingPrefixApprovalRequest) (*EmailPendingPrefixApprovalResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailPendingPrefixApproval"
	out := new(EmailPendingPrefixApprovalResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

// ============================
// Subscriptions Server Handler
// ============================

type subscriptionsServer struct {
	Subscriptions
	hooks     *twirp.ServerHooks
	ctxSource ContextSource
}

func NewSubscriptionsServer(svc Subscriptions, hooks *twirp.ServerHooks, ctxSrc ContextSource) TwirpServer {
	defaultHooks := twirp.NewServerHooks()
	if hooks == nil {
		hooks = defaultHooks
	} else {
		if hooks.RequestReceived == nil {
			hooks.RequestReceived = defaultHooks.RequestReceived
		}
		if hooks.RequestRouted == nil {
			hooks.RequestRouted = defaultHooks.RequestRouted
		}
		if hooks.ResponsePrepared == nil {
			hooks.ResponsePrepared = defaultHooks.ResponsePrepared
		}
		if hooks.ResponseSent == nil {
			hooks.ResponseSent = defaultHooks.ResponseSent
		}
		if hooks.Error == nil {
			hooks.Error = defaultHooks.Error
		}
	}
	if ctxSrc == nil {
		ctxSrc = RequestContextSource
	}

	return &subscriptionsServer{
		Subscriptions: svc,
		hooks:         hooks,
		ctxSource:     ctxSrc,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *subscriptionsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	// When handling v2 client requests, serve backwards-compatible error responses
	if version := getVersion(ctx); version == "v1" || version == "v2" {
		writeErrorPreV3(ctx, resp, err, s.hooks)
	} else {
		writeErrorPostV3(ctx, resp, err, s.hooks)
	}
}

// SubscriptionsPathPrefix is used for all URL paths on a twirp Subscriptions server.
// Requests are always: POST SubscriptionsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const SubscriptionsPathPrefix = "/twirp/code.justin.tv.revenue.subscriptions.Subscriptions/"

// SubscriptionsPathPrefixOld is used to handle requests from v2 Clients.
// If you are using an HTTP mux, please handle this routes as well to upgrade from v2 to v3.
const SubscriptionsPathPrefixOld = "/v2/code.justin.tv.revenue.subscriptions.Subscriptions/"

func (s *subscriptionsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := s.ctxSource(resp, req)
	ctx = setServerName(ctx, "Subscriptions")
	ctx = setVersionFromPath(ctx, req.URL.Path)
	ctx = context.WithValue(ctx, "__tw_response_writer", resp) // for SetHTTPResponseHeader
	ctx = s.hooks.RequestReceived(ctx)

	if req.Method != "POST" {
		msg := fmt1.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}

	switch req.URL.Path {
	case SubscriptionsPathPrefix + "FulfillSubscription", SubscriptionsPathPrefixOld + "FulfillSubscription", "/v1/Subscriptions/FulfillSubscription":
		s.serveFulfillSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateSubscription", SubscriptionsPathPrefixOld + "CreateSubscription", "/v1/Subscriptions/CreateSubscription":
		s.serveCreateSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelSubscription", SubscriptionsPathPrefixOld + "CancelSubscription", "/v1/Subscriptions/CancelSubscription":
		s.serveCancelSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateSubscription", SubscriptionsPathPrefixOld + "UpdateSubscription", "/v1/Subscriptions/UpdateSubscription":
		s.serveUpdateSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanSubscribe", SubscriptionsPathPrefixOld + "CanSubscribe", "/v1/Subscriptions/CanSubscribe":
		s.serveCanSubscribe(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "ListUserSubscriptions", SubscriptionsPathPrefixOld + "ListUserSubscriptions", "/v1/Subscriptions/ListUserSubscriptions":
		s.serveListUserSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData", SubscriptionsPathPrefixOld + "GetUserChannelSubscriptionWithPaymentsData", "/v1/Subscriptions/GetUserChannelSubscriptionWithPaymentsData":
		s.serveGetUserChannelSubscriptionWithPaymentsData(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserSubscriptions", SubscriptionsPathPrefixOld + "GetUserSubscriptions", "/v1/Subscriptions/GetUserSubscriptions":
		s.serveGetUserSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelSubscription", SubscriptionsPathPrefixOld + "GetUserChannelSubscription", "/v1/Subscriptions/GetUserChannelSubscription":
		s.serveGetUserChannelSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserProductSubscriptions", SubscriptionsPathPrefixOld + "GetUserProductSubscriptions", "/v1/Subscriptions/GetUserProductSubscriptions":
		s.serveGetUserProductSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetChannelSubscriptions", SubscriptionsPathPrefixOld + "GetChannelSubscriptions", "/v1/Subscriptions/GetChannelSubscriptions":
		s.serveGetChannelSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetFormerSubscribers", SubscriptionsPathPrefixOld + "GetFormerSubscribers", "/v1/Subscriptions/GetFormerSubscribers":
		s.serveGetFormerSubscribers(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "TakedownBadges", SubscriptionsPathPrefixOld + "TakedownBadges", "/v1/Subscriptions/TakedownBadges":
		s.serveTakedownBadges(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "TakedownAllBadges", SubscriptionsPathPrefixOld + "TakedownAllBadges", "/v1/Subscriptions/TakedownAllBadges":
		s.serveTakedownAllBadges(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SetScore", SubscriptionsPathPrefixOld + "SetScore", "/v1/Subscriptions/SetScore":
		s.serveSetScore(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CalculateSubscriberCount", SubscriptionsPathPrefixOld + "CalculateSubscriberCount", "/v1/Subscriptions/CalculateSubscriberCount":
		s.serveCalculateSubscriberCount(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateChatNotificationToken", SubscriptionsPathPrefixOld + "CreateChatNotificationToken", "/v1/Subscriptions/CreateChatNotificationToken":
		s.serveCreateChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UseChatNotificationToken", SubscriptionsPathPrefixOld + "UseChatNotificationToken", "/v1/Subscriptions/UseChatNotificationToken":
		s.serveUseChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelChatNotificationToken", SubscriptionsPathPrefixOld + "CancelChatNotificationToken", "/v1/Subscriptions/CancelChatNotificationToken":
		s.serveCancelChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken", SubscriptionsPathPrefixOld + "GetUserChannelChatNotificationToken", "/v1/Subscriptions/GetUserChannelChatNotificationToken":
		s.serveGetUserChannelChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserSettings", SubscriptionsPathPrefixOld + "GetUserSettings", "/v1/Subscriptions/GetUserSettings":
		s.serveGetUserSettings(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SetUserSettings", SubscriptionsPathPrefixOld + "SetUserSettings", "/v1/Subscriptions/SetUserSettings":
		s.serveSetUserSettings(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetExternalProductTemplateSKU", SubscriptionsPathPrefixOld + "GetExternalProductTemplateSKU", "/v1/Subscriptions/GetExternalProductTemplateSKU":
		s.serveGetExternalProductTemplateSKU(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU", SubscriptionsPathPrefixOld + "GetExternalProductPurchasableSKU", "/v1/Subscriptions/GetExternalProductPurchasableSKU":
		s.serveGetExternalProductPurchasableSKU(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPaidUpgrades", SubscriptionsPathPrefixOld + "GetPaidUpgrades", "/v1/Subscriptions/GetPaidUpgrades":
		s.serveGetPaidUpgrades(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreatePaidUpgrade", SubscriptionsPathPrefixOld + "CreatePaidUpgrade", "/v1/Subscriptions/CreatePaidUpgrade":
		s.serveCreatePaidUpgrade(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelPaidUpgrade", SubscriptionsPathPrefixOld + "CancelPaidUpgrade", "/v1/Subscriptions/CancelPaidUpgrade":
		s.serveCancelPaidUpgrade(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateGift", SubscriptionsPathPrefixOld + "CreateGift", "/v1/Subscriptions/CreateGift":
		s.serveCreateGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "InsertGift", SubscriptionsPathPrefixOld + "InsertGift", "/v1/Subscriptions/InsertGift":
		s.serveInsertGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelGift", SubscriptionsPathPrefixOld + "CancelGift", "/v1/Subscriptions/CancelGift":
		s.serveCancelGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetGifts", SubscriptionsPathPrefixOld + "GetGifts", "/v1/Subscriptions/GetGifts":
		s.serveGetGifts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanGift", SubscriptionsPathPrefixOld + "CanGift", "/v1/Subscriptions/CanGift":
		s.serveCanGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetGiftPromotion", SubscriptionsPathPrefixOld + "GetGiftPromotion", "/v1/Subscriptions/GetGiftPromotion":
		s.serveGetGiftPromotion(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanSenderGift", SubscriptionsPathPrefixOld + "CanSenderGift", "/v1/Subscriptions/CanSenderGift":
		s.serveCanSenderGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanGiftRecipient", SubscriptionsPathPrefixOld + "CanGiftRecipient", "/v1/Subscriptions/CanGiftRecipient":
		s.serveCanGiftRecipient(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "FulfillGifts", SubscriptionsPathPrefixOld + "FulfillGifts", "/v1/Subscriptions/FulfillGifts":
		s.serveFulfillGifts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SendMMGChatNotification", SubscriptionsPathPrefixOld + "SendMMGChatNotification", "/v1/Subscriptions/SendMMGChatNotification":
		s.serveSendMMGChatNotification(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SendMMGStartChatNotification", SubscriptionsPathPrefixOld + "SendMMGStartChatNotification", "/v1/Subscriptions/SendMMGStartChatNotification":
		s.serveSendMMGStartChatNotification(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetEmotePrefix", SubscriptionsPathPrefixOld + "GetEmotePrefix", "/v1/Subscriptions/GetEmotePrefix":
		s.serveGetEmotePrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateEmoticon", SubscriptionsPathPrefixOld + "CreateEmoticon", "/v1/Subscriptions/CreateEmoticon":
		s.serveCreateEmoticon(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs", SubscriptionsPathPrefixOld + "GetAllEmoticonsByProductIDs", "/v1/Subscriptions/GetAllEmoticonsByProductIDs":
		s.serveGetAllEmoticonsByProductIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPartnerStanding", SubscriptionsPathPrefixOld + "GetPartnerStanding", "/v1/Subscriptions/GetPartnerStanding":
		s.serveGetPartnerStanding(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetEmoticonPrefix", SubscriptionsPathPrefixOld + "GetEmoticonPrefix", "/v1/Subscriptions/GetEmoticonPrefix":
		s.serveGetEmoticonPrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SubmitEmoticonPrefix", SubscriptionsPathPrefixOld + "SubmitEmoticonPrefix", "/v1/Subscriptions/SubmitEmoticonPrefix":
		s.serveSubmitEmoticonPrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPendingEmoticonsByIDs", SubscriptionsPathPrefixOld + "GetPendingEmoticonsByIDs", "/v1/Subscriptions/GetPendingEmoticonsByIDs":
		s.serveGetPendingEmoticonsByIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPendingEmoticons", SubscriptionsPathPrefixOld + "GetPendingEmoticons", "/v1/Subscriptions/GetPendingEmoticons":
		s.serveGetPendingEmoticons(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "ReviewPendingEmoticons", SubscriptionsPathPrefixOld + "ReviewPendingEmoticons", "/v1/Subscriptions/ReviewPendingEmoticons":
		s.serveReviewPendingEmoticons(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetProductsByIDs", SubscriptionsPathPrefixOld + "GetProductsByIDs", "/v1/Subscriptions/GetProductsByIDs":
		s.serveGetProductsByIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetChannelProducts", SubscriptionsPathPrefixOld + "GetChannelProducts", "/v1/Subscriptions/GetChannelProducts":
		s.serveGetChannelProducts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateProduct", SubscriptionsPathPrefixOld + "UpdateProduct", "/v1/Subscriptions/UpdateProduct":
		s.serveUpdateProduct(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateChannelProducts", SubscriptionsPathPrefixOld + "UpdateChannelProducts", "/v1/Subscriptions/UpdateChannelProducts":
		s.serveUpdateChannelProducts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "EmailSubscribers", SubscriptionsPathPrefixOld + "EmailSubscribers", "/v1/Subscriptions/EmailSubscribers":
		s.serveEmailSubscribers(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "EmailGlobalEmote", SubscriptionsPathPrefixOld + "EmailGlobalEmote", "/v1/Subscriptions/EmailGlobalEmote":
		s.serveEmailGlobalEmote(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "EmailPendingPrefixApproval", SubscriptionsPathPrefixOld + "EmailPendingPrefixApproval", "/v1/Subscriptions/EmailPendingPrefixApproval":
		s.serveEmailPendingPrefixApproval(ctx, resp, req)
		return
	default:
		msg := fmt1.Sprintf("no handler for path %q", req.URL.Path)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}
}

func (s *subscriptionsServer) serveFulfillSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveFulfillSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveFulfillSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(FulfillSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillSubscriptionResponse and nil error while calling FulfillSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FulfillSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillSubscriptionResponse and nil error while calling FulfillSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSubscriptionResponse and nil error while calling CreateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSubscriptionResponse and nil error while calling CreateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelSubscriptionResponse and nil error while calling CancelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelSubscriptionResponse and nil error while calling CancelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriptionResponse and nil error while calling UpdateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriptionResponse and nil error while calling UpdateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSubscribe(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanSubscribeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanSubscribeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanSubscribeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSubscribe")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanSubscribeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSubscribeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSubscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSubscribeResponse and nil error while calling CanSubscribe. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSubscribeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSubscribe")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanSubscribeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSubscribeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSubscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSubscribeResponse and nil error while calling CanSubscribe. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveListUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveListUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ListUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserSubscriptionsResponse and nil error while calling ListUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListUserSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserSubscriptionsResponse and nil error while calling ListUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserProductSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProductSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserProductSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserProductSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetChannelSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetChannelSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetChannelSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsResponse and nil error while calling GetChannelSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsResponse and nil error while calling GetChannelSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetFormerSubscribers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetFormerSubscribersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFormerSubscribersProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetFormerSubscribersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetFormerSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetFormerSubscribersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFormerSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFormerSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFormerSubscribersResponse and nil error while calling GetFormerSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetFormerSubscribersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetFormerSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFormerSubscribersRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFormerSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFormerSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFormerSubscribersResponse and nil error while calling GetFormerSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownBadges(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveTakedownBadgesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTakedownBadgesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveTakedownBadgesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(TakedownBadgesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownBadgesResponse and nil error while calling TakedownBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownBadgesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(TakedownBadgesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownBadgesResponse and nil error while calling TakedownBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownAllBadges(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveTakedownAllBadgesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTakedownAllBadgesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveTakedownAllBadgesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownAllBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(TakedownAllBadgesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownAllBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownAllBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownAllBadgesResponse and nil error while calling TakedownAllBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownAllBadgesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownAllBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(TakedownAllBadgesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownAllBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownAllBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownAllBadgesResponse and nil error while calling TakedownAllBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetScore(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetScoreJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetScoreProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSetScoreJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetScore")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetScoreRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetScoreResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetScore(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetScoreResponse and nil error while calling SetScore. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetScoreProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetScore")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetScoreRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetScoreResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetScore(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetScoreResponse and nil error while calling SetScore. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCalculateSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCalculateSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCalculateSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCalculateSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CalculateSubscriberCount")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CalculateSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CalculateSubscriberCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CalculateSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CalculateSubscriberCountResponse and nil error while calling CalculateSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCalculateSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CalculateSubscriberCount")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CalculateSubscriberCountRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CalculateSubscriberCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CalculateSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CalculateSubscriberCountResponse and nil error while calling CalculateSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChatNotificationTokenResponse and nil error while calling CreateChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChatNotificationTokenResponse and nil error while calling CreateChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUseChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUseChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUseChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUseChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UseChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UseChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UseChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UseChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UseChatNotificationTokenResponse and nil error while calling UseChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUseChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UseChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UseChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UseChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UseChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UseChatNotificationTokenResponse and nil error while calling UseChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelChatNotificationTokenResponse and nil error while calling CancelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelChatNotificationTokenResponse and nil error while calling CancelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelChatNotificationTokenResponse and nil error while calling GetUserChannelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelChatNotificationTokenResponse and nil error while calling GetUserChannelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSettingsResponse and nil error while calling GetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserSettingsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSettingsResponse and nil error while calling GetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetUserSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetUserSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetUserSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSetUserSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetUserSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetUserSettingsResponse and nil error while calling SetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetUserSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetUserSettingsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetUserSettingsResponse and nil error while calling SetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKU(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetExternalProductTemplateSKUJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExternalProductTemplateSKUProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKUJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductTemplateSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetExternalProductTemplateSKURequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductTemplateSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductTemplateSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductTemplateSKUResponse and nil error while calling GetExternalProductTemplateSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKUProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductTemplateSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetExternalProductTemplateSKURequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductTemplateSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductTemplateSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductTemplateSKUResponse and nil error while calling GetExternalProductTemplateSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKU(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetExternalProductPurchasableSKUJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExternalProductPurchasableSKUProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKUJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductPurchasableSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetExternalProductPurchasableSKURequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductPurchasableSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductPurchasableSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductPurchasableSKUResponse and nil error while calling GetExternalProductPurchasableSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKUProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductPurchasableSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetExternalProductPurchasableSKURequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductPurchasableSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductPurchasableSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductPurchasableSKUResponse and nil error while calling GetExternalProductPurchasableSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgrades(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPaidUpgradesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPaidUpgradesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPaidUpgradesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgrades")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPaidUpgradesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgrades(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradesResponse and nil error while calling GetPaidUpgrades. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgradesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgrades")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPaidUpgradesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgrades(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradesResponse and nil error while calling GetPaidUpgrades. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreatePaidUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreatePaidUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreatePaidUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreatePaidUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreatePaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreatePaidUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreatePaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreatePaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePaidUpgradeResponse and nil error while calling CreatePaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreatePaidUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreatePaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreatePaidUpgradeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreatePaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreatePaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePaidUpgradeResponse and nil error while calling CreatePaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelPaidUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelPaidUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelPaidUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelPaidUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelPaidUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelPaidUpgradeResponse and nil error while calling CancelPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelPaidUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelPaidUpgradeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelPaidUpgradeResponse and nil error while calling CancelPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateGiftResponse and nil error while calling CreateGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateGiftResponse and nil error while calling CreateGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveInsertGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveInsertGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInsertGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveInsertGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "InsertGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(InsertGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InsertGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.InsertGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InsertGiftResponse and nil error while calling InsertGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveInsertGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "InsertGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InsertGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InsertGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.InsertGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InsertGiftResponse and nil error while calling InsertGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelGiftResponse and nil error while calling CancelGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelGiftResponse and nil error while calling CancelGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGifts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetGiftsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftsResponse and nil error while calling GetGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftsResponse and nil error while calling GetGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftResponse and nil error while calling CanGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftResponse and nil error while calling CanGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftPromotion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftPromotionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftPromotionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetGiftPromotionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftPromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftPromotionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftPromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftPromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftPromotionResponse and nil error while calling GetGiftPromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftPromotionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftPromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftPromotionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftPromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftPromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftPromotionResponse and nil error while calling GetGiftPromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSenderGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanSenderGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanSenderGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanSenderGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSenderGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanSenderGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSenderGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSenderGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSenderGiftResponse and nil error while calling CanSenderGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSenderGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSenderGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanSenderGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSenderGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSenderGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSenderGiftResponse and nil error while calling CanSenderGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGiftRecipient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanGiftRecipientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanGiftRecipientProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanGiftRecipientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGiftRecipient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanGiftRecipientRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftRecipientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGiftRecipient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftRecipientResponse and nil error while calling CanGiftRecipient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGiftRecipientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGiftRecipient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanGiftRecipientRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftRecipientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGiftRecipient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftRecipientResponse and nil error while calling CanGiftRecipient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillGifts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveFulfillGiftsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillGiftsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveFulfillGiftsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(FulfillGiftsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillGiftsResponse and nil error while calling FulfillGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillGiftsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FulfillGiftsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillGiftsResponse and nil error while calling FulfillGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGChatNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSendMMGChatNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendMMGChatNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSendMMGChatNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SendMMGChatNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGChatNotificationResponse and nil error while calling SendMMGChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGChatNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendMMGChatNotificationRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGChatNotificationResponse and nil error while calling SendMMGChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGStartChatNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSendMMGStartChatNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendMMGStartChatNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSendMMGStartChatNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGStartChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SendMMGStartChatNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGStartChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGStartChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGStartChatNotificationResponse and nil error while calling SendMMGStartChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGStartChatNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGStartChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendMMGStartChatNotificationRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGStartChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGStartChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGStartChatNotificationResponse and nil error while calling SendMMGStartChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmotePrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmotePrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmotePrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetEmotePrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmotePrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmotePrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmotePrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmotePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmotePrefixResponse and nil error while calling GetEmotePrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmotePrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmotePrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmotePrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmotePrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmotePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmotePrefixResponse and nil error while calling GetEmotePrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateEmoticon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateEmoticonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateEmoticonProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateEmoticonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateEmoticonRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateEmoticonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateEmoticonRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetAllEmoticonsByProductIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllEmoticonsByProductIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllEmoticonsByProductIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetAllEmoticonsByProductIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmoticonsByProductIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmoticonsByProductIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmoticonsByProductIDsResponse and nil error while calling GetAllEmoticonsByProductIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllEmoticonsByProductIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllEmoticonsByProductIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmoticonsByProductIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmoticonsByProductIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmoticonsByProductIDsResponse and nil error while calling GetAllEmoticonsByProductIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPartnerStanding(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPartnerStandingJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPartnerStandingProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPartnerStandingJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPartnerStanding")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPartnerStandingRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPartnerStandingResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPartnerStanding(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPartnerStandingResponse and nil error while calling GetPartnerStanding. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPartnerStandingProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPartnerStanding")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPartnerStandingRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPartnerStandingResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPartnerStanding(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPartnerStandingResponse and nil error while calling GetPartnerStanding. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmoticonPrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmoticonPrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoticonPrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetEmoticonPrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmoticonPrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonPrefixResponse and nil error while calling GetEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmoticonPrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmoticonPrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonPrefixResponse and nil error while calling GetEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSubmitEmoticonPrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSubmitEmoticonPrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SubmitEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SubmitEmoticonPrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubmitEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SubmitEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitEmoticonPrefixResponse and nil error while calling SubmitEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SubmitEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SubmitEmoticonPrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubmitEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SubmitEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitEmoticonPrefixResponse and nil error while calling SubmitEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticonsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPendingEmoticonsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPendingEmoticonsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPendingEmoticonsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticonsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPendingEmoticonsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticonsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsByIDsResponse and nil error while calling GetPendingEmoticonsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticonsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticonsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPendingEmoticonsByIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticonsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsByIDsResponse and nil error while calling GetPendingEmoticonsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPendingEmoticonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPendingEmoticonsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPendingEmoticonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPendingEmoticonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsResponse and nil error while calling GetPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPendingEmoticonsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsResponse and nil error while calling GetPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveReviewPendingEmoticons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveReviewPendingEmoticonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveReviewPendingEmoticonsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveReviewPendingEmoticonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ReviewPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ReviewPendingEmoticonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ReviewPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ReviewPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ReviewPendingEmoticonsResponse and nil error while calling ReviewPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveReviewPendingEmoticonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ReviewPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ReviewPendingEmoticonsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ReviewPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ReviewPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ReviewPendingEmoticonsResponse and nil error while calling ReviewPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetProductsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProductsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetProductsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetProductsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByIDsResponse and nil error while calling GetProductsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetProductsByIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByIDsResponse and nil error while calling GetProductsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetChannelProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetChannelProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetChannelProductsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelProductsResponse and nil error while calling GetChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelProductsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelProductsResponse and nil error while calling GetChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateProduct(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateProductJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateProductProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateProductJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateProduct")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateProductRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateProductResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateProduct(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateProductResponse and nil error while calling UpdateProduct. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateProductProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateProduct")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateProductRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateProductResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateProduct(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateProductResponse and nil error while calling UpdateProduct. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateChannelProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateChannelProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateChannelProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateChannelProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateChannelProductsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelProductsResponse and nil error while calling UpdateChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateChannelProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateChannelProductsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelProductsResponse and nil error while calling UpdateChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailSubscribers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveEmailSubscribersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEmailSubscribersProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveEmailSubscribersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(EmailSubscribersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailSubscribersResponse and nil error while calling EmailSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailSubscribersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EmailSubscribersRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailSubscribersResponse and nil error while calling EmailSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailGlobalEmote(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveEmailGlobalEmoteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEmailGlobalEmoteProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveEmailGlobalEmoteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailGlobalEmote")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(EmailGlobalEmoteRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailGlobalEmoteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailGlobalEmote(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailGlobalEmoteResponse and nil error while calling EmailGlobalEmote. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailGlobalEmoteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailGlobalEmote")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EmailGlobalEmoteRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailGlobalEmoteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailGlobalEmote(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailGlobalEmoteResponse and nil error while calling EmailGlobalEmote. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailPendingPrefixApproval(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveEmailPendingPrefixApprovalJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEmailPendingPrefixApprovalProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveEmailPendingPrefixApprovalJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailPendingPrefixApproval")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(EmailPendingPrefixApprovalRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailPendingPrefixApprovalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailPendingPrefixApproval(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailPendingPrefixApprovalResponse and nil error while calling EmailPendingPrefixApproval. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailPendingPrefixApprovalProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailPendingPrefixApproval")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EmailPendingPrefixApprovalRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailPendingPrefixApprovalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailPendingPrefixApproval(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailPendingPrefixApprovalResponse and nil error while calling EmailPendingPrefixApproval. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *subscriptionsServer) ProtocGenTwirpVersion() string {
	return "v4.7.0"
}

// =====
// Utils
// =====

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshaled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// A ContextSource establishes the base context for a Server.
type ContextSource func(http.ResponseWriter, *http.Request) context.Context

var RequestContextSource ContextSource = func(w http.ResponseWriter, req *http.Request) context.Context {
	return req.Context()
}

var BackgroundContextSource ContextSource = func(http.ResponseWriter, *http.Request) context.Context {
	return context.Background()
}

// done returns ctx.Err() if ctx.Done() indicates that the context done
func done(ctx context.Context) error {
	select {
	case <-ctx.Done():
		return ctx.Err()
	default:
		return nil
	}
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
// NOTE: not compatible with old v1/v2 clients (only returns v3+ errors)
func WriteError(resp http.ResponseWriter, err error) {
	writeErrorPostV3(nil, resp, err, nil) // does not trigger server hooks
}

// writeErrorPostV3 writes Twirp v3+ errors in the response.
func writeErrorPostV3(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	if hooks != nil {
		ctx = setStatusCode(ctx, statusCode)
		ctx = hooks.Error(ctx, twerr)
	}

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, err2 := resp.Write(respBody)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}

	if hooks != nil {
		_ = hooks.ResponseSent(ctx)
	}
}

// writeErrorPreV3 writes Twirp v1/v2 backwards-compatible errors in the response.
// This is to make it easy to upgrade to v3, a v3 server keeps serving v2-style errors to v2 clients.
func writeErrorPreV3(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Unknown 500 (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.NewError(twirp.Unknown, err.Error())
	}

	resp.Header().Set("Content-Type", "text/plain")

	// v2err.Retryable <= v3err.Meta("retryable")
	if twerr.Meta("retryable") != "" {
		resp.Header().Set("Twirp-Error-Retryable", "true")
	}

	// v2err.ErrorID <= v3err.Meta("v2_error_id") if present, otherwise v3err.Code()
	// or "unroutable" if generated from twirp router (BadRoute)
	var v2ErrorID string
	if twerr.Code() == twirp.BadRoute {
		v2ErrorID = "unroutable" // as was generated by previous router
	} else if twerr.Meta("v2_error_id") != "" {
		v2ErrorID = twerr.Meta("v2_error_id")
	} else {
		v2ErrorID = string(twerr.Code()) // the string-format of v3 codes match v2 error ids for the most part: i.e. "not_found", "internal", "unknown", "canceled", etc.
	}
	resp.Header().Set("Twirp-ErrorID", v2ErrorID)

	// v2err.StatusCode <= v3err.Meta("v2_status_code") if present, otherwise same as in v3
	statusCode, err := strconv.Atoi(twerr.Meta("v2_status_code"))
	if err != nil {
		statusCode = twirp.ServerHTTPStatusFromErrorCode(twerr.Code()) // v3 it's the same as v2 for the most part: i.e. "not_found" is 404
	}
	if hooks != nil {
		ctx = setStatusCode(ctx, statusCode)
		ctx = hooks.Error(ctx, twerr)
	}
	resp.WriteHeader(statusCode)

	msg := []byte(twerr.Msg())
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}
	_, err2 := resp.Write(msg)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}

	if hooks != nil {
		_ = hooks.ResponseSent(ctx)
	}
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// setMethodName, setServerName, and setStatusCode are functions to
// expose internal state through contexts. The context keys hardcoded
// in here are not to be used on their own. Twirp provides accessor
// functions which will retrieve these values out and give them the
// correct type for you.
func setMethodName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_method_name", name)
}
func setServerName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_service_name", name)
}
func setStatusCode(ctx context.Context, code int) context.Context {
	return context.WithValue(ctx, "__tw_status_code", strconv.Itoa(code))
}

type privateContextKey int

var versionKey = new(privateContextKey)

// setVersionFromPath adds "v1", "v2" or "v3" to the context depending on the path.
func setVersionFromPath(ctx context.Context, path string) context.Context {
	var version string
	if strings.HasPrefix(path, "/v1/") {
		version = "v1"
	} else if strings.HasPrefix(path, "/v2/") {
		version = "v2"
	} else {
		version = "v3"
	}
	return context.WithValue(ctx, versionKey, version)
}

// getVersion returns the version number ("v1", "v2", "v3") or empty string if unset.
func getVersion(ctx context.Context) string {
	v, _ := ctx.Value(versionKey).(string)
	return v
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := ctx.Value("__tw_request_header").(http.Header)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// closebody closes a response or request body and just logs
// any error encountered while closing, since errors are
// considered very unusual.
func closebody(body io.Closer) {
	if err := body.Close(); err != nil {
		log.Printf("error closing body: %q", err)
	}
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v4.7.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients dont't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt1.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt1.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtoRequest is common code to make a request to the remote twirp service.
func doProtoRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto1.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

var twirpFileDescriptor0 = []byte{
	// 5575 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x7d, 0xeb, 0x6f, 0x23, 0xc9,
	0x71, 0xf8, 0x0e, 0x49, 0x49, 0x64, 0x51, 0x0f, 0x6a, 0x76, 0x57, 0x4b, 0x71, 0x77, 0x4f, 0xbb,
	0xb3, 0x7b, 0xf6, 0x79, 0x7f, 0xb6, 0x0e, 0xa7, 0x7b, 0xbf, 0x76, 0x97, 0x92, 0x28, 0x1d, 0x6f,
	0x57, 0x14, 0x6f, 0x48, 0xdd, 0xee, 0x9d, 0xcf, 0xa0, 0x47, 0x9c, 0x96, 0x34, 0xd6, 0x70, 0x86,
	0x37, 0x33, 0x94, 0x56, 0xbf, 0x1c, 0x70, 0x01, 0x9c, 0xc0, 0x49, 0x9c, 0x04, 0x49, 0x7c, 0x80,
	0x0d, 0x03, 0x09, 0x8c, 0x04, 0x0e, 0x92, 0x4f, 0x06, 0x9c, 0x04, 0xb0, 0x91, 0x07, 0xe0, 0x0f,
	0x41, 0x82, 0x20, 0x40, 0x80, 0x00, 0xfe, 0x98, 0x04, 0xf9, 0x98, 0x7f, 0x22, 0x08, 0xfa, 0x31,
	0x4f, 0x0e, 0xc9, 0x1e, 0x52, 0xeb, 0x5c, 0xfc, 0x45, 0x62, 0x57, 0x77, 0x57, 0x57, 0x57, 0x57,
	0x57, 0x57, 0x57, 0x57, 0x91, 0xb0, 0xec, 0x9c, 0x6a, 0x56, 0xf7, 0x79, 0xbb, 0xb7, 0x6f, 0xb7,
	0x2d, 0xad, 0xeb, 0x68, 0xa6, 0x61, 0xaf, 0x76, 0x2d, 0xd3, 0x31, 0xc5, 0xdb, 0x6d, 0x53, 0x45,
	0xab, 0xdf, 0xe8, 0xd9, 0x8e, 0x66, 0xac, 0x3a, 0x27, 0xab, 0x16, 0x3a, 0x41, 0x46, 0x0f, 0xad,
	0x86, 0xda, 0x96, 0x56, 0x0e, 0x4d, 0xf3, 0x50, 0x47, 0xcf, 0x93, 0x3e, 0xfb, 0xbd, 0x83, 0xe7,
	0x1d, 0xad, 0x83, 0x6c, 0x47, 0xe9, 0x74, 0x29, 0x1a, 0xe9, 0x0f, 0x04, 0xb8, 0x59, 0xe9, 0x28,
	0x9a, 0x5e, 0x47, 0x86, 0xaa, 0x19, 0x87, 0x75, 0x0b, 0x1d, 0x68, 0x4f, 0xca, 0xdd, 0xae, 0x65,
	0x9e, 0x28, 0xba, 0x8c, 0x3e, 0xee, 0x21, 0xdb, 0x11, 0xaf, 0xc0, 0x4c, 0xcf, 0x46, 0x56, 0x4b,
	0x53, 0x8b, 0xc2, 0x0d, 0xe1, 0xb9, 0x9c, 0x3c, 0x8d, 0x8b, 0x55, 0x55, 0x5c, 0x82, 0xe9, 0x2e,
	0xe9, 0x51, 0x4c, 0x51, 0x38, 0x2d, 0x89, 0x97, 0x60, 0xca, 0x76, 0x14, 0x07, 0x15, 0xd3, 0x04,
	0x4c, 0x0b, 0xe2, 0x17, 0x60, 0x01, 0x75, 0x4c, 0x47, 0x6b, 0x9b, 0x46, 0xcb, 0x46, 0x0e, 0x46,
	0x97, 0x21, 0xf5, 0x73, 0x2e, 0xb8, 0x81, 0x9c, 0xaa, 0x2a, 0xdd, 0x06, 0x69, 0x18, 0x4d, 0x76,
	0xd7, 0x34, 0x6c, 0x24, 0xed, 0xc0, 0x15, 0xd2, 0x6a, 0x5b, 0x37, 0xf7, 0x15, 0xbd, 0xd2, 0x31,
	0x1d, 0x34, 0x92, 0xde, 0x65, 0xc8, 0xe2, 0xa1, 0x10, 0xae, 0xa1, 0x14, 0xcf, 0x90, 0x72, 0x55,
	0x95, 0x4a, 0x50, 0xec, 0x47, 0xc7, 0x86, 0xda, 0x67, 0x43, 0x35, 0x28, 0x73, 0xf7, 0x91, 0x65,
	0xbb, 0x43, 0x5d, 0x07, 0x68, 0x1f, 0x29, 0x86, 0x81, 0x74, 0x7f, 0xb4, 0x1c, 0x83, 0x54, 0x55,
	0xcc, 0x08, 0x47, 0x73, 0x74, 0xc4, 0x46, 0xa3, 0x05, 0x51, 0x84, 0x8c, 0x83, 0x9e, 0x38, 0x8c,
	0x3b, 0xe4, 0xb3, 0x37, 0x7e, 0x68, 0x0c, 0x36, 0xfe, 0x57, 0x61, 0xae, 0xc2, 0x38, 0xf4, 0x10,
	0x9d, 0x20, 0x5d, 0xbc, 0x05, 0x73, 0x1d, 0xcd, 0xd0, 0x3a, 0xbd, 0x4e, 0xcb, 0x6e, 0x9b, 0x16,
	0x22, 0x03, 0xa7, 0xe5, 0x59, 0x06, 0x6c, 0x60, 0x98, 0xf8, 0x2c, 0xcc, 0x7b, 0xec, 0xd6, 0xb5,
	0x8e, 0xe6, 0x10, 0x22, 0xd2, 0x3e, 0xb7, 0x1f, 0x62, 0xa0, 0xf4, 0x55, 0x58, 0x68, 0x20, 0x87,
	0x74, 0xe1, 0x9c, 0xd4, 0x97, 0xa0, 0x60, 0x7b, 0x54, 0x32, 0x02, 0x28, 0xea, 0x05, 0x1f, 0x4e,
	0x10, 0x4a, 0x3f, 0x11, 0xa0, 0xe0, 0x63, 0xa7, 0xd3, 0x89, 0xed, 0x2f, 0xc4, 0xf6, 0xe7, 0x9c,
	0x83, 0x28, 0x03, 0x18, 0xe8, 0x89, 0xd3, 0xd2, 0x31, 0x77, 0x08, 0x5b, 0xf3, 0x6b, 0x2f, 0xae,
	0xf2, 0x6c, 0x91, 0xd5, 0x10, 0x63, 0xe5, 0x1c, 0x46, 0x43, 0x3e, 0x4a, 0x3f, 0xcd, 0xc0, 0x62,
	0x23, 0xd0, 0x74, 0xc3, 0xec, 0x19, 0x0e, 0x91, 0xec, 0x00, 0xc1, 0xb4, 0x10, 0x19, 0x3f, 0x75,
	0x1e, 0xe3, 0x8b, 0x0e, 0x2c, 0xb4, 0xf1, 0x90, 0xad, 0x7d, 0x0b, 0x29, 0xc7, 0xaa, 0x79, 0x6a,
	0x14, 0xd3, 0x37, 0xd2, 0xcf, 0xe5, 0xd7, 0x1e, 0xf0, 0x21, 0xee, 0xa3, 0x7d, 0x95, 0xfc, 0x5d,
	0x77, 0xb1, 0x55, 0x0c, 0xc7, 0x3a, 0x93, 0xe7, 0xdb, 0x21, 0x20, 0x1e, 0x95, 0x4c, 0x29, 0x30,
	0x6a, 0x66, 0xb2, 0x51, 0xc9, 0x42, 0x46, 0x47, 0xb5, 0x43, 0x40, 0xf1, 0x26, 0xcc, 0x3a, 0x5a,
	0xfb, 0x18, 0x39, 0x2d, 0x42, 0x4e, 0x71, 0x8a, 0x30, 0x37, 0x4f, 0x61, 0x94, 0xf1, 0xfd, 0x92,
	0x30, 0x1d, 0x23, 0x09, 0xa5, 0x32, 0x5c, 0x8c, 0x99, 0xa6, 0x58, 0x80, 0xf4, 0x31, 0x3a, 0x63,
	0xa2, 0x8c, 0x3f, 0xe2, 0x85, 0x3c, 0x51, 0xf4, 0x9e, 0x2b, 0xb9, 0xb4, 0xf0, 0x46, 0xea, 0x35,
	0x01, 0xa3, 0x88, 0xa1, 0x39, 0x09, 0x0a, 0xe9, 0x3e, 0xac, 0x6c, 0x28, 0x7a, 0xbb, 0xa7, 0x2b,
	0x0e, 0xf2, 0x37, 0x34, 0x21, 0x8c, 0x6f, 0x8f, 0x49, 0xff, 0x1f, 0x6e, 0x0c, 0xc6, 0xc0, 0xf6,
	0xd1, 0xfb, 0x00, 0x98, 0xf9, 0x8c, 0x67, 0x02, 0x91, 0xba, 0x57, 0xc7, 0x5c, 0x26, 0x39, 0x87,
	0x1b, 0x90, 0x8f, 0xd2, 0x0b, 0xb0, 0xb4, 0x8d, 0x9c, 0x3d, 0x1b, 0x59, 0x0d, 0xe4, 0x38, 0x9a,
	0x71, 0x68, 0x8f, 0x52, 0xac, 0xd2, 0xb7, 0x04, 0xb8, 0xd2, 0xd7, 0x87, 0x91, 0xb9, 0x09, 0x2b,
	0x87, 0xda, 0x81, 0x63, 0xb7, 0x34, 0xa3, 0x75, 0x60, 0xea, 0xba, 0x79, 0x8a, 0xd4, 0x16, 0x9b,
	0xa9, 0xdd, 0x32, 0x0d, 0x9d, 0x32, 0x35, 0x2b, 0x5f, 0x25, 0xcd, 0xaa, 0xc6, 0x16, 0x6b, 0xb4,
	0xc1, 0xda, 0xec, 0x1a, 0xfa, 0x19, 0x3e, 0x3c, 0x8e, 0x34, 0x15, 0xb5, 0x70, 0x1b, 0x36, 0xe3,
	0x14, 0xe9, 0x35, 0x87, 0xc1, 0xdb, 0xda, 0x01, 0x95, 0x13, 0xe9, 0xdf, 0x52, 0xb0, 0xd4, 0x48,
	0x46, 0x3d, 0x0f, 0x85, 0xa9, 0xd1, 0x14, 0x7e, 0x4b, 0x80, 0x2f, 0x5a, 0xa8, 0x8d, 0xb4, 0x13,
	0x4a, 0xe5, 0x30, 0x74, 0x54, 0x45, 0xad, 0xf1, 0x2d, 0xd6, 0x2e, 0xf9, 0xaf, 0xe8, 0xeb, 0xa6,
	0xa9, 0xcb, 0x12, 0x1b, 0x62, 0x7b, 0x08, 0x25, 0x1f, 0xf6, 0xf3, 0x2a, 0x33, 0xf6, 0x80, 0x11,
	0xfe, 0xe2, 0x95, 0x6e, 0x7c, 0x2e, 0x56, 0xfa, 0x36, 0xcc, 0x06, 0x09, 0xf5, 0xb7, 0x23, 0x1d,
	0x83, 0x16, 0xa4, 0xbf, 0x48, 0xc1, 0x6c, 0x50, 0xda, 0xc5, 0x79, 0x48, 0x79, 0x02, 0x90, 0xd2,
	0xd4, 0xc8, 0x46, 0x4c, 0x45, 0x0f, 0xbb, 0x65, 0xc8, 0x9a, 0xa7, 0x06, 0x95, 0x1a, 0x7a, 0x5e,
	0xcf, 0x90, 0x72, 0x95, 0xf4, 0xec, 0x5a, 0xa6, 0xda, 0x6b, 0x07, 0x4c, 0x99, 0x1c, 0x83, 0x54,
	0x55, 0xf1, 0x2a, 0xe4, 0x4c, 0x4b, 0x3b, 0xd4, 0x0c, 0x5c, 0x3b, 0x45, 0x6a, 0xb3, 0x14, 0x50,
	0x55, 0xc5, 0x7b, 0x30, 0xb7, 0x8f, 0x0c, 0x74, 0xa0, 0x39, 0x2d, 0xdb, 0x51, 0x2c, 0xaa, 0xcd,
	0xf2, 0x6b, 0xa5, 0x55, 0x6a, 0xb1, 0xad, 0xba, 0x16, 0xdb, 0x6a, 0xd3, 0xb5, 0xd8, 0xe4, 0x59,
	0xd6, 0xa1, 0x81, 0xdb, 0x8b, 0x6f, 0x42, 0xde, 0x45, 0x80, 0x0c, 0xb5, 0x38, 0x33, 0xb2, 0x3b,
	0xb0, 0xe6, 0x15, 0x43, 0x15, 0x57, 0x20, 0xaf, 0xb4, 0xdb, 0xc8, 0xb6, 0x5b, 0x87, 0x3d, 0x4d,
	0x2d, 0x66, 0x09, 0x71, 0x40, 0x41, 0xdb, 0x3d, 0x4d, 0x95, 0xca, 0x50, 0xd8, 0x32, 0xad, 0x0e,
	0xb2, 0x7c, 0xdd, 0x93, 0x90, 0x71, 0xd2, 0xdf, 0xa6, 0xa0, 0xb4, 0xd5, 0xd3, 0x0f, 0x34, 0x5d,
	0x0f, 0xf2, 0xdf, 0xdd, 0x8c, 0x41, 0xbe, 0x0a, 0xc3, 0xf8, 0x9a, 0x1a, 0xca, 0xd7, 0xf4, 0x28,
	0xbe, 0x66, 0x26, 0xe3, 0xeb, 0x54, 0x22, 0xbe, 0xbe, 0x0b, 0xd9, 0xae, 0xae, 0x38, 0x07, 0xa6,
	0xd5, 0x21, 0x0b, 0x3a, 0xbf, 0xb6, 0xca, 0xb7, 0xe3, 0xea, 0xac, 0x97, 0xec, 0xf5, 0x97, 0x7a,
	0x70, 0x35, 0x96, 0x7d, 0x9e, 0xf2, 0x9f, 0x0d, 0xa2, 0x60, 0xea, 0x7f, 0x2d, 0xb9, 0xfa, 0x97,
	0x43, 0x78, 0xa4, 0x9f, 0xa7, 0x60, 0x79, 0xc3, 0x42, 0xfe, 0xb1, 0xf3, 0xcb, 0xbf, 0x6a, 0x6d,
	0x58, 0x0c, 0xb2, 0xa0, 0xe5, 0x9c, 0x75, 0x11, 0x5b, 0xbe, 0x57, 0x92, 0xf3, 0xb3, 0x79, 0xd6,
	0x45, 0x72, 0xc1, 0x8e, 0x40, 0x24, 0x07, 0x4a, 0x71, 0x6c, 0x7d, 0xca, 0xab, 0x69, 0xc1, 0xf2,
	0x86, 0x62, 0xb4, 0xd1, 0x2f, 0x70, 0x0b, 0x4a, 0xd7, 0xa0, 0x14, 0x37, 0x26, 0xbb, 0xcb, 0xfc,
	0x8d, 0x00, 0xcb, 0x7b, 0x5d, 0x75, 0x80, 0x7c, 0x15, 0x7c, 0x1d, 0xf3, 0xce, 0x05, 0xa2, 0x65,
	0xee, 0x53, 0xb3, 0x8b, 0xda, 0xd4, 0x5f, 0xe6, 0x66, 0xc8, 0x03, 0x74, 0xf6, 0xce, 0x05, 0x6a,
	0xa6, 0x45, 0x64, 0x23, 0x9d, 0x44, 0x36, 0xd6, 0xe7, 0xc3, 0x0b, 0x83, 0x27, 0x17, 0x47, 0x3d,
	0x9b, 0xdc, 0xaf, 0xa6, 0xe0, 0xe2, 0x86, 0x62, 0x78, 0x4a, 0x73, 0x72, 0x4e, 0x07, 0x35, 0x4a,
	0x7a, 0x32, 0x8d, 0x12, 0x2f, 0xe7, 0x99, 0x73, 0x96, 0xf3, 0x37, 0xe1, 0x52, 0x98, 0x03, 0x4c,
	0xc2, 0x6f, 0xc1, 0x5c, 0x5b, 0x31, 0x5a, 0xde, 0x05, 0x8f, 0x9d, 0xd2, 0xb3, 0xed, 0x40, 0x63,
	0xe9, 0x67, 0x29, 0xb8, 0xf6, 0x50, 0xb3, 0xa9, 0x75, 0x11, 0x1c, 0x99, 0x83, 0x91, 0x97, 0x60,
	0x2a, 0x78, 0x43, 0xa4, 0x05, 0x71, 0x09, 0xa6, 0xdb, 0x3d, 0xcb, 0x36, 0x2d, 0x26, 0xa6, 0xac,
	0x14, 0xe2, 0x6b, 0x66, 0x42, 0xbe, 0x2a, 0x30, 0x7d, 0xa0, 0xe9, 0x0e, 0xb2, 0x88, 0xde, 0x99,
	0x5f, 0xab, 0xf2, 0x61, 0x1a, 0x36, 0xd1, 0xd5, 0x2d, 0x82, 0x50, 0x66, 0x88, 0xa5, 0x2f, 0xc1,
	0x34, 0x85, 0x88, 0x33, 0x90, 0x2e, 0x3f, 0x7c, 0x58, 0xb8, 0x20, 0xce, 0x42, 0xb6, 0xfe, 0xb0,
	0xdc, 0xdc, 0xda, 0x95, 0x77, 0x0a, 0x82, 0x98, 0x85, 0xcc, 0x76, 0x75, 0xab, 0x59, 0x48, 0x49,
	0x1d, 0x78, 0x81, 0x59, 0xe2, 0xcc, 0xaa, 0x0a, 0xe2, 0x7f, 0xa4, 0x39, 0x47, 0x75, 0xe5, 0xac,
	0x83, 0x0c, 0xc7, 0xde, 0x54, 0x1c, 0x85, 0x4f, 0x40, 0x87, 0x1d, 0xf3, 0x5f, 0x83, 0x9b, 0x83,
	0x87, 0x9b, 0x1c, 0xfd, 0xf7, 0x32, 0x50, 0x88, 0x32, 0x49, 0xfc, 0x22, 0x2c, 0x84, 0x04, 0xd9,
	0xc3, 0x3a, 0x1f, 0x04, 0x47, 0x8c, 0xb7, 0xd4, 0xb0, 0x7d, 0x97, 0x1e, 0xaa, 0xe1, 0x32, 0xa3,
	0x8e, 0xab, 0xa9, 0xc9, 0x8e, 0xab, 0xe9, 0xb1, 0x8d, 0x8c, 0x99, 0x09, 0x45, 0xf7, 0x55, 0xc8,
	0x59, 0xc8, 0x40, 0xa7, 0x76, 0x4b, 0x71, 0x88, 0x19, 0x38, 0x9c, 0x8c, 0x2c, 0x6d, 0x5c, 0x76,
	0xc4, 0xe7, 0xa0, 0x80, 0x9e, 0x38, 0xad, 0x6e, 0xcf, 0x6a, 0x1f, 0x29, 0x36, 0x6a, 0xd9, 0xc7,
	0xbd, 0x62, 0x8e, 0xae, 0x01, 0x7a, 0xe2, 0xd4, 0x19, 0xb8, 0x71, 0xdc, 0xc3, 0x6b, 0xa0, 0xd9,
	0xad, 0xae, 0xa5, 0x75, 0x50, 0x11, 0xc8, 0x9e, 0x9f, 0xd1, 0xec, 0x3a, 0x2e, 0xe2, 0x0b, 0x99,
	0x66, 0x13, 0x3b, 0xbf, 0x98, 0x27, 0x35, 0xd3, 0x9a, 0x8d, 0xed, 0x7b, 0xac, 0x2c, 0x34, 0xbb,
	0x65, 0xa1, 0x83, 0x9e, 0xa1, 0x2a, 0xfb, 0x3a, 0x2a, 0xce, 0x52, 0x65, 0xa1, 0xd9, 0xb2, 0x07,
	0x93, 0x7e, 0x5b, 0x80, 0xa5, 0xa8, 0x68, 0xc8, 0xc8, 0xee, 0xe9, 0x8e, 0xf8, 0x61, 0xec, 0x71,
	0xca, 0xa9, 0xe4, 0xfa, 0x70, 0x86, 0x70, 0x05, 0x34, 0x4a, 0x2a, 0xa8, 0x51, 0xa4, 0x7f, 0x10,
	0xe0, 0xfa, 0x80, 0x2d, 0xed, 0x1d, 0xf2, 0x33, 0x16, 0xa1, 0xcf, 0x2e, 0x0a, 0xc4, 0xa7, 0xf2,
	0xd6, 0x98, 0x04, 0x11, 0x24, 0xb2, 0x8b, 0x4c, 0xbc, 0x03, 0x8b, 0x47, 0x0a, 0x66, 0x31, 0x3a,
	0xd1, 0xcc, 0x9e, 0xdd, 0xea, 0x2a, 0x87, 0x88, 0x5d, 0x99, 0x16, 0x8e, 0x14, 0xbb, 0xce, 0xe0,
	0x75, 0xe5, 0x10, 0x89, 0x12, 0xcc, 0xe1, 0xb6, 0xc4, 0x5b, 0x45, 0xda, 0xa5, 0x49, 0xbb, 0xfc,
	0x91, 0x62, 0xd7, 0xf0, 0xc2, 0x29, 0x87, 0x48, 0xfa, 0x3d, 0x01, 0xd6, 0x92, 0xa8, 0x10, 0x36,
	0xbd, 0xa7, 0xc8, 0x74, 0xe9, 0x13, 0x90, 0x86, 0x69, 0x99, 0xa7, 0x6c, 0x45, 0x7d, 0xdd, 0x1b,
	0xbd, 0x4e, 0x15, 0x44, 0xd2, 0xb3, 0x69, 0x05, 0xf2, 0xbe, 0xb2, 0xb1, 0x8b, 0xa9, 0x1b, 0x69,
	0x7c, 0xdf, 0xf2, 0xb4, 0x8d, 0x2d, 0x7d, 0x0a, 0xb7, 0x86, 0x8e, 0xc0, 0x26, 0xf8, 0x18, 0xe6,
	0x42, 0x44, 0x33, 0x39, 0x1a, 0x67, 0x86, 0x61, 0x44, 0xd2, 0x6b, 0x70, 0xd5, 0xf5, 0xdf, 0x24,
	0x9b, 0x9b, 0xf4, 0x04, 0xae, 0xc5, 0xf7, 0x7c, 0xea, 0x34, 0x77, 0xe0, 0x99, 0x6d, 0xe4, 0xc4,
	0x08, 0x44, 0x02, 0xef, 0xbc, 0x6f, 0x32, 0x4c, 0x05, 0x4c, 0x06, 0xf3, 0xe0, 0xc0, 0x46, 0xd4,
	0x3f, 0x3f, 0x25, 0xb3, 0x92, 0xf4, 0x2b, 0xb0, 0x32, 0x70, 0xb8, 0xa7, 0x3e, 0xd7, 0x6f, 0x90,
	0xf5, 0x89, 0xde, 0xc9, 0x9f, 0xce, 0x44, 0xff, 0x4b, 0x20, 0x4b, 0x1a, 0x33, 0x18, 0x9b, 0xe6,
	0x0a, 0xe4, 0x1d, 0xd3, 0x51, 0xf4, 0x80, 0xe7, 0x71, 0x4a, 0x06, 0x02, 0xa2, 0xce, 0xda, 0xc7,
	0x90, 0xf7, 0x3d, 0xf9, 0x54, 0xde, 0xb9, 0x35, 0x41, 0x74, 0x58, 0x39, 0x88, 0x2a, 0x5e, 0xd7,
	0xa5, 0x39, 0x75, 0x5d, 0xa6, 0x5f, 0xd7, 0x1d, 0xc3, 0xe5, 0xa6, 0x72, 0x8c, 0x54, 0xf3, 0xd4,
	0x58, 0x57, 0xd4, 0x43, 0xc4, 0xcb, 0xd1, 0xab, 0x90, 0xdb, 0xc7, 0xed, 0x03, 0xfb, 0x39, 0x4b,
	0x00, 0x55, 0xd5, 0xc6, 0x8c, 0xb5, 0x90, 0x62, 0x9b, 0x86, 0x6b, 0x74, 0xd2, 0x92, 0x74, 0x0f,
	0x96, 0xa2, 0x83, 0x31, 0x8e, 0x3e, 0x0b, 0xf3, 0xa4, 0x37, 0x3e, 0xf4, 0x3a, 0xe6, 0x09, 0x52,
	0x89, 0xe4, 0xe4, 0xe4, 0xb9, 0x7d, 0xd6, 0x8e, 0x00, 0xa5, 0xf7, 0xa0, 0xe8, 0x22, 0x28, 0xeb,
	0x7a, 0x22, 0x82, 0x7d, 0x9a, 0x52, 0x21, 0x9a, 0xd6, 0x61, 0x39, 0x06, 0x65, 0x32, 0xb2, 0xfe,
	0x52, 0x80, 0xdb, 0xdb, 0xc8, 0xa9, 0x3c, 0x71, 0x90, 0x65, 0x28, 0x3a, 0x53, 0x61, 0x4d, 0xd4,
	0xe9, 0x12, 0xf7, 0xf5, 0x83, 0xbd, 0x00, 0x8d, 0x01, 0xa3, 0x4b, 0x18, 0x76, 0xd9, 0x49, 0x4d,
	0x68, 0xd9, 0xdc, 0x84, 0x59, 0x22, 0x9d, 0xd6, 0x59, 0x0b, 0xa3, 0x60, 0x2b, 0x91, 0x67, 0xb0,
	0x0d, 0x53, 0x45, 0xd2, 0x5d, 0x78, 0x76, 0x04, 0xd5, 0x8c, 0x0d, 0x97, 0x61, 0xda, 0x3e, 0xee,
	0xf9, 0x24, 0x4f, 0xd9, 0xc7, 0xbd, 0xaa, 0x2a, 0xfd, 0xab, 0x00, 0x5f, 0xec, 0x47, 0xc0, 0x6c,
	0x1f, 0x6c, 0xa2, 0x04, 0x66, 0xfe, 0xf9, 0xb8, 0x01, 0x46, 0x99, 0x92, 0xe9, 0x67, 0x4a, 0x19,
	0x9e, 0x1b, 0x3d, 0xa7, 0xe1, 0x7c, 0xa9, 0xc3, 0x34, 0xbd, 0x81, 0x8b, 0x45, 0x98, 0x61, 0x13,
	0x71, 0x27, 0xcd, 0x8a, 0x58, 0x23, 0x91, 0xf9, 0xbb, 0x0f, 0xa3, 0xa4, 0x40, 0x34, 0x12, 0x31,
	0xb2, 0xdd, 0x8d, 0x43, 0x4b, 0xd2, 0x3f, 0xa7, 0x20, 0x5f, 0x57, 0x34, 0x75, 0xaf, 0x7b, 0x68,
	0x29, 0x2a, 0x12, 0xb7, 0x21, 0xbb, 0x8f, 0xad, 0x4e, 0xf7, 0x41, 0x26, 0xa1, 0x67, 0x40, 0x9e,
	0xc1, 0xbd, 0x31, 0x81, 0x3b, 0x90, 0xef, 0x51, 0x9c, 0xad, 0x31, 0xbd, 0x0c, 0x32, 0x30, 0x04,
	0x18, 0xdd, 0xb3, 0x30, 0x8f, 0x0c, 0xf2, 0xc6, 0x8b, 0xcd, 0x23, 0xff, 0x62, 0x31, 0x17, 0x80,
	0x56, 0x55, 0xf1, 0x75, 0x00, 0x72, 0x6f, 0x68, 0xa9, 0x8a, 0x83, 0x38, 0x7c, 0x5d, 0x39, 0xd2,
	0x7a, 0x53, 0x71, 0xe8, 0xd3, 0xb1, 0xc6, 0x6e, 0x9a, 0x39, 0x99, 0x7c, 0xc6, 0xbc, 0xec, 0x5a,
	0x5a, 0x9b, 0xfa, 0xac, 0xa6, 0x64, 0x5a, 0xc0, 0x12, 0x47, 0x3e, 0x60, 0x2a, 0x66, 0x5c, 0xe6,
	0x6b, 0x6d, 0x54, 0x55, 0xa5, 0x0f, 0xc9, 0x03, 0x4f, 0x80, 0xa1, 0x9e, 0x12, 0xb9, 0x0f, 0x99,
	0x63, 0x74, 0xe6, 0x9e, 0x5b, 0xc9, 0x18, 0x41, 0x7a, 0x4a, 0x1f, 0x93, 0x87, 0xa0, 0x30, 0x6e,
	0xcf, 0x3c, 0x9b, 0xeb, 0x2a, 0x9a, 0xda, 0x62, 0x0c, 0x73, 0x47, 0x79, 0x81, 0x53, 0x9c, 0x7d,
	0x94, 0xf2, 0x6c, 0x37, 0x80, 0x5f, 0xfa, 0xb1, 0x00, 0x45, 0xea, 0x5b, 0x0b, 0xb6, 0x61, 0x33,
	0xfa, 0x9c, 0x8a, 0x8a, 0xf4, 0xb1, 0xeb, 0x66, 0x0d, 0xd1, 0xcc, 0x38, 0xd5, 0x84, 0xd9, 0x20,
	0xa7, 0x18, 0xe1, 0x63, 0x30, 0x2a, 0x1f, 0x60, 0x14, 0xe5, 0x13, 0xf1, 0xcc, 0xfd, 0x1f, 0xe2,
	0xd3, 0x55, 0xd7, 0x83, 0x19, 0xc3, 0x27, 0xe9, 0xe7, 0x29, 0x90, 0x28, 0x17, 0x37, 0x8e, 0x14,
	0xa7, 0x66, 0x3a, 0xda, 0x81, 0xd6, 0x56, 0x88, 0x2f, 0xca, 0x3c, 0x46, 0xe7, 0xe0, 0xe8, 0x7c,
	0x1b, 0x66, 0x95, 0x13, 0x45, 0xd3, 0xb1, 0xe6, 0xc3, 0x57, 0xe4, 0xd1, 0xce, 0xc3, 0xbc, 0xd7,
	0xbe, 0xec, 0x88, 0x3b, 0x81, 0xbb, 0xef, 0xf8, 0x2f, 0x70, 0xde, 0x7d, 0xf9, 0x10, 0x2e, 0x1a,
	0xe8, 0xb4, 0xc5, 0x9e, 0xca, 0x35, 0xc3, 0x41, 0xd6, 0x89, 0xa2, 0x33, 0xef, 0x03, 0xe7, 0xcb,
	0x6f, 0x0d, 0x9d, 0x36, 0x49, 0xff, 0x2a, 0xeb, 0x2e, 0x2f, 0x1a, 0x51, 0x90, 0x74, 0x0f, 0x6e,
	0x0d, 0x65, 0x2b, 0x13, 0xd3, 0x22, 0xcc, 0x74, 0x90, 0x6d, 0x63, 0xd3, 0x8a, 0xb1, 0x95, 0x15,
	0xa5, 0xdf, 0x11, 0x60, 0xb1, 0x6f, 0x24, 0xc2, 0x4d, 0xfa, 0xec, 0x44, 0xdd, 0x26, 0x02, 0x07,
	0x37, 0x49, 0x7b, 0xea, 0x35, 0x79, 0x1d, 0xd8, 0x13, 0x15, 0x71, 0x9a, 0xa4, 0x46, 0xab, 0x4d,
	0xda, 0xba, 0x62, 0xa8, 0xd2, 0x6f, 0x0a, 0xb0, 0xb2, 0x67, 0x8f, 0x94, 0x12, 0x07, 0x97, 0x03,
	0x52, 0x42, 0xca, 0x55, 0x55, 0xbc, 0x0d, 0xf3, 0x4a, 0xcf, 0x39, 0x42, 0x6a, 0xcb, 0x7d, 0x40,
	0xa6, 0x92, 0x32, 0x4b, 0xa1, 0x7b, 0xf4, 0x19, 0xf9, 0x59, 0x98, 0x6f, 0xf7, 0x6c, 0xc7, 0xec,
	0xb4, 0x5c, 0xae, 0x30, 0xed, 0x4f, 0xa1, 0x3b, 0x8c, 0x37, 0x6f, 0xc1, 0x8d, 0xc1, 0xa4, 0x8c,
	0xe4, 0xec, 0x0e, 0x48, 0x74, 0x3f, 0x0c, 0x9d, 0x0b, 0xaf, 0x87, 0x8c, 0xac, 0xf4, 0x30, 0x74,
	0x23, 0xe9, 0x51, 0xe1, 0x4e, 0xf8, 0x66, 0x3e, 0x94, 0xae, 0x81, 0x4f, 0xf0, 0x23, 0xdc, 0x80,
	0x7f, 0x2c, 0xc0, 0xff, 0xe3, 0x1a, 0x86, 0xd1, 0x6b, 0xc3, 0x95, 0xf6, 0x91, 0xe2, 0xb4, 0x8c,
	0x40, 0x8b, 0x16, 0x59, 0x4d, 0x26, 0x74, 0x6f, 0xf2, 0xed, 0x96, 0xf8, 0x51, 0x2e, 0xb7, 0xe3,
	0xc0, 0xf8, 0x2e, 0x11, 0xdb, 0xbe, 0xef, 0xe5, 0x34, 0xc0, 0xcd, 0x54, 0x88, 0x9b, 0xf8, 0x28,
	0xef, 0x98, 0x86, 0x73, 0xe4, 0x06, 0xce, 0x91, 0x02, 0x3e, 0xf4, 0x8f, 0x35, 0xc3, 0xf5, 0x43,
	0x92, 0xcf, 0xd2, 0x5f, 0xa7, 0x20, 0x43, 0x7c, 0x65, 0x4b, 0x30, 0x6d, 0x23, 0x43, 0x45, 0x96,
	0xcb, 0x51, 0x5a, 0x12, 0xaf, 0x41, 0xce, 0x42, 0x6d, 0xad, 0xab, 0x21, 0xf6, 0x80, 0x9e, 0x93,
	0x7d, 0x40, 0xd0, 0x32, 0x4b, 0x87, 0x2d, 0x33, 0xdf, 0x06, 0xcb, 0x04, 0x6d, 0x30, 0xb1, 0xe2,
	0xc6, 0xf4, 0x51, 0x27, 0xf7, 0xf3, 0x7c, 0x0c, 0xc4, 0x24, 0x36, 0x70, 0x37, 0x37, 0x08, 0xf0,
	0x55, 0xc8, 0x91, 0x87, 0x7d, 0x62, 0xfa, 0x8c, 0x76, 0x7c, 0x66, 0x71, 0x63, 0x62, 0xf9, 0x3c,
	0x60, 0x1d, 0xc9, 0xab, 0x45, 0x22, 0xbf, 0x27, 0xa6, 0x81, 0xbc, 0x56, 0x10, 0x64, 0xe4, 0x95,
	0xe2, 0x03, 0x98, 0xc1, 0xd0, 0xe1, 0x36, 0xaa, 0xcf, 0x89, 0x54, 0x88, 0x13, 0x21, 0xce, 0xa6,
	0x23, 0x9c, 0x95, 0xfe, 0x51, 0x80, 0x45, 0xaa, 0x3c, 0xf1, 0x08, 0xae, 0xe0, 0xff, 0xa2, 0x56,
	0x29, 0xc4, 0xa5, 0xa9, 0x09, 0xb9, 0xd4, 0x04, 0x31, 0x38, 0x13, 0xb6, 0xb7, 0xee, 0x42, 0x86,
	0xb8, 0x6c, 0xe9, 0x46, 0xba, 0xc3, 0x8f, 0x5d, 0x26, 0xfd, 0x08, 0x83, 0xaa, 0x86, 0x8d, 0x2c,
	0xe7, 0x97, 0x81, 0x41, 0xc1, 0x99, 0x9c, 0x13, 0x83, 0xda, 0xb0, 0x48, 0x75, 0x72, 0x90, 0x3f,
	0xe7, 0x2d, 0xa6, 0x08, 0xc4, 0xe0, 0x20, 0x8c, 0xf4, 0x5d, 0xf2, 0x4a, 0xd7, 0x46, 0x3a, 0x52,
	0x5b, 0x63, 0xce, 0x61, 0xd6, 0x45, 0x80, 0x4b, 0x52, 0x13, 0x16, 0xb6, 0x11, 0x61, 0x8f, 0x77,
	0xc7, 0x28, 0x87, 0xee, 0x18, 0x5f, 0xe1, 0x47, 0xed, 0x5f, 0x32, 0x9a, 0x50, 0xf0, 0xb1, 0x32,
	0xd2, 0xef, 0xc3, 0x14, 0x89, 0x2a, 0x62, 0x78, 0x93, 0x90, 0x4c, 0x3b, 0x4a, 0x5f, 0x87, 0xf9,
	0x0d, 0xc5, 0x78, 0x8a, 0x42, 0x29, 0x7d, 0x19, 0x16, 0xbc, 0x11, 0x18, 0xd9, 0xcb, 0x90, 0x6d,
	0x2b, 0x86, 0xcf, 0xec, 0xac, 0x3c, 0xd3, 0xa6, 0x4d, 0x24, 0x99, 0x3e, 0xa5, 0x92, 0x21, 0x83,
	0x54, 0x5d, 0x85, 0x1c, 0xa5, 0xc3, 0x3f, 0x46, 0xb3, 0x14, 0x30, 0xd2, 0xa0, 0x95, 0xd6, 0xe0,
	0x72, 0x04, 0xe7, 0x68, 0x3a, 0xfe, 0x5e, 0x80, 0x2b, 0x1e, 0xd9, 0x6c, 0x92, 0xe7, 0x40, 0x8b,
	0x78, 0x13, 0x66, 0x3d, 0xa6, 0xf9, 0x77, 0xe5, 0xbc, 0x07, 0xab, 0xaa, 0xe1, 0xdd, 0x9a, 0x99,
	0x70, 0xb7, 0xbe, 0x4c, 0xae, 0x3f, 0x91, 0x69, 0x8c, 0x9e, 0xfe, 0x7f, 0x0b, 0x30, 0x87, 0x3f,
	0xd4, 0x2d, 0xb3, 0x63, 0x92, 0x27, 0xa0, 0x11, 0x6e, 0xac, 0xab, 0x90, 0xc3, 0x66, 0x3a, 0xbd,
	0x93, 0xd3, 0xd7, 0xe8, 0xac, 0x81, 0x4e, 0xeb, 0xe4, 0x5a, 0x7e, 0x15, 0x72, 0xa6, 0xae, 0xb2,
	0xca, 0x34, 0xad, 0x34, 0x75, 0x95, 0x56, 0x3e, 0x82, 0x39, 0x55, 0xb3, 0x69, 0xd8, 0x6f, 0x60,
	0xca, 0x9c, 0x97, 0x86, 0x4d, 0xd6, 0x95, 0x4c, 0x7b, 0x56, 0x0d, 0x94, 0xb0, 0x69, 0xea, 0x21,
	0xa6, 0x41, 0x72, 0x34, 0xc4, 0xd6, 0x1b, 0xee, 0x7d, 0x0c, 0xc4, 0xe6, 0x07, 0xb2, 0x2c, 0xd3,
	0x22, 0x07, 0x73, 0x4e, 0xa6, 0x05, 0xe9, 0x0d, 0x72, 0xa5, 0x0f, 0xb1, 0xc0, 0x5d, 0xfe, 0xc8,
	0xc3, 0x86, 0xd0, 0xf7, 0xb0, 0xf1, 0x67, 0x02, 0x14, 0xfb, 0x3b, 0x33, 0xa6, 0xaf, 0xc2, 0x45,
	0x72, 0x3d, 0x62, 0xf0, 0x96, 0xd2, 0x76, 0xb4, 0x13, 0x37, 0x32, 0x60, 0x11, 0xdf, 0x7a, 0x58,
	0x4d, 0x99, 0x54, 0x88, 0x1f, 0xc1, 0x02, 0x91, 0x06, 0xaf, 0x87, 0xeb, 0x5a, 0x7e, 0x91, 0x5f,
	0x26, 0x7c, 0x2a, 0xe6, 0x0f, 0x83, 0x45, 0x5b, 0xfa, 0xf7, 0x14, 0x5c, 0x64, 0x11, 0x57, 0x21,
	0x7d, 0x35, 0x89, 0x88, 0x0f, 0x8d, 0x7a, 0x3a, 0x4f, 0xe1, 0x16, 0x6f, 0xc1, 0x1c, 0x41, 0xf6,
	0x71, 0x4f, 0x31, 0x1c, 0xcd, 0x39, 0x23, 0x0b, 0x3c, 0x25, 0xcf, 0x62, 0xe0, 0x7b, 0x0c, 0xf6,
	0xbf, 0x1b, 0x75, 0x28, 0x2d, 0xc1, 0xa5, 0x30, 0x7f, 0xd9, 0x2d, 0xfe, 0x8f, 0x04, 0x78, 0x06,
	0x6b, 0xa4, 0x9d, 0x9d, 0xed, 0xa8, 0xfd, 0xcc, 0xb5, 0x06, 0x51, 0x3d, 0x92, 0xea, 0xd7, 0x23,
	0x23, 0x5e, 0xfb, 0xc3, 0xb7, 0x8f, 0x4c, 0xf4, 0xf6, 0x71, 0x13, 0x56, 0x06, 0xd2, 0xc7, 0xe6,
	0xf0, 0x43, 0x01, 0x6e, 0xb1, 0x36, 0x84, 0x53, 0x63, 0x4d, 0x64, 0x84, 0x30, 0x85, 0xa9, 0x4c,
	0x47, 0x3d, 0xfc, 0x7d, 0x12, 0x90, 0xe9, 0x97, 0x00, 0xe9, 0x0b, 0x70, 0x7b, 0x38, 0x99, 0x6c,
	0x3e, 0x6b, 0x70, 0x79, 0x1b, 0x39, 0x24, 0x0d, 0x86, 0xe6, 0xdf, 0x70, 0xbc, 0x04, 0xbe, 0x44,
	0xdc, 0x8a, 0xa1, 0x3e, 0x6c, 0xa3, 0x97, 0x20, 0x4b, 0x33, 0x83, 0x90, 0xab, 0x23, 0xbc, 0xb2,
	0xf4, 0x3a, 0x51, 0x10, 0x6e, 0x1a, 0x44, 0x78, 0xb0, 0x11, 0x41, 0xf2, 0xbf, 0x26, 0xc0, 0x72,
	0x4c, 0x5f, 0x36, 0xa8, 0x9f, 0x9c, 0x24, 0x84, 0x92, 0x93, 0x76, 0xdd, 0x8b, 0x0c, 0x7d, 0x62,
	0x78, 0x3d, 0x59, 0x9e, 0x06, 0x1d, 0x24, 0x78, 0xa5, 0x91, 0xfe, 0x45, 0x80, 0xcb, 0xd4, 0x4e,
	0x76, 0x1b, 0x8d, 0xbc, 0xee, 0xae, 0x40, 0x1e, 0x8f, 0xda, 0xb2, 0x7b, 0x07, 0x7e, 0xf6, 0x14,
	0x60, 0x50, 0x83, 0x40, 0x38, 0x04, 0x56, 0xeb, 0x28, 0x87, 0x68, 0xed, 0xb5, 0x80, 0xc0, 0x32,
	0x48, 0xa0, 0xfa, 0xe5, 0x57, 0xfc, 0xd8, 0xe3, 0x1c, 0x83, 0xd0, 0xd1, 0x49, 0xe1, 0x85, 0x17,
	0xd6, 0x70, 0x3d, 0x55, 0xf6, 0xe0, 0x82, 0xaa, 0xaa, 0xf4, 0xed, 0x98, 0x19, 0x51, 0xa6, 0x46,
	0xaf, 0xb2, 0x22, 0x64, 0xc8, 0x4b, 0x02, 0x9d, 0x01, 0xf9, 0x3c, 0x8a, 0xf6, 0x65, 0xc8, 0x1e,
	0x5a, 0x66, 0xaf, 0xeb, 0x53, 0x3e, 0x43, 0xca, 0xf4, 0x9d, 0xd2, 0xbf, 0x63, 0xba, 0x79, 0x63,
	0x52, 0x85, 0x3c, 0xbf, 0x97, 0x75, 0xdd, 0x25, 0xc6, 0x5e, 0x3f, 0x63, 0x0f, 0x13, 0xd5, 0x4d,
	0x9b, 0xfb, 0x28, 0xfa, 0xa6, 0x40, 0x1e, 0xd9, 0x07, 0xe3, 0x61, 0x72, 0xf3, 0x51, 0x20, 0x4d,
	0x8d, 0x10, 0xe6, 0x9a, 0x94, 0x09, 0x33, 0x7a, 0xb6, 0x71, 0x5f, 0xd9, 0xcb, 0x5a, 0x21, 0x45,
	0x5b, 0xfa, 0xc4, 0xcf, 0xe5, 0x22, 0x90, 0x51, 0xc6, 0xc4, 0x43, 0xc8, 0xb9, 0x18, 0xdc, 0xd3,
	0x6e, 0x35, 0x19, 0x1d, 0xb2, 0x8f, 0x40, 0xfa, 0x4c, 0x80, 0xac, 0x0b, 0xe7, 0x5a, 0xcb, 0xe0,
	0x62, 0xa5, 0xc3, 0x8b, 0x55, 0x75, 0x17, 0x8b, 0x1e, 0x5d, 0x09, 0xb9, 0x13, 0xda, 0x41, 0x2f,
	0x91, 0x7d, 0x5c, 0x57, 0x2c, 0xc7, 0x40, 0x56, 0xc3, 0x51, 0x48, 0xde, 0xdf, 0xc8, 0xa4, 0x93,
	0x07, 0x50, 0x8a, 0xeb, 0xc5, 0x96, 0xf1, 0x2b, 0xc4, 0xb8, 0xd0, 0x8c, 0xd6, 0xa1, 0x69, 0xaa,
	0xf8, 0xb8, 0x23, 0xd5, 0xcc, 0xb8, 0x28, 0x68, 0x76, 0xd5, 0xd8, 0x36, 0x4d, 0xd5, 0xed, 0x26,
	0x35, 0xe1, 0x6a, 0xa3, 0xb7, 0xdf, 0xd1, 0xc6, 0xd2, 0x44, 0x83, 0x12, 0x21, 0xa5, 0x67, 0xe0,
	0x5a, 0x3c, 0x56, 0xa6, 0x66, 0x37, 0x49, 0x4c, 0x01, 0x4b, 0x74, 0x0c, 0x88, 0x65, 0x40, 0xae,
	0x6f, 0xc2, 0xac, 0x27, 0x8e, 0xbe, 0x60, 0xe7, 0x5d, 0x18, 0x96, 0xec, 0x53, 0xb8, 0x31, 0x18,
	0x0b, 0x63, 0x47, 0x23, 0x28, 0x47, 0x54, 0x9e, 0x5f, 0xe6, 0x7c, 0x4f, 0x08, 0xe3, 0x0d, 0x8a,
	0xd3, 0x77, 0x52, 0x74, 0x09, 0x22, 0x23, 0xbb, 0xa4, 0x3f, 0xf4, 0x02, 0x23, 0x05, 0x22, 0x22,
	0x2f, 0x25, 0x13, 0x91, 0x70, 0x0c, 0x24, 0x56, 0x0e, 0x7e, 0x36, 0xc8, 0x94, 0x4c, 0x0b, 0x78,
	0x8c, 0xfd, 0x5e, 0xfb, 0x18, 0xb9, 0xbe, 0xf9, 0x84, 0x63, 0xac, 0x93, 0xbe, 0x32, 0xc3, 0x21,
	0x6e, 0xc0, 0x82, 0x72, 0xe0, 0x20, 0xab, 0xe5, 0x25, 0xca, 0x72, 0x3c, 0xcf, 0xcd, 0x93, 0x2e,
	0x5e, 0x59, 0xfa, 0x8e, 0x40, 0x82, 0x35, 0xfa, 0xb9, 0xf2, 0x14, 0x97, 0x22, 0x1a, 0x93, 0x91,
	0x8a, 0xc6, 0x64, 0x48, 0xdf, 0x13, 0xe0, 0xba, 0x8c, 0x4e, 0x34, 0x74, 0x3a, 0x68, 0xb9, 0x3e,
	0x82, 0x19, 0x8b, 0x34, 0x70, 0xa9, 0x5a, 0xe7, 0xa3, 0x2a, 0x16, 0x2b, 0x43, 0x2a, 0xbb, 0x28,
	0xb1, 0x26, 0x51, 0xd4, 0x0e, 0xb5, 0x84, 0x99, 0xd7, 0x93, 0x94, 0xab, 0xaa, 0xf4, 0x03, 0x01,
	0xae, 0x0d, 0x43, 0x12, 0xe7, 0x40, 0x55, 0x48, 0x3e, 0xb0, 0x1b, 0xe7, 0xe6, 0x16, 0xc9, 0x45,
	0x07, 0xb5, 0x75, 0xcd, 0x40, 0xad, 0x50, 0x08, 0xc6, 0x1c, 0x83, 0xca, 0x04, 0x28, 0x3e, 0x0f,
	0x17, 0xdd, 0x66, 0xe8, 0x49, 0x57, 0x57, 0x0c, 0x62, 0xfd, 0xb0, 0xe3, 0x48, 0x64, 0x55, 0x15,
	0xbf, 0x46, 0xfa, 0x14, 0x9e, 0x19, 0xc4, 0x3c, 0xb6, 0xaa, 0x5f, 0x8b, 0x46, 0xf7, 0x6d, 0x4c,
	0xc4, 0x3d, 0x8a, 0xd5, 0x0b, 0xf2, 0x93, 0xf4, 0x01, 0xab, 0xe7, 0x8d, 0x1f, 0xe5, 0xd1, 0x35,
	0xc8, 0xd9, 0xbd, 0x76, 0x1b, 0x21, 0x15, 0xa9, 0x8c, 0x4b, 0x3e, 0x00, 0xeb, 0x33, 0x7c, 0x47,
	0xc5, 0xea, 0xb7, 0x67, 0xbb, 0x67, 0xb4, 0x81, 0x4e, 0x1b, 0x04, 0x20, 0xbd, 0x07, 0xf3, 0xe1,
	0x1d, 0x42, 0x5d, 0x1e, 0x64, 0x35, 0x90, 0xca, 0x22, 0x7e, 0x7c, 0x00, 0x56, 0x52, 0x74, 0x07,
	0x85, 0xc4, 0x2f, 0x4f, 0x61, 0x54, 0xfe, 0x7e, 0x28, 0xc0, 0x42, 0x84, 0xf6, 0x3e, 0x9a, 0x07,
	0xe5, 0x93, 0xbb, 0x27, 0x53, 0x3a, 0x7c, 0x32, 0x79, 0x86, 0x68, 0x26, 0xfc, 0xa8, 0xf7, 0x26,
	0xe4, 0x7b, 0x5d, 0xdd, 0x54, 0x54, 0xb2, 0x8d, 0x79, 0xb2, 0x41, 0x68, 0x73, 0x0c, 0x90, 0xfe,
	0x33, 0x0d, 0x33, 0xcc, 0x2a, 0x88, 0x4b, 0x79, 0xb2, 0x8f, 0x4c, 0xcb, 0x69, 0x19, 0x4a, 0xc7,
	0x3d, 0x27, 0x73, 0x04, 0x52, 0x53, 0x3a, 0x08, 0x73, 0x41, 0xd5, 0xec, 0xae, 0xae, 0x9c, 0xd1,
	0x06, 0xcc, 0xa1, 0xc1, 0x60, 0xa4, 0xc9, 0x73, 0x50, 0x88, 0xe4, 0xc0, 0xdb, 0x24, 0xc1, 0x36,
	0xe7, 0x1b, 0x0a, 0x24, 0x09, 0xde, 0xf6, 0x5f, 0xf5, 0xa7, 0x22, 0xaf, 0xfa, 0x24, 0x39, 0x4e,
	0x51, 0x6d, 0x62, 0xb7, 0x65, 0xe5, 0x19, 0x5c, 0x2e, 0xab, 0x36, 0x09, 0x0d, 0x70, 0x7d, 0xe3,
	0x39, 0x99, 0x7c, 0x0e, 0x31, 0x29, 0x1b, 0x66, 0x92, 0x1b, 0x49, 0x90, 0x0b, 0x44, 0x12, 0xbc,
	0x07, 0x59, 0xef, 0x55, 0x11, 0x08, 0xd7, 0x78, 0x15, 0x13, 0xb3, 0x57, 0xdc, 0x37, 0x45, 0x0f,
	0x0d, 0x09, 0x21, 0xd2, 0x1c, 0x4b, 0x71, 0x50, 0x8b, 0x3e, 0xc7, 0x15, 0xf3, 0x2c, 0x84, 0x88,
	0x42, 0xcb, 0x04, 0xc8, 0x72, 0xc2, 0x4d, 0x43, 0x3f, 0x6b, 0x29, 0x56, 0xfb, 0x48, 0x3b, 0x41,
	0x36, 0x0b, 0xfa, 0x5d, 0x60, 0xf0, 0x32, 0x03, 0xc7, 0x7d, 0x8d, 0xc0, 0x5c, 0xcc, 0xd7, 0x08,
	0x84, 0x02, 0x20, 0xe6, 0xc3, 0x01, 0x10, 0x9f, 0xc0, 0x42, 0x84, 0x62, 0x7c, 0x45, 0x51, 0x7b,
	0x96, 0xe2, 0xc5, 0x8d, 0x4e, 0xc9, 0x5e, 0x59, 0xdc, 0x81, 0x4c, 0xcf, 0x60, 0xd1, 0x73, 0xdc,
	0x17, 0x86, 0xc8, 0x00, 0x7b, 0x86, 0xe6, 0xc8, 0x04, 0x0d, 0xf3, 0xa7, 0xb0, 0xfa, 0xf0, 0x61,
	0x3f, 0xd2, 0x88, 0x45, 0xe4, 0xb6, 0x14, 0xe9, 0xcb, 0x34, 0x40, 0x15, 0x4f, 0x98, 0x56, 0x24,
	0x73, 0xae, 0x32, 0x74, 0xb2, 0xd7, 0x5d, 0x7a, 0x44, 0x0c, 0x32, 0xf6, 0xd4, 0xe6, 0x8e, 0xc6,
	0x1f, 0x1a, 0xd7, 0xd6, 0xc3, 0x77, 0xf1, 0x2c, 0x05, 0x54, 0x55, 0xe9, 0x90, 0x18, 0x0c, 0x7d,
	0x88, 0xcf, 0x7f, 0x06, 0x8f, 0xe1, 0x12, 0x4d, 0xd4, 0x71, 0xab, 0xf8, 0x42, 0xd0, 0xa2, 0x5b,
	0x38, 0xd5, 0xb7, 0x85, 0xa5, 0x2b, 0x70, 0x39, 0x82, 0x99, 0x19, 0x73, 0xdf, 0x14, 0xe0, 0x1a,
	0xad, 0x19, 0x8f, 0x71, 0xc1, 0xbd, 0x9d, 0x0a, 0xef, 0xed, 0xb8, 0xed, 0x91, 0x8e, 0xdd, 0x1e,
	0xd2, 0x0a, 0x5c, 0x1f, 0x40, 0x04, 0x25, 0xf3, 0x8e, 0x0e, 0x59, 0x37, 0x34, 0x4c, 0x5c, 0x84,
	0x39, 0x37, 0x89, 0xa4, 0x55, 0xdb, 0xad, 0x55, 0x0a, 0x17, 0xc4, 0x02, 0xcc, 0x7a, 0xa0, 0x47,
	0x95, 0xf5, 0x82, 0x10, 0x82, 0x54, 0x77, 0x1b, 0x85, 0x94, 0x78, 0x09, 0x0a, 0x1e, 0xa4, 0x5c,
	0xdb, 0x94, 0x77, 0xab, 0x9b, 0x85, 0xb4, 0x78, 0x11, 0x16, 0x7c, 0xe8, 0x4e, 0xf9, 0xc3, 0xdd,
	0x5a, 0x21, 0x73, 0xe7, 0xa7, 0x02, 0x14, 0xa2, 0x69, 0x43, 0xe2, 0x65, 0x58, 0x6c, 0xec, 0xad,
	0x37, 0x36, 0xe4, 0x6a, 0xbd, 0x59, 0xdd, 0xad, 0xb5, 0xea, 0xe5, 0xea, 0x66, 0xe1, 0x82, 0xb8,
	0x04, 0x62, 0x18, 0x2c, 0x57, 0x77, 0x2a, 0x05, 0xa1, 0x0f, 0x5e, 0xde, 0xdc, 0xa9, 0xd6, 0x0a,
	0x29, 0x51, 0x82, 0x67, 0x42, 0xf0, 0xed, 0xea, 0x56, 0x93, 0xe0, 0x6a, 0xed, 0xd5, 0xb7, 0xe5,
	0xf2, 0x66, 0xa5, 0x90, 0x16, 0x6f, 0xc1, 0x4a, 0x3f, 0xce, 0x70, 0xa3, 0x4c, 0x1f, 0x3d, 0x24,
	0x95, 0x66, 0xea, 0xce, 0x7d, 0xc8, 0x79, 0xef, 0x97, 0xe2, 0x1c, 0xe4, 0x08, 0x7e, 0xc6, 0xa6,
	0x45, 0x98, 0x23, 0xc5, 0xf2, 0xc6, 0x46, 0xa5, 0xde, 0xac, 0x6c, 0x16, 0x04, 0x0f, 0xb4, 0x51,
	0xae, 0x6d, 0x54, 0x1e, 0x56, 0x36, 0x0b, 0xa9, 0x3b, 0xef, 0xc3, 0x6c, 0xd0, 0x2b, 0x8b, 0x9b,
	0x6c, 0x56, 0x1b, 0x1b, 0xbb, 0x7b, 0x35, 0x0f, 0xd1, 0x15, 0xb8, 0xe8, 0x81, 0xea, 0x15, 0x79,
	0xa3, 0x52, 0x6b, 0xee, 0x6e, 0x6d, 0x15, 0x04, 0xb1, 0x04, 0x4b, 0x5e, 0xc5, 0x56, 0xf5, 0x71,
	0x65, 0xf3, 0xfd, 0xf2, 0xc3, 0xbd, 0x0a, 0xae, 0x4b, 0xdd, 0xd9, 0x81, 0xac, 0xeb, 0x03, 0x14,
	0x45, 0x98, 0x27, 0xc3, 0x36, 0x3f, 0xa8, 0x57, 0x5c, 0xa4, 0x97, 0x61, 0xd1, 0x87, 0xed, 0x7c,
	0xd0, 0x68, 0x56, 0xe4, 0x0f, 0x28, 0x23, 0x7d, 0x70, 0xa3, 0x59, 0xae, 0x6d, 0x96, 0x65, 0x4c,
	0xe6, 0x13, 0xff, 0x52, 0x4a, 0x27, 0xbb, 0x04, 0x62, 0x08, 0xe0, 0xe2, 0x2d, 0xc2, 0xa5, 0x30,
	0xbc, 0xbc, 0xd1, 0xac, 0xbe, 0x8f, 0xd7, 0x68, 0x19, 0x2e, 0x87, 0x6b, 0xea, 0x95, 0xda, 0x66,
	0xb5, 0xb6, 0x5d, 0x48, 0xe1, 0x89, 0x84, 0xab, 0xaa, 0x35, 0xd6, 0x2d, 0x7d, 0xe7, 0x14, 0x2e,
	0xc6, 0x78, 0x56, 0xf0, 0x9c, 0xea, 0x72, 0x65, 0xab, 0xfa, 0xb8, 0xb5, 0x57, 0x7b, 0x50, 0xdb,
	0x7d, 0x54, 0x63, 0x82, 0xe9, 0xc2, 0x1a, 0x95, 0x26, 0x65, 0x38, 0x83, 0x30, 0x7c, 0x29, 0x22,
	0x83, 0x14, 0x24, 0x57, 0xde, 0xad, 0x6c, 0xe0, 0x85, 0x49, 0x07, 0xb0, 0xb9, 0x44, 0x65, 0xee,
	0xec, 0xfb, 0x16, 0x0e, 0xcb, 0xac, 0x0a, 0xcc, 0x99, 0x42, 0x5a, 0x65, 0x5d, 0x2f, 0x5c, 0x08,
	0x92, 0xcf, 0xe0, 0xec, 0xca, 0x59, 0x10, 0xc4, 0x6b, 0x50, 0x8c, 0xf6, 0x39, 0x38, 0xd0, 0x74,
	0x4d, 0x71, 0x50, 0x21, 0x75, 0xe7, 0x47, 0x02, 0x5c, 0x8c, 0x39, 0x06, 0x70, 0xaf, 0x18, 0xb0,
	0xcb, 0xe3, 0x01, 0xb5, 0x8f, 0x2a, 0x95, 0x07, 0x05, 0x41, 0xbc, 0x0e, 0xcb, 0x71, 0xb5, 0x3b,
	0xbb, 0xb5, 0xe6, 0x3b, 0x85, 0xd4, 0xa0, 0xce, 0x1f, 0x54, 0xca, 0x72, 0x21, 0x2d, 0xae, 0xc0,
	0xd5, 0xb8, 0xda, 0xdd, 0x5a, 0xa5, 0x89, 0x77, 0x5a, 0x66, 0xed, 0xef, 0xd6, 0x61, 0x2e, 0x14,
	0xda, 0x2e, 0x7e, 0x5f, 0xf0, 0xbc, 0xe2, 0xa1, 0x1c, 0xac, 0xfb, 0x9c, 0xd1, 0xdc, 0x03, 0x33,
	0xc0, 0x4b, 0xe5, 0x09, 0x30, 0xb0, 0xf3, 0xe2, 0xbb, 0x82, 0xfb, 0x42, 0x1d, 0xa2, 0xed, 0x1e,
	0x67, 0x70, 0xc7, 0xa0, 0x34, 0xe7, 0xd2, 0xfd, 0xf1, 0x11, 0x04, 0x29, 0xeb, 0xcb, 0x82, 0xe5,
	0xa6, 0x6c, 0x50, 0xce, 0x2e, 0x37, 0x65, 0x03, 0x13, 0x70, 0x09, 0x65, 0xfd, 0x29, 0xac, 0xbc,
	0x94, 0x0d, 0x4c, 0xdd, 0xe5, 0xa5, 0x6c, 0x70, 0xf6, 0xac, 0xf8, 0xeb, 0x02, 0xcc, 0x06, 0x73,
	0x47, 0xc5, 0xd7, 0xb9, 0x27, 0x1b, 0xcd, 0xb8, 0x2d, 0xbd, 0x31, 0x4e, 0x57, 0x46, 0xc7, 0x0f,
	0x04, 0xb8, 0x1c, 0x9b, 0xc9, 0x25, 0xae, 0x4f, 0x9e, 0xd9, 0x59, 0xda, 0x98, 0x08, 0x07, 0x23,
	0xf1, 0x3f, 0x84, 0x68, 0xd8, 0xd5, 0xb0, 0x14, 0x2d, 0xf1, 0x11, 0xe7, 0xb3, 0x52, 0xd2, 0xbc,
	0xd1, 0xd2, 0xe3, 0xf3, 0x47, 0xcc, 0x66, 0xf8, 0x87, 0x02, 0x5c, 0x8a, 0xcb, 0x2b, 0x12, 0xcb,
	0x89, 0x86, 0x8c, 0x5d, 0x82, 0xf5, 0x49, 0x50, 0x30, 0xfa, 0x7e, 0x24, 0x10, 0x4b, 0x76, 0xc0,
	0xb4, 0xc4, 0xed, 0x49, 0x19, 0xe3, 0xd2, 0xfa, 0xce, 0xe4, 0x88, 0x18, 0xc5, 0x3f, 0x16, 0xbc,
	0x1c, 0xaf, 0xb8, 0x24, 0x33, 0x31, 0xd9, 0x48, 0x43, 0x32, 0xe1, 0x4a, 0xd5, 0x73, 0xc0, 0xc4,
	0x88, 0xfe, 0x53, 0xfa, 0xc5, 0x42, 0x71, 0x59, 0x57, 0xe2, 0x26, 0xf7, 0x30, 0x43, 0x72, 0xc4,
	0x4a, 0x95, 0x09, 0xb1, 0x84, 0xe5, 0xb5, 0x2f, 0x69, 0x2a, 0x81, 0xbc, 0x0e, 0xca, 0xee, 0x4a,
	0x20, 0xaf, 0x83, 0x73, 0xb6, 0xbe, 0x2d, 0xc0, 0x7c, 0x38, 0xf9, 0x48, 0xe4, 0x8c, 0x81, 0x8c,
	0xcd, 0x8f, 0x2a, 0xbd, 0x35, 0x5e, 0x67, 0x46, 0xcd, 0x67, 0x02, 0x2c, 0xf6, 0xa5, 0x1d, 0x89,
	0x77, 0x93, 0xe1, 0x8c, 0xa6, 0x40, 0x95, 0xee, 0x8d, 0xdd, 0x9f, 0x91, 0x75, 0x06, 0x59, 0xf7,
	0xdb, 0xea, 0x44, 0x4e, 0xcf, 0x47, 0xe4, 0xbb, 0xf3, 0x4a, 0xaf, 0x24, 0xed, 0xc6, 0x86, 0xfe,
	0x73, 0x12, 0x9c, 0x1f, 0xff, 0x8d, 0x5f, 0x62, 0x85, 0xf7, 0x34, 0x1b, 0xfa, 0x9d, 0x63, 0xa5,
	0xad, 0x49, 0xd1, 0x04, 0x34, 0xc9, 0x90, 0xf8, 0x70, 0x5e, 0x4d, 0x32, 0x3a, 0x72, 0x9f, 0x57,
	0x93, 0xf0, 0x04, 0xab, 0x63, 0x06, 0x0f, 0x8a, 0xbb, 0xe6, 0x65, 0xf0, 0x88, 0x10, 0x72, 0x5e,
	0x06, 0x8f, 0x0c, 0xff, 0x26, 0x0c, 0x1e, 0x1c, 0x96, 0xcd, 0xcd, 0xe0, 0x91, 0x81, 0xe2, 0xdc,
	0x0c, 0xe6, 0x88, 0x11, 0xff, 0x27, 0xc1, 0x4b, 0x62, 0x1e, 0x16, 0xa3, 0x2d, 0xd6, 0xc7, 0x39,
	0xd1, 0x86, 0x4e, 0xe2, 0xbd, 0x73, 0xc4, 0xc8, 0x26, 0xf3, 0xbb, 0x02, 0x09, 0x5c, 0x0c, 0x7e,
	0xcd, 0x99, 0xf8, 0x56, 0x32, 0xb3, 0x21, 0xfc, 0xed, 0x73, 0xa5, 0xb7, 0xc7, 0xec, 0x1d, 0x20,
	0xa8, 0x31, 0x1e, 0x41, 0x8d, 0x89, 0x08, 0x1a, 0xf4, 0x65, 0x6f, 0x3f, 0x11, 0xe0, 0xfa, 0xd0,
	0xf4, 0x49, 0xf1, 0x5d, 0xee, 0x19, 0x8f, 0xcc, 0x1c, 0x2d, 0x3d, 0x38, 0x17, 0x5c, 0x8c, 0xf4,
	0x9f, 0x09, 0xe4, 0xc1, 0x74, 0x68, 0x92, 0xa3, 0xb8, 0x33, 0xee, 0x88, 0xb1, 0x09, 0xa0, 0xa5,
	0xda, 0x79, 0xa1, 0x0b, 0x0b, 0x68, 0x30, 0xd1, 0x2e, 0x81, 0x80, 0xc6, 0xe4, 0xfe, 0x25, 0x10,
	0xd0, 0xd8, 0xec, 0xbe, 0xcf, 0xbc, 0xb8, 0xf7, 0x60, 0xa6, 0xe6, 0xdd, 0x24, 0x0a, 0xbc, 0x3f,
	0x2d, 0xad, 0x74, 0x6f, 0xec, 0xfe, 0x41, 0xb2, 0xa2, 0x09, 0x64, 0xdc, 0x64, 0x0d, 0xc8, 0x96,
	0x2b, 0xdd, 0x1b, 0xbb, 0x3f, 0x23, 0xeb, 0x53, 0x00, 0x3f, 0xb4, 0x5e, 0x7c, 0x35, 0xc9, 0x2c,
	0x03, 0xa1, 0xc0, 0xa5, 0xd7, 0x92, 0x77, 0xf4, 0x09, 0xf0, 0x43, 0xd7, 0x79, 0x09, 0xe8, 0x0b,
	0xdb, 0xe7, 0x25, 0x20, 0x26, 0x4a, 0x1e, 0x73, 0xc0, 0x0b, 0x40, 0xe7, 0xe6, 0x40, 0x34, 0x2e,
	0x9e, 0x9b, 0x03, 0xfd, 0xb1, 0xee, 0x67, 0x90, 0x75, 0x83, 0xc8, 0x79, 0x8d, 0xbd, 0x48, 0x28,
	0x3b, 0xaf, 0xb1, 0xd7, 0x17, 0xab, 0x7e, 0x02, 0x33, 0x2c, 0x12, 0x59, 0x7c, 0x89, 0x9b, 0xfe,
	0xe0, 0xac, 0x5f, 0x4e, 0xd8, 0x8b, 0x8d, 0xfb, 0xfb, 0x82, 0x17, 0x38, 0xef, 0x47, 0x33, 0xbf,
	0x9d, 0x68, 0x12, 0xd1, 0x10, 0xe0, 0xd2, 0xdd, 0x71, 0xbb, 0x33, 0x9a, 0x7e, 0x43, 0x80, 0xb9,
	0x50, 0x48, 0xba, 0x98, 0xc0, 0x77, 0x13, 0x8d, 0x8d, 0x2f, 0xbd, 0x39, 0x56, 0xdf, 0x00, 0x7b,
	0xa2, 0x11, 0xe2, 0xbc, 0xec, 0x19, 0x10, 0x20, 0x5f, 0xba, 0x3b, 0x6e, 0xf7, 0x80, 0x53, 0x2c,
	0x18, 0x35, 0xcb, 0xeb, 0x14, 0x8b, 0x89, 0x64, 0xe6, 0x75, 0x8a, 0xc5, 0x05, 0xe9, 0x92, 0x8b,
	0xf8, 0x80, 0x20, 0x58, 0xde, 0x8b, 0xf8, 0xf0, 0x18, 0x5f, 0xde, 0x8b, 0xf8, 0x88, 0x48, 0x5c,
	0xf1, 0xaf, 0x04, 0xb8, 0x36, 0x2c, 0xc4, 0x55, 0xac, 0x26, 0x1a, 0x67, 0x58, 0x34, 0x6f, 0xe9,
	0xdd, 0xf3, 0x40, 0x15, 0xb8, 0xa0, 0x87, 0xc3, 0x67, 0x79, 0x2f, 0xe8, 0xb1, 0x81, 0xba, 0xa5,
	0xb7, 0xc6, 0xeb, 0xcc, 0xa8, 0xf9, 0x2d, 0x01, 0xe6, 0xc3, 0x11, 0xa0, 0xbc, 0xd4, 0xc4, 0x46,
	0xc2, 0x96, 0xc6, 0xec, 0x1c, 0xf2, 0x5c, 0x0d, 0x8a, 0xdc, 0x4c, 0xe0, 0xb9, 0x1a, 0x11, 0x44,
	0x9a, 0xc0, 0x73, 0x35, 0x32, 0x8c, 0xf4, 0xbb, 0x02, 0x88, 0xfd, 0xe1, 0x89, 0xbc, 0x7e, 0xf6,
	0x81, 0xe1, 0x90, 0xbc, 0x7e, 0xf6, 0x21, 0x91, 0x91, 0xd8, 0x24, 0xea, 0x0b, 0x9b, 0x16, 0xef,
	0x26, 0x92, 0x97, 0xbe, 0x08, 0xc9, 0xd2, 0xbd, 0xb1, 0xfb, 0x07, 0x3c, 0x68, 0x71, 0xc1, 0x92,
	0xbc, 0x1e, 0xb4, 0x21, 0xe1, 0x9b, 0xbc, 0x1e, 0xb4, 0x61, 0xb1, 0x9a, 0xc4, 0x81, 0x30, 0x28,
	0xcc, 0x52, 0xe4, 0xf7, 0x22, 0x0e, 0x0b, 0xf6, 0xe4, 0x75, 0x20, 0x8c, 0x8c, 0xf6, 0xfc, 0xbe,
	0x00, 0x17, 0x63, 0x1a, 0x89, 0xf7, 0xc7, 0xc6, 0x9f, 0xf0, 0xd5, 0x6e, 0x58, 0xfc, 0xe3, 0x9f,
	0x08, 0xb0, 0x14, 0x1f, 0x4c, 0x27, 0x4e, 0x12, 0x33, 0xe7, 0x91, 0xb8, 0x39, 0x19, 0x92, 0xb0,
	0xad, 0x14, 0x0a, 0xb5, 0x49, 0x60, 0x2b, 0xc5, 0x85, 0xf7, 0x24, 0xb0, 0x95, 0xe2, 0x23, 0x7c,
	0x98, 0x4e, 0x89, 0x44, 0x76, 0x24, 0xd0, 0x29, 0xf1, 0x81, 0x29, 0x09, 0x74, 0xca, 0xa0, 0xc8,
	0x1d, 0x6c, 0xc5, 0x85, 0xa2, 0x62, 0x78, 0xad, 0xb8, 0xb8, 0x20, 0x1d, 0xde, 0xd3, 0x22, 0x36,
	0x0c, 0x87, 0x3c, 0xdf, 0xc5, 0x46, 0xc0, 0xf0, 0x3e, 0xdf, 0x0d, 0x8b, 0xe1, 0xe1, 0x7d, 0xbe,
	0x1b, 0x1a, 0x82, 0x43, 0x64, 0x2b, 0xfa, 0x6b, 0x2f, 0xbc, 0xb2, 0x35, 0xe0, 0x97, 0x68, 0x78,
	0x65, 0x6b, 0xd0, 0x8f, 0xcc, 0xf8, 0x34, 0x05, 0x7e, 0x01, 0x27, 0x11, 0x4d, 0xfd, 0x3f, 0xc4,
	0x93, 0x88, 0xa6, 0x98, 0x1f, 0xde, 0x21, 0x8f, 0x6c, 0x83, 0x7f, 0x0a, 0x88, 0xf7, 0x91, 0x6d,
	0xe4, 0x0f, 0x1c, 0xf1, 0x3e, 0xb2, 0x8d, 0xfe, 0x55, 0xa2, 0xf5, 0xfc, 0x87, 0xe4, 0x87, 0x34,
	0xc8, 0x0f, 0x37, 0xed, 0x4f, 0x93, 0x50, 0xd3, 0x17, 0xff, 0x27, 0x00, 0x00, 0xff, 0xff, 0x37,
	0x88, 0x99, 0x41, 0xc8, 0x69, 0x00, 0x00,
}
