// Code generated by protoc-gen-twirp v4.9.0, DO NOT EDIT.
// source: rpc/rex_service.proto

/*
Package rex is a generated twirp stub package.
This code was generated with code.justin.tv/common/twirp/protoc-gen-twirp v4.9.0.

It is generated from these files:
	rpc/rex_service.proto
*/
package rex

import bytes "bytes"
import fmt "fmt"
import ioutil "io/ioutil"
import log "log"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import context "golang.org/x/net/context"
import twirp "code.justin.tv/common/twirp"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import strings "strings"
import json "encoding/json"
import url "net/url"
import ctxhttp "golang.org/x/net/context/ctxhttp"

// =============
// Rex Interface
// =============

type Rex interface {
	GetOfferStatuses(context.Context, *GetOfferStatusesRequest) (*GetOfferStatusesResponse, error)

	UpdateOfferStatuses(context.Context, *UpdateOfferStatusesRequest) (*UpdateOfferStatusesResponse, error)

	GiftOffer(context.Context, *GiftOfferRequest) (*GiftOfferResponse, error)

	GetClaimableGiftedOffer(context.Context, *GetClaimableGiftedOfferRequest) (*GetClaimableGiftedOfferResponse, error)

	GetGiftedOffersTo(context.Context, *GetGiftedOffersToRequest) (*GetGiftedOffersToResponse, error)

	GetGiftedOffersFrom(context.Context, *GetGiftedOffersFromRequest) (*GetGiftedOffersFromResponse, error)

	ClaimGiftedOffer(context.Context, *ClaimGiftedOfferRequest) (*ClaimGiftedOfferResponse, error)
}

// ===================
// Rex Protobuf Client
// ===================

type rexProtobufClient struct {
	urlBase string
	client  *http.Client
}

// NewRexProtobufClient creates a Protobuf client that implements the Rex interface.
// It communicates using protobuf messages and can be configured with a custom http.Client.
func NewRexProtobufClient(addr string, client *http.Client) Rex {
	return &rexProtobufClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *rexProtobufClient) GetOfferStatuses(ctx context.Context, in *GetOfferStatusesRequest) (*GetOfferStatusesResponse, error) {
	url := c.urlBase + RexPathPrefix + "GetOfferStatuses"
	out := new(GetOfferStatusesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexProtobufClient) UpdateOfferStatuses(ctx context.Context, in *UpdateOfferStatusesRequest) (*UpdateOfferStatusesResponse, error) {
	url := c.urlBase + RexPathPrefix + "UpdateOfferStatuses"
	out := new(UpdateOfferStatusesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexProtobufClient) GiftOffer(ctx context.Context, in *GiftOfferRequest) (*GiftOfferResponse, error) {
	url := c.urlBase + RexPathPrefix + "GiftOffer"
	out := new(GiftOfferResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexProtobufClient) GetClaimableGiftedOffer(ctx context.Context, in *GetClaimableGiftedOfferRequest) (*GetClaimableGiftedOfferResponse, error) {
	url := c.urlBase + RexPathPrefix + "GetClaimableGiftedOffer"
	out := new(GetClaimableGiftedOfferResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexProtobufClient) GetGiftedOffersTo(ctx context.Context, in *GetGiftedOffersToRequest) (*GetGiftedOffersToResponse, error) {
	url := c.urlBase + RexPathPrefix + "GetGiftedOffersTo"
	out := new(GetGiftedOffersToResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexProtobufClient) GetGiftedOffersFrom(ctx context.Context, in *GetGiftedOffersFromRequest) (*GetGiftedOffersFromResponse, error) {
	url := c.urlBase + RexPathPrefix + "GetGiftedOffersFrom"
	out := new(GetGiftedOffersFromResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexProtobufClient) ClaimGiftedOffer(ctx context.Context, in *ClaimGiftedOfferRequest) (*ClaimGiftedOfferResponse, error) {
	url := c.urlBase + RexPathPrefix + "ClaimGiftedOffer"
	out := new(ClaimGiftedOfferResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ===============
// Rex JSON Client
// ===============

type rexJSONClient struct {
	urlBase string
	client  *http.Client
}

// NewRexJSONClient creates a JSON client that implements the Rex interface.
// It communicates using JSON requests and responses instead of protobuf messages.
func NewRexJSONClient(addr string, client *http.Client) Rex {
	return &rexJSONClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *rexJSONClient) GetOfferStatuses(ctx context.Context, in *GetOfferStatusesRequest) (*GetOfferStatusesResponse, error) {
	url := c.urlBase + RexPathPrefix + "GetOfferStatuses"
	out := new(GetOfferStatusesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexJSONClient) UpdateOfferStatuses(ctx context.Context, in *UpdateOfferStatusesRequest) (*UpdateOfferStatusesResponse, error) {
	url := c.urlBase + RexPathPrefix + "UpdateOfferStatuses"
	out := new(UpdateOfferStatusesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexJSONClient) GiftOffer(ctx context.Context, in *GiftOfferRequest) (*GiftOfferResponse, error) {
	url := c.urlBase + RexPathPrefix + "GiftOffer"
	out := new(GiftOfferResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexJSONClient) GetClaimableGiftedOffer(ctx context.Context, in *GetClaimableGiftedOfferRequest) (*GetClaimableGiftedOfferResponse, error) {
	url := c.urlBase + RexPathPrefix + "GetClaimableGiftedOffer"
	out := new(GetClaimableGiftedOfferResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexJSONClient) GetGiftedOffersTo(ctx context.Context, in *GetGiftedOffersToRequest) (*GetGiftedOffersToResponse, error) {
	url := c.urlBase + RexPathPrefix + "GetGiftedOffersTo"
	out := new(GetGiftedOffersToResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexJSONClient) GetGiftedOffersFrom(ctx context.Context, in *GetGiftedOffersFromRequest) (*GetGiftedOffersFromResponse, error) {
	url := c.urlBase + RexPathPrefix + "GetGiftedOffersFrom"
	out := new(GetGiftedOffersFromResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rexJSONClient) ClaimGiftedOffer(ctx context.Context, in *ClaimGiftedOfferRequest) (*ClaimGiftedOfferResponse, error) {
	url := c.urlBase + RexPathPrefix + "ClaimGiftedOffer"
	out := new(ClaimGiftedOfferResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ==================
// Rex Server Handler
// ==================

type rexServer struct {
	Rex
	hooks     *twirp.ServerHooks
	ctxSource ContextSource
}

func NewRexServer(svc Rex, hooks *twirp.ServerHooks, ctxSrc ContextSource) TwirpServer {
	defaultHooks := twirp.NewServerHooks()
	if hooks == nil {
		hooks = defaultHooks
	} else {
		if hooks.RequestReceived == nil {
			hooks.RequestReceived = defaultHooks.RequestReceived
		}
		if hooks.RequestRouted == nil {
			hooks.RequestRouted = defaultHooks.RequestRouted
		}
		if hooks.ResponsePrepared == nil {
			hooks.ResponsePrepared = defaultHooks.ResponsePrepared
		}
		if hooks.ResponseSent == nil {
			hooks.ResponseSent = defaultHooks.ResponseSent
		}
		if hooks.Error == nil {
			hooks.Error = defaultHooks.Error
		}
	}
	if ctxSrc == nil {
		ctxSrc = RequestContextSource
	}

	return &rexServer{
		Rex:       svc,
		hooks:     hooks,
		ctxSource: ctxSrc,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *rexServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	// When handling v2 client requests, serve backwards-compatible error responses
	if version := getVersion(ctx); version == "v1" || version == "v2" {
		writeErrorPreV3(ctx, resp, err, s.hooks)
	} else {
		writeErrorPostV3(ctx, resp, err, s.hooks)
	}
}

// RexPathPrefix is used for all URL paths on a twirp Rex server.
// Requests are always: POST RexPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const RexPathPrefix = "/twirp/code.justin.tv.samus.rex.Rex/"

// RexPathPrefixOld is used to handle requests from v2 Clients.
// If you are using an HTTP mux, please handle this routes as well to upgrade from v2 to v3.
const RexPathPrefixOld = "/v2/code.justin.tv.samus.rex.Rex/"

func (s *rexServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := s.ctxSource(resp, req)
	ctx = setServerName(ctx, "Rex")
	ctx = setVersionFromPath(ctx, req.URL.Path)
	ctx = context.WithValue(ctx, "__tw_response_writer", resp) // for SetHTTPResponseHeader
	ctx = s.hooks.RequestReceived(ctx)

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}

	switch req.URL.Path {
	case RexPathPrefix + "GetOfferStatuses", RexPathPrefixOld + "GetOfferStatuses", "/v1/Rex/GetOfferStatuses":
		s.serveGetOfferStatuses(ctx, resp, req)
		return
	case RexPathPrefix + "UpdateOfferStatuses", RexPathPrefixOld + "UpdateOfferStatuses", "/v1/Rex/UpdateOfferStatuses":
		s.serveUpdateOfferStatuses(ctx, resp, req)
		return
	case RexPathPrefix + "GiftOffer", RexPathPrefixOld + "GiftOffer", "/v1/Rex/GiftOffer":
		s.serveGiftOffer(ctx, resp, req)
		return
	case RexPathPrefix + "GetClaimableGiftedOffer", RexPathPrefixOld + "GetClaimableGiftedOffer", "/v1/Rex/GetClaimableGiftedOffer":
		s.serveGetClaimableGiftedOffer(ctx, resp, req)
		return
	case RexPathPrefix + "GetGiftedOffersTo", RexPathPrefixOld + "GetGiftedOffersTo", "/v1/Rex/GetGiftedOffersTo":
		s.serveGetGiftedOffersTo(ctx, resp, req)
		return
	case RexPathPrefix + "GetGiftedOffersFrom", RexPathPrefixOld + "GetGiftedOffersFrom", "/v1/Rex/GetGiftedOffersFrom":
		s.serveGetGiftedOffersFrom(ctx, resp, req)
		return
	case RexPathPrefix + "ClaimGiftedOffer", RexPathPrefixOld + "ClaimGiftedOffer", "/v1/Rex/ClaimGiftedOffer":
		s.serveClaimGiftedOffer(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}
}

func (s *rexServer) serveGetOfferStatuses(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetOfferStatusesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetOfferStatusesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rexServer) serveGetOfferStatusesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetOfferStatuses")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetOfferStatusesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetOfferStatusesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetOfferStatuses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOfferStatusesResponse and nil error while calling GetOfferStatuses. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveGetOfferStatusesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetOfferStatuses")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetOfferStatusesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetOfferStatusesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetOfferStatuses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOfferStatusesResponse and nil error while calling GetOfferStatuses. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveUpdateOfferStatuses(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateOfferStatusesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateOfferStatusesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rexServer) serveUpdateOfferStatusesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateOfferStatuses")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateOfferStatusesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateOfferStatusesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateOfferStatuses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateOfferStatusesResponse and nil error while calling UpdateOfferStatuses. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveUpdateOfferStatusesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateOfferStatuses")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateOfferStatusesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateOfferStatusesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateOfferStatuses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateOfferStatusesResponse and nil error while calling UpdateOfferStatuses. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveGiftOffer(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGiftOfferJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGiftOfferProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rexServer) serveGiftOfferJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GiftOffer")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GiftOfferRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GiftOfferResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GiftOffer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GiftOfferResponse and nil error while calling GiftOffer. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveGiftOfferProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GiftOffer")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GiftOfferRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GiftOfferResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GiftOffer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GiftOfferResponse and nil error while calling GiftOffer. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveGetClaimableGiftedOffer(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetClaimableGiftedOfferJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetClaimableGiftedOfferProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rexServer) serveGetClaimableGiftedOfferJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetClaimableGiftedOffer")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetClaimableGiftedOfferRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetClaimableGiftedOfferResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetClaimableGiftedOffer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetClaimableGiftedOfferResponse and nil error while calling GetClaimableGiftedOffer. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveGetClaimableGiftedOfferProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetClaimableGiftedOffer")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetClaimableGiftedOfferRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetClaimableGiftedOfferResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetClaimableGiftedOffer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetClaimableGiftedOfferResponse and nil error while calling GetClaimableGiftedOffer. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveGetGiftedOffersTo(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftedOffersToJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftedOffersToProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rexServer) serveGetGiftedOffersToJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftedOffersTo")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftedOffersToRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftedOffersToResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftedOffersTo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftedOffersToResponse and nil error while calling GetGiftedOffersTo. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveGetGiftedOffersToProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftedOffersTo")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftedOffersToRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftedOffersToResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftedOffersTo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftedOffersToResponse and nil error while calling GetGiftedOffersTo. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveGetGiftedOffersFrom(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftedOffersFromJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftedOffersFromProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rexServer) serveGetGiftedOffersFromJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftedOffersFrom")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftedOffersFromRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftedOffersFromResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftedOffersFrom(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftedOffersFromResponse and nil error while calling GetGiftedOffersFrom. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveGetGiftedOffersFromProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftedOffersFrom")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftedOffersFromRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftedOffersFromResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftedOffersFrom(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftedOffersFromResponse and nil error while calling GetGiftedOffersFrom. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveClaimGiftedOffer(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveClaimGiftedOfferJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveClaimGiftedOfferProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *rexServer) serveClaimGiftedOfferJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ClaimGiftedOffer")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ClaimGiftedOfferRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ClaimGiftedOfferResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ClaimGiftedOffer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ClaimGiftedOfferResponse and nil error while calling ClaimGiftedOffer. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) serveClaimGiftedOfferProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ClaimGiftedOffer")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ClaimGiftedOfferRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ClaimGiftedOfferResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ClaimGiftedOffer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ClaimGiftedOfferResponse and nil error while calling ClaimGiftedOffer. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *rexServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *rexServer) ProtocGenTwirpVersion() string {
	return "v4.9.0"
}

// =====
// Utils
// =====

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshaled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// A ContextSource establishes the base context for a Server.
type ContextSource func(http.ResponseWriter, *http.Request) context.Context

var RequestContextSource ContextSource = func(w http.ResponseWriter, req *http.Request) context.Context {
	return req.Context()
}

var BackgroundContextSource ContextSource = func(http.ResponseWriter, *http.Request) context.Context {
	return context.Background()
}

// done returns ctx.Err() if ctx.Done() indicates that the context done
func done(ctx context.Context) error {
	select {
	case <-ctx.Done():
		return ctx.Err()
	default:
		return nil
	}
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
// NOTE: not compatible with old v1/v2 clients (only returns v3+ errors)
func WriteError(resp http.ResponseWriter, err error) {
	writeErrorPostV3(nil, resp, err, nil) // does not trigger server hooks
}

// writeErrorPostV3 writes Twirp v3+ errors in the response.
func writeErrorPostV3(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	if hooks != nil {
		ctx = setStatusCode(ctx, statusCode)
		ctx = hooks.Error(ctx, twerr)
	}

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, err2 := resp.Write(respBody)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}

	if hooks != nil {
		_ = hooks.ResponseSent(ctx)
	}
}

// writeErrorPreV3 writes Twirp v1/v2 backwards-compatible errors in the response.
// This is to make it easy to upgrade to v3, a v3 server keeps serving v2-style errors to v2 clients.
func writeErrorPreV3(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Unknown 500 (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.NewError(twirp.Unknown, err.Error())
	}

	resp.Header().Set("Content-Type", "text/plain")

	// v2err.Retryable <= v3err.Meta("retryable")
	if twerr.Meta("retryable") != "" {
		resp.Header().Set("Twirp-Error-Retryable", "true")
	}

	// v2err.ErrorID <= v3err.Meta("v2_error_id") if present, otherwise v3err.Code()
	// or "unroutable" if generated from twirp router (BadRoute)
	var v2ErrorID string
	if twerr.Code() == twirp.BadRoute {
		v2ErrorID = "unroutable" // as was generated by previous router
	} else if twerr.Meta("v2_error_id") != "" {
		v2ErrorID = twerr.Meta("v2_error_id")
	} else {
		v2ErrorID = string(twerr.Code()) // the string-format of v3 codes match v2 error ids for the most part: i.e. "not_found", "internal", "unknown", "canceled", etc.
	}
	resp.Header().Set("Twirp-ErrorID", v2ErrorID)

	// v2err.StatusCode <= v3err.Meta("v2_status_code") if present, otherwise same as in v3
	statusCode, err := strconv.Atoi(twerr.Meta("v2_status_code"))
	if err != nil {
		statusCode = twirp.ServerHTTPStatusFromErrorCode(twerr.Code()) // v3 it's the same as v2 for the most part: i.e. "not_found" is 404
	}
	if hooks != nil {
		ctx = setStatusCode(ctx, statusCode)
		ctx = hooks.Error(ctx, twerr)
	}
	resp.WriteHeader(statusCode)

	msg := []byte(twerr.Msg())
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}
	_, err2 := resp.Write(msg)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}

	if hooks != nil {
		_ = hooks.ResponseSent(ctx)
	}
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// setMethodName, setServerName, and setStatusCode are functions to
// expose internal state through contexts. The context keys hardcoded
// in here are not to be used on their own. Twirp provides accessor
// functions which will retrieve these values out and give them the
// correct type for you.
func setMethodName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_method_name", name)
}
func setServerName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_service_name", name)
}
func setStatusCode(ctx context.Context, code int) context.Context {
	return context.WithValue(ctx, "__tw_status_code", strconv.Itoa(code))
}

type privateContextKey int

var versionKey = new(privateContextKey)

// setVersionFromPath adds "v1", "v2" or "v3" to the context depending on the path.
func setVersionFromPath(ctx context.Context, path string) context.Context {
	var version string
	if strings.HasPrefix(path, "/v1/") {
		version = "v1"
	} else if strings.HasPrefix(path, "/v2/") {
		version = "v2"
	} else {
		version = "v3"
	}
	return context.WithValue(ctx, versionKey, version)
}

// getVersion returns the version number ("v1", "v2", "v3") or empty string if unset.
func getVersion(ctx context.Context) string {
	v, _ := ctx.Value(versionKey).(string)
	return v
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := ctx.Value("__tw_request_header").(http.Header)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// closebody closes a response or request body and just logs
// any error encountered while closing, since errors are
// considered very unusual.
func closebody(body io.Closer) {
	if err := body.Close(); err != nil {
		log.Printf("error closing body: %q", err)
	}
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v4.9.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients dont't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtoRequest is common code to make a request to the remote twirp service.
func doProtoRequest(ctx context.Context, client *http.Client, url string, in, out proto.Message) error {
	var err error
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client *http.Client, url string, in, out proto.Message) error {
	var err error
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

var twirpFileDescriptor0 = []byte{
	// 958 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0x4f, 0x8f, 0xdb, 0x44,
	0x14, 0x67, 0xec, 0x24, 0xed, 0xbe, 0x94, 0x95, 0xfb, 0xd0, 0x6e, 0x5d, 0x57, 0x5a, 0x56, 0xa6,
	0xb4, 0x51, 0x2a, 0x5c, 0x35, 0x2d, 0x52, 0x29, 0x08, 0x91, 0x6e, 0x26, 0x21, 0xa2, 0x75, 0x60,
	0xe2, 0x88, 0xa5, 0x07, 0xac, 0x34, 0x99, 0x94, 0xd0, 0xcd, 0x7a, 0xb1, 0x27, 0xcb, 0xae, 0xc4,
	0x01, 0x71, 0xe1, 0xc6, 0x19, 0x71, 0xe5, 0x2b, 0xf1, 0x01, 0xf8, 0x08, 0x9c, 0x38, 0x70, 0x42,
	0x9e, 0x38, 0xa9, 0x13, 0xff, 0x61, 0x37, 0xf4, 0xb0, 0xb7, 0xcc, 0x9b, 0xf7, 0x7e, 0xef, 0xf7,
	0xfe, 0xf9, 0x4d, 0x60, 0xcb, 0x3f, 0x1a, 0xdc, 0xf5, 0xf9, 0x89, 0x1b, 0x70, 0xff, 0x78, 0x3c,
	0xe0, 0xd6, 0x91, 0xef, 0x09, 0x0f, 0xf5, 0x81, 0x37, 0xe4, 0xd6, 0xb7, 0xd3, 0x40, 0x8c, 0x0f,
	0x2d, 0x71, 0x6c, 0x05, 0xfd, 0xc9, 0x34, 0xb0, 0x7c, 0x7e, 0x62, 0x7e, 0x05, 0xd7, 0x5a, 0x5c,
	0x74, 0x46, 0x23, 0xee, 0x77, 0x45, 0x5f, 0x4c, 0x03, 0x1e, 0x30, 0xfe, 0xdd, 0x94, 0x07, 0x02,
	0x4d, 0xb8, 0x22, 0xbe, 0x1f, 0x8b, 0xc1, 0x37, 0xbd, 0x80, 0xfb, 0xed, 0x86, 0x4e, 0x76, 0x49,
	0x65, 0x83, 0x2d, 0xc9, 0xd0, 0x80, 0xcb, 0x5e, 0x68, 0xdb, 0x6e, 0x04, 0xba, 0xb2, 0xab, 0x56,
	0x36, 0xd8, 0xe2, 0x6c, 0xfe, 0x45, 0x40, 0x4f, 0x62, 0x07, 0x47, 0xde, 0x61, 0xc0, 0xf1, 0x25,
	0xbc, 0xe9, 0xc5, 0x2f, 0x74, 0xb2, 0xab, 0x56, 0xca, 0x35, 0x6a, 0x65, 0x31, 0xb5, 0xb2, 0xa0,
	0xac, 0x25, 0x29, 0x3d, 0x14, 0xfe, 0x29, 0x5b, 0xc6, 0x36, 0x5e, 0x00, 0x26, 0x95, 0x50, 0x03,
	0xf5, 0x25, 0x3f, 0x8d, 0xc2, 0x0a, 0x7f, 0xe2, 0x87, 0x50, 0x3c, 0xee, 0x1f, 0x4c, 0xb9, 0xae,
	0xec, 0x92, 0xca, 0x66, 0xed, 0xdd, 0x6c, 0x32, 0x31, 0x38, 0x36, 0xb3, 0x79, 0xa4, 0x3c, 0x24,
	0xe6, 0xaf, 0x0a, 0x18, 0xbd, 0xa3, 0x61, 0x5f, 0xf0, 0xb5, 0x33, 0x3a, 0x59, 0x4d, 0x8c, 0x22,
	0x13, 0xd3, 0xca, 0xe6, 0x92, 0xed, 0xf0, 0x22, 0xa5, 0xe6, 0x6f, 0x02, 0x37, 0x52, 0x99, 0x46,
	0x0d, 0x71, 0x98, 0xde, 0x10, 0x9f, 0x9e, 0x33, 0xee, 0x8b, 0xd7, 0x13, 0xbf, 0x11, 0x28, 0xb4,
	0xc6, 0x23, 0x81, 0xdb, 0x50, 0x7a, 0x31, 0x1e, 0x89, 0x45, 0xdd, 0xa3, 0x13, 0x22, 0x14, 0x46,
	0xbe, 0x37, 0x91, 0x0e, 0x36, 0x98, 0xfc, 0x8d, 0x3a, 0x5c, 0x8a, 0xe6, 0x48, 0x57, 0xa5, 0x78,
	0x7e, 0xc4, 0x4d, 0x50, 0x84, 0xa7, 0x17, 0xa4, 0x50, 0x11, 0x1e, 0x7e, 0x04, 0xa5, 0x40, 0xfa,
	0xd4, 0x8b, 0x92, 0xe0, 0xcd, 0x9c, 0x09, 0x1a, 0x8f, 0x44, 0xc4, 0x2f, 0xb2, 0x31, 0x7f, 0x24,
	0xa0, 0x85, 0x62, 0xc9, 0x7d, 0xde, 0xa6, 0x55, 0xd0, 0x42, 0x12, 0x4e, 0xb2, 0x55, 0x13, 0xf2,
	0x38, 0x51, 0x65, 0x99, 0xe8, 0x2d, 0xd8, 0x14, 0xde, 0x12, 0xc6, 0x2c, 0x92, 0x15, 0xa9, 0xf9,
	0x33, 0x81, 0xab, 0x31, 0x0a, 0x51, 0x3b, 0xd4, 0xa0, 0x10, 0xa6, 0x47, 0xfa, 0x2d, 0xd7, 0x76,
	0xf2, 0x83, 0x62, 0x52, 0x17, 0x3f, 0x86, 0x22, 0xf7, 0x7d, 0xcf, 0x8f, 0x4a, 0x55, 0xc9, 0x37,
	0x92, 0xfe, 0x68, 0xa8, 0xcf, 0x66, 0x66, 0xe6, 0xd7, 0xb0, 0xd3, 0xe2, 0x62, 0xef, 0xa0, 0x3f,
	0x9e, 0xf4, 0x9f, 0x1f, 0xf0, 0x50, 0x89, 0x0f, 0x97, 0x32, 0x73, 0x96, 0x01, 0xce, 0xcc, 0x88,
	0xd9, 0x83, 0xb7, 0x33, 0xf1, 0xd7, 0x0f, 0xdb, 0x7c, 0x06, 0x46, 0x8b, 0x8b, 0x18, 0x5a, 0xd0,
	0xf4, 0xbd, 0xc9, 0xeb, 0xa1, 0xdc, 0x85, 0x1b, 0xa9, 0xd8, 0x11, 0xdd, 0x07, 0x50, 0x0c, 0x29,
	0xcc, 0x87, 0xf5, 0xbf, 0xf8, 0xce, 0x94, 0xcd, 0x7d, 0xb9, 0x17, 0xe2, 0xa0, 0x8e, 0xf7, 0x7a,
	0xe8, 0x7e, 0x01, 0xd7, 0x53, 0x90, 0xff, 0x17, 0xd9, 0x1e, 0x5c, 0x93, 0x15, 0x4b, 0xe9, 0x86,
	0xac, 0x81, 0x5e, 0x8d, 0x41, 0x49, 0xc6, 0x60, 0xfe, 0x4e, 0x40, 0x4f, 0xe2, 0x46, 0x4c, 0x3f,
	0x81, 0xf2, 0x20, 0xbc, 0xe3, 0xc3, 0xd6, 0xd9, 0x9b, 0x21, 0x6e, 0x82, 0x74, 0x79, 0x14, 0xee,
	0x66, 0xdb, 0xae, 0x92, 0x88, 0x4f, 0x44, 0xf5, 0x11, 0x94, 0x63, 0x5f, 0x35, 0xbc, 0x0c, 0x05,
	0xbb, 0x63, 0x53, 0xed, 0x0d, 0x04, 0x28, 0xf5, 0xec, 0x2e, 0xa5, 0xb6, 0x46, 0x42, 0xa9, 0xfc,
	0xa5, 0x60, 0x19, 0x2e, 0xed, 0x3d, 0xa9, 0xb7, 0x9f, 0xd2, 0x86, 0xa6, 0x56, 0x19, 0xc0, 0xab,
	0x0f, 0x0e, 0x1a, 0xb0, 0xdd, 0x6a, 0x37, 0x1d, 0x57, 0xde, 0xbb, 0x5d, 0xa7, 0xee, 0xf4, 0xba,
	0x6e, 0x04, 0xb6, 0x0d, 0x18, 0xbb, 0xfb, 0x9c, 0xda, 0x8d, 0xb6, 0xdd, 0xd2, 0x08, 0x6a, 0x70,
	0xe5, 0x95, 0x9c, 0x36, 0x34, 0xa5, 0xfa, 0x27, 0x81, 0xcd, 0xe5, 0xd9, 0xc5, 0xeb, 0xb0, 0x25,
	0x95, 0x3a, 0xcd, 0x26, 0x65, 0x2e, 0x65, 0xac, 0xc3, 0xe6, 0xb8, 0x26, 0xec, 0x24, 0xae, 0x7a,
	0xf6, 0x67, 0x76, 0xe7, 0x4b, 0x7b, 0x76, 0xd2, 0x08, 0x56, 0xe0, 0x66, 0x42, 0x67, 0xe6, 0x94,
	0xd1, 0xba, 0xd3, 0xee, 0xcc, 0x35, 0x15, 0xac, 0x81, 0x95, 0xd0, 0x94, 0xcc, 0xea, 0x8f, 0x9f,
	0xd0, 0x54, 0x1b, 0x15, 0xef, 0xc1, 0x7b, 0x09, 0x9b, 0xa7, 0xf5, 0x7d, 0xa9, 0xdd, 0x75, 0x9b,
	0x1d, 0x36, 0xbf, 0xd9, 0xdf, 0xa3, 0xb4, 0x41, 0x1b, 0x5a, 0xa1, 0xfa, 0x07, 0x81, 0xad, 0xd4,
	0x9a, 0x2c, 0x22, 0x9d, 0xa5, 0x29, 0x35, 0xd2, 0xf8, 0xd5, 0x6a, 0xa4, 0xb7, 0xc0, 0x4c, 0x33,
	0x77, 0xe9, 0x7e, 0xbb, 0xeb, 0x50, 0xdb, 0x91, 0xa4, 0x34, 0x05, 0xef, 0xc0, 0xed, 0x24, 0x56,
	0x97, 0x32, 0xb7, 0xd1, 0xa1, 0x61, 0xc9, 0x1c, 0x37, 0x44, 0x95, 0xca, 0x2a, 0xde, 0x86, 0x77,
	0x12, 0xca, 0x52, 0x10, 0xea, 0x2d, 0xb2, 0xa3, 0x15, 0x6a, 0xff, 0x94, 0x40, 0x65, 0xfc, 0x04,
	0x4f, 0x41, 0x5b, 0x7d, 0xc8, 0xe1, 0xbd, 0xf3, 0x3c, 0xfa, 0xe4, 0xe8, 0x19, 0xb5, 0xf3, 0xbf,
	0x13, 0xf1, 0x27, 0x02, 0x6f, 0xa5, 0xbc, 0x19, 0xf0, 0xc1, 0x3a, 0x4f, 0x2b, 0xe3, 0xfd, 0xb5,
	0x1e, 0x26, 0x38, 0x84, 0x8d, 0x45, 0x03, 0x63, 0xf5, 0x0c, 0x1b, 0x6a, 0xee, 0xef, 0xce, 0x99,
	0x74, 0x23, 0x2f, 0xbf, 0x10, 0xf9, 0xac, 0x4f, 0x5b, 0x35, 0xf8, 0x30, 0x37, 0x75, 0x39, 0xdb,
	0xcf, 0xf8, 0x60, 0x0d, 0xcb, 0x88, 0xd0, 0x0f, 0x70, 0x35, 0xf1, 0x61, 0xc6, 0xfc, 0x22, 0xa6,
	0xee, 0x07, 0xe3, 0xfe, 0xb9, 0x6c, 0x62, 0x95, 0x4f, 0x59, 0x63, 0x79, 0x95, 0xcf, 0xde, 0xa8,
	0x79, 0x95, 0xcf, 0xdb, 0x95, 0xa7, 0xa0, 0xad, 0xce, 0x75, 0x5e, 0xe7, 0x67, 0x2c, 0x9d, 0xbc,
	0xce, 0xcf, 0xda, 0x27, 0x8f, 0x8b, 0xcf, 0x54, 0x9f, 0x9f, 0x3c, 0x2f, 0xc9, 0x3f, 0x83, 0xf7,
	0xff, 0x0d, 0x00, 0x00, 0xff, 0xff, 0xf2, 0xac, 0x69, 0x5d, 0x25, 0x0e, 0x00, 0x00,
}
