# offer-tracking-service-client
### Testing
1. ```git checkout -b <new-branch-name>```
2. Make your initial pass of changes in the client
3. git push origin --set-upstream origin <new-branch-name>
4. Go to https://git-aws.internal.justin.tv/samus/offer-tracking-service-client
5. Create a new pull request
6. Switch to the `Commits` tab
7. Copy last commit hash
8. Go to your local visage
9. Update code.justin.tv/samus/offer-tracking-service-client in glide.yaml to point to the hash you copied above
10. `glide install` in Visage
11. `make upgrade` in Visage
12. `make clients` in Visage
13. `make dev` in Visage
14. Navigate to localhost:8080/gql/explorer
15. Query
16. If more changes are needed it is easier to change them in `/Users/mchenryz/goworkspace/src/code.justin.tv/edge/visage/__vendor/code.justin.tv/samus/offer-tracking-service-client/client/samus_offer_status.go`
17. Restart using `Ctrl-C` and `make dev`
18. Repeat from step 15

###### Note
You may need to log into twitch.tv to grab the twitch-user cookie and save that in your own application cookies for localhost so that you can make queries with a signed in user.


### Sample Queries
##### Get Offer Status
```
query primeoffers {
  primeOffers {
    id
    self {
      status
    }
  }
}
```

##### Update Offer Status
note: change the offerID and userID below
```
mutation updateSeen {
  updatePrimeOfferStatus(input: {statusChanges: [{offerID: "c0b1816d-300b-d234-828e-59e76119bffe", status:"SEEN"}], userID: "160142933"}) {
    self {
      status
    }
  }
}
```