# prime-extension
Front-End Application code for the Prime Subscription and Loot Reminder extension. You might know it by one of the following names: Prime extension, Twitch Prime extension, Prime Gaming extension.

## Getting Started

- Clone this repo and install dependencies with `npm install`.
- Ensure your `/etc/hosts` file has a mapping from "localhost.twitch.tv" to "127.0.0.1". 
- Before running your code locally, you need to create your own test version of the extension. To do this, you’ll need access to a shared account on the Twitch Developer Portal which owns the extension.
  - Go to "https://odin.amazon.com/#view/materialSet/com.amazon.samus.extension.twitch.developer.account" and click the “Add a Destination” button to add your dev desktop to the set of machines allowed to access these credentials. 
    - Your dev desktop name should be of the form `DEV-DSK-<yourAmazonAlias\>`.
  - SSH to your dev desktop.
  - Execute `odin-get com.amazon.samus.extension.twitch.developer.account` to view the credentials. 
- With access to the shared Twitch Developer Account, you can create your own test version of the extension.
  - Visit "https://dev.twitch.tv/" and log in with the credentials obtained in the previous step.
  - This account has 2fa enabled.  Contact nicokuhn@ to get the verification code.
  - Click "Your Dashboard" -> "Extensions" -> "Prime Channel Subscription Reminder" -> "Version" -> "Create New Version" and name your new version one number higher than the previous "In Development" version. 
- There are two alterations that need to be made to your test extension.
  - Click "Manage" next to your new version -> "Asset Hosting" -> and under "Live Config Path", paste in "live_config.html".
  - Click "Access" from the panel on the left and enter in your Twitch account's ID. You can get this by entering `/user <twitchUsername\>` in Slack. 
    - You'll also want to [add this username/ID pair to the "testing-accounts.csv"](#adding-testing-accounts) file present in the root of this repository. 
- Before you can test the extension, you need to install your version on a channel.  You can either install it on your own channel or use a QA account.
  - Go to `https://www.twitch.tv/<twitchUsername\>/dashboard/extensions`
  - Click on the "Invite Only" tab
  - You should see many instances of the "Prime Channel Subscription Reminder".  Each of these represents a version.  Find your version.  (If you hover over each card and then hover over the details button, you can see the version number at the end of the URL that it's going to take you to)
  - Click "Install"
  - You'll see a success modal with an option to configure.  You don't need to do this (but clicking "Configure" takes you to our `config.html`).  Close the modal.
  - Click on the "My Extensions" tab
  - Click the "Activate" dropdown.  You can install the extension either in overlay or component mode.  In overlay mode, we set where the extension shows up on the screen (configurable from the `live_config.html`).  In component mode, you can put the extension anywhere you like.  To view the extension on your stream, you'll need to install whichever extension type you intend to run locally.  So, install it as an overlay if you're going to run `npm run overlay`.
- You can now start your local instance! Make sure to navigate to "https://localhost.twitch.tv:8080/" and proceed through any security warnings before testing your changes however. Note that you may have to do this periodically as these security warnings reappear. You may need to redo this step if you are suddenly not seeing the extension appear, for instance.  We have live update functionality for the code, so you can make changes without killing and restarting your server.  Only exception is when new files are added. 
- Below is an example for running the live_config UI.
  - Start your local server with `npm run live_config`.
  - Visit `www.twitch.tv/<twitchUsername\>/dashboard/live` - you'll see a message stating that this is a test extension that has not been evaluated.  Click "Accept"
  - You should see your local version of the extension running under the Extensions menu.
- To run the actual extension on Twitch
  - Start your local service with `npm run [overlay|component]`
  - Start streaming using OBS - Download [OBS For Mac](https://obsproject.com/) and you can enter your stream key that you get from your Twitch Dashboard. Here's a [help guide](https://mirillis.com/blog/en/where-is-my-twitch-stream-key-2018-update/) if you cant find your key.
  - On your channel (`www.twitch.tv/<twitchUsername\>`) you should see a crown icon in the lower middle portion of the screen.  Click on that.
  - You'll see a message stating that this is a test extension that has not been evaluated.  Click "Accept".
  - You should now see your extension appear
- To run the config UI
  - Start your local service with `npm run config`
  - Go to `https://www.twitch.tv/<twitchUsername\>/dashboard/extensions/manage`
  - Click on the "Settings" gear icon on your version of the extension.


## Writing Tests Best Practices
We should NOT be writing any new snapshot test going forward, only write shallow tests.

When updating the extension, if an existing snapshot test fails, it should be REPLACED with a shallow test rather than updated to pass.

## Common Development Commands

Install dependencies.
```
$ npm install
```

Run the development server for component, overlay, config, or live_config applications. The server will run at `https://localhost.twitch.tv:8080/`. Make sure to set up your /etc/hosts correctly per Twitch onboarding.

```
$ npm run [component|overlay|config|live_config]
```

Run tests with the following command(s). Ensure these commands exit with a status of 0 before merging.
```
$ npm test
```

Create a zip file to upload to Twitch's CDN for a hosted test.  This runs the test and zips up all the files needed to deploy the extension.  The zip file will live in the `dist/` folder as "extension.zip".  
```
npm run zip
```


### Credentials
| Material | Odin Link |
|-------------|--------|
| Dev Account   | https://odin.amazon.com/#view/materialSet/com.amazon.samus.extension.twitch.developer.account |
| JWT Credentials | https://odin.amazon.com/#view/materialSet/com.amazon.samus.extension.jwt.credentials |

### Using Date Override
1. Add your Twitch UserID to the whitelist of TUIDs in CommunityService - there's a table called "TestUsers"
2. Inspect extension to open developer tools
3. Add &dateOverride=\<desiredDate\> to the iframe URL (e.g. &dateOverride=2018-06-07T00:05:00Z)
4. ...
5. Profit

## Release Process
Extensions are released differently from any of our Amazon or Twitch services.  When we have a set of features ready to go out, whoever is in charge of the release will follow these steps:
- On your machine, make sure you've pulled all the changes.
- Run `npm run zip`
- Create a new version of the extension using the same process as defined in the [Getting Started](#getting-started) section
- Update things like
  - [Screenshots for the extension](#adding-screenshots) (THESE WILL ONLY CHANGE FOR LIVE CUSTOMERS WHEN A NEW VERSION OF THE EXTENSION IS RELEASED - this is important because just updating them will not make them live)
  - [Whitelist for test accounts](#how-to-manage-access) (copy in the list of tuids from "testing-accounts.csv")
  - [Whitelist for channels that can install](#how-to-manage-access) (CAREFUL WITH THIS, THIS IS ONLY EDITABLE IN TEST MODE BUT WILL STILL APPLY TO THE APPLICATION AFTER RELEASE)
  - Various version details
- Open up the "Version Asssets" section of your new version of the extension.
- Click on "Choose File" and select "extension.zip" from the `dist/` directory that was created when you ran `npm run zip`
- Click the "Upload Assets" button.
- When this is complete, your version is hosted and changes you make locally will no longer have an affect.  You should test this version on your own channel and by running the automated tests.
  - Automated tests live in [SamusSeleniumExtensionTests](https://code.amazon.com/packages/SamusSeleniumExtensionTests/trees/mainline).  To run them, install your version of the extension on the test accounts and then run the tests.
- If you need to change the zip file, go to the "Version Status" section and click "Return to Testing".  You can then follow the steps above again.
- If QA has signed off on the hosted version and the tests are passing, you're ready for review!  On the "Version Status" page, there is a "Mark in Review" button.  Click this.
- Twitch will now review our code to make sure we're in compliance with their standards.  This process takes about a day, but can be sped up if urgent.  Ping #extensions-feedback in slack if you need help.
- We'll get an e-mail when Twitch has approved our extension for release.  When this happens, go back to the "Version Status" page.  There will be a new button that says "Release".  Click this button.
- The new version of the extension is now live!

## How to manage Access

- The Extension Version management page has a tab called 'Access' that is used for. This contains two options:

  1. The Whitelist for Broadcasters:

    ```Comma-separated list of broadcaster account IDs allowed to install this extension after release. If this is empty or missing, all broadcasters can use this extension.```

  2. The Access List for Testing:

    ```Testing Accounts```

[Screenshot](https://drive.corp.amazon.com/documents/rrieblin@/public/access_page.png)

- We don't use the Broadcasters whitelist right now because we want all users to be able to install the extension.
- The testing accounts section can be used when you move to hosted mode and want to be able to have QA or any other accounts use the Extension before official release

## Adding Screenshots
- There is tab on the top navigation bar that allows you to add or remove screenshots for the Extension.
- These apply to all versions of the extension.
- You must update this BEFORE submitting the version for release if you want the new screenshots to be applied.

[Screenshot](https://drive.corp.amazon.com/documents/rrieblin@/public/screenshots.png)

## Adding Testing accounts
Add the username & userID to `testing-accounts.csv` (to track), then go to the dev.twitch.tv dashboard for your extension version, go to the 'access' section, and copy and paste all of the test accounts into the 'testing accounts' field.
