import configureMockStore from 'redux-mock-store';
import * as Types from 'core/types/CommunityService';
import * as fetchMock from 'fetch-mock';
import { GET_OVERLAY_EXTENSION_LOCATION_URL, OVERLAY_EXTENSION_URL, SET_OVERLAY_EXTENSION_LOCATION_URL, SPEND_SUBSCRIPTION_CREDIT_URL } from 'core/clients/constants';
import CommunityServiceClient from 'core/clients/CommunityServiceClient';

describe('CommunityServiceClient', () => {

  afterEach(() => {
    fetchMock.reset();
    fetchMock.restore();
  });

  describe('GetOverlayExtension', () => {

    it('returns a Promise that resolves to the desired data.', () => {
      const jwt = 'jwt';
      const locale = 'locale';
      const dateOverride = '2018-04-05T00:00:00Z';
      const expectedData = { some: 'stuff' };
      fetchMock.post(OVERLAY_EXTENSION_URL, { body: expectedData });

      return CommunityServiceClient.GetOverlayExtension({ jwt, locale, dateOverride }).then(response => {
        expect(response.ok).toBeTruthy();
        expect(response.status).toEqual(200);
        return response.json();
      }).then(receivedData => {
        expect(receivedData).toEqual(expectedData);
      });
    });

  });

  describe('SpendSubscriptionCredit', () => {

    it('returns a Promise that resolves to the desired data', () => {
      const jwt = 'jwt';
      const expectedData = { some: 'stuff' };
      fetchMock.post(SPEND_SUBSCRIPTION_CREDIT_URL, { body: expectedData });

      return CommunityServiceClient.SpendSubscriptionCredit({ jwt }).then(response => {
        expect(response.ok).toBeTruthy();
        expect(response.status).toEqual(200);
        return response.json();
      }).then(receivedData => {
        expect(receivedData).toEqual(expectedData);
      });
    });

  });

  describe('GetOverlayExtensionLocation', () => {

    it('returns a Promise that resolves to the desired data', () => {
      const jwt = 'jwt';
      const expectedData = { some: 'stuff' };
      fetchMock.post(GET_OVERLAY_EXTENSION_LOCATION_URL, { body: expectedData });

      return CommunityServiceClient.GetOverlayExtensionLocation({ jwt }).then(response => {
        expect(response.ok).toBeTruthy();
        expect(response.status).toEqual(200);
        return response.json();
      }).then(receivedData => {
        expect(receivedData).toEqual(expectedData);
      });
    });
  });

  describe('SetOverlayExtensionLocation', () => {

    it('returns a Promise that resolves to the desired data', () => {
      const jwt = 'jwt';
      const location = Types.Location.TOP_RIGHT;
      const expectedData = { some: 'stuff', extensionLocation: location };
      fetchMock.post(SET_OVERLAY_EXTENSION_LOCATION_URL, { body: expectedData });

      return CommunityServiceClient.SetOverlayExtensionLocation({ jwt, location }).then(response => {
        expect(response.ok).toBeTruthy();
        expect(response.status).toEqual(200);
        return response.json();
      }).then(receivedData => {
        expect(receivedData).toEqual(expectedData);
      });
    });
  });

});
