import configureMockStore from 'redux-mock-store';
import * as fetchMock from 'fetch-mock';
import { TWITCH_USERS_URL } from 'core/clients/constants'
import TwitchClient from 'core/clients/TwitchClient';

describe('TwitchClient', () => {

  afterEach(() => {
    fetchMock.reset();
    fetchMock.restore();
  });

  describe('GetStreamerContext', () => {

    it('returns a Promise that resolves to the desired data.', () => {
      const channelID = 'channelID';
      const expectedData = { some: 'stuff' };
      fetchMock.get(TWITCH_USERS_URL + "?id=" + channelID, { body: expectedData });

      return TwitchClient.GetStreamerContext({ channelID }).then(response => {
        expect(response.ok).toBeTruthy();
        expect(response.status).toEqual(200);
        return response.json();
      }).then(receivedData => {
        expect(receivedData).toEqual(expectedData);
      });
    });

  });
})
