import { communityService } from 'core/store/modules/CommunityService/reducer';
import { Location } from "core/types/CommunityService";
import * as types from 'core/store/modules/CommunityService/constants';
import * as MockDate from "mockdate";

describe('CommunityService module reducer', () => {

  it('returns the initial state', () => {
    expect(
      communityService(undefined, {}),
    ).toEqual(
      null,
    );
  });

  it('handles FETCH_OVERLAY_EXTENSION', () => {
    const expectedState = {
      hasIdentitySharingEnabled: false,
      user: {
        hasPrime: false,
        twitchUserId: undefined,
        credit: {
          balance: -1,
          locale: undefined,
          message: 'No credit yet!'
        },
      },
      loot: {
        locale: undefined,
        message: 'No loot yet!',
        imageUrl: undefined,
        destinationLink: undefined
      },
      signup: {
        destinationLink: undefined
      },
      location: Location.TOP_RIGHT,
    };
    const action = {
      type: types.FETCH_OVERLAY_EXTENSION,
      payload: {
        extensionData: {
          hasIdentitySharingEnabled: false,
          user: {
            hasPrime: false,
            twitchUserId: undefined,
            credit: {
              balance: -1,
              locale: undefined,
              message: 'No credit yet!'
            },
          },
          loot: {
            locale: undefined,
            message: 'No loot yet!',
            imageUrl: undefined,
            destinationLink: undefined
          },
          signup: {
            destinationLink: undefined
          },
          location: Location.TOP_RIGHT,
        }
      }
    };
    expect(
      communityService(undefined, action)
    ).toEqual(
      expectedState
    );
  });

  it('handles SPEND_SUBSCRIPTION_CREDIT', () => {
    MockDate.set("5/12/2018");
    const expectedState = {
      user: {
        credit: {
          balance: 0,
          subscribed: true
        },
        lastSpend: {
          channel: "ninja",
          timestamp: Date.now(),
        }
      },
    };
    const action = {
      type: types.SPEND_SUBSCRIPTION_CREDIT,
      payload: {
        balance: 0,
        channelId: "ninja"
      }
    };
    expect(
      communityService(undefined, action)
    ).toEqual(
      expectedState
    );
  });

  it('merges user data for SPEND_SUBSCRIPTION_CREDIT', () => {
    MockDate.set("5/12/2018");
    const expectedState = {
      user: {
        hasPrime: true,
        credit: {
          locale: "en-US",
          message: "",
          balance: 0,
          subscribed: true
        },
        lastSpend: {
          channel: "ninja",
          timestamp: Date.now(),
        },
      },
    };
    const state = {
      user: {
        hasPrime: true,
        credit: {
          locale: "en-US",
          message: "",
          balance: 1
        }
      }
    };
    const action = {
      type: types.SPEND_SUBSCRIPTION_CREDIT,
      payload: {
        balance: 0,
        channelId: "ninja"
      }
    };
    expect(
      communityService(state, action)
    ).toEqual(
      expectedState
    );
  });

  it("handles GET_OVERLAY_EXTENSION_LOCATION", () => {
    const expectedState = {
      location: Location.TOP_LEFT
    };
    const action = {
      payload: {
        location: Location.TOP_LEFT,
      },
      type: types.GET_OVERLAY_EXTENSION_LOCATION,
    };
    expect(
      communityService(undefined, action),
    ).toEqual(
      expectedState,
    );
  });
});
