import configureStore from 'redux-mock-store';
import * as actions from 'core/store/modules/Display/actions';
import * as types from 'core/store/modules/Display/constants';
import middleware from 'core/store/middleware';

describe('Display module actions', () => {

  describe('creators', () => {
    it('creates an action to dismiss the application.', () => {
      const expectedAction = {
        type: types.DISMISS,
      };
      const receivedAction = actions.dismiss();

      expect(receivedAction).toEqual(expectedAction);
    });

    it('creates an action to toggle the expanded state of the application.', () => {
      const expectedAction = {
        type: types.TOGGLE_IS_EXPANDED,
      };
      const receivedAction = actions.toggleIsExpanded();

      expect(receivedAction).toEqual(expectedAction);
    });

    it('creates an action to set the type of the extension', () => {
      const expectedAction = {
        type: types.SET_EXTENSION_TYPE,
      };
      const receivedAction = actions.setTypeOfExtension();

      expect(receivedAction).toEqual(expectedAction);
    });
  });

  describe('store integration', () => {

    function setUp() {
      const mockStore = configureStore(middleware)({});

      return { mockStore };
    }

    it('dispatches a DISMISS action.', () => {
      const { mockStore } = setUp();

      // Critical statement.
      mockStore.dispatch(actions.dismiss())

      const expectedActions = [{
        type: types.DISMISS
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });

    it('dispatches a TOGGLE_IS_EXPANDED action.', () => {
      const { mockStore } = setUp();

      // Critical statement.
      mockStore.dispatch(actions.toggleIsExpanded());

      const expectedActions = [{
        type: types.TOGGLE_IS_EXPANDED,
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });

    it('dispatches a SET_EXTENSION_TYPE action.', () => {
      const { mockStore } = setUp();

      // Critical statement.
      mockStore.dispatch(actions.setTypeOfExtension());

      const expectedActions = [{
        type: types.SET_EXTENSION_TYPE,
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });
  });

});
