import { display } from 'core/store/modules/Display/reducer';
import * as types from 'core/store/modules/Display/constants';

describe('Display module reducer', () => {

  it('returns the initial state', () => {
    expect(
      display(undefined, {}),
    ).toEqual({
      isDismissed: false,
      isExpanded: false,
      isSubscribing: false,
      typeOfExtension: types.OVERLAY,
    });
  });

  it('handles a DISMISS action', () => {
    const action = {
      type: types.DISMISS,
    };
    expect(
      display(undefined, action),
    ).toEqual({
      isDismissed: true,
      isExpanded: false,
      isSubscribing: false,
      typeOfExtension: types.OVERLAY,
    });
  });

  it('handles a TOGGLE_IS_EXPANDED action', () => {
    let state = undefined;
    const action = {
      type: types.TOGGLE_IS_EXPANDED,
    };

    // Initially collapsed.
    state = display(state, {});
    expect(state).toEqual({
      isDismissed: false,
      isExpanded: false,
      isSubscribing: false,
      typeOfExtension: types.OVERLAY,
    });

    // Toggle -> expand.
    state = display(state, action);
    expect(state).toEqual({
      isDismissed: false,
      isExpanded: true,
      isSubscribing: false,
      typeOfExtension: types.OVERLAY,
    });

    // Toggle -> collapse.
    state = display(state, action);
    expect(state).toEqual({
      isDismissed: false,
      isExpanded: false,
      isSubscribing: false,
      typeOfExtension: types.OVERLAY,
    });
  });
  
  it('handles a SET_SUBSCRIBING_STATUS action', () => {
    const action = {
      payload: true,
      type: types.SET_SUBSCRIBING_STATUS,
    };
    expect(
      display(undefined, action),
    ).toEqual({
      isDismissed: false,
      isExpanded: false,
      isSubscribing: true,
      typeOfExtension: types.OVERLAY,
    });
  });

  it('handles a SET_EXTENSION_TYPE action', () => {
    const action = {
      payload: types.COMPONENT, 
      type: types.SET_EXTENSION_TYPE,
    };
    expect(
      display(undefined, action),
    ).toEqual({
      isDismissed: false,
      isExpanded: false,
      isSubscribing: false,
      typeOfExtension: types.COMPONENT,
    });
  });

});
