import { selectIsDismissed, selectIsExpanded, selectTypeOfExtension } from 'core/store/modules/Display/selectors';
import { name, OVERLAY } from 'core/store/modules/Display/constants';

describe('Display module selectors', () => {
  it('selects the isDismissed state.', () => {
    const state = { [name]: { isDismissed: true } };

    const receivedSelection = selectIsDismissed(state);

    expect(receivedSelection).toEqual(true);
  });

  it('selects the isExpanded state.', () => {
    const state = { [name]: { isExpanded: true } };

    const receivedSelection = selectIsExpanded(state);

    expect(receivedSelection).toEqual(true);
  });

  it('selects the type of extension.', () => {
    const state = { [name]: { typeOfExtension:  OVERLAY } };

    const receivedSelection = selectTypeOfExtension(state);

    expect(receivedSelection).toEqual(OVERLAY);
  });
});
