import configureStore from 'redux-mock-store';
import * as actions from 'core/store/modules/ErrorMessage/actions';
import * as types from 'core/store/modules/ErrorMessage/constants';
import middleware from 'core/store/middleware';

describe('ErrorMessage module actions', () => {

  describe('creators', () => {
    it('creates an action to set the main extension error message.', () => {
      const errMsg = 'TEST_ERROR_MESSAGE';

      const expectedAction = {
        type: types.SET_MAIN_EXTENSION_ERROR_MESSAGE,
        payload: errMsg
      };
      const receivedAction = actions.setMainExtensionErrorMessage(errMsg);

      expect(receivedAction).toEqual(expectedAction);
    });

    it('creates an action to clear the main extension error message.', () => {
      const expectedAction = {
        type: types.CLEAR_MAIN_EXTENSION_ERROR_MESSAGE
      };

      expect(actions.clearMainExtensionErrorMessage()).toEqual(expectedAction);
    });

    it('creates an action to set the game error message.', () => {
      const errMsg = 'TEST_ERROR_MESSAGE';

      const expectedAction = {
        type: types.SET_GAME_ERROR_MESSAGE,
        payload: errMsg
      };
      const receivedAction = actions.setGameErrorMessage(errMsg);

      expect(receivedAction).toEqual(expectedAction);
    });

    it('creates an action to clear the game error message.', () => {
      const expectedAction = {
        type: types.CLEAR_GAME_ERROR_MESSAGE
      };

      expect(actions.clearGameErrorMessage()).toEqual(expectedAction);
    });

    it('creates an action to set the live_config error message.', () => {
      const errMsg = 'TEST_ERROR_MESSAGE';

      const expectedAction = {
        type: types.SET_LIVE_CONFIG_ERROR_MESSAGE,
        payload: errMsg
      };
      const receivedAction = actions.setLiveConfigErrorMessage(errMsg);

      expect(receivedAction).toEqual(expectedAction);
    });

    it('creates an action to clear the live_config error message.', () => {
      const expectedAction = {
        type: types.CLEAR_LIVE_CONFIG_ERROR_MESSAGE
      };

      expect(actions.clearLiveConfigErrorMessage()).toEqual(expectedAction);
    });

    it('creates an action to set the config error message.', () => {
      const errMsg = 'TEST_ERROR_MESSAGE';

      const expectedAction = {
        type: types.SET_CONFIG_ERROR_MESSAGE,
        payload: errMsg
      };
      const receivedAction = actions.setConfigErrorMessage(errMsg);

      expect(receivedAction).toEqual(expectedAction);
    });

    it('creates an action to clear the config error message.', () => {
      const expectedAction = {
        type: types.CLEAR_CONFIG_ERROR_MESSAGE
      };

      expect(actions.clearConfigErrorMessage()).toEqual(expectedAction);
    });
  });

  describe('store integration', () => {

    function setUp() {
      const mockStore = configureStore(middleware)({});

      return { mockStore }
    }

    it('dispatches a SET_MAIN_EXTENSION_ERROR_MESSAGE action.', () => {
      const { mockStore } = setUp();
      const errMsg = 'TEST_ERROR_MESSAGE';

      // Critical statement.
      mockStore.dispatch(actions.setMainExtensionErrorMessage(errMsg))

      const expectedActions = [{
        type: types.SET_MAIN_EXTENSION_ERROR_MESSAGE,
        payload: errMsg
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });

    it('dispatches a CLEAR_MAIN_EXTENSION_ERROR_MESSAGE action.', () => {
      const { mockStore } = setUp();

      // Critical statement.
      mockStore.dispatch(actions.clearMainExtensionErrorMessage())

      const expectedActions = [{
        type: types.CLEAR_MAIN_EXTENSION_ERROR_MESSAGE
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });

    it('dispatches a SET_GAME_ERROR_MESSAGE action.', () => {
      const { mockStore } = setUp();
      const errMsg = 'TEST_ERROR_MESSAGE';

      // Critical statement.
      mockStore.dispatch(actions.setGameErrorMessage(errMsg))

      const expectedActions = [{
        type: types.SET_GAME_ERROR_MESSAGE,
        payload: errMsg
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });

    it('dispatches a CLEAR_GAME_ERROR_MESSAGE action.', () => {
      const { mockStore } = setUp();

      // Critical statement.
      mockStore.dispatch(actions.clearGameErrorMessage())

      const expectedActions = [{
        type: types.CLEAR_GAME_ERROR_MESSAGE
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });

    it('dispatches a SET_LIVE_CONFIG_ERROR_MESSAGE action.', () => {
      const { mockStore } = setUp();
      const errMsg = 'TEST_ERROR_MESSAGE';

      // Critical statement.
      mockStore.dispatch(actions.setLiveConfigErrorMessage(errMsg))

      const expectedActions = [{
        type: types.SET_LIVE_CONFIG_ERROR_MESSAGE,
        payload: errMsg
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });

    it('dispatches a CLEAR_LIVE_CONFIG_ERROR_MESSAGE action.', () => {
      const { mockStore } = setUp();

      // Critical statement.
      mockStore.dispatch(actions.clearLiveConfigErrorMessage())

      const expectedActions = [{
        type: types.CLEAR_LIVE_CONFIG_ERROR_MESSAGE
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });

    it('dispatches a SET_CONFIG_ERROR_MESSAGE action.', () => {
      const { mockStore } = setUp();
      const errMsg = 'TEST_ERROR_MESSAGE';

      // Critical statement.
      mockStore.dispatch(actions.setConfigErrorMessage(errMsg))

      const expectedActions = [{
        type: types.SET_CONFIG_ERROR_MESSAGE,
        payload: errMsg
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });

    it('dispatches a CLEAR_CONFIG_ERROR_MESSAGE action.', () => {
      const { mockStore } = setUp();

      // Critical statement.
      mockStore.dispatch(actions.clearConfigErrorMessage())

      const expectedActions = [{
        type: types.CLEAR_CONFIG_ERROR_MESSAGE
      }];
      const dispatchedActions = mockStore.getActions();

      expect(dispatchedActions).toEqual(expectedActions);
    });
  }); 

});
