import { errorMessage } from 'core/store/modules/ErrorMessage/reducer';
import * as types from 'core/store/modules/ErrorMessage/constants';
import { State }from 'core/store/modules/ErrorMessage/State'
import { initialState } from 'core/store/modules/ErrorMessage/State';

describe('ErrorMessage module reducer', () => {

  it('returns the initial state', () => {
    expect(
      errorMessage(undefined, {})
     ).toEqual(
       initialState
     );
  });

  it('handles an arbitrary action with an error', () => {
    const state = {
      liveConfigErrorMessage: null,
      gameErrorMessage: null,
      mainExtensionErrorMessage: null,
      configErrorMessage: null,
      unhandledErrorMessage: null
    };

    const errMsg = 'TST_ERR_MSG';
    const action = { error: true, payload: new Error(errMsg) };
    expect(
      errorMessage(state, action).unhandledErrorMessage
    ).toEqual(
      errMsg
    )
  })

  it('handles SET_MAIN_EXTENSION_ERROR_MESSAGE', () => {
    const errMsg = 'TST_ERR_MSG'
    const action = { type: types.SET_MAIN_EXTENSION_ERROR_MESSAGE, payload: errMsg }
    expect(
      errorMessage(null, action).mainExtensionErrorMessage
    ).toEqual(
      errMsg
    );
  });

  it('handles CLEAR_MAIN_EXTENSION_ERROR_MESSAGE', () => {
    const state: State = {mainExtensionErrorMessage: 'TST_ERR_MSG', gameErrorMessage: 'TST_ERR_MSG', liveConfigErrorMessage: 'TST_ERR_MSG', unhandledErrorMessage: 'TST_ERR_MSG', configErrorMessage: 'TST_ERR_MSG'};
    const action = { type: types.CLEAR_MAIN_EXTENSION_ERROR_MESSAGE };
    expect(
      errorMessage(state, action).mainExtensionErrorMessage
    ).toEqual(
      null
    );
  });

  it('handles SET_GAME_ERROR_MESSAGE', () => {
    const errMsg = 'TST_ERR_MSG'
    const action = { type: types.SET_GAME_ERROR_MESSAGE, payload: errMsg }
    expect(
      errorMessage(null, action).gameErrorMessage
    ).toEqual(
      errMsg
    );
  });

  it('handles CLEAR_GAME_ERROR_MESSAGE', () => {
    const state: State = {mainExtensionErrorMessage: 'TST_ERR_MSG', gameErrorMessage: 'TST_ERR_MSG', liveConfigErrorMessage: 'TST_ERR_MSG', unhandledErrorMessage: 'TST_ERR_MSG', configErrorMessage: 'TST_ERR_MSG'};
    const action = { type: types.CLEAR_GAME_ERROR_MESSAGE };
    expect(
      errorMessage(state, action).gameErrorMessage
    ).toEqual(
      null
    );
  });

  it('handles SET_LIVE_CONFIG_ERROR_MESSAGE', () => {
    const errMsg = 'TST_ERR_MSG'
    const action = { type: types.SET_LIVE_CONFIG_ERROR_MESSAGE, payload: errMsg }
    expect(
      errorMessage(null, action).liveConfigErrorMessage
    ).toEqual(
      errMsg
    );
  });

  it('handles CLEAR_LIVE_CONFIG_ERROR_MESSAGE', () => {
    const state: State = {mainExtensionErrorMessage: 'TST_ERR_MSG', gameErrorMessage: 'TST_ERR_MSG', liveConfigErrorMessage: 'TST_ERR_MSG', unhandledErrorMessage: 'TST_ERR_MSG', configErrorMessage: 'TST_ERR_MSG'};
    const action = { type: types.CLEAR_LIVE_CONFIG_ERROR_MESSAGE };
    expect(
      errorMessage(state, action).liveConfigErrorMessage
    ).toEqual(
      null
    );
  });

  it('handles SET_CONFIG_ERROR_MESSAGE', () => {
    const errMsg = 'TST_ERR_MSG'
    const action = { type: types.SET_CONFIG_ERROR_MESSAGE, payload: errMsg }
    expect(
      errorMessage(null, action).configErrorMessage
    ).toEqual(
      errMsg
    );
  });

  it('handles CLEAR_CONFIG_ERROR_MESSAGE', () => {
    const state: State = {mainExtensionErrorMessage: 'TST_ERR_MSG', gameErrorMessage: 'TST_ERR_MSG', liveConfigErrorMessage: 'TST_ERR_MSG', unhandledErrorMessage: 'TST_ERR_MSG', configErrorMessage: 'TST_ERR_MSG'};
    const action = { type: types.CLEAR_CONFIG_ERROR_MESSAGE };
    expect(
      errorMessage(state, action).configErrorMessage
    ).toEqual(
      null
    );
  });

});
