import { selectMainExtensionErrorMessage, selectGameErrorMessage, selectLiveConfigErrorMessage, selectConfigErrorMessage, selectUnhandledErrorMessage } from 'core/store/modules/ErrorMessage/selectors';
import { name } from 'core/store/modules/ErrorMessage/constants';

describe('ErrorMessage module selectors', () => {
  it('selects the ErrorMessage state.', () => {
    const liveConfigErrorMessage = 'liveConfigErrorMessage';
    const gameErrorMessage = 'gameErrorMessage';
    const mainExtensionErrorMessage = 'mainExtensionErrorMessage';
    const configErrorMessage = 'configErrorMessage';
    const unhandledErrorMessage = 'unhandledErrorMessage';

    const state = { [name]: {liveConfigErrorMessage, gameErrorMessage, mainExtensionErrorMessage, configErrorMessage, unhandledErrorMessage}}

    const liveConfigSelection = selectLiveConfigErrorMessage(state);
    const gameSelection = selectGameErrorMessage(state);
    const mainExtensionSelection = selectMainExtensionErrorMessage(state);
    const configErrorSelection = selectConfigErrorMessage(state);
    const unhandledErrorSelection = selectUnhandledErrorMessage(state);

    expect(liveConfigSelection).toEqual(liveConfigErrorMessage);
    expect(gameSelection).toEqual(gameErrorMessage);
    expect(mainExtensionSelection).toEqual(mainExtensionErrorMessage);
    expect(configErrorSelection).toEqual(configErrorMessage);
    expect(unhandledErrorSelection).toEqual(unhandledErrorMessage);
  });
});
