import * as types from "core/store/modules/Twitch/constants";
import { initialState } from "core/store/modules/Twitch/State";
import { twitch } from "core/store/modules/Twitch/reducer";

describe("Twitch module reducer", () => {

  it("returns the initial state", () => {
    expect(
      twitch(undefined, {}),
    ).toEqual(
      initialState,
    );
  });

  it("handles GET_STREAMER_CONTEXT", () => {
    const expectedState = {
      ... initialState,
      streamerName: "streamerName",
      streamerType: "affiliate",
    };
    const action = {
      payload: {
        data: [{
          broadcaster_type: "affiliate",
          display_name: "streamerName",
        }],
      },
      type: types.GET_STREAMER_CONTEXT,
    };
    expect(
      twitch(undefined, action),
    ).toEqual(
      expectedState,
    );
  });


  it("handles INITIAL_VISIBILITY_CHANGE", () => {
    const expectedState = {
      ... initialState,
      receivedInitialVisibilityChangedEvent: true,
    };
    const action = {
      payload: {},
      type: types.INITIAL_VISIBILITY_CHANGE,
    };
    expect(
      twitch(undefined, action),
    ).toEqual(
      expectedState,
    );
  });
});
