import { name } from "core/store/modules/Twitch/constants";
import * as selectors from "core/store/modules/Twitch/selectors";

describe("Twitch module selectors", () => {
  it("selects the streamer name.", () => {
    const expectedSelection = "streamerName";
    const currentState = {
        streamerName: expectedSelection,
    };

    const state = { [name]: currentState };

    const receivedSelection = selectors.selectStreamerName(state);

    expect(receivedSelection).toEqual(expectedSelection);
  });

  it("returns an empty string if there is no streamer name", () => {
    const expectedSelection = "";

    const state = { [name]: {} };
    const receivedSelection = selectors.selectStreamerName(state);
    expect(receivedSelection).toEqual(expectedSelection);
  });

  it("returns canSubscribeToStreamer=true if a streamer is partnered", () => {
    const expectedSelection = true;
    const currentState = {
        streamerType: "partner",
    };

    const state = { [name]: currentState };
    const receivedSelection = selectors.selectCanSubscribeToStreamer(state);

    expect(receivedSelection).toEqual(expectedSelection);
  });

  it("returns canSubscribeToStreamer=true if a streamer is affiliate", () => {
    const expectedSelection = true;
    const currentState = {
        streamerType: "affiliate",
    };

    const state = { [name]: currentState };
    const receivedSelection = selectors.selectCanSubscribeToStreamer(state);

    expect(receivedSelection).toEqual(expectedSelection);
  });

  it("returns canSubscribeToStreamer=false if a streamer is not a partner or an affiliate", () => {
    const expectedSelection = false;
    const currentState = {
        streamerType: "",
    };

    const state = { [name]: currentState };
    const receivedSelection = selectors.selectCanSubscribeToStreamer(state);

    expect(receivedSelection).toEqual(expectedSelection);
  });

  it("returns canSubscribeToStreamer=false if data is missing", () => {
    const expectedSelection = false;

    let state = {};
    let receivedSelection = selectors.selectCanSubscribeToStreamer(state);

    expect(receivedSelection).toEqual(expectedSelection);

    const currentState = {};
    state = { [name]: currentState };
    receivedSelection = selectors.selectCanSubscribeToStreamer(state);

    expect(receivedSelection).toEqual(expectedSelection);
  });
});
