import configureStore from 'redux-mock-store';
import * as actions from 'core/store/modules/TwitchExtension/actions';
import * as types from 'core/store/modules/TwitchExtension/constants';
import middleware from 'core/store/middleware';

describe('TwitchExtension module actions', () => {

  describe('creators', () => {
    it('creates an action to handle an Authorization object.', () => {
      const auth = { foo: 'bar' };

      const expectedAction = {
        type: types.HANDLE_AUTHORIZED,
        payload: auth
      };
      const receivedAction = actions.handleTwitchExtensionAuthorized(auth);

      expect(receivedAction).toEqual(expectedAction);
    });

    it('creates an action to handle a Context object.', () => {
      const context = { some: 'stuff' };

      const expectedAction = {
        type: types.HANDLE_CONTEXT,
        payload: context
      };
      const receivedAction = actions.handleTwitchExtensionContext(context);

      expect(receivedAction).toEqual(expectedAction);
    });
  });

  describe('store integration', () => {

    function setUp() {
      const mockStore = configureStore(middleware)({});

      return { mockStore };
    };

    it('dispatches a HANDLE_AUTHORIZED action.', () => {
      const { mockStore } = setUp();
      const auth = { foo: 'bar' };

      // Critical statement.
      mockStore.dispatch(actions.handleTwitchExtensionAuthorized(auth));

      const expectedActions = [{
        type: types.HANDLE_AUTHORIZED,
        payload: auth
      }];
      const receivedActions = mockStore.getActions();

      expect(receivedActions).toEqual(expectedActions);
    });


    it('dispatches a HANDLE_CONTEXT action.', () => {
      const { mockStore } = setUp();
      const context = { foo: 'bar' };

      // Critical statement.
      mockStore.dispatch(actions.handleTwitchExtensionContext(context));

      const expectedActions = [{
        type: types.HANDLE_CONTEXT,
        payload: context
      }];
      const receivedActions = mockStore.getActions();

      expect(receivedActions).toEqual(expectedActions);
    });
  });

});
