import { twitchExtension } from 'core/store/modules/TwitchExtension/reducer';
import * as types from 'core/store/modules/TwitchExtension/constants';

describe('TwitchExtensionModule reducer', () => {

  it('returns the initial state', () => {
    expect(
      twitchExtension(undefined, {})
     ).toEqual({
      authorization: null,
      context: null
    });
  });

  it('handles HANDLE_AUTHORIZED', () => {
    const auth = { foo: 'bar' };
    const action = { type: types.HANDLE_AUTHORIZED, payload: auth };

    expect(
      twitchExtension(undefined, action)
    ).toEqual({
      authorization: auth,
      context: null
    });
  });

  it('handles HANDLE_CONTEXT', () => {
    const context = { some: 'stuff' };
    const action = { type: types.HANDLE_CONTEXT, payload: context };

    expect(
      twitchExtension(undefined, action)
    ).toEqual({
      authorization: null,
      context: context
    });
  });

});
