import { getQueryParam, addQueryParam } from 'core/utils/queryParam';

describe("Query Param Utils", () => {
    describe("getQueryParam", () => {
        it("returns the date override when it exists as a query param", () => {
            const url = 'https://this.location.isawesome?dateOverride=';
            const dateOverrideValue = '2018-09-10T00:00:00Z';
            const dateOverride = getQueryParam(`${url}${dateOverrideValue}`, 'dateOverride');
    
            expect(dateOverride).toEqual(dateOverrideValue);
        });
    
        it("returns an empty when date override does not exist on the url", () => {
            const url = 'https://this.location.isawesome';
            const dateOverride = getQueryParam(`${url}`, 'dateOverride');
    
            expect(dateOverride).toEqual("");
        });
    });

    describe("addQueryParam", () => {
        it("correctly adds a first query param when there are no existing params", () => {
            const startingUrl = 'https://test.com';
            const newUrl = addQueryParam(startingUrl, "a", "b");
    
            expect(newUrl).toEqual(`${startingUrl}?a=b`);
        });
    
        it("correctly appends a query param when there are already existing params", () => {
            const startingUrl = 'https://test.com?a=b';
            const newUrl = addQueryParam(startingUrl, "c", "d");
    
            expect(newUrl).toEqual(`${startingUrl}&c=d`);
        });

        it("Doesn't modify the URL when trying to add a query param that already exists", () => {
            const startingUrl = 'https://test.com?a=b';
            const newUrl = addQueryParam(startingUrl, "a", "b");
    
            expect(newUrl).toEqual(`${startingUrl}`);
        });
    });
});