import { shallow } from "enzyme";
import toJson from "enzyme-to-json";
import * as React from "react";
import { Location } from "core/types/CommunityService";
import { DropdownComponent } from "live_config/components/Dropdown/component";

interface OptionsProps {
  location?: Location;
  onDropdownChange?: (location) => void;
}

const getDropdownComponent = (options?: OptionsProps) => {
  return (
    <DropdownComponent 
      extensionLocation = { options && options.location || Location.TOP_RIGHT }
      onDropdownChange = { options && options.onDropdownChange || jest.fn() }
    />
  );
}

const setupShallow = (options?: OptionsProps) => {
  return shallow(getDropdownComponent(options));
}

describe("Dropdown component", () => {

  it("renders the Dropdown correctly at the TOP_MIDDLE location", () => {
    const component = setupShallow({ location: Location.TOP_MIDDLE });

    const tree = toJson(component);
    expect(tree).toMatchSnapshot();
  });

  it("calls on onDropdownChange when changing location", () => {
    const onChangeMock = jest.fn();
    const newLocation = Location.TOP_LEFT
    const component = setupShallow({ onDropdownChange: onChangeMock });

    component.find('Select').simulate('change', {target : { value : newLocation}});
    expect(onChangeMock).toBeCalledWith(newLocation);
  });
});
