import { shallow } from "enzyme";
import toJson from "enzyme-to-json";
import * as React from "react";
import { SelectableLocationComponent } from "live_config/components/SelectableLocation/component";
import { Location } from 'core/types/CommunityService'

interface OptionsProps {
  location?: Location;
  isSelected?: boolean;
  onSelection?: (location) => void;
}

const getSelectableLocationComponent = (options?: OptionsProps) => {
  return (
    <SelectableLocationComponent 
      isSelected = { options && options.isSelected || false }
      location = { options && options.location || Location.TOP_RIGHT }
      onSelection = { options && options.onSelection || jest.fn() }
    />
  );
}


const setupShallow = (options?: OptionsProps) => {
  return shallow(getSelectableLocationComponent(options));
}

describe("SelectableLocation component", () => {

  it("renders the prime crown when SelectableLocation is selected", () => {
    const component = setupShallow({ isSelected: true });

    const tree = toJson(component);
    expect(tree).toMatchSnapshot();
  });

  it("renders the empty SelectableLocation when SelectableLocation is not selected", () => {
    const component = setupShallow();

    const tree = toJson(component);
    expect(tree).toMatchSnapshot();
  });

  it("calls onSelection() when clicked", () => {
    const onSelectionMock = jest.fn();
    const newLocation = Location.TOP_LEFT;
    const component = setupShallow({ onSelection: onSelectionMock, location: newLocation });

    component.simulate('click');
    expect(onSelectionMock).toBeCalledWith(newLocation);
  });
});
