import { shallow } from "enzyme";
import toJson from "enzyme-to-json";
import * as React from "react";
import * as ReactTestUtils from "react-dom/test-utils";
import { DismissButtonComponent } from "viewer/components/DismissButton/component";

describe("DismissButton component", () => {
  it("renders the DismissButton correctly", () => {
    const component = shallow(
      <DismissButtonComponent
        dismiss={jest.fn()}
      />,
    );

    const tree = toJson(component);
    expect(tree).toMatchSnapshot();
  });

  it("dismisses when clicked", () => {
    const dismiss = jest.fn();

    const component = shallow(
      <DismissButtonComponent
        dismiss={dismiss}
      />,
    );

    component.find("button").simulate("click");

    expect(dismiss.mock.calls.length).toBe(1);
  });
});
