import { shallow } from "enzyme";
import toJson from "enzyme-to-json";
import * as React from "react";
import { ErrorComponent } from "viewer/components/Error/component";

interface OptionsProps {
  error: string;
}

const getErrorComponent = (options: OptionsProps) => {
  return (
    <ErrorComponent
        error={options.error}
    />
  );
}

const setupShallow = (options: OptionsProps) => {
  return shallow(getErrorComponent(options));
}


describe("Error component", () => {
  it("renders a generic error message", () => {
    const component = setupShallow({ error: "network error" });

    const tree = toJson(component);
    expect(tree).toMatchSnapshot();
  });

  it("renders a NO_BALANCE error message", () => {
    const component = setupShallow({ error: "NO_BALANCE" });

    const tree = toJson(component);
    expect(tree).toMatchSnapshot();
  });

  it("renders a HAS_PAID_SUB error message", () => {
    const component = setupShallow({ error: "HAS_PAID_SUB" });

    const tree = toJson(component);
    expect(tree).toMatchSnapshot();
  });
});
