import { shallow } from "enzyme";
import * as React from "react";
import { OFFER_BANNER, OfferComponent } from "viewer/components/Offer/component";

interface OptionsProps {
  offerID?: string;
  offerMessage?: string;
  offerImage?: string;
  offerLink?: string;
  reportClick?: () => {};
}

const getOfferComponent = (options?: OptionsProps) => {
  return (
    <OfferComponent
        offerID={options && options.offerID || "ID" }
        offerMessage={options && options.offerMessage || "Message" }
        offerImage={options && options.offerImage || "Image" }
        offerLink={options && options.offerLink || "offer.com" }
        reportClick={options && options.reportClick || jest.fn()}
    />
  );
}

const setupShallow = (options?: OptionsProps) => {
  return shallow(getOfferComponent(options));
}


describe("Offer presentation component", () => {
  it("renders an offer", () => {
    const component = setupShallow();

    const banner = component.find({ "data-test-target": OFFER_BANNER });
    expect(banner).toHaveLength(1);
  });

  it("calls on reportClick when the ad is clicked on", () => {
    jest.useFakeTimers();
    const reportClick = jest.fn();
    const component = setupShallow({reportClick: reportClick});

    const banner = component.find({ "data-test-target": OFFER_BANNER });
    expect(banner).toHaveLength(1);
    banner.simulate("click");
    expect(reportClick).toBeCalled();
  });
});
