import { shallow } from "enzyme";
import * as React from "react";
import { UPSELL_BANNER, UpsellComponent } from "viewer/components/Upsell/component";

interface OptionsProps {
  offerID?: string;
  signupLink?: string;
  reportClick?: () => {};
}

const getUpsellComponent = (options?: OptionsProps) => {
  return (
    <UpsellComponent
        offerID={options && options.offerID || "ID" }
        signupLink={options && options.signupLink || "link.com" }
        reportClick={options && options.reportClick || jest.fn()}
    />
  );
}

const setupShallow = (options?: OptionsProps) => {
  return shallow(getUpsellComponent(options));
}


describe("Upsell presentation component", () => {
  it("renders an upsell", () => {
    const component = setupShallow();

    const banner = component.find({ "data-test-target": UPSELL_BANNER });
    expect(banner).toHaveLength(1);
  });

  it("calls on reportClick when the upsell is clicked on", () => {
    jest.useFakeTimers();
    const reportClick = jest.fn();
    const component = setupShallow({reportClick: reportClick});

    const banner = component.find({ "data-test-target": UPSELL_BANNER });
    expect(banner).toHaveLength(1);
    banner.simulate("click");
    expect(reportClick).toBeCalled();
  });
});
