var { resolve } = require('path');
var webpack = require('webpack');
var HtmlPlugin = require('html-webpack-plugin');
var CopyAssetsPlugin = require('copy-webpack-plugin');


module.exports = app => ({

  context: resolve('src'),

  entry: [
    'whatwg-fetch',
    app
  ],

  output: {
    filename: 'js/[name].[chunkhash].js',
    path: resolve('dist'),
  },

  module: {
    rules: [{
      test: /\.(js|tsx?)$/,
      loader: 'awesome-typescript-loader',
      include: [ resolve('node_modules/extension-game'), resolve('node_modules/twitch-core-ui'), resolve('src') ],
    }, {
      test: /\.(sass|scss)$/,
      loaders: [
        'style-loader',
        'css-loader',
        'postcss-loader',
        {
          loader: 'sass-loader',
          options: {
            sourceMap: true,
            includePaths: [ resolve('node_modules', 'twitch-core-ui', 'src', 'scss') ]
          }
        }
      ]
    }, {
      test: /\.(css|less)$/,
      loaders: [
        'style-loader',
        'css-loader',
        'less-loader'
      ],
      include: [ resolve('node_modules/extension-game'), resolve('node_modules/react-spinkit'), resolve('node_modules/loaders.css') ]
    }, {
      test: /\.(gif|png|jpe?g)$/i,
      loader: 'file-loader',
      options: { name: 'images/[hash].[ext]' }
    }, {
      test: /\.(ttf|otf|eot|woff2?)$/i,
      loader: 'file-loader',
      options: { name: 'fonts/[hash].[ext]' }
    }]
  },

  resolve: {
    extensions: [ '.ts', '.tsx', '.js', '.json' ],
    modules: [ 'src', 'node_modules' ]
  },

  // Define global, namespaced variables.
  externals: {
    twitch: 'Twitch'
  },

  plugins: [

    // Inject environment variables.
    new webpack.EnvironmentPlugin({
      NODE_ENV: null
    }),

    // Generate the HTML document.
    new HtmlPlugin({
      template: resolve('src', 'templates', app + '.html'),
      filename: app + '.html'
    }),

    // Copy static assets to the output
    new CopyAssetsPlugin([{
      from: resolve('src', 'assets')
    }]),

    // Shim Promise
    new webpack.ProvidePlugin({
      Promise: 'promise-polyfill',
    }),

  ]

})
