module.exports = {
  transform: {
    '^.+\\.tsx?$': 'ts-jest'
  },
  testRegex: '(<rootDir>/__tests__/.*|(\\.|/)(test|spec))\\.(tsx?)$',
  moduleFileExtensions: [
    'ts',
    'tsx',
    'js',
    'jsx',
    'json',
    'node'
  ],
  moduleDirectories: [
    '<rootDir>/src',
    'node_modules'
  ],
  moduleNameMapper: {
    '^@__tests__/*': '<rootDir>/__tests__/$1',
    '\\.(jpg|jpeg|png|gif|eot|otf|webp|svg|ttf|woff|woff2|mp4|webm|wav|mp3|m4a|aac|oga)$': '<rootDir>/__tests__/__mocks__/fileMock.ts',
    '\\.(css|scss|sass)$': '<rootDir>/__tests__/__mocks__/styleMock.ts'
  },
  setupTestFrameworkScriptFile: '<rootDir>/__tests__/setup.ts',
  "transformIgnorePatterns": [
    "node_modules/(?!(twitch-core-ui|extension-game))"
  ]
}
