import connectTwitchExtension from "core/connectTwitchExtension";
import configureStore from "core/store/configureStore";
import { polyfills } from "core/polyfills";
import * as React from "react";
import { render } from "react-dom";
import { Provider } from "react-redux";
import { Root } from "viewer/Root";
import rootReducer from "viewer/rootReducer";
import "whatwg-fetch";
import { COMPONENT } from "core/store/modules/Display";
import { isLegacyComponentDesignEnabled } from 'core/utils/extensionSettings';

async function start(): Promise<void> {

  polyfills();

  const store = await configureStore(rootReducer);

  connectTwitchExtension(store, COMPONENT);


  // The prime extension needs to render differently within the component sidenav popup.
  // See: https://discuss.dev.twitch.tv/t/changes-coming-to-component-extensions-and-how-to-update/21201
  const displayAsSidenavPopup = !isLegacyComponentDesignEnabled();

  render(
    <Provider store={ store }>
      <Root displayAsSidenavPopup={displayAsSidenavPopup}/>
    </Provider>,
    document.getElementById("root"),
  );
}

start();
