import { shallow } from "enzyme";
import * as React from "react";
import { RootComponent } from "./component";
import { CoreImage, CoreText, StyledLayout } from "twitch-core-ui";


interface PropOptions {
    theme?: string;
  }

const getDefaultProps = (options?: PropOptions) => {
    return (
      <RootComponent
          theme={options && options.theme}
        />
    );
}

const setupShallow = (options?: PropOptions) => {
    return shallow(getDefaultProps(options));
}

describe("Config root presentation component", () => {
    it("renders correctly", () => {
        const component = setupShallow();
        expect(component.find(CoreImage)).toHaveLength(3);
        expect(component.find(CoreText)).toHaveLength(6);
        expect(component.findWhere(x => x.hasClass("tw-theme--")))
    });

    it("renders correctly with a theme", () => {
        const component = setupShallow({ theme: "dark" });
        expect(component.find(CoreImage)).toHaveLength(3);
        expect(component.find(CoreText)).toHaveLength(6);
        expect(component.findWhere(x => x.hasClass("tw-theme--dark")))
    });
});
