import * as React from "react";
import "./styles.scss";
import { Background, Color, CoreImage, CoreLink, CoreText, StyledLayout, TextType, FontSize, Display, FlexDirection, JustifyContent, CoreLinkType } from "twitch-core-ui";

export interface Props {
  theme: string;
}

export class RootComponent extends React.Component<Props> {

  public render() {
    return (
      <StyledLayout 
        className={`tw-theme--${this.props.theme}`}
        fullHeight={true}
      >
        <StyledLayout 
          background={Background.Base}
          fullHeight={true}
        >
            <CoreText
                color={Color.Base}
                fontSize={FontSize.Size5}
            >
                <CoreText type={TextType.H4} bold>Editing the location of this extension:</CoreText>
                To edit the location of this extension on your stream, click on the dropdown button and select between Component mode and Overlay 
                mode <CoreLink to="https://dev.twitch.tv/docs/extensions/required-technical-background/#types-of-extensions" targetBlank>(?)</CoreLink>, then follow the corresponding instructions below.
            </CoreText>
            <CoreImage 
                src="https://m.media-amazon.com/images/G/01/sm/extension/extension_mode_dropdown_pg.png" 
                alt="Extension mode selection"
                className="config__extension-mode-dropdown-image"
            />
            <CoreText 
                className="config__component-instructions"
                color={Color.Base}
                fontSize={FontSize.Size5}
            >
                <CoreText type={TextType.H5} bold>Setting up Component mode:</CoreText>
                After selecting "Set as Component", your extension will appear in the list of extensions in Component mode on the right side of your stream. <br />
            </CoreText>
            <CoreImage 
                src="https://m.media-amazon.com/images/G/01/sm/extension/component_instructions_pg.png" 
                alt="Selecting location for component extension"
                className="config__extension-mode-dropdown-image"
            />
            <CoreText
                className="config__overlay-instructions"
                color={Color.Base}
                fontSize={FontSize.Size5}
            >
                <CoreText type={TextType.H5} bold>Setting up Overlay mode:</CoreText>
                After selecting "Set as Overlay", navigate to the "Stream Manager" page in your dashboard, select the Prime Subscription and Loot Reminder extension from Quick Actions, and choose one of the preset locations.
            </CoreText>
            <CoreImage
                src="https://m.media-amazon.com/images/G/01/sm/extension/extension-live-config-location_pg.png"
                alt="Live config location for overlay mode"
                className="config__extension-mode-dropdown-image"
            />
        </StyledLayout>
      </StyledLayout>
    );
  }
}
