declare var Twitch: any;

import { setConfigErrorMessage } from "core/store/modules/ErrorMessage";
import { handleTwitchExtensionContext } from "core/store/modules/TwitchExtension";

/**
 * @param store a redux store
 */
export default function connectConfigurationPage(store) {
  if (!Twitch) {
    store.dispatch(setConfigErrorMessage("Twitch init failed."));
    return;
  }
  Twitch.ext.onContext((context) => store.dispatch(handleTwitchExtensionContext(context)));
}
