import connectConfigurationPage from "config/connectConfigurationPage";
import configureStore from "core/store/configureStore";
import * as React from "react";
import { render } from "react-dom";
import { Provider } from "react-redux";
import { Root } from "config/Root";
import rootReducer from "config/rootReducer";
import "whatwg-fetch";

async function start(): Promise<void> {

  const store = await configureStore(rootReducer);

  connectConfigurationPage(store);

  render(
    <Provider store={store}>
      <Root/>
    </Provider>,
    document.getElementById("root"),
  );
}

start();
