import { OVERLAY_EXTENSION_URL, GET_OVERLAY_EXTENSION_LOCATION_URL, SET_OVERLAY_EXTENSION_LOCATION_URL, SPEND_SUBSCRIPTION_CREDIT_URL } from "./constants";

/**
 * Provides static utility methods for SCS API calls.
 */
export default class CommunityServiceClient {

  /**
   * @return a Promise that resolves to a OverlayExtension object.
   */
  public static GetOverlayExtension({ jwt, locale, dateOverride }) {
    const headers = new Headers();
    headers.append("X-SCS-Authorization", jwt);

    const options = {
      body: JSON.stringify({ locale, dateOverride }),
      headers,
      method: "POST",
    };
    return fetch(OVERLAY_EXTENSION_URL, options)
  };

  /**
   * @return a Promise that gets an overlay extension location for a particular channelId.
   */
  public static GetOverlayExtensionLocation({ jwt }) {
    const headers = new Headers();
    headers.append("X-SCS-Authorization", jwt);

    const options = {
      headers,
      method: "POST",
    };
    return fetch(GET_OVERLAY_EXTENSION_LOCATION_URL, options);
  }

  /**
   * @return a Promise that sets an overlay extension location for a particular channelId.
   */
  public static SetOverlayExtensionLocation({ jwt, location }) {
    const headers = new Headers();
    headers.append("X-SCS-Authorization", jwt);

    const options = {
      body: JSON.stringify({ location }),
      headers,
      method: "POST",
    };
    return fetch(SET_OVERLAY_EXTENSION_LOCATION_URL, options);
  }

  /**
   * @return a Promise that resolves to a balance for a user.
   */
  public static SpendSubscriptionCredit({ jwt }) {
    const headers = new Headers();
    headers.append("X-SCS-Authorization", jwt);

    const options = {
      headers,
      method: "POST",
    };
    return fetch(SPEND_SUBSCRIPTION_CREDIT_URL, options);
  }

}
