import { END_GAME_SESSION_URL, START_GAME_SESSION_URL, START_MATCHMAKING_URL, GET_GAME_SESSION_URL, LEAVE_GAME_URL, SUBMIT_GAME_INPUT_URL, CANCEL_MATCHMAKING_URL } from "./constants";

/**
 * Provides static utility methods for the game API calls.
 */
export default class GameClient {

  /**
   * @return a Promise that resolves to a game session ID.
   */
  public static StartGameSession({ jwt }) {
    const headers = new Headers();
    headers.append("X-Game-Authorization", jwt);

    const options = {
      headers,
      method: "POST",
    };

    return fetch(START_GAME_SESSION_URL, options)
  };

  /**
   * @return a Promise with no response body.
   */
  public static EndGameSession({ jwt }) {
    const headers = new Headers();
    headers.append("X-Game-Authorization", jwt);

    const options = {
      headers,
      method: "POST",
    };

    return fetch(END_GAME_SESSION_URL, options)
  };

  public static StartMatchmaking({ jwt }) {
    const headers = new Headers();
    headers.append("X-Game-Authorization", jwt);

    const options = {
      headers,
      method: "POST",
    };

    return fetch(START_MATCHMAKING_URL, options)
  };

  public static GetGameSession({ jwt }) {
    const headers = new Headers();
    headers.append("X-Game-Authorization", jwt);

    const options = {
      headers,
      method: "GET",
    };

    return fetch(GET_GAME_SESSION_URL, options)
  };

  public static SubmitGameInput({ jwt, input }) {
    const headers = new Headers();
    headers.append("X-Game-Authorization", jwt);
    headers.append("Content-Type", "application/json");

    const options = {
      body: JSON.stringify({input: input}),
      headers,
      method: "POST",
    };

    return fetch(SUBMIT_GAME_INPUT_URL, options)
  };

  public static LeaveGame({ jwt }) {
    const headers = new Headers();
    headers.append("X-Game-Authorization", jwt);

    const options = {
      headers,
      method: "POST",
    };

    return fetch(LEAVE_GAME_URL, options)
  };

  public static CancelMatchmaking({ jwt }) {
    const headers = new Headers();
    headers.append("X-Game-Authorization", jwt);

    const options = {
      headers,
      method: "POST",
    };

    return fetch(CANCEL_MATCHMAKING_URL, options)
  };

}