import { TWITCH_CLIENT_ID, TWITCH_USERS_URL } from "./constants";

 /**
  * Provides static utility methods for Twitch API calls.
  */
export default class TwitchClient {
   /**
    * @return a Promise that resolves to a OverlayExtension object.
    */
   public static GetStreamerContext({ channelID }) {
        const parameterizedURL = TWITCH_USERS_URL + "?id=" + channelID;
        const headersInit = {
          "client-id": TWITCH_CLIENT_ID,
          "content-type": "application/json",
        };
        const headers = new Headers(headersInit);

        const options = {
          headers,
          method: "GET",
        };
        return fetch(parameterizedURL, options);
   }
 }
