// Twitch
export const TWITCH_USERS_URL = "https://api.twitch.tv/helix/users";
export const TWITCH_CLIENT_ID = "d4uvtfdr04uq6raoenvj7m86gdk16v";
const PROD_BASE_URL = "https://twitch.amazon.com/extensions/prime";
const BETA_BASE_URL = "https://twitch.integ.amazon.com/extensions/prime";
const BASE_URL = process.env.NODE_ENV === "production" ? PROD_BASE_URL : BETA_BASE_URL;

// SCS
declare var process: {
  env: {
    NODE_ENV: string,
  },
};

export const OVERLAY_EXTENSION_URL = BASE_URL + "/overlay";
export const GET_OVERLAY_EXTENSION_LOCATION_URL = BASE_URL + "/location";
export const SET_OVERLAY_EXTENSION_LOCATION_URL = BASE_URL + "/setLocation";
export const SPEND_SUBSCRIPTION_CREDIT_URL = BASE_URL + "/spend";

// Game backend
const GAME_BASE_URL = "https://nzt4aclj4e.execute-api.us-east-1.amazonaws.com/production";
// const GAME_BASE_URL = "http://localhost:3000";
const COMMON_ROUTE_URL = "/common";
const STREAMER_ROUTE_URL = "/streamer";
const VIEWER_ROUTE_URL = "/viewer";

export const GET_GAME_SESSION_URL = GAME_BASE_URL + COMMON_ROUTE_URL + "/getSession";
export const START_GAME_SESSION_URL = GAME_BASE_URL + STREAMER_ROUTE_URL + "/startSession";
export const END_GAME_SESSION_URL = GAME_BASE_URL + STREAMER_ROUTE_URL + "/requestSessionEnd";
export const START_MATCHMAKING_URL = GAME_BASE_URL + VIEWER_ROUTE_URL + "/startMatchmaking";
export const SUBMIT_GAME_INPUT_URL = GAME_BASE_URL + VIEWER_ROUTE_URL + "/submitGameInput";
export const LEAVE_GAME_URL = GAME_BASE_URL + VIEWER_ROUTE_URL + "/leaveGame";
export const CANCEL_MATCHMAKING_URL = GAME_BASE_URL + VIEWER_ROUTE_URL + "/cancelMatchmaking";
