declare var Twitch: any;

import { setTypeOfExtension } from "core/store/modules/Display";
import { setMainExtensionErrorMessage } from "core/store/modules/ErrorMessage";
import { handleTwitchExtensionContext } from "core/store/modules/TwitchExtension";
import handleTwitchExtensionAuthorizedWorkflow from "core/store/workflows/handleTwitchExtensionAuthorizedWorkflow";
import handleTwitchExtensionPubsubBroadcastWorkflow from "core/store/workflows/handleTwitchExtensionPubsubWorkflow";
import handleTwitchVisibilityChangedWorkflow from "core/store/workflows/handleTwitchVisibilityChangedWorkflow";

/**
 * @param store a redux store
 */
export default function connectTwitchExtension(store, typeOfExtension) {
  if (!Twitch) {
    store.dispatch(setMainExtensionErrorMessage("Twitch init failed."));
    return;
  }

  store.dispatch(setTypeOfExtension(typeOfExtension));
  Twitch.ext.onAuthorized((auth) => store.dispatch(handleTwitchExtensionAuthorizedWorkflow(auth)));
  Twitch.ext.onContext((context) => store.dispatch(handleTwitchExtensionContext(context)));
  Twitch.ext.onVisibilityChanged((isVisible) => store.dispatch(handleTwitchVisibilityChangedWorkflow(isVisible, typeOfExtension)));
  Twitch.ext.listen(
    "broadcast", 
    (target, contentType, message) => 
      store.dispatch(
        handleTwitchExtensionPubsubBroadcastWorkflow(
          store.getState(), 
          target, 
          contentType, 
          message
        )
      )
  );
}
