import { buildReporter } from "core/utils/reporter";
import thunkMiddleware from "redux-thunk";
import fetchMiddleware from "./fetch";
import { configureMetricsMiddleware } from "./metrics";
import promiseMiddleware from "./promise";

export async function configureMiddleware() {
  const reporter = await buildReporter();
  return Promise.all([
    thunkMiddleware,
    promiseMiddleware,
    fetchMiddleware,
    configureMetricsMiddleware(reporter),
  ]);
}

export default [
  thunkMiddleware,
  promiseMiddleware,
  fetchMiddleware,
];
