import { PrimeExtensionEvent, TwitchPrimeSignUpReferredEvent, getDeviceID } from "core/utils/reporter";
import { Reporter } from "tachyon-spade-reporter";

const configureMetricsMiddleware = (reporter: Reporter<PrimeExtensionEvent | TwitchPrimeSignUpReferredEvent>) => ({ getState }) => (next) => (action) => {

  const state = getState();

  if (state.TwitchExtension && state.CommunityService && state.DISPLAY) {
    const { channelId, userId } = state.TwitchExtension.authorization;
    const { game, mode } = state.TwitchExtension.context;
    const location = state.CommunityService.location;
    const { twitchUserId, hasPrime, credit } = state.CommunityService.user;
    const typeOfExtension = state.DISPLAY.typeOfExtension;

    switch (action.type) {
      case MetricActions.REPORT_EXTENSION_ACTION:
          reporter.reportEvent({
            event: "prime_extension_action",
            properties: {
              action: action.payload,
              channel_id: channelId,
              creditBalance: credit ? credit.balance : 0,
              extension_type: typeOfExtension,
              game,
              hasPrime,
              mode,
              opaque_user_id: userId,
              role: mode,
              user_id: twitchUserId,
              extension_location: location,
            },
          });
        break;
      case MetricActions.REPORT_TWITCH_PRIME_REFERRAL:
          reporter.reportEvent({
            event: "tp_signup_referred",
            properties: {
              tp_refcode: action.payload.referralID,
              tp_campaign: action.payload.offerID, 
              user_id: twitchUserId,
              client_time: Date.now() / 1000,
              device_id: getDeviceID(),
              content: "twitch_prime",
              medium: action.payload.medium,
            },
          });
        break;
      default:
        next(action);
    }
  }
  else {
    next(action);
  }
};

enum MetricActions {
  REPORT_EXTENSION_ACTION = "REPORT_EXTENSION_ACTION",
  REPORT_TWITCH_PRIME_REFERRAL = "REPORT_TWITCH_PRIME_REFERRAL",
}

export { configureMetricsMiddleware, MetricActions };
