import CommunityServiceClient from "core/clients/CommunityServiceClient";
import { createAction } from "redux-actions";
import { FETCH_OVERLAY_EXTENSION, GET_OVERLAY_EXTENSION_LOCATION, SET_OVERLAY_EXTENSION_LOCATION, SPEND_SUBSCRIPTION_CREDIT } from "./constants";
import { getOverlayExtensionLocationErrorMessage, setOverlayExtensionLocationErrorMessage, setLiveConfigErrorMessage, clearLiveConfigErrorMessage } from "core/store/modules/ErrorMessage";
import { containsSumoExperiment } from "./helpers";

export const fetchOverlayExtension = ({jwt, locale, dateOverride, callbackIfWhitelistedForSumo}) => {
    return (dispatch) => {
        return CommunityServiceClient.GetOverlayExtension({jwt, locale, dateOverride})
        .then((response) => response.ok ? response.json() : Promise.reject())
        .then((json) => { 
            dispatch(fetchOverlayExtensionAction(json));
            const experiments = json && json.extensionData && json.extensionData.experiments;
            if (containsSumoExperiment(experiments)) {
                callbackIfWhitelistedForSumo();
            }
        })
        .catch((error) => dispatch(fetchOverlayExtensionAction(new Error(`fetchOverlayExtension encountered an error: ${error}`))));
    }
}

export const spendSubscriptionCredit =
    createAction(SPEND_SUBSCRIPTION_CREDIT, CommunityServiceClient.SpendSubscriptionCredit);

export const getOverlayExtensionLocation = ({jwt}) => {
    return (dispatch) => {
        return CommunityServiceClient.GetOverlayExtensionLocation({jwt})
        .then((response) => response.ok ? response.json() : Promise.reject())
        .then((json) => { dispatch(getOverlayExtensionLocationSuccess(json)); })
        .catch(() => dispatch(setLiveConfigErrorMessage(getOverlayExtensionLocationErrorMessage)));
    }
}

export const setOverlayExtensionLocation = ({jwt, location}) => {
    return (dispatch) => {
        return CommunityServiceClient.SetOverlayExtensionLocation({jwt, location})
        .then((response) => response.ok ? response.json() : Promise.reject() )
        .then((json) => { dispatch(setOverlayExtensionLocationSuccess(json)); dispatch(clearLiveConfigErrorMessage()); })
        .catch(() => dispatch(setLiveConfigErrorMessage(setOverlayExtensionLocationErrorMessage)));
    }
}

const fetchOverlayExtensionAction = 
    createAction(FETCH_OVERLAY_EXTENSION);

const getOverlayExtensionLocationSuccess = 
    createAction(GET_OVERLAY_EXTENSION_LOCATION);

const setOverlayExtensionLocationSuccess = 
    createAction(SET_OVERLAY_EXTENSION_LOCATION);
