import { FETCH_OVERLAY_EXTENSION, GET_OVERLAY_EXTENSION_LOCATION, SPEND_SUBSCRIPTION_CREDIT, SET_OVERLAY_EXTENSION_LOCATION } from "./constants";
import { State } from "./State";

export function communityService(state = null, action): State {
  switch (action.type) {
    case FETCH_OVERLAY_EXTENSION:
      if (action.payload.extensionData) {
        return action.payload.extensionData;
      } else {
        return state;
      }
    case SPEND_SUBSCRIPTION_CREDIT:
      state = state || {};
      state.user = state.user || {};
      state.user.credit = state.user.credit || {};
      return {
        ...state,
        user: {
          ...state.user,
          credit: {
            ...state.user.credit,
            balance: action.payload.balance,
            subscribed: !action.payload.balance,
          },
          lastSpend: {
            timestamp: Date.now(),
            channel: action.payload.channelId
          },
        },
      };
    case GET_OVERLAY_EXTENSION_LOCATION:
      if (action.payload.location) {
        return {...state, location: action.payload.location }
      }
    case SET_OVERLAY_EXTENSION_LOCATION:
      return {...state, location: action.payload.location }
    default:
      return state;
  }
}
